#!/bin/bash

DEFAULT_SED="/usr/local/bin/sed";
DEFAULT_LFTP="/usr/local/bin/lftp";
DEFAULT_WGET="/usr/local/bin/wget";
DEFAULT_CAT="/usr/local/bin/cat";
DEFAULT_PRINTF="/usr/local/bin/printf";
DEFAULT_DATE="/usr/local/bin/date";

unset SED
unset LFTP
unset WGET
unset CAT
unset PRINTF
unset DATE

#check indispensable programs

which --help 2>/dev/null > /dev/null
if test $? -eq 0;then
	SED=`which sed 2>/dev/null`;
	test -z "$SED" && SED="$DEFAULT_SED";

	LFTP=`which lftp 2>/dev/null`;
	test -z "$LFTP" && LFTP="$DEFAULT_LFTP";

	WGET=`which wget 2>/dev/null`;
	test -z "$WGET" && LFTP="$DEFAULT_WGET";
  
        CAT=`which cat 2>/dev/null`;
        test -z "$CAT" && CAT="$DEFAULT_CAT";

        PRINTF=`which printf 2>/dev/null`;
        test -z "$PRINTF" && PRINTF="$DEFAULT_PRINTF";

        DATE=`which date 2>/dev/null`;
        test -z "$DATE" && DATE="$DEFAULT_DATE";
else
	SED="$DEFAULT_SED";
	LFTP="$DEFAULT_LFTP";
	WGET="$DEFAULT_WGET";
	CAT="$DEFAULT_CAT";
	PRINTF="$DEFAULT_PRINTF";
	DATE="$DEFAULT_DATE";
fi

if test ! -f "$SED";then
	echo "sed program is required" >&2;
        exit 2;
fi

DEFAULT_DOWNLOADER="lftp"

if test ! -f "$LFTP";then
	DEFAULT_DOWNLOADER="wget";
	if test ! -f "$WGET";then
		echo "lftp or wget program is required" >&2;
        	exit 2;
	fi;
fi


if test ! -f "$CAT";then
	echo "cat program is required" >&2;
        exit 2;
fi

if test ! -f "$PRINTF";then
	echo "printf program is required" >&2;
        exit 2;
fi

if test ! -f "$DATE";then
	echo "date program is required" >&2;
        exit 2;
fi


function incdata()
{

# compute the date of tomorrow

        local anno="10#$1";
        local mese="10#$2";
        local giorno="10#$3";
        local bisestile;
        local inc1 inc2 inc3 feb;
        local incanno;

        let bisestile=\(anno%4==0\)\&\&\(\(anno%100!=0\)\|\|\(anno%400==0\)\);
        let feb=28+$bisestile;
        let giorno++;
        let inc1=\(\(mese==1\)\|\|\(mese==3\)\|\|\(mese==5\)\|\|\(mese==7\)\|\|\(mese==8\)\|\|\(mese==10\)\|\|\(mese==12\)\)\&\&\(giorno\>31\);
        let inc2=\(\(mese==4\)\|\|\(mese==6\)\|\|\(mese==9\)\|\|\(mese==11\)\)\&\&\(giorno\>30\);
        let inc3=\(mese==2\)\&\&\(giorno\>feb\);
        let incmese=inc1+inc2+inc3;
        let mese+=incmese;
        let incanno=mese\>12;
        let anno+=incanno;
        let giorno=giorno*\(1-incmese\)+incmese;
        ${PRINTF} "%04d%02d%02d\n" $anno $mese $giorno;
}


function filter_mset()
{

# mediaset filter
# transform a mediaset html into an XAVTV compliant file

	local channelid basedata tmp tomorrow flstart cntstart orig nextdate prog end start cntend 
	channelid="$1";

#	basedata=`date +"%Y%m%d"`;
#	tmp=`date +"%Y %m %d"`;
#	tomorrow=`incdata $tmp`;

	basedata="$2";
	tomorrow="$3";

	flstart=0;
	
	${SED} -e ':top1 /<!--.*-->/ { s/<!--.*-->//g; } ; /<!--.*/ { N; b top1};'|${SED} ':a $!{N; ba;}; s/\n/ /; s/<\/tr[^>]*>/\n/gi; s/<tr[^>]*>/\n/gi; s/<td[^>]*>/\|/gi; s/<\/td[^>]*>/\|/gi; s/<[^>]*>//gi;' |${SED} -e 's/^ *//; /^[|\t ]*$/d; /||/! d; s/^|//; s/[\t ]*$//g ; s/||/\t/; s/|$//;' |${SED} -n 'p;1{h;d;}; p; ${x;p;}'|${SED} -e 'N; s/\n/\t/g'|while read a;do
  start=`echo "$a"|${SED} 's/\t.*//; s/\.//g'`;
		cntstart=`echo "$a"|${SED} -e 's/\t.*//; s/0*\([1-9][0-9]*\)/\1/g ; s/\./*60+/g'`;
	        cntstart="let cntstart=$cntstart";
        	eval $cntstart;
	        if test "$flstart" = "0";then
        	        flstart=1;
                	let orig=cntstart;
	        else
        	        let nextdate=cntstart\<orig;
                	if test "$nextdate" = "1"; then
                        	let orig=cntstart;
	                        basedata="$tomorrow";
        	        fi
	        fi;

	        start="$basedata""$start""00";
        	prog=`echo "$a"|${SED} "s/[^\t]*\t\([^\t]*\)\t.*/\1/; s/[^'abcdefghijklmnopqrstuvwxzABCDEFGHIJKLMNOPQRSTUVWXYZZ0123456789 -]/ /g ; s/ \+/ /g;"`;
	        end=`echo "$a"|${SED} 's/[^\t]*\t[^\t]*\t\([^\t]*\)\t.*/\1/; s/\.//g'`;
	        cntend=`echo "$a"|${SED} -e 's/[^\t]*\t[^\t]*\t\([^\t]*\)\t.*/\1/; s/0*\([1-9][0-9]*\)/\1/g ; s/\./*60+/g'`;
	        cntend="let cntend=$cntend";
	        eval $cntend;

        	let nextdate=cntend\<orig;
	        if test "$nextdate" = "1"; then
        	        let orig=cntend;
                	basedata="$tomorrow";
	        fi


        	end="$basedata""$end""00";
	        echo "<programme start=\"$start\" stop=\"$end\" channel=\"$channelid\">";
	        echo -e "\t<title>$prog</title>";
	        echo -e "</programme>\n";
	done;

}




XLPFX="www.xiaprojects.com/logos/"
FILE_DEST="tv.xml";

channeltmp="tmpchannel$$.xml";
tvtmp="tmptv$$.xml";
defsource="italy_channel$$";
tmplftp="lftp$$";


mpcont=0;
xacont=0;
error=0;



prgname="$0";
while test "$#" != "0" ;do
case "$1" in
	--import)
		shift;
		case "$1" in
			mplayer)
				shift;
				cfile="$1";
				if test -f "$cfile"; then
					mpfile[mpcont]="$cfile not found";
					let mpcont++;
					shift;
				else
					error=1;
					error_type="$cfile not found";
					shift;
				fi
				;;
			xavtv)
				shift;
				cfile="$1";
				if test -f "$cfile";then  
					xafile[xacont]="$cfile";
					let xacont++;
					shift;
				else
					error=1;
					error_type="$cfile not found";
					shift;
				fi
				;;
			*)
				error=1;
				error_type="mplayer or xavtv must follow --import option";
				shift;
				;;
			
		esac;
		;;
	--help)
${CAT} << EOF

$prgname [--help] [[-import mplayer|xavtv file] ...]


	--help			print this help
	--import		import an mplayer or xavtv file conf

						written by Bruno Morelli


EOF
		exit 0;
		;;

	*)
		error=1;
		error_type="'$1' unknow parameter";
		shift;
		;;

esac;
done;

if test $error -eq 1;then
	echo "$error_type" >&2;
	exit 1;
fi



for i in "./italy_default_channels" "$HOME/.italy_default_channels" "/etc/italy_default_channels" "/usr/share/grabmed/italy_default_channels";do
	if test -f "$i";then
		#test -f italy_default_channels && ${CAT} italy_default_channels >> "$defsource";
		${CAT} "$i" >> "$defsource";
		break;
	fi
done


i=0;
while test $i -lt $mpcont;do
#	echo "Reading ${mpfile[$i]}"

# some sed seems to have a bug matching [A-Z] or [a-z] ranges

	${SED} 's/^\([^:]\+\):.*/\1/; /[^QWERTYUIOPASDFGHJKLZXCVBNM qwertyuiopasdfghjklzxcvbnm1234567890()]/d; /^[\t 0123456789]*$/d; /^[dD][lL][0123456789]\+/d; /test\|iepg/d' "${mpfile[$i]}"|while read a;do
		echo "$a:${XLPFX}${a}.png:dvb:$a:::" >> "$defsource";
	done;
	let i++;
done;

i=0;
while test $i -lt $xacont;do
#	echo "Reading ${xafile[$i]}"
	${SED} '/.*\[/!d; s/\[\(.*\)\]/\1/; s/#.*$//; s/global\|defaults//ig; /^[\t ]*$/d;' "${xafile[$i]}"|while read a;do
        	echo "$a:${XLPFX}${a}.png:dvb:$a:::" >> "$defsource";
        done;
	let i++;
done;


basedata=`${DATE} +"%Y%m%d"`;

tmp=`${DATE} +"%Y %m %d"`;
tomorrow=`incdata $tmp`;

# exit

${SED} -e 's/#.*$//; /^[ \t]*$/d; s/:/\n/g' "$defsource"|while read channel_id;do 
	read logo_url;
	read type;
	read channel_name;
	read pgrabber;
	read program_site;
	read post_info_program_site;

#	echo -e "<$channel_id> <$logo_url> <$type> <$channel_name> <$program_site> <$post_info_program_site>\n";

	if test -n "$channel_id";then

#		echo -e "Collecting informations for $channel_id                             \r\c";

		echo "<channel id=\"$channel_id\">" >> "$channeltmp";

		if test -n "$channel_name";then
			echo -e "\t<display-name>$channel_name</display-name>" >> "$channeltmp";
		fi;

		if test -n "$logo_url";then
			echo -e "\t<icon src=\"http://$logo_url\"/>" >> "$channeltmp";
		fi;

		echo -e "</channel>\n" >> "$channeltmp";
	
		if test "$pgrabber" = "mset"; then
#		echo "putting <$channel_id>";

			case "$DEFAULT_DOWNLOADER" in
				wget)
					wgt=`echo "$post_info_program_site"|sed "s/\([^\?]*\)?\(.*\)/--post-data\=\2 -O $tmplftp http:\/\/$program_site\1/" `;
					wget ${wgt} 2>/dev/null >/dev/null;
					;;
				lftp)
					${CAT} << EOF | ${LFTP}  > /dev/null 2> /dev/null
open "http://$program_site"
quote post "$post_info_program_site" > "$tmplftp"
EOF
					;;
				esac;
		fi;
		${CAT} "$tmplftp"| filter_mset "$channel_id" "${basedata}" "${tomorrow}" >> "$tvtmp";
	fi;

done;

${CAT} << EOF  ;# > "$FILE_DEST"
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE tv SYSTEM "xmltv.dtd">
<tv generator-info-name="IT-retriver">
EOF

${CAT} "$channeltmp" ;# >> "$FILE_DEST"
${CAT} "$tvtmp" ;# >> "$FILE_DEST"
echo "</tv>" ;# >> "$FILE_DEST"

rm -f "$tvtmp" "$channeltmp" "$defsource" "$tmplftp";
