# ***********************************
# *
# *	Calendar for Superkaramba
# *	(C) by Thomas Gollenia
# *	email: baraquda@gmx.com
# *	License: BSD
# *
# *	the out-commented print commands are for debugging only!
# ************************************


import karamba
import skxmltvdisplay
import skxmltvengine
import os
import locale
import string
import datetime
from threading import *

# Create a new calendar Object
global calendar
xmltvdisplay= skxmltvdisplay.skxmltvDisplay()
xmltvengine = skxmltvengine.skxmltvEngine()


def initWidget(widget):
	
	
	# add a menu entry to select language
	karamba.addMenuConfigOption(widget, "ac_locale", "Select your country")
	karamba.setMenuConfigOption(widget, "ac_locale", 0)
	
	karamba.addMenuConfigOption(widget, "tv.xml", "Select TV.xml file")
	karamba.setMenuConfigOption(widget, "tv.xml", 0)
	
	karamba.addMenuConfigOption(widget, "playerdvb", "Select player dvb")
	karamba.setMenuConfigOption(widget, "playerdvb", 0)
	
	karamba.addMenuConfigOption(widget, "playertv", "Select player tv")
	karamba.setMenuConfigOption(widget, "playertv", 0)
	# set the language
	locale.setlocale(locale.LC_ALL, getLocale(widget))
	xmltvengine.setXMLSource('tv.xml')
	xmltvdisplay.create(widget,xmltvengine)
	widgetUpdated(widget)
	#xmltvview.repaint(widget)

#                    1 = Left Mouse Button
#                    2 = Middle Mouse Button
#                    3 = Right Mouse Button, but this will never happen
#                        because the right mouse button brings up the
#                        Karamba menu.
#                    4,5 = Scroll wheel up and down
def widgetClicked(widget, x, y, button):

	if(button==1):
		#xmltvdisplay.hideTexts(widget)
		cPlayer="mplayer"
		cProtocol="dvb://"
		cPlayerOpts=" -ao arts"
		cName=xmltvengine.getLastChannelName()
		playcmd=cPlayer+" "+cProtocol+cName+" "+cPlayerOpts
		print playcmd
		karamba.execute(playcmd)
	if(button==4):
		xmltvdisplay.RollUpChannel(widget)
		karamba.redrawWidget(widget)
	if(button==5):
		xmltvdisplay.RollDownChannel(widget)
		karamba.redrawWidget(widget)
	if(button==3):
		xmltvdisplay.hideTexts(widget)
		

def widgetUpdated(widget):
	locale.setlocale(locale.LC_ALL, getLocale(widget))
	xmltvdisplay.repaint(widget)


def getLocale(widget):
	GetLocale = karamba.readConfigEntry(widget, "locale") # have you set any language?
	if GetLocale == None:
		# no language found, using english
		# print "No locale-setting was found. Using English en_US"
		karamba.writeConfigEntry(widget, "locale", "en_US")
		SetLocale = "en_US.ISO8859-1"	
	else:
		# language found! using it
		# print "Locale-setting " + SetLocale + " was found!"
		SetLocale = GetLocale + ".ISO8859-1"
	return SetLocale
	# language is stored in SetLocale now. let's use it:



def menuOptionChanged(widget, key, value):
	global localePid
	if(key=="locale"):
		localeSelection = ["kdialog", "--title", "Country Selector", "--radiolist", "Please select your language:", "en_US", "English", "off", "de_DE", "German", "off", "es_ES", "Spanish", "off", "nl_BE", "Dutch", "off", "fr_FR", "French", "off", "fi_FI", "Finnish", "off", "it_IT", "Italian", "off"]
		if (key == "ac_locale"):
			karamba.setMenuConfigOption(widget, "ac_locale", 0)
			localePid = karamba.executeInteractive(widget, localeSelection)



def commandOutput(widget, pid, output):
	if pid == localePid:
		localeString = output.replace('\n','')
		print "New language " + localeString + " was selected!"
		karamba.writeConfigEntry(widget, "locale", localeString)
		getLocale(widget)
