#!/bin/bash

function mset_filter()
{
	local channel_name start starth stop stoph program
	channel_name="$1";
	${SED} -n 'p;1{h;d;}; p; ${x;p;}'|${SED} -e 'N; s/\n/\t/g'|while read a;do
	eval `echo "$a"|${SED} 's/^\([0-9]\{8\}\)[\t ]*\([0-9]\{2\}\):\([0-9]\{2\}\)/start=\1\2\300/ ; s/\([0-9]\{8\}\)[\t ]*\([0-9]\{2\}\):\([0-9]\{2\}\)/stop=\1\2\300/ ; s/\(start=[0-9]\{8\}\)\([0-9]\{6\}\)[\t ]*\(.*\)[\t ]\+\(stop=[0-9]\{8\}\)\([0-9]\{6\}\).*/\1; starth=\2; program="\3"; \4; stoph=\5/'`

		test ${start} -gt ${stop} && stop=${start};
		program=`echo "$program"|${SED} "s/[^'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 -]//g"`
		echo "<programme start=\"${start}${starth}\" stop=\"${stop}${stoph}\" channel=\"${channel_name}\">";
		echo -e "\t<title>$program</title>";
		echo -e "</programme>";
	done
	exit 1
}

function mset_to_txt()
{
	local tmp_in tmp_out
	tmp_in="$1";
	tmp_out="$2";
	
	${CAT} "$tmp_in" |${SED} ':top1 ; /<!--.*-->/ { s/<!--.*-->//g; } ; /<!--.*/ { N; b top1};   $!{N; b top1;}; s/\n/ /; s/<\/tr[^>]*>/\n/gi; s/<tr[^>]*>/\n/gi; s/<td[^>]*>/\|/gi; s/<\/td[^>]*>/\|/gi; s/<[^>]*>//gi; s/\n */\n/g; s/[\t]*//g; s/\n\+/\n/g ;  s/|[^|]\+$//; s/^[^|]\+// ; s/\n[^|][^\n]*\n//g; s/|\([^|]\+\)||\([^|]\+\)||\([^|]\+\)||\([^|]\+\)||\([^|]\+\)|\?/\1\t\2\t\3/g; s/|[^\n]*\n//g ; s/|[^\n]*\n//g;'|${SED} 's/\n\?[a-z]\{3\} \([0-9]\{2\}\)\/\([0-9]\{2\}\)\/\([0-9]\{4\}\)\t/\3\2\1\t/g' >> "$tmp_out"


}

function mset_find_stop_page()
{
	local tmp_in max
	tmp_in="$1";
	max=0
	for i in `${CAT} "$tmp_in" | ${SED} '/javascript:page(/!d ; '":a ; s/\(.*\)javascript:page('\([^)]*\)')[^\n]*/\1\n\2/; ta ; s/^[^\n]*\n// ; "`; do
		test $i -gt $max && max="$i"
	done
	echo "$max"
}

FILE_DEST_TMP="tv$$.xml";
channeltmp="tmpchannel$$.xml";
tvtmp="tmptv$$.xml";
listtmp="tmplist$$.txt";
defsource="italy_channel$$.tmp";
tmplftp="lftp$$";

trap 'rm -f "$tvtmp" "$channeltmp" "$defsource" "$tmplftp" "$FILE_DEST_TMP" "$listtmp"; exit 1' TERM INT

DEFAULT_SED="/usr/local/bin/sed";
DEFAULT_LFTP="/usr/local/bin/lftp";
DEFAULT_WGET="/usr/local/bin/wget";
DEFAULT_CAT="/usr/local/bin/cat";
DEFAULT_DATE="/usr/local/bin/date";

unset SED
unset LFTP
unset WGET
unset CAT
unset DATE
unset FILE_DEST

#check for indispensable programs
which --help 2>/dev/null > /dev/null

if test $? -eq 0;then
	SED=`which sed 2>/dev/null`;
	test -z "$SED" && SED="$DEFAULT_SED";

	LFTP=`which lftp 2>/dev/null`;
	test -z "$LFTP" && LFTP="$DEFAULT_LFTP";

	WGET=`which wget 2>/dev/null`;
	test -z "$WGET" && LFTP="$DEFAULT_WGET";

	CAT=`which cat 2>/dev/null`;
	test -z "$CAT" && CAT="$DEFAULT_CAT";

	DATE=`which date 2>/dev/null`;
	test -z "$DATE" && DATE="$DEFAULT_DATE";
else
	SED="$DEFAULT_SED";
	LFTP="$DEFAULT_LFTP";
	WGET="$DEFAULT_WGET";
	CAT="$DEFAULT_CAT";
	DATE="$DEFAULT_DATE";
fi

if test ! -f "$SED";then
	echo "sed program is required" >&2;
	exit 2;
fi

DEFAULT_DOWNLOADER="wget"
if test ! -f "$LFTP";then
	DEFAULT_DOWNLOADER="wget";
	if test ! -f "$WGET";then
		echo "lftp or wget program is required" >&2;
		exit 2;
	fi;
fi


if test ! -f "$CAT";then
	echo "cat program is required" >&2;
	exit 2;
fi

if test ! -f "$DATE";then
	echo "date program is required" >&2;
	exit 2;
fi


XLPFX="www.xiaprojects.com/logos/"
mpcont=0;
xacont=0;
error=0;


prgname="$0";
while test "$#" != "0" ;do
case "$1" in
	--import)
		shift;
		case "$1" in
			mplayer)
				shift;
				cfile="$1";
				if test -f "$cfile"; then
					mpfile[mpcont]="$cfile";
					let mpcont++;
					shift;
				else
					error=1;
					error_type="file \"$cfile\" not found.";
					break;
				fi
				;;
			xavtv)
				shift;
				cfile="$1";
				if test -f "$cfile";then  
					xafile[xacont]="$cfile";
					let xacont++;
					shift;
				else
					error=1;
					error_type="file \"$cfile\" not found.";
					break;
				fi
				;;
			*)
				error=1;
				error_type="mplayer or xavtv must follow --import option.";
				break;
				;;
			
		esac;
		;;
	--help)
${CAT} << EOF

$prgname [--help] [[--import mplayer|xavtv file] ...] [--output|-o file]


	--help			print this help
	--import		import an mplayer or xavtv file conf

	--output file		save to file
	-o file			
						written by Bruno Morelli


EOF
		exit 0;
		;;
	--output|-o)
		shift;
		FILE_DEST="$1";
		if test x"$FILE_DEST"x = xx ; then
			error=1;
			error_type="output file expected";
			break;
		fi;
		shift;
		;;

	*)
#		error=1;
#		error_type="'$1' unknow parameter";
		shift;
		;;

esac;
done;

if test $error -eq 1;then
	echo "$error_type" >&2;
	exit 1;
fi



for i in "./italy_default_channels" "$HOME/.italy_default_channels" "/etc/italy_default_channels" "/usr/share/grabmed/italy_default_channels";do
	if test -f "$i";then
		${CAT} "$i" >> "$defsource";
		break;
	fi
done


i=0;
while test $i -lt $mpcont;do

# some sed seems to have a bug matching [A-Z] or [a-z] ranges

	${SED} 's/^\([^:]\+\):.*/\1/; /[^QWERTYUIOPASDFGHJKLZXCVBNM qwertyuiopasdfghjklzxcvbnm1234567890()]/d; /^[\t 0123456789]*$/d; /^[dD][lL][0123456789]\+/d; /test\|iepg/d' "${mpfile[$i]}"|while read a;do
		echo "$a:${XLPFX}${a}.png:dvb:$a:::" >> "$defsource";
	done;
	let i++;
done;

i=0;
while test $i -lt $xacont;do

	${SED} '/.*\[/!d; s/\[\(.*\)\]/\1/; s/#.*$//; s/global\|defaults//ig; /^[\t ]*$/d;' "${xafile[$i]}"|while read a;do
        	echo "$a:${XLPFX}${a}.png:dvb:$a:::" >> "$defsource";
        done;
	let i++;
done;


basedata=`date +"%Y%m%d"`;

${SED} -e 's/#.*$//; /^[ \t]*$/d; s/:/\n/g' "$defsource"|while read channel_id;do
	read logo_url;
	read type;
	read channel_name;
	read pgrabber;
	read program_site;
	read post_info_program_site;

	if test -n "$channel_id";then
		echo "<channel id=\"$channel_id\">" >> "$channeltmp";

		if test -n "$channel_name";then
			echo -e "\t<display-name>$channel_name</display-name>" >> "$channeltmp";
                fi;

		if test -n "$logo_url";then
			echo -e "\t<icon src=\"http://$logo_url\"/>" >> "$channeltmp";
		fi;

		echo -e "</channel>\n" >> "$channeltmp";

		if test "$pgrabber" = "mset"; then
			case "$DEFAULT_DOWNLOADER" in
				wget)
					wgt=`echo "$post_info_program_site&giorno=$basedata&inizio=0"|${SED} "s/\([^\?]*\)?\(.*\)/--post-data\=\2 -O $tmplftp http:\/\/$program_site\1/"`;
					${WGET} ${wgt} 2>/dev/null >/dev/null;
					mset_to_txt "$tmplftp" "$listtmp"
					max=`mset_find_stop_page "$tmplftp"`
					if test $max -gt 0 ; then
						for i in `seq 1 $max`;do
							wgt=`echo "$post_info_program_site&giorno=$basedata&inizio=$i"|${SED} "s/\([^\?]*\)?\(.*\)/--post-data\=\2 -O $tmplftp http:\/\/$program_site\1/"`;
							${WGET} ${wgt} 2>/dev/null >/dev/null;
							mset_to_txt "$tmplftp" "$listtmp"
						done
					fi
					;;
				lftp)
					${CAT} << EOF | ${LFTP}  > /dev/null 2> /dev/null
open "http://$program_site"
quote post "$post_info_program_site&giorno=$basedata&inizio=0" > "$tmplftp"
EOF
					mset_to_txt "$tmplftp" "$listtmp"
					max=`mset_find_stop_page "$tmplftp"`
					if test ${max} -gt 0 ; then 
						for i in `seq 1 $max`;do
							${CAT} << EOF | lftp > /dev/null 2> /dev/null
open "http://$program_site"
quote post "$post_info_program_site&giorno=$basedata&inizio=$i" > "$tmplftp"
EOF
							mset_to_txt "$tmplftp" "$listtmp"
						done
					fi
					;;
				esac;
			${CAT} "$listtmp"| mset_filter "$channel_name" >> "$tvtmp";
		fi;
	fi
done

${CAT} << EOF > "$FILE_DEST_TMP"
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE tv SYSTEM "xmltv.dtd">
<tv generator-info-name="IT-retriver">
EOF

${CAT} "$channeltmp" >> "$FILE_DEST_TMP"
${CAT} "$tvtmp"  >> "$FILE_DEST_TMP"

echo "</tv>" >> "$FILE_DEST_TMP"

if test -n "$FILE_DEST"; then
	mv "$FILE_DEST_TMP" "$FILE_DEST";
else
	cat "$FILE_DEST_TMP";
fi;

rm -f "$tvtmp" "$channeltmp" "$defsource" "$tmplftp" "$FILE_DEST_TMP" "$listtmp";