# ***********************************
# *
# *	Calendar for Superkaramba
# *	(C) by Thomas Gollenia
# *	email: baraquda@gmx.com
# *	License: BSD
# *
# *	the out-commented print commands are for debugging only!
# ************************************


import karamba
import skmoondisplay
import skmoonengine
import os
import locale
import string
import datetime
from threading import *

# Create a new calendar Object
global calendar
moondisplay= skmoondisplay.skmoondisplay()
moonengine = skmoonengine.skmoonengine()


def initWidget(widget):
	
	
	# add a menu entry to select language
	karamba.addMenuConfigOption(widget, "epatta", "Set your E-Patta")
	karamba.addMenuConfigOption(widget, "kxdocker", "Enable KXDocker Icons")
	#karamba.setMenuConfigOption(widget, "epatta", 0)
	# set the language
	locale.setlocale(locale.LC_ALL, getLocale(widget))
	moonengine.epatta=karamba.readConfigEntry(widget, "epatta")
	if(moonengine.epatta==None or moonengine.epatta=='' or moonengine.epatta=='None'):
		moonengine.epatta=0
	moondisplay.kxdocker_show=karamba.readConfigEntry(widget, "kxdocker")
	if(moondisplay.kxdocker_show==None or moondisplay.kxdocker_show=='' or moondisplay.kxdocker_show=='None'):
		moondisplay.kxdocker_show=1

	moondisplay.create(widget,moonengine)
	widgetUpdated(widget)
	#xmltvview.repaint(widget)

#                    1 = Left Mouse Button
#                    2 = Middle Mouse Button
#                    3 = Right Mouse Button, but this will never happen
#                        because the right mouse button brings up the
#                        Karamba menu.
#                    4,5 = Scroll wheel up and down
def widgetClicked(widget, x, y, button):

	if(button==1):
		print 1
	if(button==4):
		print 4
	if(button==5):
		print 5
	if(button==3):
		print 3

def widgetUpdated(widget):
	locale.setlocale(locale.LC_ALL, getLocale(widget))
	moondisplay.repaint(widget)


def getLocale(widget):
	GetLocale = karamba.readConfigEntry(widget, "locale") # have you set any language?
	if GetLocale == None:
		# no language found, using english
		# print "No locale-setting was found. Using English en_US"
		karamba.writeConfigEntry(widget, "locale", "en_US")
		SetLocale = "en_US.ISO8859-1"	
	else:
		# language found! using it
		# print "Locale-setting " + SetLocale + " was found!"
		SetLocale = GetLocale + ".ISO8859-1"
	return SetLocale
	# language is stored in SetLocale now. let's use it:


localePid=0
pidEpatta=0

def menuOptionChanged(widget, key, value):
	global localePid
	global pidEpatta
	if(key=="locale"):
		localeSelection = ["kdialog", "--title", "Country Selector", "--radiolist", "Please select your language:", "en_US", "English", "off", "de_DE", "German", "off", "es_ES", "Spanish", "off", "nl_BE", "Dutch", "off", "fr_FR", "French", "off", "fi_FI", "Finnish", "off", "it_IT", "Italian", "off"]
		if (key == "ac_locale"):
			karamba.setMenuConfigOption(widget, "ac_locale", 0)
			localePid = karamba.executeInteractive(widget, localeSelection)
	if(key=="epatta"):
		localeSelection = ["kdialog", "--title","Superkaramba MoonPhases","--inputbox", "Start Day (your epatta)", str(moonengine.epatta)]
		if (key == "epatta"):
			karamba.setMenuConfigOption(widget, "epatta", 0)
			pidEpatta = karamba.executeInteractive(widget, localeSelection)
	
	if(key=="kxdocker"):
		testkxd = os.popen('kdialog --yesno "Enable KXDocker Icon?" && echo si').readlines()
		if len(testkxd) > 0:
			moondisplay.kxdocker_show=1
			moondisplay.testKXDocker()
			moondisplay.updateKXDocker(widget)
		else:
			moondisplay.kxdocker_show=0
			moondisplay.removeKXdocker()
		karamba.writeConfigEntry(widget, "kxdocker",str(moondisplay.kxdocker_show))

def commandOutput(widget, pid, output):
	global pidEpatta
	if pid == pidEpatta:
		moonengine.epatta = output.replace('\n','')
		if(moonengine.epatta==''):
			moonengine.epatta='0'
		print "New epatta " + moonengine.epatta + " was selected!"
		karamba.writeConfigEntry(widget, "epatta", moonengine.epatta)
		widgetUpdated(widget)
