<?

$NEWENGINE="1.0.0.2";

function print_search_info($project_path, $project_relative, $section)
{
	$buffer="";
	$buffer.=print_project_info($project_path, $project_relative, $section);
	return $buffer;
}

function search_map($section)
{
	$buffer="";
	$counter=0;
	if ($handle = opendir($XIAPREFIX . 'projects'))
	{
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(is_dir($XIAPREFIX . 'projects/' . $file)>0)
			{
				if($section!="" && $section!="All")
				{
					if(file_exists($XIAPREFIX . 'projects/' . $file . '/' . $section . '.section' )!=1)continue;
				}

				$get_keywords="";
				if(file_exists($XIAPREFIX . 'projects/' . $file . '/keywords.txt'))
				{
					$get_keywords=load_keywords($XIAPREFIX . 'projects/' . $file . '/keywords.txt');
				}
				
				$counter++;
				$buffer.=str_replace("<br>"," <em>" . $get_keywords . "</em><br>", print_search_info($XIAPREFIX . 'projects/' , $file,$section));
			}
		}
		closedir($handle);
	}
	return $buffer;
}

function search_project($section, $keys)
{
	$buffer="";
	$counter=0;
	if ($handle = opendir($XIAPREFIX . 'projects'))
	{
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(is_dir($XIAPREFIX . 'projects/' . $file)>0)
			{
				if($section!="" && $section!="All")
				{
					if(file_exists($XIAPREFIX . 'projects/' . $file . '/' . $section . '.section' )!=1)continue;
				}
				$founding=0;
				for($i=0;$i<sizeof($keys);$i++)
				{
					if(strpos(strtolower($file),strtolower($keys[$i]))=== false)
					{
						continue;
					}
					$founding++;
				}
				if($founding<sizeof($keys) && file_exists($XIAPREFIX . 'projects/' . $file . '/keywords.txt'))
				{
					$get_keywords=load_keywords($XIAPREFIX . 'projects/' . $file . '/keywords.txt');
					$founding=0;
					for($i=0;$i<sizeof($keys);$i++)
					{
						if(strpos(strtolower($get_keywords),strtolower($keys[$i]))=== false)
						{
							continue;
						}
						$founding++;
					}
				}
				
				if($founding>=sizeof($keys))
				{
					$counter++;
					$buffer.=print_search_info($XIAPREFIX . 'projects/' , $file,$section);
				}
			}
		}
		if($counter>0)
		{
			$buffer="<i>founded $counter projects<ul>" . $buffer . "</ul>";
		}
		else
		{
			if($section!="" && $section!="All")
			{
				$buffer.="<table><tr><td style='padding:5px;'>";
				$buffer="<i>no projects founded, do you like to try searching on All sections?</td><td style='padding:5px;'>";
				$buffer.="<form action='?section=$SELECTEDSECTION&project=Search project' method='POST'><input type='hidden' name='find' value='" . implode(" ", $keys) . "'/>";
				$buffer.="<input type='submit' value='Search again'/>";
				$buffer.="</form></td></tr></table>";
			}
		}
		closedir($handle);
	}
	return $buffer;
}

function print_project_info($project_path, $project_relative, $section)
{
	$buffer="";
	$buffer.=" <a href='?section=$section&project=$project_relative'>";
	$buffer.=$project_relative;
	
	$buffer.="</a>";
	$buffer.=" " . page_count_project($project_relative) . " hits";
	$buffer.="<br>";
	return $buffer;
}
function print_section_info($project_path, $project_relative)
{
	$buffer="";
	$buffer.=" <a href='?section=$project_relative'>";
	$buffer.=$project_relative;
	$buffer.="</a><br>";
	return $buffer;
}
function print_section_list()
{
	$buffer="";
	$counter=0;
	
	if ($handle = opendir($XIAPREFIX . 'sections'))
	{

		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(is_dir($XIAPREFIX . 'sections/' . $file)>0)
			{
				$buffer.=print_section_info($XIAPREFIX . '/sections/' , $file);
				$counter++;
			}
		}
		closedir($handle);
	}
	if($counter>0)
	{
	$buffer="<i>sections ($counter):</i><br><ul>" . $buffer . "</ul>";
	}
	return $buffer;

}
function print_project_list($section)
{
$buffer="";
$counter=0;
if ($handle = opendir($XIAPREFIX . 'projects'))
	{
	while (false !== ($file = readdir($handle)))
	{
		if($file==".")continue;
		if($file=="..")continue;
		if(is_dir($XIAPREFIX . 'projects/' . $file)>0)
		{

if($section!="" && $section!="All")
{
	if(file_exists($XIAPREFIX . 'projects/' . $file . '/' . $section . '.section' )!=1)continue;
}
$counter++;
			$buffer.=print_project_info($XIAPREFIX . 'projects/' , $file,$section);
		}
	}
	if($counter>0)
	{
	$buffer="<i><br>browsing avaiable projects ($counter) on selected section:</i><br><ul>" . $buffer . "</ul>";
	}
	
	closedir($handle);
}
return $buffer;
}
function print_download_generic($filename, $project)
{
	$buffer="";
	$buffer.="<a>$filename</a>";
	return $buffer;	
}
function load_keywords($filename)
{
	if(file_exists($filename))
	{
		$buffer="";
		$f_c_contents = file($filename);
		while(list($lineno,$row) = each($f_c_contents))
		{
			$buffer.=$row . " ";
		}
		return $buffer;
	}
	else return "";
}
function top_projects($appendproject="", $maxRows=5,$section="")
{
		$buffer="";
		$counter=0;
		if ($handle = opendir($XIAPREFIX . 'projects'))
			{
			while (false !== ($file = readdir($handle)))
			{
				if($file==".")continue;
				if($file=="..")continue;
				if(is_dir($XIAPREFIX . 'projects/' . $file)>0)
				{
					if($section!="" && $section!="All")
					{
						if(file_exists($XIAPREFIX . 'projects/' . $file . '/' . $section . '.section' )!=1)continue;
					}
					$counter++;
					$thiscount=page_count_project($project_relative) . " hits";
				}
			}
			closedir($handle);
		}
		return $buffer;
}
function recent_projects($appendproject="", $maxRows=5)
{
	$filename="stats/recents_projects.txt";
	
	$allBuffer="";
	if(file_exists($filename))
	{
		$buffer="";
		$f_c_contents = file($filename);
		while((list($lineno,$row) = each($f_c_contents)) && $maxRows>0)
		{
		$thisp=trim($row);
		if($thisp!="")
		{
		if($appendproject==$thisp)$appendproject="";
			$maxRows--;
			$buffer.=print_project_info("projects/" . $thisp,$thisp, "All");
			$allBuffer.=$thisp . "\n";
		}
		}
	}
	if($appendproject!="")
	{
		$allBuffer=$appendproject . "\n" . $allBuffer;
		$fo = fopen($filename,"w");
		fwrite($fo,$allBuffer);
		fclose($fo);
	}
	return $buffer;
}
function page_count($prj, $act,$sum =0)
{
	$page_count_result=$sum;
	$prj=str_replace(" ","", $prj);
	$act=str_replace(" ","", $act);
	$page_count_filename="stats/pagesview_" . $prj . "_" . $act . ".txt";
	if(file_exists($page_count_filename)){
		$new = 0;
		$f_c_contents = file($page_count_filename);
		while(list($lineno,$row) = each($f_c_contents))
		{
			$page_count_result=$row;
			if(is_numeric($page_count_result))$page_count_result=$sum+(intval($page_count_result));
			else $page_count_result=$sum;
		}
	}
	if($sum!=0)
	{
		$fo = fopen($page_count_filename,"w");
		fwrite($fo,$page_count_result);
		fclose($fo);
	}
	return $page_count_result;
}

function print_redirect_download($url,$file)
{
	$buffer="";
	page_count("downloads",$file,1);
	header("location: $url"); 
	return $buffer;
}

function page_count_project($req_project)
{
	$buffer=0;
	$count=0;
	if(file_exists($XIAPREFIX . 'projects/' . $req_project))
	{
	if ($handle = opendir($XIAPREFIX . 'projects/' . $req_project))
	{
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(!is_dir($XIAPREFIX . 'projects/' . $file))
			{
				if(endsWith($file, ".php"))
				{
					$file = str_replace(".php","", $file);
					$info="$file";
					if($req_action==$info)continue;
					$buffer+= page_count($req_project,$file,0);
					$count++;
				}
			}
		}
		closedir($handle);
	}}
	return $buffer;
}

function print_project_action($req_action,$req_project,$req_section)
{
	global $PROJECTPATH;
	global $SELECTEDSECTION;
	global $PROJECTNAME;
	global $global_array_include;
	
	if($req_action=="")$req_action="index";

	$buffer="";
	$PROJECTNAME=$req_project;
	$SELECTEDSECTION=$req_section;
	$PROJECTPATH=$XIAPREFIX . 'projects/' . $PROJECTNAME . '/';
	$urlo=$PROJECTPATH . $req_action . '.php';
	if(file_exists($urlo)!=1)return $buffer;
	$buffer.= ' [';
	$buffer.= date ("d/F/Y H:i",filemtime($urlo));
	$buffer.= ' ] ';
	$buffer.= page_count($req_project,$req_action,1) . " hits";
	
	$buffer.=print_project_actions($req_project,$req_section,$req_action);
	
	$buffer.="<div style='background-color:#A0A0A0;width:100%;height:1px;'></div>";
	$buffer.= '%PROJECT_CONTENT%';
	$global_array_include["%PROJECT_CONTENT%"]=$urlo;
	return $buffer;
}
function size_readable ($size, $retstring = null)
{
        // adapted from code at http://aidanlister.com/repos/v/function.size_readable.php
        $sizes = array('B', 'kB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
        if ($retstring === null) { $retstring = '%01.2f %s'; }
        $lastsizestring = end($sizes);
        foreach ($sizes as $sizestring) {
                if ($size < 1024) { break; }
                if ($sizestring != $lastsizestring) { $size /= 1024; }
        }
        if ($sizestring == $sizes[0]) { $retstring = '%01d %s'; } // Bytes aren't normally fractional
        return sprintf($retstring, $size, $sizestring);
}

function print_project_themes($screenshotname, $req_project)
{
	global $XIAPRREFIX;
	$buffer="";
	if(is_dir($XIAPREFIX . 'downloads/' . $req_project . '/' . $screenshotname)>0)
	{
	if ($handle = opendir($XIAPREFIX .'downloads/' . $req_project . '/' . $screenshotname))
	{
		$buffer.= "<table class='download' border='1'>";
	
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if($file=="hidden.section")continue;
			if(endsWith($file, ".hidden"))continue;
			$urlo=$XIAPREFIX .'downloads/' . $req_project . '/' . $screenshotname . "/" . $file;
			if(!is_dir($urlo))
			{
				if((endsWith($file, ".tar.bz2") || endsWith($file, ".tar.gz")|| endsWith($file, ".zip")))
				{
					$buffer.= "<tr>";
					$buffer.= "<td>";
							$buffer.= date ("d/F/Y H:i",filemtime($urlo));
					$buffer.= "</td>";
					$buffer.= "<td>";
$nameWithoutExt=$urlo;
$nameWithoutExt=str_replace(".tar.bz2","",$nameWithoutExt);
$nameWithoutExt=str_replace(".tar.gz","",$nameWithoutExt);
$nameWithoutExt=str_replace(".zip","",$nameWithoutExt);
					
if(file_exists($nameWithoutExt . ".jpg"))$buffer.= "<img src='".$nameWithoutExt . ".jpg"."' border='0'/><br>";
if(file_exists($nameWithoutExt . ".png"))$buffer.= "<img src='".$nameWithoutExt . ".png"."' border='0'/><br>";
					
							$target_url=$urlo;
							if(file_exists($urlo . ".hidden"))$buffer.= "$file (download locked)";
							else $buffer.= "<a href='?downloadfile=$target_url&downloadname=$file' name='$file'>$file</a>";
					$buffer.= "<td>";
							$buffer.= size_readable(filesize($urlo));
					$buffer.= "</td>";
					$buffer.= "<td>";
							$buffer.= page_count("downloads",$file,0) . " downloads";
					$buffer.= "</td>";		
					$buffer.= "</tr>";
				}
			}
			else
			{
			if(file_exists($urlo . "/hidden.section"))continue;
		$buffer.= "<tr>";
		$buffer.= "<td>";
				$buffer.= date ("d/F/Y H:i",filemtime($urlo));
		$buffer.= "</td>";
		$buffer.= "<td colspan='2'>";
				$buffer.= "<a href='#' onclick='if(document.getElementById(\"$file\").style.display!=\"\")document.getElementById(\"$file\").style.display=\"\";else document.getElementById(\"$file\").style.display=\"none\";'>Browse $file</a>";
				$buffer.= "<div id='$file' style='display:none;'>";
				$buffer.= print_project_downloads($screenshotname . "/" . $file, $req_project);
				$buffer.= "</div>";
		$buffer.= "</tr>";
			}
		}
		closedir($handle);
		$buffer.= "</table>";
	}
	}
	return $buffer;	
}
function print_project_downloads($screenshotname, $req_project)
{
	global $XIAPRREFIX;
	
	$buffer="";
	if(is_dir($XIAPREFIX . 'downloads/' . $req_project . '/' . $screenshotname)>0)
	{
	if ($handle = opendir($XIAPREFIX .'downloads/' . $req_project . '/' . $screenshotname))
	{
		$buffer.= "<table class='download' border='1'>";
	
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if($file=="hidden.section")continue;
			if(endsWith($file, ".hidden"))continue;
			

		$urlo=$XIAPREFIX .'downloads/' . $req_project . '/' . $screenshotname . "/" . $file;
		
			if(!is_dir($urlo))
			{
		$buffer.= "<tr>";
		$buffer.= "<td>";
				$buffer.= date ("d/F/Y H:i",filemtime($urlo));
		$buffer.= "</td>";
		$buffer.= "<td>";
				$target_url=$urlo;
				if(file_exists($urlo . ".hidden"))$buffer.= "$file (download locked)";
				else $buffer.= "<a href='?downloadfile=$target_url&downloadname=$file' name='$file'>$file</a>";
		$buffer.= "<td>";
				$buffer.= size_readable(filesize($urlo));
		$buffer.= "</td>";
		$buffer.= "<td>";
				$buffer.= page_count("downloads",$file,0) . " downloads";
		$buffer.= "</td>";		
		$buffer.= "</tr>";
			}
			else
			{
			if(file_exists($urlo . "/hidden.section"))continue;
		$buffer.= "<tr>";
		$buffer.= "<td>";
				$buffer.= date ("d/F/Y H:i",filemtime($urlo));
		$buffer.= "</td>";
		$buffer.= "<td colspan='2'>";
				$buffer.= "<a href='#' onclick='if(document.getElementById(\"$file\").style.display!=\"\")document.getElementById(\"$file\").style.display=\"\";else document.getElementById(\"$file\").style.display=\"none\";'>Browse $file</a>";
				$buffer.= "<div id='$file' style='display:none;'>";
				$buffer.= print_project_downloads($screenshotname . "/" . $file, $req_project);
				$buffer.= "</div>";
		$buffer.= "</tr>";
			}
		}
		closedir($handle);
		$buffer.= "</table>";
	}
	}
	return $buffer;	
}
function print_project_screenshots($screenshotname, $req_project)
{
	global $XIAPRREFIX;
	
	$buffer="";
	
	
	if(is_dir($XIAPREFIX . 'screenshots/' . $req_project . '/' . $screenshotname)>0)
	{
	if ($handle = opendir($XIAPREFIX .'screenshots/' . $req_project . '/' . $screenshotname))
	{
	
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			$urlo=$XIAPREFIX .'screenshots/' . $req_project . '/' . $screenshotname . "/" . $file;
			if(!is_dir($urlo))
			{
			
				if(endsWith(strtolower($file), ".jpg") || endsWith(strtolower($file), ".png")|| endsWith(strtolower($file), ".gif")|| endsWith(strtolower($file), ".png"))
				{
					$minitest=$XIAPREFIX .'screenshots/' . $req_project . '/' . $screenshotname . "/mini/" . $file;
					$mini=$urlo;
					$width=" width='128' ";
					if(file_exists($minitest))
					{
						$width="";
						$mini=$minitest;
					}
					$buffer.= "<a href='$urlo'><img src='$mini' border='0' $width alt='$req_project - $file'/></a>";
				}
			}
		}
		closedir($handle);
	}
	}
	return $buffer;	
}


function endsWith( $str, $sub ) {
   return ( substr( $str, strlen( $str ) - strlen( $sub ) ) === $sub );
}
function print_project_action_info($req_project,$req_section,$file, $info)
{
	$buffer="";
	$buffer.="<a href='?section=$req_section&project=$req_project&action=$file'>";
	$buffer.=$info;
	$buffer.="</a>";
	return $buffer;
}
function print_project_actions($req_project,$req_section, $req_action)
{
	$buffer="";
	$count=0;
	if ($handle = opendir($XIAPREFIX . 'projects/' . $req_project))
	{
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(!is_dir($XIAPREFIX . 'projects/' . $file))
			{
				if(endsWith($file, ".php"))
				{
					$file = str_replace(".php","", $file);
					$info="$file";
					if($req_action==$info)continue;
					if($count>0)$buffer.= " - ";
					$buffer.= print_project_action_info($req_project,$req_section,$file, $info);
					$count++;
				}
			}
		}
		closedir($handle);
		if($count>0)
		{
			$buffer="<br>Read article: " . $buffer . "";
		}
	}
	return $buffer;
}
function get_array_sections()
{
	$array_prj=array();
	if ($handle = opendir($XIAPREFIX . 'sections'))
	{
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(is_dir($XIAPREFIX . 'sections/' . $file)>0)
			{
				$array_prj[sizeof($array_prj)]=$file;
			}
		}
		closedir($handle);
	}
	return $array_prj;
}
function secure_section($req_project)
{
	$array_prj=get_array_sections();
	for($i=0;$i<sizeof($array_prj);$i++)
	{
		if($array_prj[$i]==$req_project)return $req_project;
	}
	return "";
}
function get_array_projects($section="")
{
	$array_prj=array();
	if ($handle = opendir($XIAPREFIX . 'projects'))
	{
		while (false !== ($file = readdir($handle)))
		{
			if($file==".")continue;
			if($file=="..")continue;
			if(is_dir($XIAPREFIX . 'projects/' . $file)>0)
			{
				$array_prj[sizeof($array_prj)]=$file;
			}
		}
		closedir($handle);
	}
	return $array_prj;
}
function secure_project($req_project)
{
	$array_prj=get_array_projects();
	for($i=0;$i<sizeof($array_prj);$i++)
	{
		if($array_prj[$i]==$req_project)return $req_project;
	}
	return "";
}
function urlaction($name)
{
	global $PROJECTPATH;
	global $SELECTEDSECTION;
	global $PROJECTNAME;
	$buffer="";
	$buffer.="?section=$SELECTEDSECTION&project=$PROJECTNAME&action=$name";
	return $buffer;
}

function print_default($phppage)
{
	global $global_array_include;

	$buffer="<div style='background-color:#A0A0A0;width:100%;height:1px;'></div>";
	$buffer.="%PAGE_DEFAULT_MODULE%";
	$global_array_include["%PAGE_DEFAULT_MODULE%"]=$phppage;
	return $buffer;
}
?>