<?
/* ===================================================================================
 * Copyright (c) 2001 Rudy S. Ingga (toekangweb@wartamikael.org). All rights reserved.
 *
 * wmcounter.php
 *   Function to display daily + total counter for your page(s)
 * 
 * This module is released under the GNU General Public License. See:
 *   http://www.gnu.org/copyleft/gpl.html
 * 
 * Version
 *   0.1a,	Friday, April 20, 2001 09:40:15 PM
 *          Fixed offset_time function for .php3 mode
 *
 *   0.1,	Monday, March 19, 2001 01:43:59 PM
 *
 * For latest version and example, visit:
 *   http://wartamikael.org/PHPScripts
 *
 * Notice for WMNews Users:
 *   Copy function daily_count below, paste it into wmlib.php, TADA...!
 *   So simple, isnt' it? Display your counter by insert the code as written
 *   on readme.html or if you want..., scroll this screen... you'll find
 *   the same code there :P
 * ===================================================================================
 */

/* Your data path
 * Keeps all files created by script, for your security,
 * change name of this directory to be an unusual name like 'jVld0ksqQk' or 
 * something else to make it hard to find by someone who doesn't have authority
 * for the * files :). Don't forget to chmod this subdir to '777'.
 */

$base_datapath = $XIAPREFIX . "stats";

/* How many seconds different between webserver time and the real time in your place,
 * 3600 means 3600 seconds / 1 hour. I've never tried with -/minus :)
 */

$offset=0;

/* GREAT! YOU'VE DONE IT! Next step is follow the code on readme.html, or...
 * copy and paste sample code below into your page. :P

include("wmcounter.php");
$visitors = daily_count("","");
echo "Visitors today: ".$visitors[0]." from total: ".$visitors[1]." visitors, since ".$visitors[2];

 *
 */


/*
 * ============================================================
 * function offset_time()
 * Return updated Unix timestamp after recalculate with $offset
 * ------------------------------------------------------------
 */
function offset_time() {
	global $offset;
	$offsettime	= time()+$offset;
	$localtime = getdate($offsettime);
	$i = 0;
	while(list($k,$v) = each($localtime)){
		if($i == 0){
			$detik = $v;
			if($detik < 10){ $detik = "0".$detik; }
		}elseif($i == 1){
			$menit = $v;
			if($menit < 10){ $menit = "0".$menit; }
		}elseif($i == 2){
			$jam = $v;
			if($jam < 10){ $jam = "0".$jam; }
		}elseif($i == 3){
			$tanggal = $v;
			if($tanggal < 10) { $tanggal = "0".$tanggal; }
		}elseif($i == 5){
			$bulan = $v;
			if($bulan < 10) { $bulan = "0".$bulan; }
		}elseif($i == 6){
			$tahun = $v;
		}	
		$i++;
	}
	$offset_time = "$tahun$bulan$tanggal$jam$menit$detik";
	return $offset_time;
}


/*
 * ============================================================
 * function daily_count($counter_file_name, $visitor_file_name)
 * Display how many visitors get in!
 * ------------------------------------------------------------
 */
$REMOTE_ADDR = getenv("REMOTE_ADDR");
$HTTP_USER_AGENT= getenv("HTTP_USER_AGENT");
$HTTP_REFERER= getenv("HTTP_REFERER");

$REMOTE_ADDR=getenv("REMOTE_ADDR");
function daily_count($counter_file_name, $visitor_file_name){

	global $base_datapath, $REMOTE_ADDR, $HTTP_USER_AGENT, $HTTP_REFERER;
	if (($REMOTE_ADDR)=="")$REMOTE_ADDR="127.0.0.1";

	if(empty($counter_file_name)){ $counter_file_name = "daily_count.wmn"; }
	if(empty($visitor_file_name)){ $visitor_file_name = "daily_visitors.wmn"; }
	$counter_file_path = $base_datapath."/".$counter_file_name;
	$visitor_file_path = $base_datapath."/".$visitor_file_name;

	$get_visitors = 0;
	$get_total = 0;
	$new = 1;
	$newday = 0;
	$visitor_found = 0;
	$elap_time = 3600;
	$visitor_host = gethostbyaddr($REMOTE_ADDR);
	if(!$visitor_host){ $visitor_host = $REMOTE_ADDR; }

	$offset_time = offset_time();
	$currTime = time() + $offset;
	$tahun = substr($offset_time,0,4);
	$bulan = substr($offset_time,4,2);
	$hari = substr($offset_time,6,2);
	$currDate = $tahun."-".$bulan."-".$hari;
	$firstDate = $currDate;

	if(file_exists($counter_file_path) && file_exists($visitor_file_path)){

		$new = 0;
		$f_c_contents = file("$counter_file_path");
		while(list($lineno,$row) = each($f_c_contents)){
			$row_content = explode("|",$row);
			if($row_content[0] == $currDate){
				$f_v_contents = file("$visitor_file_path");
				$get_visitors = $row_content[1];
				while(list($v_lineno,$v_row) = each($f_v_contents)){
					$row_v_content = explode("|",$v_row);
					if(($row_v_content[1] == $REMOTE_ADDR) && (($row_v_content[0] + $elap_time) > $currTime)) {
						$visitor_found = 1;
					}
				}
			}else{
				$newday = 1;
			}
			$firstDate = $row_content[3];
			$get_total = $row_content[2];
		}

	}

	if(!$visitor_found){

		$get_visitors = $get_visitors + 1;
		$get_total = $get_total + 1;

		if($newday || $new){
			$fo = fopen($visitor_file_path,"w");
		}else{
			$fo = fopen($visitor_file_path,"a");
		}
		fwrite($fo,"$currTime|$REMOTE_ADDR|$visitor_host|$HTTP_USER_AGENT|$HTTP_REFERER\n");
		fclose($fo);

		$fo = fopen($counter_file_path,"w");
		fwrite($fo,"$currDate|$get_visitors|$get_total|$firstDate");
		fclose($fo);
	}

	$return = array("$get_visitors","$get_total","$firstDate");
	return $return;

}
?>
