// VolumeToArrows.cpp : Defines the entry point for the application.
//
#include "stdafx.h"
#include <commctrl.h>
#include <aygshell.h>
#include <sipapi.h>
#include "resource.h"

#define MAX_LOADSTRING 100
#define TIMER_POLLING_SYSTEM 1
#define TIMER_ANIMATION 2

// Global Variables:
HINSTANCE			g_hInst;				// The current instance
HWND				g_hwndCB;					// The command bar handle
HICON HTC_Icon;
HICON Win_Icon;
HBITMAP HuePattern;
HWND m_hWndTaskBar;
static SHACTIVATEINFO s_sai;
typedef int(__cdecl *RemoteProc)();

// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass	(HINSTANCE, LPTSTR);
BOOL				InitInstance	(HINSTANCE, int);
LRESULT CALLBACK	WndProc			(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About			(HWND, UINT, WPARAM, LPARAM);
HWND				CreateRpCommandBar(HWND);
//int CfgData.Status[1].CurrentValue=0;
//int CfgData.Status[1].LastValue=0;
void ReadSystemStus();
//int CfgData.Status[1].CurrentAnimationStep=0;
void Animate(int);
void ReadConfiguration();
void WriteConfiguration();

struct GadjetStatusData
{
	int LastValue;
	int CurrentValue;
	int CurrentAnimationStep;
};
#define MAX_WIDGETS 32
struct ConfigurationData
{
	int EnabledGadjets[MAX_WIDGETS];
	int EnabledGadjetsUseCustomSensor[MAX_WIDGETS];
	wchar_t EnabledGadjetsProc[MAX_WIDGETS][1024];
	wchar_t EnabledGadjetsDll[MAX_WIDGETS][1024];
	RemoteProc RemoteSensor[MAX_WIDGETS];
	int EnabledAnimationsMask;
	int RefreshTimeoutMs;
	GadjetStatusData Status[MAX_WIDGETS];
	int isTransparent;
};



ConfigurationData CfgData;

DWORD RegReadDWORD(const wchar_t *KeyPath,const wchar_t *KeyName, DWORD KeyDefault,bool WriteAnyway)
{
	DWORD dwType = REG_NONE;
	DWORD dwDataSize = 0;
	DWORD ReturnValue=KeyDefault;
	HKEY hKey = 0;

	RegOpenKeyEx(HKEY_LOCAL_MACHINE,KeyPath,0,0,&hKey);
	if(hKey==0)
	{
		if(WriteAnyway==true)
		{
			RegCreateKeyEx(HKEY_LOCAL_MACHINE,KeyPath,0,0,0,0,0,&hKey,0);
		}
	}
	else
	{
		if (RegQueryValueEx(hKey , KeyName, 0, &dwType, (PBYTE)NULL, &dwDataSize ) == ERROR_SUCCESS)
		{
			DWORD *buffer=new DWORD(dwDataSize);
			RegQueryValueEx( hKey, KeyName, 0, &dwType,(PBYTE)buffer,&dwDataSize);
			ReturnValue=buffer[0];
			delete buffer;
		}
	}
	if(WriteAnyway==true)
	{
		RegSetValueEx(hKey,KeyName,0,REG_DWORD,(BYTE *)&ReturnValue,sizeof(ReturnValue));
	}
	return ReturnValue;
}

wchar_t *RegReadString(const wchar_t *KeyPath,const wchar_t *KeyName, const wchar_t *KeyDefault,wchar_t *BufferString, bool WriteAnyway)
{
	DWORD dwType = REG_SZ;
	DWORD dwDataSize = 0;
	wchar_t *ReturnValue=BufferString;
	HKEY hKey = 0;
	wsprintf(ReturnValue,_T("%s"),KeyDefault);
	RegOpenKeyEx(HKEY_LOCAL_MACHINE,KeyPath,0,0,&hKey);
	if(hKey==0)
	{
		if(WriteAnyway==true)
		{
			RegCreateKeyEx(HKEY_LOCAL_MACHINE,KeyPath,0,0,0,0,0,&hKey,0);
		}
	}
	else
	{
		if (RegQueryValueEx(hKey , KeyName, 0, &dwType, (PBYTE)NULL, &dwDataSize ) == ERROR_SUCCESS)
		{
			//DWORD *buffer=new DWORD(dwDataSize);
			RegQueryValueEx( hKey, KeyName, 0, &dwType,(PBYTE)BufferString,&dwDataSize);
			//ReturnValue=buffer[0];
			//ReturnValue=BufferString;
			//delete buffer;
		}
	}
	if(WriteAnyway==true)
	{
		RegSetValueEx(hKey,KeyName,0,REG_SZ,(BYTE *)ReturnValue,sizeof(wchar_t)*(_tcslen(ReturnValue) + 1));
	}
	return ReturnValue;
}


void ReadConfiguration()
{
	memset(&CfgData,0,sizeof(ConfigurationData));
	CfgData.EnabledGadjets[0]=1;
	CfgData.EnabledGadjets[1]=1;
	CfgData.isTransparent=0;
	CfgData.EnabledAnimationsMask=1;
	CfgData.EnabledGadjetsUseCustomSensor[0]=0;
	CfgData.EnabledGadjetsUseCustomSensor[1]=1;
	CfgData.RefreshTimeoutMs=20000;

	CfgData.EnabledGadjets[0]=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_0_enabled"),CfgData.EnabledGadjets[0],true);
	CfgData.EnabledGadjets[1]=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_1_enabled"),CfgData.EnabledGadjets[1],true);

	CfgData.EnabledGadjetsUseCustomSensor[0]=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_0_iscustom"),CfgData.EnabledGadjetsUseCustomSensor[0],true);
	CfgData.EnabledGadjetsUseCustomSensor[1]=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_1_iscustom"),CfgData.EnabledGadjetsUseCustomSensor[1],true);
	CfgData.isTransparent=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Transparent"),CfgData.isTransparent,true);
	wchar_t bf[1024];

	RegReadString(_T("Software\\XIAProjects\\TopBar"),_T("Version"),_T("0.0.10"),bf,true);

	RegReadString(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_0_dll"),_T("\\Program Files\\TopBar\\GadjetExampleSensor.dll"),CfgData.EnabledGadjetsDll[0],true);
	RegReadString(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_1_dll"),_T("\\Program Files\\TopBar\\GadjetExampleSensor.dll"),CfgData.EnabledGadjetsDll[1],true);

	RegReadString(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_0_proc"),_T("getDataSensor0"),CfgData.EnabledGadjetsProc[0],true);
	RegReadString(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_1_proc"),_T("getDataSensor1"),CfgData.EnabledGadjetsProc[1],true);


	RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_0_value"),0,true);
	RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("Gadjet_1_value"),0,true);


	CfgData.EnabledAnimationsMask=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("AnimationMask"),CfgData.EnabledAnimationsMask,true);
	CfgData.RefreshTimeoutMs=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),_T("RefreshTimeoutMs"),CfgData.RefreshTimeoutMs,true);

	for(int i=0;i<2;i++)
	{
		if(CfgData.EnabledGadjetsUseCustomSensor[i]==3)
		{
			// we need to load the dll
			HINSTANCE dll=LoadLibrary(CfgData.EnabledGadjetsDll[i]);
			if(dll)
			{
				CfgData.RemoteSensor[i]=(RemoteProc) GetProcAddress(dll, CfgData.EnabledGadjetsProc[i]); 
				 // If the function address is valid, call the function.
				if (NULL != CfgData.RemoteSensor[i]) 
				{
					//MessageBox(0,CfgData.EnabledGadjetsProc[i],_T("Success"),0);
				}
			}
		}
	}
}

int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPTSTR    lpCmdLine,
					int       nCmdShow)
{
	MSG msg;
//	HACCEL hAccelTable;

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

//	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_VOLUMETOARROWS);
/*
	HWND AlreadyRunning=FindWindow(_T("HHTaskBarTopLineClass"),_T("HHTaskBarTopLine0"));
	if(AlreadyRunning)
	{
		ShowWindow(AlreadyRunning,SW_SHOW);
		return 0;
	}
*/
	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		
		//if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    It is important to call this function so that the application 
//    will get 'well formed' small icons associated with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance, LPTSTR szWindowClass)
{
	WNDCLASS	wc;

    wc.style			= CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc		= (WNDPROC) WndProc;
    wc.cbClsExtra		= 0;
    wc.cbWndExtra		= 0;
    wc.hInstance		= hInstance;
	HTC_Icon=LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON2));
	HuePattern=LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_HUE));
	Win_Icon=LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON4));
//	DirectBitmap=LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_V));
    wc.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
	//wc.hIcon			= 0;
    wc.hCursor			= 0;
    wc.hbrBackground	= (HBRUSH) GetStockObject(HOLLOW_BRUSH); //BLACK_BRUSH);
    wc.lpszMenuName		= 0;
    wc.lpszClassName	= szWindowClass;

	return RegisterClass(&wc);
}
//TCHAR szHello[MAX_LOADSTRING];
//
//  FUNCTION: InitInstance(HANDLE, int)
//
//  PURPOSE: Saves instance handle and creates main window
//
//  COMMENTS:
//
//    In this function, we save the instance handle in a global variable and
//    create and display the main program window.
//
HWND	hWnd[3] = {0,0,0};
unsigned int BaseHue=0;
unsigned int Gradient=0;

unsigned int BgR=0;
unsigned int BgG=0;
unsigned int BgB=0;
HBITMAP DupBitmapData(IN HBITMAP hbmSrc, OUT void** ppdata, OUT int* pcx, OUT int* pcy)
{
  BITMAP bm = {0};
  BITMAPINFO bmi = {0};
  HBITMAP hbm;

  if (!hbmSrc || !ppdata)

      return NULL;

  if (!GetObject((HGDIOBJ)hbmSrc, sizeof(BITMAP), &bm))

      return NULL;
  if (pcx) *pcx = bm.bmWidth;
  if (pcy) *pcy = bm.bmHeight;

 

  *ppdata = NULL;


  bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
  bmi.bmiHeader.biWidth = bm.bmWidth;
  /* rest of the initialization of bmi.bmiHeader... */
  hbm = CreateDIBSection(NULL, &bmi, DIB_RGB_COLORS, ppdata, NULL, 0);
  return hbm;
}
unsigned int Pantone[]={			99,101,99,
			99,101,99,
			107,105,107,
			107,109,107,
			107,109,107,
			115,113,115,
			115,113,115,
			115,117,115,
			115,117,115,
			123,121,123,
			123,125,123,
			123,125,123,
			132,130,132,
			132,130,132,
			132,134,132,
			132,134,132,
			140,138,140,
			140,142,140,
			140,142,140,
			148,146,148,
			148,146,148,
			148,150,148,
			156,154,156,
			156,154,156,
			156,158,156,
			156,158,156,
			165,162,165,
			165,162,165,
			165,166,165,
			165,166,165,
			173,170,173,
			173,174,173,
			173,174,173,
			181,178,181,
			181,178,181,
			181,182,181,
			181,182,181,
			189,186,189,
			189,190,189,
			189,190,189,
			198,195,198,
			198,195,198,
			189,190,189,
			189,190,189,
			189,190,189,
			189,186,189,
			189,186,189,
			189,186,189,
			181,182,181,
			181,182,181,
			181,182,181,
			181,182,181,
			181,178,181,
			181,178,181,
			181,178,181,
			173,174,173,
			173,174,173,
			173,174,173,
			173,174,173,
			173,170,173,
			173,170,173,
			173,170,173,
			165,166,165,
			165,166,165,
			165,166,165,
			165,166,165,
			165,162,165,
			165,162,165,
			165,162,165,
			156,158,156,
			156,158,156,
			156,158,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			148,150,148,
			148,150,148,
			148,150,148,
			148,146,148,
			148,146,148,
			148,146,148,
			148,146,148,
			148,146,148,
			148,150,148,
			148,150,148,
			148,150,148,
			148,150,148,
			148,150,148,
			148,150,148,
			148,150,148,
			148,150,148,
			148,150,148,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,154,156,
			156,158,156,
			156,158,156,
			156,158,156,
			156,158,156,
			156,158,156,
			156,158,156,
			156,158,156,
			156,158,156,
			156,158,156,
			165,162,165,
			165,162,165,
			165,162,165,
			165,162,165,
			165,162,165,
			165,162,165,
			165,162,165,
			165,162,165,
			165,162,165,
			165,166,165,
			165,162,165,
			156,158,156,
			156,158,156,
			156,154,156,
			156,154,156,
			148,150,148,
			148,150,148,
			148,146,148,
			140,142,140,
			140,142,140,
			140,138,140,
			140,138,140,
			132,134,132,
			132,134,132,
			132,130,132,
			123,125,123,
			123,125,123,
			123,121,123,
			123,121,123,
			115,117,115,
			115,117,115,
			115,113,115,
			107,109,107,
			107,109,107,
			107,105,107,
			107,105,107,
			99,101,99,
			99,101,99,
			99,97,99,
			90,93,90,
			90,93,90,
			90,89,90,
			90,89,90,
			82,85,82,
			82,85,82,
			82,81,82,
			74,77,74,
			74,77,74,
			74,73,74,
			74,73,74,
			74,73,74,
			74,73,74,
			74,77,74,
			74,77,74,
			74,77,74,
			74,77,74,
			82,81,82,
			82,81,82,
			82,81,82,
			82,85,82,
			82,85,82,
			82,85,82,
			90,89,90,
			90,89,90,
			90,89,90,
			90,89,90,
			90,93,90,
			90,93,90,
			90,93,90,
			99,97,99,
			99,97,99,
			99,97,99,
			99,97,99,
			99,101,99,
			99,101,99,
			99,101,99,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,109,107,
			107,109,107,
			107,109,107,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			107,109,107,
			107,109,107,
			107,109,107,
			107,109,107,
			107,109,107,
			107,109,107,
			107,109,107,
			107,109,107,
			107,109,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			107,105,107,
			99,101,99,
			99,101,99,
			99,101,99,
			99,101,99,
			99,101,99,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,117,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			115,113,115,
			214,52,49,
			214,56,49,
			214,60,49,
			214,65,49,
			214,69,49,
			214,73,49,
			214,77,49,
			214,81,49,
			214,85,49,
			214,89,49,
			214,93,49,
			214,97,49,
			214,101,49,
			214,105,49,
			214,109,49,
			214,113,49,
			214,117,49,
			214,121,49,
			214,125,49,
			214,130,49,
			214,134,49,
			214,138,49,
			214,142,49,
			214,146,49,
			214,150,49,
			214,154,49,
			214,158,49,
			214,162,49,
			214,166,49,
			214,170,49,
			214,174,49,
			214,178,49,
			214,182,49,
			214,186,49,
			214,186,49,
			214,190,49,
			214,195,49,
			214,199,49,
			214,203,49,
			214,207,49,
			214,211,49,
			206,211,49,
			206,211,49,
			198,211,49,
			198,211,49,
			189,211,49,
			189,211,49,
			189,211,49,
			181,211,49,
			181,211,49,
			173,211,49,
			173,211,49,
			165,211,49,
			165,211,49,
			156,211,49,
			156,211,49,
			148,211,49,
			148,211,49,
			140,211,49,
			140,211,49,
			132,211,49,
			132,211,49,
			123,211,49,
			123,211,49,
			115,211,49,
			115,211,49,
			107,211,49,
			107,211,49,
			99,211,49,
			99,211,49,
			90,211,49,
			90,211,49,
			82,211,49,
			82,211,49,
			74,211,49,
			74,211,49,
			66,211,49,
			66,211,49,
			57,211,49,
			57,211,49,
			49,211,49,
			49,211,57,
			49,211,57,
			49,211,66,
			49,211,66,
			49,211,74,
			49,211,74,
			49,211,82,
			49,211,82,
			49,211,90,
			49,211,90,
			49,211,99,
			49,211,99,
			49,211,107,
			49,211,107,
			49,211,115,
			49,211,115,
			49,211,123,
			49,211,123,
			49,211,132,
			49,211,132,
			49,211,140,
			49,211,140,
			49,211,148,
			49,211,148,
			49,211,156,
			49,211,156,
			49,211,165,
			49,211,165,
			49,211,173,
			49,211,173,
			49,211,181,
			49,211,181,
			49,211,189,
			49,211,189,
			49,211,189,
			49,211,198,
			49,211,198,
			49,211,206,
			49,211,206,
			49,211,214,
			49,207,214,
			49,203,214,
			49,199,214,
			49,195,214,
			49,190,214,
			49,190,214,
			49,186,214,
			49,182,214,
			49,178,214,
			49,174,214,
			49,170,214,
			49,166,214,
			49,162,214,
			49,158,214,
			49,154,214,
			49,150,214,
			49,146,214,
			49,142,214,
			49,138,214,
			49,134,214,
			49,130,214,
			49,125,214,
			49,121,214,
			49,117,214,
			49,113,214,
			49,109,214,
			49,105,214,
			49,101,214,
			49,97,214,
			49,93,214,
			49,89,214,
			49,85,214,
			49,81,214,
			49,77,214,
			49,73,214,
			49,69,214,
			49,65,214,
			49,60,214,
			49,56,214,
			49,52,214,
			57,52,214,
			57,52,214,
			66,52,214,
			66,52,214,
			74,52,214,
			74,52,214,
			82,52,214,
			82,52,214,
			90,52,214,
			90,52,214,
			99,52,214,
			99,52,214,
			107,52,214,
			107,52,214,
			115,52,214,
			115,52,214,
			123,52,214,
			123,52,214,
			132,52,214,
			132,52,214,
			140,52,214,
			140,52,214,
			148,52,214,
			148,52,214,
			156,52,214,
			156,52,214,
			165,52,214,
			165,52,214,
			173,52,214,
			173,52,214,
			181,52,214,
			181,52,214,
			189,52,214,
			189,52,214,
			189,52,214,
			198,52,214,
			198,52,214,
			206,52,214,
			206,52,214,
			214,52,214,
			214,52,206,
			214,52,206,
			214,52,198,
			214,52,198,
			214,52,189,
			214,52,189,
			214,52,189,
			214,52,181,
			214,52,181,
			214,52,173,
			214,52,173,
			214,52,165,
			214,52,165,
			214,52,156,
			214,52,156,
			214,52,148,
			214,52,148,
			214,52,140,
			214,52,140,
			214,52,132,
			214,52,132,
			214,52,123,
			214,52,123,
			214,52,115,
			214,52,115,
			214,52,107,
			214,52,107,
			214,52,99,
			214,52,99,
			214,52,90,
			214,52,90,
			214,52,82,
			214,52,82,
			214,52,74,
			214,52,74,
			214,52,66,
			214,52,66,
			214,52,57,
			214,52,57,
			214,52,214,
			214,52,206,
			214,52,206,
			214,52,198,
			214,52,198,
			214,52,189,
			214,52,189,
			214,52,189,
			214,52,181,
			214,52,181,
			214,52,173,
			214,52,173,
			214,52,165,
			214,52,165,
			214,52,156,
			214,52,156,
			214,52,156, // this entry is being duplicated because we have +1 in pantone
			214,52,156,
			214,52,156
			};
void ReadColor()
{
	DWORD dwType = REG_NONE;
	DWORD dwDataSize = 0;
	HKEY hKey = 0;
	BaseHue=0;
	Gradient=0;
	BgR=0;
	BgG=0;
	BgB=0;
	RegOpenKeyEx(HKEY_LOCAL_MACHINE,_T("Software\\Microsoft\\Color"),0,0,&hKey);
	if(hKey==0)
	{
			//MessageBox(0,_T("Error opening key"),_T("TopBar"),0);
	}
	else
	{
		/*
		const wchar_t *colorrefstring=_T("42");	
		if (RegQueryValueEx(hKey , colorrefstring, 0, &dwType, (PBYTE)NULL, &dwDataSize ) == ERROR_SUCCESS)
		{
			DWORD *buffer=new DWORD(dwDataSize);
			RegQueryValueEx( hKey, colorrefstring, 0, &dwType, 
				(PBYTE)buffer,
				&dwDataSize);
			BgR=(buffer[0] & 0xFF0000)>>16;
			BgG=(buffer[0] & 0xFF00)>>8;
			BgB=(buffer[0] & 0xFF);
			delete buffer;
		}
		else
		{
		}
*/
		if (RegQueryValueEx(hKey , _T("BaseHue"), 0, &dwType, (PBYTE)NULL, &dwDataSize ) == ERROR_SUCCESS)
		{
			switch(dwType)
			{
			case REG_SZ:
				break;
			case REG_BINARY:
			case REG_DWORD:
				{
					DWORD *buffer=new DWORD(dwDataSize);
					RegQueryValueEx( hKey, _T("BaseHue"), 0, &dwType,(PBYTE)buffer,&dwDataSize);
					BaseHue=buffer[0];
					delete []buffer;
				}
				break;
			}
		}
		else
		{
			/*
			if (RegQueryValueEx(hKey , _T("SHColor"), 0, &dwType, (PBYTE)NULL, &dwDataSize ) == ERROR_SUCCESS)
			{
				DWORD *buffer=new DWORD(dwDataSize);
				TCHAR dbgstring[1024];
				RegQueryValueEx( hKey, _T("SHColor"), 0, &dwType, 
					(PBYTE)buffer,
					&dwDataSize);

				wsprintf(dbgstring,_T("Colors:%d %X %X %X %X %X "),dwDataSize,buffer[0],buffer[1],buffer[2],buffer[3],buffer[4]);
				MessageBox(0,dbgstring,_T("TopBar"),0);
				delete buffer;
			}

			else
			{
				MessageBox(0,_T("Error reading colors"),_T("TopBar"),0);
			}
			*/
		}
	}
	//HuePattern
	//BaseHue
/*
  BITMAP bm = {0};
  BITMAPINFO bmi = {0};
	if (!GetObject((HGDIOBJ)HuePattern, sizeof(BITMAP), &bm))return;
  if (pcx) *pcx = bm.bmWidth;
  if (pcy) *pcy = bm.bmHeight;

	void *pH;
int pcx=0;
int pcy=0;
HBITMAP bb=DupBitmapData(HuePattern, &pH, &pcx, &pcy);
	*/

//	TCHAR dbgstring[1024];
				//wsprintf(dbgstring,_T("Colors:%d %d %d"),BgR, BgG, BgB);
				//MessageBox(0,dbgstring,_T("TopBar"),0);

	BaseHue=BaseHue & 0x01FF; // to fit into 512
	/*
	int maxCounter=(BaseHue+1)*3;
	int siz=sizeof(Pantone); => 2048!!
	if(maxCounter>siz)BaseHue=maxCounter/3-1;
	*/
	
	BgR=Pantone[BaseHue*3];
	BgG=Pantone[BaseHue*3+1];
	BgB=Pantone[BaseHue*3+2];
	
}
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	
	TCHAR	szTitle[MAX_LOADSTRING];			// The title bar text
	TCHAR	szWindowClass[MAX_LOADSTRING];		// The window class name

	g_hInst = hInstance;		// Store instance handle in our global variable
	// Initialize global strings
//	LoadString(hInstance, IDC_VOLUMETOARROWS, szWindowClass, MAX_LOADSTRING);
//	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	int k=0;

	/*	
	//If it is already running, then focus on the window
	hWnd[k] = FindWindow(szWindowClass, szTitle);	
	if (hWnd[k]) 
	{
		// set focus to foremost child window
		// The "| 0x01" is used to bring any owned windows to the foreground and
		// activate them.
		SetForegroundWindow((HWND)((ULONG) hWnd[k] | 0x00000001));
		MessageBox(hWnd[k],_T("Hey TopBar is already running this is 0.0.8"),_T("TopBar"),0);
		return 0;
	} 
	*/

	ReadConfiguration();
	ReadColor();

	wsprintf(szWindowClass,TEXT("HHTaskBarTopLineClass"));
	MyRegisterClass(hInstance, szWindowClass);

	m_hWndTaskBar = FindWindow(TEXT("HHTaskBar"), NULL);


	wsprintf(szTitle,TEXT("HHTaskBarTopLine%d"),k);
	int AnotherWndDrawed00=0;
	if(CfgData.EnabledGadjets[k]>0)
	{
		hWnd[k] = CreateWindowEx(0, szWindowClass, szTitle, WS_CHILD | WS_VISIBLE, 0,0,4,28, m_hWndTaskBar, 0, hInstance,0);
		AnotherWndDrawed00=4;
	}
	
	k++;
	wsprintf(szTitle,TEXT("HHTaskBarTopLine%d"),k);
	if(CfgData.EnabledGadjets[k]>0)
	{
		hWnd[k] = CreateWindowEx(0, szWindowClass, szTitle, WS_CHILD  | WS_VISIBLE, AnotherWndDrawed00,0,320-AnotherWndDrawed00,4, m_hWndTaskBar, 0, hInstance,0);
	}
	k++;


	//hWnd = CreateWindow(szWindowClass, szTitle, WS_CHILD|WS_VISIBLE,
	//	CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, m_hWndTaskBar , NULL, hInstance, NULL);
	if (hWnd[0]==0 && hWnd[1]==0)
	{	
		return FALSE;
	}
	//When the main window is created using CW_USEDEFAULT the height of the menubar (if one
	// is created is not taken into account). So we resize the window after creating it
	// if a menubar is present
	if (g_hwndCB)
    {
		/*
		RECT rc;
        RECT rcMenuBar;

		GetWindowRect(hWnd, &rc);
        GetWindowRect(g_hwndCB, &rcMenuBar);
		rc.bottom -= (rcMenuBar.bottom - rcMenuBar.top);
		MoveWindow(hWnd, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, FALSE);
		*/
		//RECT m_rcTaskBar;
		//GetClientRect(m_hWndTaskBar, &m_rcTaskBar);
		//MoveWindow(hWnd, 0,0,m_rcTaskBar.right-m_rcTaskBar.left,m_rcTaskBar.bottom-m_rcTaskBar.top,true);
	}

	//wsprintf(szHello,_T(""));
	//MessageBox(hWnd,_T("TopBar Fix is Ready"),_T("TopBar"),0);


	for(int i=0;i<k;i++)
	{
		if(CfgData.EnabledGadjets[i]>0)
		{
			ShowWindow(hWnd[k], SW_SHOW); //nCmdShow);
			SetForegroundWindow((HWND)((ULONG) hWnd[k] | 0x00000001));
			UpdateWindow(hWnd[k]);
		}
		else
		{
			ShowWindow(hWnd[k], SW_HIDE); //nCmdShow);
		}
	}
	//Animate();
	if(!CfgData.isTransparent)
	{
		SetTimer(hWnd[1],TIMER_POLLING_SYSTEM,CfgData.RefreshTimeoutMs,0);
	}

	return TRUE;
}


//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
void Wnd_Repaint(HWND hWnd)
{
		HDC hdc;
	//int wmId, wmEvent;
	PAINTSTRUCT ps;
	RECT rt,rt1;
			hdc = BeginPaint(hWnd, &ps);
			//DrawIcon(hdc,0,0,HTC_Icon);
			
			GetClientRect(hWnd, &rt);
			rt1=rt;
			//HGDIOBJ PreviousObject=SelectObject(hdc, DirectBitmap);
		    //BitBlt(hdc,0,0,bm.bmWidth,bm.bmHeight,BufferDC,0,0,SRCCOPY);
			FillRect(hdc,&rt,CreateSolidBrush(RGB(BgR/5,BgG/5,BgB/5)));

			if(rt.bottom-rt.top>rt.right-rt.left)
			{
				rt1.right=rt1.right-1;
			}
			//else
			{
				int GradientDualPass=11;
				int GradientRatio=8;
				for(int y=0;y<rt.bottom-rt.top-1&&y<GradientDualPass;y++)
				{
					rt1.top=rt.top+y;
					rt1.bottom=rt1.top+1;
					//FillRect(hdc,&rt1,CreateSolidBrush(RGB(Pantone[(BaseHue)*3],Pantone[(BaseHue)*3+1],Pantone[(BaseHue)*3+2]+100-y*10)));
					int k=20+(GradientDualPass*GradientRatio)-y*GradientRatio;
					if(BgR+k>255)k=255-BgR;
					if(BgG+k>255)k=255-BgG;
					if(BgB+k>255)k=255-BgB;
					FillRect(hdc,&rt1,CreateSolidBrush(RGB(BgR+k,BgG+k,BgB+k)));
				}			
				unsigned int mink=BgR;
				if(BgG<mink)mink=BgG;
				if(BgB<mink)mink=BgB;

				for(int y=GradientDualPass;y<rt.bottom-rt.top-1;y++)
				{
					rt1.top=rt.top+y;
					rt1.bottom=rt1.top+1;

					int k=((mink/(rt.bottom-rt.top-1-GradientDualPass))/8)*y;
					
					//FillRect(hdc,&rt1,CreateSolidBrush(RGB(Pantone[(BaseHue)*3],Pantone[(BaseHue)*3+1],Pantone[(BaseHue)*3+2])));
					FillRect(hdc,&rt1,CreateSolidBrush(RGB(BgR+k,BgG+k,BgB+k)));
				}			
			}
			if(rt.bottom-rt.top>rt.right-rt.left)
			{
				// is the vertical so we draw the win flag
				DrawIcon(hdc,0,2,Win_Icon);
			}
			else
			{
				// is the horiz so we paint the Battery gauge
				RECT rtH;
				GetClientRect(m_hWndTaskBar, &rtH);
				float SingleStepWidth=((float)(rtH.right-rtH.left)/(float)100);
				int Current_Gauge=0;
				if(CfgData.Status[1].CurrentAnimationStep>0)Current_Gauge=CfgData.Status[1].CurrentAnimationStep;
				else Current_Gauge=CfgData.Status[1].CurrentValue;
				float GaugeWidth=(float)SingleStepWidth*(float)Current_Gauge;
				int OffBgR=BgR/3;
				int OffBgG=BgG/3;
				int OffBgB=BgB/3;

				rt1.left=(long)GaugeWidth;
				rt1.right=rtH.right;

				for(int y=0;y<rt.bottom-rt.top-1 && y<9; y++)
				{
					rt1.top=rt.top+y;
					rt1.bottom=rt1.top+1;
					int k=20-20+72-y*8;
					if(OffBgR+k>255)k=255-OffBgR;
					if(OffBgG+k>255)k=255-OffBgG;
					if(OffBgB+k>255)k=255-OffBgB;
					FillRect(hdc,&rt1,CreateSolidBrush(RGB(OffBgR+k,OffBgG+k,OffBgB+k)));
					RECT rt2=rt1;
					rt2.right=rt1.left;
					rt2.left=rt1.left-1;
					FillRect(hdc,&rt2,CreateSolidBrush(RGB((OffBgR+k)/2,(OffBgG+k)/2,(OffBgB+k)/2)));
				}


			}
			EndPaint(hWnd, &ps);
}

void ReadSystemStus()
{
	wchar_t KeyReg[1024];

	for(int i=0;i<2;i++)
	{
		if(CfgData.EnabledGadjets[i]>0)
		{
			switch(CfgData.EnabledGadjetsUseCustomSensor[i])
			{
			case 0:
				// none
				break;
			case 1:
				// battery meter
				SYSTEM_POWER_STATUS_EX info_Power;
				CfgData.Status[i].LastValue=CfgData.Status[i].CurrentValue;
				if(GetSystemPowerStatusEx(&info_Power,false))
				{
					CfgData.Status[i].CurrentValue=info_Power.BatteryLifePercent;
				}
				break;
			case 2:
				// custom value on registry
				wsprintf(KeyReg,_T("Gadjet_%d_value"),i);
				CfgData.Status[i].LastValue=CfgData.Status[i].CurrentValue;
				CfgData.Status[i].CurrentValue=RegReadDWORD(_T("Software\\XIAProjects\\TopBar"),KeyReg,0,false);
				break;
			case 3:
				// dll
				if(CfgData.RemoteSensor[i]!=NULL)
				{
					CfgData.Status[i].LastValue=CfgData.Status[i].CurrentValue;
					CfgData.Status[i].CurrentValue=CfgData.RemoteSensor[i]();
				}
				break;
			default:
				// none
				break;
			}
		}
	}

	for(int i=0;i<2;i++)
	{
		if(CfgData.EnabledGadjets[i]>0)
		{
			if(CfgData.Status[1].LastValue!=CfgData.Status[1].CurrentValue)
			{
				Animate(i);
			}
		}
	}
}
void AnimationStep(HWND hWnd)
{
	if(CfgData.Status[1].CurrentAnimationStep==CfgData.Status[1].CurrentValue)
	{
		KillTimer(hWnd,TIMER_ANIMATION);
	}
	else
	{
		if(CfgData.Status[1].CurrentAnimationStep>CfgData.Status[1].CurrentValue)
		{
			int disp=((CfgData.Status[1].CurrentAnimationStep-CfgData.Status[1].CurrentValue)/2);
			if(disp>8)CfgData.Status[1].CurrentAnimationStep-=8;
			else if(disp>1)CfgData.Status[1].CurrentAnimationStep-=disp;
			else CfgData.Status[1].CurrentAnimationStep--;
		}
		else
		{
			int disp=((CfgData.Status[1].CurrentValue-CfgData.Status[1].CurrentAnimationStep)/2);
			if(disp>8)CfgData.Status[1].CurrentAnimationStep+=8;
			else if(disp>1)CfgData.Status[1].CurrentAnimationStep+=disp;
			else CfgData.Status[1].CurrentAnimationStep++;
		}
	}
	RECT rt;
	GetClientRect(hWnd, &rt);
	InvalidateRect(hWnd,&rt,false);
}
void Animate(int GadjetIndex)
{
	if((CfgData.EnabledAnimationsMask & 0x1))
	{
		CfgData.Status[GadjetIndex].CurrentAnimationStep=CfgData.Status[GadjetIndex].LastValue;
		AnimationStep(hWnd[GadjetIndex]);
		SetTimer(hWnd[GadjetIndex],TIMER_ANIMATION,50,0);
	}
	else
	{
		CfgData.Status[GadjetIndex].CurrentAnimationStep=CfgData.Status[GadjetIndex].CurrentValue;
		AnimationStep(hWnd[GadjetIndex]);
	}
}
void DispatchTimers(HWND hWnd, WPARAM id_Timer)
{
	switch(id_Timer)
	{
	case TIMER_ANIMATION:
		AnimationStep(hWnd);
		break;
	case TIMER_POLLING_SYSTEM:
			ReadSystemStus();
		break;
	}
}
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{

	//return DefWindowProc(hWnd, message, wParam, lParam);
	RECT rt;
	static int NextIsGood=0;
	switch (message) 
	{
/*
 case WM_SIZE:
            // Recompute the layout of any child windows; resize
            // list views and edit boxes, and reposition buttons, 
            // statics, and other controls.
MessageBox(hWnd,_T("TopBar Fix is Ready"),_T("TopBar"),0);
	 ReadColor();
			GetClientRect(hWnd, &rt);
			InvalidateRect(hWnd,&rt,false);
            break;
			*/
	case WM_TIMER:
			DispatchTimers(hWnd, wParam);
		break;
        case WM_SETTINGCHANGE:
            if (SETTINGCHANGE_RESET == wParam) {
                // An orientation change occurred. This is where you
                // perform processing that you cannot perform in WM_SIZE, 
                // such as resizing full-screen child windows, calling 
                // MoveWindow on the top-level window, and so on.                // If there 
                // is no need to handle the WM_SETTINGCHANGE message,                 // you can
                // simply ignore it.

            }
			GetClientRect(hWnd, &rt);
			InvalidateRect(hWnd,&rt,false);
            break;
		case WM_PAINT:
/*
			if(IS_Painting>0)
			{
				ShowWindow(hWnd, SW_SHOW);
				IS_Painting--;
			}
			else
			{
				ShowWindow(hWnd, SW_HIDE);
				IS_Painting++;
			}
			*/
			/*
			hdc = BeginPaint(hWnd, &ps);
			//DrawIcon(hdc,0,0,HTC_Icon);
			GetClientRect(hWnd, &rt);
			IS_Painting++;
			if(IS_Painting>8)IS_Painting=0;

			FillRect(hdc,&rt,(HBRUSH) GetStockObject(IS_Painting));
			//DrawText(hdc, szHello, _tcslen(szHello), &rt, DT_SINGLELINE | DT_VCENTER | DT_CENTER);//DT_SINGLELINE
			EndPaint(hWnd, &ps);
*/
			if(CfgData.isTransparent)
			{
				NextIsGood=1;
				PAINTSTRUCT ps;
				HDC hdc = BeginPaint(hWnd, &ps);
				GetClientRect(hWnd, &rt);
				//FillRect(hdc,&rt,(HBRUSH) GetStockObject(IS_Painting));
				//SendMessage(GetParent(hWnd),WM_PAINT,(WPARAM)hdc,lParam);
				EndPaint(hWnd, &ps);
			}
			else
			{
				ReadColor();
				Wnd_Repaint(hWnd);
			}
			break; 
		case WM_DESTROY:
			CommandBar_Destroy(g_hwndCB);
			PostQuitMessage(0);
			break;
		
		case WM_LBUTTONUP:
			if(LOWORD(lParam)>2 && HIWORD(lParam)  >2 && LOWORD(lParam)<24 && HIWORD(lParam)  <24) 
			{
				//SendMessage (m_hWndTaskBar, message, wParam, lParam);
				//wsprintf(szHello,_T("%ld %ld %ld"),(long)message,(long)LOWORD(lParam), (long)HIWORD(lParam));
				//MessageBox(0,szHello,_T("TopBar"),0);
			}
				break;
		case WM_ERASEBKGND:
			//return DefWindowProc(hWnd, message, wParam, lParam);
			if(CfgData.isTransparent && NextIsGood)
			{
				SendMessage(GetParent(hWnd),message,wParam,lParam);
				NextIsGood=0;
			}
			return TRUE;
			//NextIsGood=1;
			//SendMessage(GetParent(hWnd),message,wParam,lParam);
			break;
		default:
			// 32 513
			//wsprintf(szHello,_T("%ld %ld %ld"),(long)message,(long)LOWORD(lParam), (long)HIWORD(lParam));
			//MessageBox(0,szHello,_T("TopBar"),0);
			return DefWindowProc(hWnd, message, wParam, lParam);
			break;

			/*
		case 1:
		case 3:
		case 5:
		case 71:

		break;
		case WM_HOTKEY:
        case WM_KEYUP:
        case WM_KEYDOWN:
		case WM_LBUTTONUP:
		case WM_COMMAND:
			//GetClientRect(hWnd, &rt);
			//InvalidateRect(hWnd,&rt,true);
			MessageBox(0,szHello,_T("TopBar"),0);
			
			break;
		
			
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 

			switch (wmId)
			{	
				case IDOK:
					SendMessage (hWnd, WM_CLOSE, 0, 0);
					break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			
			break;
		case WM_CREATE:
			//g_hwndCB = CreateRpCommandBar(hWnd);
            // Initialize the shell activate info structure
            //memset (&s_sai, 0, sizeof (s_sai));
            //s_sai.cbSize = sizeof (s_sai);
			break;

		case WM_ACTIVATE:
            // Notify shell of our activate message
			//SHHandleWMActivate(hWnd, wParam, lParam, &s_sai, FALSE);
			wmId    = LOWORD(wParam);
switch(wmId )
{
		case WA_ACTIVE:
		case WA_CLICKACTIVE:
MessageBox(0,szHello,_T("TopBar"),0);
			break;

}
     		break;
		case WM_SETTINGCHANGE:
			//SHHandleWMSettingChange(hWnd, wParam, lParam, &s_sai);
     		break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
*/
   }
   return 0;
}

HWND CreateRpCommandBar(HWND hwnd)
{
	/*
	SHMENUBARINFO mbi;

	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize     = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwnd;
	mbi.nToolBarId = 0;//IDM_MENU;
	mbi.hInstRes   = g_hInst;
	mbi.nBmpId     = 0;
	mbi.cBmpImages = 0;

	if (!SHCreateMenuBar(&mbi)) 
		return NULL;

	return mbi.hwndMB;
	*/
	return 0;
}

// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	//SHINITDLGINFO shidi;

	switch (message)
	{
		/*
		case WM_INITDIALOG:
			// Create a Done button and size it.  
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);
			return TRUE; 
*/
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK)
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

