##########################################
# osXBar 1.0 20030923 - 20031001 -20031015
# Source code GPL
# stefano@xiaprojects.com
# http://www.xiaproject.com
#
#
#



import karamba
import string
import os

class osXBarPager:
	# Externals
	Engine=0
	Matrix=0
	# Local Images
	PagerBar=[]
	PagerOn=[]
	PagerOff=[]
	ImageDeltaX=0
	ImageDeltaY=0
	PagerX=0
	PagerY=0
	PagerdX=0
	PagerdY=0
	LastDesktop=0
	SecondRow=0

	def Update(self):
		ActiveDesktop=os.popen(self.Engine.Configuration["GetDesktop"],"r")
		ActiveDesktop=int(string.strip(ActiveDesktop.read(10)))-1
		if(ActiveDesktop!=self.LastDesktop):
			# Updating
			self.SwitchDesktop(ActiveDesktop)

	def DispatchClick(self,x,y,button):
		if(x<self.PagerX or x>self.PagerX+self.PagerdX):
			return
		if(y<self.PagerY or y>self.PagerY+self.PagerdY):
			return
		# you have clicked into the DesktopSelector
		DesktopNum=(x-self.PagerX)/self.ImageDeltaX
		if(y>self.PagerY+self.ImageDeltaY):
			# we are on the second line...
			DesktopNum=DesktopNum+(self.SecondRow)
		if(button==1):
			# left mouse
			self.SwitchDesktop(DesktopNum)

	def SwitchDesktop(self,DesktopNum):
		if(DesktopNum==self.LastDesktop):
			karamba.toggleShowDesktop(self.Engine.Widget)
			return
		DesktopNum=DesktopNum+1
		if(DesktopNum>self.Engine.Configuration["VirtualDesktop"]):
			return
		os.system(self.Engine.Configuration["SetDesktop"]+str(DesktopNum)+" &")
		DesktopNum=DesktopNum-1
		karamba.hideImage(self.Engine.Widget,self.PagerOff[DesktopNum])
		karamba.showImage(self.Engine.Widget,self.PagerOn[DesktopNum])
		karamba.hideImage(self.Engine.Widget,self.PagerOn[self.LastDesktop])
		karamba.showImage(self.Engine.Widget,self.PagerOff[self.LastDesktop])
		self.LastDesktop=DesktopNum


	def Refresh(self):
		(x,y)=self.Matrix.MakeSpace(len(self.Engine.Objects)+1)
		y=y-3
		self.PagerX=x
		self.PagerY=y
		# We are sliding over the last icons
		k=0
		for i in range(0, self.Engine.Configuration["VirtualDesktop"]):
			if(i>=self.Engine.Configuration["VirtualDesktop"]/2 and k==0):
				k=1
				# this will start the 2 line
				self.PagerdX=i*self.ImageDeltaX
				x=x-self.PagerdX
				self.PagerdY=self.ImageDeltaY*2
				self.SecondRow=i

			karamba.moveImage(self.Engine.Widget,self.PagerOff[i],x+i*self.ImageDeltaX,y+k*self.ImageDeltaY)
			karamba.moveImage(self.Engine.Widget,self.PagerOn[i],x+i*self.ImageDeltaX,y+k*self.ImageDeltaY)


	def Init(self,NextState):
		if(self.Engine.Configuration["VirtualDesktop"]<1):
			return
		if(NextState==3):
			# Icons are created
			if(self.Engine.Configuration["BarTheme"]!=""):
				# We need the Background
				print "dummy"
			# Creating Images
			imgFile=self.Engine.Configuration["pathBar"]+"/virtual_desktop"
			for i in range(0, self.Engine.Configuration["VirtualDesktop"]):
				imgMini=karamba.createImage(self.Engine.Widget,-100,0,imgFile+"_active.png")
				karamba.hideImage(self.Engine.Widget,imgMini)
				self.PagerOn.append(imgMini)
				imgMini=karamba.createImage(self.Engine.Widget,-100,0,imgFile+".png")
				#karamba.hideImage(self.Engine.Widget,imgMini)
				self.PagerOff.append(imgMini)
			self.ImageDeltaX=karamba.getImageWidth(self.Engine.Widget,self.PagerOff[0])+2
			self.ImageDeltaY=karamba.getImageHeight(self.Engine.Widget,self.PagerOff[0])
			karamba.showImage(self.Engine.Widget,self.PagerOn[0])
			karamba.hideImage(self.Engine.Widget,self.PagerOff[0])
		if(NextState==5):
			# We are ready
			self.Refresh()
			self.Update()

