##########################################
# osXBar 1.0 20030923 - 20031001 -20031015
# Source code GPL
# stefano@xiaprojects.com
# http://www.xiaproject.com
#
#



import karamba
import os


class osXBarObject:
	# Current XYZ
	currentX=0
	currentY=0

	defaultX=0
	defaultY=0

	currentZ=32
	# The Focus point
	centerX=0
	centerY=0
	# Image Engine
	imgSource=0
	imgFileName=0
	Engine=0
	imgImage=0
	imgImageSmall=0
	imgImages=[]
	HasChanged=0
	# The Task Arrow
	imgArrow=0
	arrowSource=0

	arrowX=0
	arrowY=0
	ShowArrow=0
	ShowedArrow=0
	# Command Actions
	Command=""
	DropCommand=""
	CommandType=0
	TextString=""
	MenuString=[]
	MenuCommand=[]
	MenuIcon=[]
	Sound=""
	Name=""
	# Task Sensor
	WindowTitle=""
	TimeToLive=0
	MaxTimeMoltiplier=1
	Locked=0
	# Sensor
	SensorTimeOut=0
	SensorThread=0
	SensorType=0
	SensorCmd=""
	SensorRefresh=0
	
	def CreateVirtual(self,NewEngine,NewimgSource,NewCommand,NewTitle,NewString,x,y,z,cx,cy):
		self.Engine=NewEngine
		self.imgSource=NewimgSource
		self.Command=NewCommand
		self.WindowTitle=NewTitle
		self.TextString=NewString
		self.currentZ=z
		self.currentX=x
		self.currentY=y
		self.centerX=cx
		self.centerY=cy
		# 20031018 Engine with current real position
		self.defaultX=self.currentX
		self.defaultY=self.currentY

	def ChangeArrow(self,NewArrow):
		self.arrowSource=NewArrow
		oldArrow=self.imgArrow
		self.CreateArrow(self.Engine.Widget)
		karamba.deleteImage(self.Engine.Widget,oldArrow)
		#if(self.ShowedArrow!=0):
		#	karamba.showImage(self.Engine.Widget,self.imgArrow)
		self.ShowedArrow=0

	def ChangeImage(self,NewImage):
		self.imgFileName=NewImage
		self.imgSource=NewImage
		#if (not os.path.exists(self.imgSource)):
		#	self.imgSource=self.Engine.Cfg.FindIcon(self.imgSource)
		if (not os.path.exists(self.imgFileName)):
			self.imgFileName=self.Engine.Cfg.FindIcon(self.imgFileName)
		oldImage=self.imgImage
		oldImageSmall=self.imgImageSmall
		self.imgImage=karamba.createImage(self.Engine.Widget, 1000, 1000,self.imgFileName)
		self.imgImageSmall=karamba.createImage(self.Engine.Widget, self.currentX, self.currentY,self.imgFileName)
		self.ChangeArrow(self.arrowSource)
		karamba.resizeImageSmooth(self.Engine.Widget,self.imgImageSmall,self.Engine.Configuration["ImageSize"] , self.Engine.Configuration["ImageSize"])
		karamba.deleteImage(self.Engine.Widget,oldImage)
		karamba.deleteImage(self.Engine.Widget,oldImageSmall)
		self.Engine.HasMoved=1
		self.Engine.MouseMoved(self.Engine.lastx,self.Engine.lasty,self.Engine.lastbutton)
	def AppendObject(self,NewObject):
		## append to the objects list
		self.Engine.Objects.append(NewObject)
		pass
	def ArrowFile(self,theme,align):
		basepath=self.Engine.Configuration["pathArrow"]
		if(theme!=""):
			basepath=basepath+theme+"/"
		if(self.arrowSource==0 or  self.arrowSource=="" or type(self.arrowSource)==int):
			self.arrowSource="arrow.png"
		if (os.path.exists(basepath+align+self.arrowSource)):
			return basepath+align+self.arrowSource
		if (os.path.exists(self.Engine.Configuration["pathArrow"]+align+self.arrowSource)):
			return self.Engine.Configuration["pathArrow"]+align+self.arrowSource
		self.arrowSource="arrow.png"
		if (os.path.exists(basepath+align+self.arrowSource)):
			return basepath+align+self.arrowSource
		if (os.path.exists(self.Engine.Configuration["pathArrow"]+align+self.arrowSource)):
			return self.Engine.Configuration["pathArrow"]+align+self.arrowSource
		return ""

	def CreateArrow(self,widget):
		# Check the Align
		if(self.Engine.Configuration["WidgetAlign"]=="top"):
			# The Arrow to over and use the toparrow.png
			self.arrowX=self.defaultX+(self.Engine.Configuration["ImageSize"]/2)-(self.Engine.Configuration["ArrowXSize"]/2)
			self.arrowY=self.defaultY-((self.Engine.Configuration["ImageSize"])+(self.Engine.Configuration["ArrowY"])-3)

			self.imgArrow=karamba.createImage(widget, self.arrowX, self.arrowY, self.ArrowFile(self.Engine.Configuration["ArrowTheme"] ,"top"))
		if(self.Engine.Configuration["WidgetAlign"]=="bottom"):
			self.arrowX=self.defaultX+(self.Engine.Configuration["ImageSize"]/2)-(self.Engine.Configuration["ArrowXSize"]/2)
			self.arrowY=self.defaultY+(self.Engine.Configuration["ImageSize"])+(self.Engine.Configuration["ArrowY"]-3)
			self.imgArrow=karamba.createImage(widget, self.arrowX, self.arrowY, self.ArrowFile(self.Engine.Configuration["ArrowTheme"] ,""))
		karamba.hideImage(widget,self.imgArrow)

	def CreateObject(self,widget):
		## this will load the Image than show itself
		# Put out the Icon
		#if (not os.path.exists(self.imgSource)):
		#	self.imgSource=self.Engine.Cfg.FindIcon(self.imgSource)
		self.imgFileName=self.imgSource
		if (not os.path.exists(self.imgFileName)):
			self.imgFileName=self.Engine.Cfg.FindIcon(self.imgFileName)
		# we can create img after arrows!
		self.imgImage=karamba.createImage(widget, 1000, 1000,self.imgFileName)
		self.imgImageSmall=karamba.createImage(widget, self.currentX, self.currentY,self.imgFileName)
		# karamba.resizeImage(widget,self.imgImage, self.currentZ, self.currentZ)
		self.CreateArrow(widget)
		karamba.resizeImageSmooth(widget,self.imgImageSmall, self.currentZ, self.currentZ)
		pass
	def CreateSmooth(self,widget):
		## this will load the Image than show itself
		self.imgImages=[]
		for i in range(self.Engine.Configuration["ImageSize"],self.Engine.Configuration["ImageSizeBig"]):
			lastAdded=karamba.createImage(widget, self.currentX, self.currentY,self.imgFileName)
			karamba.hideImage(widget,lastAdded)
			self.imgImages.append(lastAdded)
			karamba.resizeImage(widget,lastAdded, i, i)
		pass
	def Remove(self,widget,MyIndex):
		# Doing animations :)
		self.Engine.Animator.AniRemove(MyIndex)
		karamba.hideImage(widget,self.imgImageSmall)
		#Shift other Icons
		iconShowed=len(self.Engine.Objects)
		for i in range(1,iconShowed-(MyIndex)):
			print self.Engine.Objects[i].Command
			self.Engine.Objects[iconShowed-i].currentX=self.Engine.Objects[iconShowed-i-1].currentX
			self.Engine.Objects[iconShowed-i].currentY=self.Engine.Objects[iconShowed-i-1].currentY
			self.Engine.Objects[iconShowed-i].arrowX=self.Engine.Objects[iconShowed-i-1].arrowX
			self.Engine.Objects[iconShowed-i].arrowY=self.Engine.Objects[iconShowed-i-1].arrowY
			self.Engine.Objects[iconShowed-i].centerX=self.Engine.Objects[iconShowed-i-1].centerX
			self.Engine.Objects[iconShowed-i].centerY=self.Engine.Objects[iconShowed-i-1].centerY
			self.Engine.Objects[iconShowed-i].currentZ=self.Engine.Objects[iconShowed-i-1].currentZ
			self.Engine.Objects[iconShowed-i].defaultY=self.Engine.Objects[iconShowed-i-1].defaultY
			self.Engine.Objects[iconShowed-i].defaultX=self.Engine.Objects[iconShowed-i-1].defaultX
		lastObject=self.Engine.Objects.pop(MyIndex)
		karamba.hideImage(widget,self.imgArrow)
		karamba.hideImage(widget,self.imgImage)
		karamba.deleteImage(widget,self.imgArrow)
		karamba.deleteImage(widget,self.imgImage)
		karamba.deleteImage(widget,self.imgImageSmall)
