#######################################################
# osXBar 1.0 20030923 - 20031001 -20031015 - 20031115
# Source code GPL
# stefano@xiaprojects.com
# http://www.xiaproject.com
#
#


import karamba
import time
import xcursor
import os

import osXBarObject
import osXBarMatrix
import osXBarCfg
import osXBarSystem
import osXBarCommand
import osXBarSensor
import osXBarTask
import osXBarAni
import osXBarPager
import osXBarOptions

import osXBarCfgLink
import osXBarCfgSensors



## Configurations
confosXBar = {
	"EnableLoadCfg"	:	"yes",
	"CfgFile"	:	"osXBar.conf",
	"osXBar"	:	"osXBar",
	"Version"	:	"1.0.20 Beta",
	"LoadCfgSensors":	"yes",
	"LoadCfgAlias":	"yes",
	"ImageSizeBig"	:	128,
	"ImageSize"	:	32,
	"WidgetY"	:	0,
	"WidgetX"	:	0,
	"WidgetHeight"	:	0,
	"WidgetWidth"	:	0,
	"WidgetAlign"	:	"bottom",
	"Design"	:	"tria",
	"DisplayX"	:	640,
	"DisplayY"	:	480,
	"borderLeft"	:	200,
	"borderTop"	:	200,
	"borderBottom"	:	6,
	"iconSeparation":	5,
	"iconRaise"	:	-50,
	"iconHoriz"	:	32,
	"iconEffect"	:	0,
	"AniSpeed"	:	1,
	"AniClick"	:	"cicle",
	"AniActivate"	:	"bounce",
	"AniClose"	:	"micro",
	"AniRotate"	:	"micro",
	"AniRemove"	:	"slide",
	"mouseXMin"	:	0,
	"SleepTime"	:	0.01,
	"SleepMin"	:	0.01,
	"SleepMax"	:	0.50,
	"ArrowXSize"	:	10,
	"ArrowY"	:	5,
	"pathTheme"	:	"",
	"pathIcons"	:	"",
	"pathBar"	:	"",
	"pathArrow"	:	"",
	"pathUserIcons"	:	[],
	"IconsTheme"	:	"",
	"BarTheme"	:	"",
	"BarThemeOver"	:	"",
	"ArrowTheme"	:	"",
	"pathKDEIcons"	:	"",
	"ArrowUpdate"	:	2,
	"AutoRotate"	:	1,
	"MaxTaskIcons"	:	5,
	"MaxTaskLife"	:	5,
	"MouseTimeout"	:	5,
	"Font"		:	"none",
	"FontSize"	:	16,
	"TextSize"	:	5,
	"AudioCmd"	:	"esdplay ",
	"VirtualDesktop":	0,
	"GetDesktop"	:	"dcop kwin KWinInterface currentDesktop",
	"SetDesktop"	:	"dcop kwin KWinInterface setCurrentDesktop ",
	"EnableHandles"	:	"",
	"HideMouseEdge"	:	"10",
	"HideAutoTimer"	:	"-1",
	"EnableSensors"	:	"no",
}



theMatrix=osXBarMatrix.osXBarMatrix()
theObject=osXBarObject.osXBarObject()
theCfg=osXBarCfg.osXBarCfg()
theSystem=osXBarSystem.osXBarSystem()
theCommand=osXBarCommand.osXBarCommand()
theSensor=osXBarSensor.osXBarSensor()
theTask=osXBarTask.osXBarTask()
theAnimator=osXBarAni.osXBarAni()
thePager=osXBarPager.osXBarPager()
theOptions=osXBarOptions.osXBarOptions()
theCfgLinker=osXBarCfgLink.osXBarCfgLink()
theCfgSensors=osXBarCfgSensors.osXBarCfgSensors()

class osXBarEngine:
	Status=0
	# osXBarObject.osXBarObject()
	# These are the Icons
	Objects=[]
	NumerOfStaticIcons=0
	Configuration=0
	Me=0
	Widget=0
	HasMoved=0
	# Only for movement, it will speed up all
	HasMoved2=0
	Drop=""

	IsReset=0
	IsHidden=0
	TimerHide=0

	lastx=0
	lasty=0
	lastIcon=-1
	lastbutton=0
	lastIconx=0
	lastIcony=0
	lastMouseX=0
	lastMouseY=0

	IncrementalSleep=0.01
	DesignXMoltiplier=2
	DesignYMoltiplier=1
	DesignDMoltiplier=1
	DesignVirtualXMax=10000
	DesignVirtualYMax=10000
	# Objects
	Pager=0
	Command=0
	Cfg=0
	Sensor=0
	TaskMgr=0
	Animator=0
	Options=0
	DropTest=0
	CfgLinker=0
	# Time Counter
	UpdateTaskCounter=0
	UpdateTaskCounterMax=0
	widgetCheckForMouse=0
	lastIconEnabled=0
	MoveFirstTime=1
	# background bar
	Bar=[]
	# Down arrow to hide, minize :)
	Handles=[]
	HandlesX=[]
	HandlesY=[]
	HandlesAction=[]

	Testo=0
	def Init(self, NextStatus):
		global confosXBar
		global theMatrix
		global theSensor
		global theObject
		global theSystem
		global theCommand
		global theCfg
		global theTask
		global theAnimator
		global theOptions
		global theCfgLinker
		self.Configuration=confosXBar
		print self.Configuration["osXBar"] + " [" + self.Configuration["Version"]+"] Init (" + str(NextStatus)+")"
		self.Status=NextStatus
		if(NextStatus==0):
			## Other
			## Bind
			theMatrix.Engine=self.Me
			theObject.Engine=self.Me
			theCfg.Engine=self.Me
			theCfg.Matrix=theMatrix
			theSystem.Engine=self.Me
			theCfg.System=theSystem
			theCfg.Sensor=theSensor
			theCommand.Engine=self.Me
			theSensor.Engine=self.Me
			theTask.Engine=self.Me
			theTask.Matrix=theMatrix
			theAnimator.Engine=self.Me
			thePager.Engine=self.Me
			theOptions.Engine=self.Me
			theCfgLinker.Engine=self.Me
			theCfgSensors.Engine=self.Me

			self.Animator=theAnimator
			self.Command=theCommand
			self.Cfg=theCfg
			self.Sensor=theSensor
			self.TaskMgr=theTask
			self.Sensor.Matrix=theMatrix
			self.Animator.Matrix=theMatrix
			self.Pager=thePager
			self.Pager.Matrix=theMatrix
			self.Options=theOptions
			self.CfgLinker=theCfgLinker
			self.CfgSensors=theCfgSensors
			# Init
			theMatrix.Init(NextStatus)
			theCfg.Init(NextStatus)
			theSensor.Init(NextStatus)
			theAnimator.Init(NextStatus)
			theCommand.Init(NextStatus)
			theTask.Init(NextStatus)
			## Configurations
			if(confosXBar["EnableLoadCfg"]=="yes"):
				print self.Configuration["osXBar"] + ": Loading configuration file [" + self.Configuration["CfgFile"] +"]"
				theCfg.LoadCfg(karamba.getThemePath(self.Widget) + "/" +self.Configuration["CfgFile"])
				theCfg.Scan("ilink")
				theCfg.Scan("iconf")
				theCfg.Scan("imenu")
				# After Loaded the CFG we can count the Static Icons
				self.NumerOfStaticIcons=len(self.Objects)
			if(confosXBar["LoadCfgSensors"]=="yes"):
				print self.Configuration["osXBar"] + ": Loading Sensors files"
				theCfgSensors.Scan("sconf")
			if(confosXBar["LoadCfgAlias"]=="yes"):
				print self.Configuration["osXBar"] + ": Loading Sensors files"
				theCfgSensors.Scan("alias")
				theCfgSensors.Scan("aconf")
			# Time Counter Setup
			self.UpdateTaskCounterMax=self.Configuration["ArrowUpdate"]
			pass
		if(NextStatus==1):
			## Initializations
			theMatrix.Init(NextStatus)
			theSensor.Init(NextStatus)
			theAnimator.Init(NextStatus)
			theCommand.Init(NextStatus)
			theOptions.Init(NextStatus)
			theTask.Init(NextStatus)
			# 20031017
			if(self.Configuration["Design"]=="realosx"):
				(self.DesignVirtualXMax,self.DesignVirtualYMax)=theMatrix.MakeCenter(0)
			pass

		if(NextStatus==2):
			## Loading objects
			theSensor.Init(NextStatus)
			theCommand.Init(NextStatus)
			theOptions.Init(NextStatus)
			theAnimator.Init(NextStatus)
			theTask.Init(NextStatus)
			pass

		if(NextStatus==3):
			## Loading GUI
			## WARNING: Using Widget
			## Setup Widget
			# Thread and sensors
			theAnimator.Init(NextStatus)
			theSensor.Init(NextStatus)
			theOptions.Init(NextStatus)
			thePager.Init(NextStatus)
			theTask.Init(NextStatus)
			# Enable Hides handles
			if(self.Configuration["EnableHandles"]!=""):
				# Hide Handle
				(bx,by)=theMatrix.MakeSpace(-2)
				self.HandlesX.append(bx)
				self.HandlesY.append(by)
				self.HandlesAction.append(self.HideWidget)
				self.Handles.append(karamba.createImage(self.Widget,bx,by,self.Configuration["pathBar"]+"/arrow_hide.png"))
				# Change Background
				by=by+16
				self.HandlesX.append(bx)
				self.HandlesY.append(by)
				self.Handles.append(karamba.createImage(self.Widget,bx,by,self.Configuration["pathBar"]+"/arrow_background.png"))
				self.HandlesAction.append(self.Command.HandlechangeBackground)

			# Creating BackBar
			self.Bar.append(0);
			self.Bar.append(0);
			self.Bar.append(0);
			self.Bar.append(0);
			if(self.Configuration["BarTheme"]=="none"):
				self.Configuration["BarTheme"]=""
			if(self.Configuration["BarTheme"]!=""):
				(bx,by)=theMatrix.MakeBarSpace(0)
				self.Bar[0]=(karamba.createImage(self.Widget,bx,by,self.Configuration["pathBar"]+self.Configuration["BarTheme"]+"/background-left.png"))
				(bx,by)=theMatrix.MakeBarSpace(1)
				self.Bar[1]=(karamba.createImage(self.Widget,bx,by,self.Configuration["pathBar"]+self.Configuration["BarTheme"]+"/background-center.png"))
				(bx,by)=theMatrix.MakeBarSpace(2)
				self.Bar[2]=(karamba.createImage(self.Widget,bx,by,self.Configuration["pathBar"]+self.Configuration["BarTheme"]+"/background-right.png"))
			# Loading Icons
			for i in range (0,len(self.Objects)):
				#print self.Configuration["osXBar"] + ": Creating [" + str(i) +"]"
				self.Objects[i].CreateObject(self.Widget)
			# 20031026
			self.ResizeWidget()
			# no flickering
			#karamba.moveWidget(self.Widget,0,self.Configuration["WidgetY"])
			# After all we apply changes
			#karamba.resizeWidget(self.Widget, self.Configuration["DisplayX"]+self.Pager.PagerdX+self.Configuration["ImageSize"], self.Configuration["WidgetHeight"])
			#MakeSpaceMaxWidget
			(maxwidth,maxheight)=theMatrix.MakeSpaceMaxWidget()
			maxwidth=maxwidth+self.Pager.PagerdX*2+self.Configuration["ImageSize"]+theMatrix.KMatrix[theMatrix.SizeMatrix*2-1]*2
			print "********************* " +str(maxwidth)+ " ********* " + str(self.Pager.PagerdX)
			karamba.resizeWidget(self.Widget, maxwidth,maxheight)

			if(self.Configuration["BarTheme"]!=""):
				karamba.resizeImageSmooth(self.Widget,self.Bar[1],self.Configuration["WidgetWidth"]-self.Configuration["borderLeft"]*2,self.Configuration["ImageSize"]+16)
				#karamba.resizeImageSmooth(self.Widget,self.Bar[0],karamba.getImageWidth(self.Widget,self.Bar[0]),self.Configuration["ImageSize"]+16)
				# 20031124
				# tanks to muhulu to track the bug :)
				karamba.resizeImageSmooth(self.Widget,self.Bar[0],self.Configuration["ImageSize"]+16,self.Configuration["ImageSize"]+16)
				karamba.resizeImageSmooth(self.Widget,self.Bar[2],karamba.getImageWidth(self.Widget,self.Bar[2]),self.Configuration["ImageSize"]+16)

			theCommand.Init(NextStatus)
			pass
		if(NextStatus==4):
			## Loading GUI
			## WARNING: Using Widget
			theSensor.Init(NextStatus)
			theOptions.Init(NextStatus)
			thePager.Init(NextStatus)
			theTask.Init(NextStatus)
			## Setup Widget
			#for i in range (0,len(self.Objects)):
			#	print self.Configuration["osXBar"] + ": Creating [" + str(i) +"]"
			#	#self.Objects[i].CreateSmooth(self.Widget)
			# Over Text
			if(self.Configuration["Font"]!="none"):
				#self.Testo=karamba.createText(self.Widget,0,0,self.Configuration["WidgetWidth"],self.Configuration["WidgetHeight"],"")
				self.Testo=karamba.createText(self.Widget,0,0,self.Configuration["DisplayX"],self.Configuration["WidgetHeight"],"")
				karamba.changeText(self.Widget, self.Testo,self.Configuration["osXBar"])
				karamba.changeTextFont(self.Widget, self.Testo,self.Configuration["Font"])
				karamba.changeTextSize(self.Widget, self.Testo,self.Configuration["FontSize"])
				karamba.changeTextColor(self.Widget, self.Testo,255,255,255)
				karamba.changeTextShadow(self.Widget, self.Testo,2)
			else:
				# we like to create text, only to avoid karamba errors
				self.Testo=karamba.createText(self.Widget,0,0,0,0,"")
			if(self.Configuration["BarThemeOver"]!=""):
				(bx,by)=theMatrix.MakeBarSpace(1)
				self.Bar[3]=(karamba.createImage(self.Widget,bx,by,self.Configuration["pathBar"]+self.Configuration["BarTheme"]+"/background-over.png"))
		if(NextStatus==5):
			## Loading Sensors
			theSensor.Init(NextStatus)
			theOptions.Init(NextStatus)
			thePager.Init(NextStatus)
			theTask.Init(NextStatus)
			karamba.acceptDrops(self.Widget)
		pass
	def CheckMouse_Passive(self):
		#print "Passive mouse checking..."
		# Check The Mouse Position
		global theMatrix
		#print "CheckMousePosition()"
		if(self.IsReset!=0):
			self.IncrementalSleep=self.Configuration["SleepMax"]
			if(self.IsHidden==0):
				if(int(self.Configuration["HideAutoTimer"])>=0):
					#print "AutoHideTimer: " + str(self.TimerHide)
					self.TimerHide=self.TimerHide+1
					if(self.TimerHide>=int(self.Configuration["HideAutoTimer"])):
						# Calling the Real Function
						# self.HideWidget()
						self.Sensor.RefreshIcons.append(-5)
						#self.Sensor.Ready=1
				return
		x, y = xcursor.position()
		if(self.IsHidden!=0):
			self.TimerHide=0
			if(self.Configuration["WidgetAlign"]=="bottom"):
				if(y<self.Configuration["DisplayY"]-int(self.Configuration["HideMouseEdge"])):
					return
			if(self.Configuration["WidgetAlign"]=="top"):
				if(y>int(self.Configuration["HideMouseEdge"])):
					return
			# I hope it will be showed ?
			self.IsHidden=0
			# self.ResizeWidget()
			self.Sensor.RefreshIcons.append(-6)
			#self.Sensor.Ready=1
			return
		if(self.HasMoved!=0):
			return

		# Auto Hide Timer
		#print "CheckMousePosition() Not reset"
		(wx,wy)=theMatrix.MakeCenterWidget(self.Configuration["WidgetAlign"])
		if(x>(wx+self.Configuration["WidgetWidth"]) or x<wx):
			# sono fuori in X
			self.widgetCheckForMouse=self.widgetCheckForMouse+1
		else:
			if(y>(wy+(self.Configuration["WidgetHeight"])) or y<wy):
				# sono fuori in Y ma non in X
				self.widgetCheckForMouse=self.widgetCheckForMouse+1
			else:
				# 20031012 Mouse check over other window
				# If you move mouse over the withget it will reset self.widgetCheckForMouse
				# otherwise it will came here ... than we can  update self.widgetCheckForMouse
				# Now i'm over the widget rect, we have to check the last mouse position
				if(self.lastMouseX!=x or self.lastMouseY!=y):
					# ok i had moved over rect but it don't have done "Update"
					# i hope you are over other windows :)
					self.widgetCheckForMouse=self.widgetCheckForMouse+1
		if(self.Configuration["MouseTimeout"]<self.widgetCheckForMouse):
			## we have to reset the widget
			self.Sensor.RefreshIcons.append(-7)
			#self.Sensor.Ready=1

	def CheckMousePosition_Reset(self):
		# superkaramba patch
		#karamba.setWidgetFakeTop(self.Widget,0)
		#karamba.redrawWidgetBackground(self.Widget)
		#karamba.redrawWidget(self.Widget)

		self.widgetCheckForMouse=0
		self.HasMoved=1
		karamba.hideText(self.Widget, self.Testo)
		print "reset"
		#self.MouseMoved(-1000,0,0)
		self.Animator.AniReset(self.lastx,self.lasty)
		self.IsReset=1

	def CheckMousePosition_old(self):
		# Check The Mouse Position
		global theMatrix
		print "CheckMousePosition()"
		if(self.IsReset!=0):
			self.IncrementalSleep=self.Configuration["SleepMax"]
			if(self.IsHidden==0):
				if(int(self.Configuration["HideAutoTimer"])>=0):
					print "AutoHideTimer: " + str(self.TimerHide)
					self.TimerHide=self.TimerHide+1
					if(self.TimerHide>=int(self.Configuration["HideAutoTimer"])):
						self.HideWidget()
				return
		# 20031101
		# Hidend functions
		x, y = xcursor.position()
		if(self.IsHidden!=0):
			self.TimerHide=0
			if(self.Configuration["WidgetAlign"]=="bottom"):
				if(y<self.Configuration["DisplayY"]-int(self.Configuration["HideMouseEdge"])):
					return
			if(self.Configuration["WidgetAlign"]=="top"):
				if(y>int(self.Configuration["HideMouseEdge"])):
					return
			# I hope it will be showed ?
			self.IsHidden=0
			self.ResizeWidget()
			return
		# Auto Hide Timer
		#print "CheckMousePosition() Not reset"
		(wx,wy)=theMatrix.MakeCenterWidget(self.Configuration["WidgetAlign"])
		if(x>(wx+self.Configuration["WidgetWidth"]) or x<wx):
			# sono fuori in X
			self.widgetCheckForMouse=self.widgetCheckForMouse+1
		else:
			if(y>(wy+(self.Configuration["WidgetHeight"])) or y<wy):
				# sono fuori in Y ma non in X
				self.widgetCheckForMouse=self.widgetCheckForMouse+1
			else:
				# 20031012 Mouse check over other window
				# If you move mouse over the withget it will reset self.widgetCheckForMouse
				# otherwise it will came here ... than we can  update self.widgetCheckForMouse
				# Now i'm over the widget rect, we have to check the last mouse position
				if(self.lastMouseX!=x or self.lastMouseY!=y):
					# ok i had moved over rect but it don't have done "Update"
					# i hope you are over other windows :)
					self.widgetCheckForMouse=self.widgetCheckForMouse+1
				else:
					self.widgetCheckForMouse=0
				# done on update
		#print "CheckMousePosition() " + str(self.widgetCheckForMouse)

		if(self.Configuration["MouseTimeout"]<self.widgetCheckForMouse):
			## we have to reset the widget
			self.widgetCheckForMouse=0
			self.HasMoved=1
			karamba.hideText(self.Widget, self.Testo)
			print "reset"
			#self.MouseMoved(-1000,0,0)
			self.Animator.AniReset(self.lastx,self.lasty)
			self.IsReset=1
	def Update(self):
		# Arrow- task control
		# Moved to Sensor Engine multithread
		#self.UpdateTaskCounter=self.UpdateTaskCounter+1
		#if(self.UpdateTaskCounter>self.UpdateTaskCounterMax):
		#	self.UpdateTaskCounter=0
		#	theTask.Update()
		#	self.CheckMousePosition()
		#if(self.HasMoved==0):
		#	return
		print "Update()"
		if(self.DropTest!=0):
			# Do you have dropped a file?
			self.DropTest=0
			IconDrop=(self.lastx-self.Configuration["borderLeft"])/(self.Configuration["ImageSize"]+self.Configuration["iconSeparation"])
			self.Command.Drop(IconDrop,self.Drop)
			self.Drop=""
			return
		#print "Update() [Animating]"
		self.IncrementalSleep=self.Configuration["SleepMin"]
		#karamba.stopWidgetTimer()
		if(self.Animator.Animating!=0):
			#karamba.startWidgetTimer(self.Widget,100)
			self.Animator.Animate()
			return
		#print "Update() [Imgs]"
		self.HasMoved=0
		self.HasMoved2=0
		for i in range (0,len(self.Objects)):
			if(self.Objects[i].HasChanged==0):
				continue
			self.Objects[i].HasChanged=0
			if(self.lastIcon==i):
					self.lastIconEnabled=i
					if(self.Configuration["Font"]!="none"):
						karamba.changeText(self.Widget, self.Testo,self.Objects[i].TextString)
						# We Need to find the right coords
						#dx=self.Objects[i].centerX-self.lastx
						# how many icon to raise?
						#DiffIconX=abs(dx*2)
						#dy=self.Objects[i].centerY-self.lasty
						#DiffIconY=abs(dy)
						#DiffIcon=DiffIconY+DiffIconX
						#DiffIcon=DiffIconY+DiffIconX
						#if(DiffIcon<theMatrix.SizeMatrix*2):
						delta=(len(self.Objects[i].TextString)*self.Configuration["TextSize"])
						delta=(self.Objects[i].currentZ/2-delta)
						#karamba.moveText(self.Widget,self.Testo,self.Objects[i].currentX-theMatrix.XMatrix[DiffIcon]+delta,self.Objects[i].currentY-theMatrix.YMatrix[DiffIcon]-30)
						karamba.moveText(self.Widget,self.Testo,self.Objects[i].currentX+delta,self.Objects[i].currentY-20)
						karamba.showText(self.Widget, self.Testo)
					if(self.Configuration["iconEffect"]==0):
						pass
					elif(self.Configuration["iconEffect"]==1):
						karamba.changeImageIntensity(self.Widget,self.Objects[i].imgImage , 0.2, 0)
					elif(self.Configuration["iconEffect"]==2):
						karamba.changeImageToGray(self.Widget,self.Objects[i].imgImage,0)
			karamba.resizeImageSmooth(self.Widget,self.Objects[i].imgImage,self.Objects[i].currentZ,self.Objects[i].currentZ)
		# Check Mouse
		#self.widgetCheckForMouse=0
		# Superkaramba patch
		#karamba.setWidgetFaketop(self.Widget,1)
		#karamba.redrawWidgetBackground(self.Widget)
		#karamba.setWidgetFakeTop(self.Widget,1)
		#karamba.redrawWidget(self.Widget)
		#karamba.setWidgetFakeTop(self.Widget,0)
		(mx,my)=xcursor.position()
		if(self.lastMouseX!=mx or self.lastMouseY != my):
			self.widgetCheckForMouse=0
		self.lastMouseX=mx
		self.lastMouseY=my
		# AutoHide Timer
		self.TimerHide=0
		karamba.startWidgetTimer(self.Widget,1000)
		self.MoveFirstTime=1
		pass


	def MouseMoved(self,x,y,button):
		if(y>self.DesignVirtualYMax):
			y=self.DesignVirtualYMax
		if(self.lastx==x and self.lasty==y and self.HasMoved==0):
			return
		# Find the MouseOverIcon
		IconShowed=len(self.Objects)
		iconNum=(x-self.Configuration["borderLeft"])/(self.Configuration["ImageSize"]+self.Configuration["iconSeparation"])
		if(self.MoveFirstTime>0):
			self.MouseMoved_FirstTime(x,y,button,iconNum,IconShowed)
		self.MouseMoved_Always(x,y,button,iconNum,IconShowed)

	def MouseMoved_FirstTime(self,x,y,button,iconNum,IconShowed):
		# Old Status
		# superkaramba bug?
		#if(x<0 or y<0 or y>self.Configuration["WidgetWidth"]):
		#	return
		#print str(x) + " " +str(y)
		self.MoveFirstTime=1
		karamba.stopWidgetTimer(self.Widget)
		# Overtext
		karamba.hideText(self.Widget, self.Testo)
		#
		if(self.lastIconEnabled!=iconNum and self.Configuration["iconEffect"]!=0):
			karamba.removeImageEffects(self.Widget,self.Objects[self.lastIconEnabled%IconShowed].imgImage)
		#karamba.redrawWidgetBackground(self.Widget)
		#karamba.setWidgetFakeTop(self.Widget,0)
		#karamba.redrawWidgetBackground(self.Widget)

	def MouseMoved_Always(self,x,y,button,iconNum,IconShowed):
		global theMatrix
		if(iconNum<=0):
			dx=self.Objects[0].centerX-x
			#self.HasMoved=1
			if(dx>0):
				# we are doing the first image
				dy=self.Objects[0].centerY-y
				if(dy>0):
					y=y-abs(self.Objects[0].centerX-x)
				else:
					y=abs(self.Objects[0].centerX-x)+y
				x=self.Objects[0].centerX
		if(iconNum>=IconShowed-1):
			#self.HasMoved=1
			dx=self.Objects[IconShowed-1].centerX-x
			if(dx<0):
				# we are doing the last image
				dy=self.Objects[IconShowed-1].centerY-y
				if(dy>0):
					y=y-abs(self.Objects[IconShowed-1].centerX-x)
				else:
					y=abs(self.Objects[IconShowed-1].centerX-x)+y
				x=self.Objects[IconShowed-1].centerX
		self.lastIcon=iconNum
		# This routine move the icon around the pointer
		for i in range (0,IconShowed):
			dx=self.Objects[i].centerX-x
			# how many icon to raise?
			DiffIconX=abs(dx*self.DesignXMoltiplier)
			dy=self.Objects[i].centerY-y
			DiffIconY=abs(dy*self.DesignYMoltiplier)
			DiffIcon=DiffIconY+DiffIconX

			# The Positional Matrix 3D
			if(DiffIcon<theMatrix.SizeMatrix*2):
				# September engine
				# self.IsReset=0
				# Put out the small icon [with smooth]
				karamba.moveImage(self.Widget,self.Objects[i].imgImageSmall,0,+10000)
				if(dx>0):
					# The right icon
					AreMovingToLeft=theMatrix.DMatrix[DiffIconX][DiffIconY]
				else:
					# the LEft icon
					AreMovingToLeft=-theMatrix.DMatrix[DiffIconX][DiffIconY]
				# The RealOSx is tooo wide...
				#AreMovingToLeft=AreMovingToLeft*self.DesignDMoltiplier
				# 20031018
				self.Objects[i].currentX=self.Objects[i].defaultX-theMatrix.XMatrix[DiffIcon]+AreMovingToLeft
				self.Objects[i].currentY=self.Objects[i].defaultY-theMatrix.YMatrix[DiffIcon]
				#cix=self.Objects[i].currentX-theMatrix.XMatrix[DiffIcon]+AreMovingToLeft
				#ciy=self.Objects[i].currentY-theMatrix.YMatrix[DiffIcon]
				#karamba.moveImage(self.Widget,self.Objects[i].imgImage,cix,ciy)
				karamba.moveImage(self.Widget,self.Objects[i].imgImage,self.Objects[i].currentX,self.Objects[i].currentY)
				#Arrow
				#karamba.moveImage(self.Widget,self.Objects[i].imgArrow,self.Objects[i].arrowX-theMatrix.XMatrix[DiffIcon]+theMatrix.XMatrix[DiffIcon]+AreMovingToLeft,self.Objects[i].arrowY)
				karamba.moveImage(self.Widget,self.Objects[i].imgArrow,self.Objects[i].arrowX+AreMovingToLeft,self.Objects[i].arrowY)
				self.Objects[i].currentZ=theMatrix.ZMatrix[DiffIcon]
				self.Objects[i].HasChanged=1
				karamba.resizeImage(self.Widget,self.Objects[i].imgImage,self.Objects[i].currentZ,self.Objects[i].currentZ)
				if(i==iconNum):
					self.lastIconx=self.Objects[i].currentX
					self.lastIcony=self.Objects[i].currentY
					# October engine
					self.IsReset=0
				#	karamba.changeImageIntensity(self.Widget,self.Objects[i] , 0.2, 0)
			else:
				# We are out of the matrix
				# We can use the LMATRIX
				if(self.lasty==y and self.HasMoved==0 and self.Objects[i].currentY==self.Objects[i].defaultY):
						#print "si"
						continue
					#pass
				#print "no"
				if(DiffIconY>=theMatrix.SizeMatrix*2):
					#continue
					DiffIconY=theMatrix.SizeMatrix*2-1
				if(dx>0):
					AreMovingToLeft=theMatrix.KMatrix[DiffIconY]
				else:
					AreMovingToLeft=-theMatrix.KMatrix[DiffIconY]
				#AreMovingToLeft=AreMovingToLeft*self.DesignDMoltiplier
				# Todo: here we can optimize code
				self.Objects[i].currentX=self.Objects[i].defaultX+AreMovingToLeft
				self.Objects[i].currentY=self.Objects[i].defaultY
				karamba.moveImage(self.Widget,self.Objects[i].imgImageSmall,self.Objects[i].currentX,self.Objects[i].currentY)
				# Arrow
				karamba.moveImage(self.Widget,self.Objects[i].imgArrow,self.Objects[i].arrowX+AreMovingToLeft,self.Objects[i].arrowY)
				#karamba.resizeImage(self.Widget,self.Objects[i].imgImage,self.Objects[i].currentZ,self.Objects[i].currentZ)
				self.Objects[i].currentZ=self.Configuration["ImageSize"]
				# Putout the resized image
				karamba.moveImage(self.Widget,self.Objects[i].imgImage,0,+1000)
				self.Objects[i].HasChanged=0

		#self.Update()
		if(self.lasty!=y or self.HasMoved!=0):
			#ok we may have to update the bar
			if(self.Configuration["BarTheme"]!=""):
				# Updateing the bar
				(bx,by)=theMatrix.MakeDynBarSpace(0,DiffIconY)
				karamba.moveImage(self.Widget,self.Bar[0],bx,by)
				(cx,by)=theMatrix.MakeDynBarSpace(1,DiffIconY)
				karamba.moveImage(self.Widget,self.Bar[1],cx,by)
				karamba.moveImage(self.Widget,self.Bar[3],cx,by)
				(bx,by)=theMatrix.MakeDynBarSpace(2,DiffIconY)
				karamba.moveImage(self.Widget,self.Bar[2],bx,by)
				#karamba.resizeImageSmooth(self.Widget,self.Bar[1],bx-cx,self.Configuration["ImageSize"]+16)
				karamba.resizeImage(self.Widget,self.Bar[1],bx-cx,self.Configuration["ImageSize"]+16)
			if(self.Configuration["BarThemeOver"]!=""):
				(cx,by)=theMatrix.MakeDynBarSpace(1,DiffIconY)
				karamba.moveImage(self.Widget,self.Bar[3],cx,by)
				karamba.resizeImage(self.Widget,self.Bar[3],bx-cx,self.Configuration["ImageSize"]+16)
		self.HasMoved2=1
		self.HasMoved=0
		self.lastx=x
		self.lasty=y
		self.lastbutton=button
		karamba.redrawWidget(self.Widget)
		time.sleep(self.Configuration["SleepTime"])
		karamba.startWidgetTimer(self.Widget,100)
		#self.MoveFirstTime=0
		pass
	def PlaySoundIcon(self,theIcon):
		if(self.Configuration["AudioCmd"]!=""):
			if(os.path.exists(self.Objects[theIcon].Sound)):
				os.system(self.Configuration["AudioCmd"]+" "+self.Objects[theIcon].Sound+" & ")
			else:
				# Auto cache :)
				if(self.Objects[theIcon].Sound==""):
					self.Objects[theIcon].Sound="bounce.wav"
				self.Objects[theIcon].Sound=self.Configuration["pathTheme"]+ "sounds/" + self.Objects[theIcon].Sound
				os.system(self.Configuration["AudioCmd"]+" "+self.Objects[theIcon].Sound+" & ")
	def ResizeWidget(self):
		if(self.IsHidden!=0):
			return
		# Now Setup the width
		if(self.Configuration["VirtualDesktop"]>0):
			self.Pager.Refresh()
		(self.Configuration["WidgetWidth"],self.Configuration["WidgetHeight"])=theMatrix.MakeSpaceWidget()
		# Auto Center Widget
		# Remeber to setup the Align like top bottom
		(self.Configuration["WidgetX"],self.Configuration["WidgetY"])=theMatrix.MakeCenterWidget(self.Configuration["WidgetAlign"])
		# 20031026
		# no flickering
		karamba.moveWidget(self.Widget,self.Configuration["WidgetX"],self.Configuration["WidgetY"])
		# After all we apply changes
		#karamba.resizeWidget(self.Widget, self.Configuration["WidgetWidth"]+self.Pager.PagerdX, self.Configuration["WidgetHeight"])

	def HideWidget(self):
		# We are going to hide the widget
		self.IsHidden=1
		karamba.moveWidget(self.Widget,self.Configuration["WidgetX"],self.Configuration["DisplayY"])
