##########################################
# osXBar 1.0 20030923 - 20031001 -20031015
# Source code GPL
# stefano@xiaprojects.com
# http://www.xiaproject.com
#
#
# getKDEConfigValue code came from Kroller by Caspian



import osXBarObject
import karamba
import os
import re

class osXBarCfg:
	Engine=0
	Matrix=0
	System=0
	Sensor=0
	# Icon Sizes and path types on kde :)
	# cache is better...
	sizes = []
	types = []

	def Scan(self, FileType):
		print "Scanning for objects..." + FileType
		pathFinder=""
		AliasInfo=0
		if(FileType=="iconf"):
			# Standard configuration tool
			pathFinder="find " + self.Engine.Configuration["pathTheme"] +"objects" + " -type f -iname \"*.iconf\" |sort"
			ListFinder=os.popen(pathFinder,"r")
			## Exstract any single line
			while 1:
				FileName=ListFinder.readline()
				if len(FileName) == 0:
					break
				FileName=FileName.strip()
				print "Now loading: " + FileName
				#self.Engine.Cfg.ReadCfgObject(FileName)
				self.Engine.Cfg.ReadCfgObject(FileName,FileType)
			ListFinder.close()
			pass
		if(FileType=="ilink"):
			# Standard configuration tool
			pathFinder="find " + self.Engine.Configuration["pathTheme"] +"objects" + " -type f -iname \"*.ilink\" |sort"
			ListFinder=os.popen(pathFinder,"r")
			## Exstract any single line
			while 1:
				FileName=ListFinder.readline()
				if len(FileName) == 0:
					break
				FileName=FileName.strip()
				print "Now loading: " + FileName
				self.ReadCfgObject(FileName,FileType)
			ListFinder.close()
			pass
		if(FileType=="imenu"):
			# Standard configuration tool
			pathFinder="find " + self.Engine.Configuration["pathTheme"] +"objects" + " -type f -iname \"*.imenu\" |sort"
			ListFinder=os.popen(pathFinder,"r")
			## Exstract any single line
			while 1:
				FileName=ListFinder.readline()
				if len(FileName) == 0:
					break
				FileName=FileName.strip()
				print "Now loading: " + FileName
				self.ReadCfgObject(FileName,FileType)
			ListFinder.close()
			pass


	def ReadCfgObject(self,FileName,FileType):
		if(FileType=="ilink"):
			IconInfo=self.Engine.CfgLinker.Load(FileName)
			if(len(IconInfo)>6):
				# Formats are:
				# 0	Icon
				# 1	Exec
				# 2	Name
				# 3	SwallowTitle
				# 4	Comment
				# 5	SwallowExec
				# 6	TerminalOptions
				# 7	GenericName [Description]
				# Searching for the name
				IndexName=-1
				for i in range(len(self.Engine.Objects)):
					if(self.Engine.Objects[i].Name==IconInfo[2]):
						# Found!
						# We have to add the Multiobject
						# not all data
						IndexName=i
						break
				if(IndexName>=0):
					# Ok we have to append the object
					ThisMultiObject=osXBarObject.osXBarObject()
					self.Engine.Command.MultiObject[IndexName].append(ThisMultiObject)
					ThisMultiObject.imgSource=IconInfo[0]
					ThisMultiObject.Command=IconInfo[1]
					ThisMultiObject.Name=IconInfo[2]
					ThisMultiObject.WindowTitle=IconInfo[3]
					ThisMultiObject.arrowSource=IconInfo[4]
					ThisMultiObject.DropCommand=IconInfo[5]
					ThisMultiObject.Sound=IconInfo[6]
					ThisMultiObject.TextString=IconInfo[7]

				else:
					ThisMultiObject=osXBarObject.osXBarObject()
					self.Engine.Command.MultiObjectIndex.append(0)
					VetMultiObject=[]
					VetMultiObject.append(ThisMultiObject)
					self.Engine.Command.MultiObject.append(VetMultiObject)
					NewObject=osXBarObject.osXBarObject()
					NewObject.Engine=self.Engine
					# Ok rememeber the Array must be reallocated!
					NewObject.MenuString=[]
					NewObject.MenuCommand=[]
					NewObject.MenuIcon=[]
					NewObject.Sound="bounce.wav"
					NewObject.Locked=1
					NewObject.currentZ=self.Engine.Configuration["ImageSize"]
					(NewObject.currentX,NewObject.currentY)=self.Matrix.MakeSpace(len(self.Engine.Objects))
					(NewObject.centerX,NewObject.centerY)=self.Matrix.MakeCenter(len(self.Engine.Objects))
					(NewObject.defaultX,NewObject.defaultY)=(NewObject.currentX,NewObject.currentY)
					NewObject.Command=IconInfo[1]
					ThisMultiObject.Command=IconInfo[1]
					if(len(IconInfo[6])>0):
						# Sound!
						NewObject.Sound=IconInfo[6]
					if(len(IconInfo[4])>0):
						# Arrow!
						NewObject.arrowSource=IconInfo[4]
						ThisMultiObject.arrowSource=IconInfo[4]
					NewObject.imgSource=IconInfo[0]
					ThisMultiObject.imgSource=IconInfo[0]
					ThisMultiObject.TextString=IconInfo[7]
					NewObject.TextString=IconInfo[7]
					ThisMultiObject.Name=IconInfo[2]
					NewObject.Name=IconInfo[2]
					ThisMultiObject.WindowTitle=IconInfo[3]
					NewObject.WindowTitle=IconInfo[3]
					ThisMultiObject.DropCommand=IconInfo[5]
					NewObject.DropCommand=IconInfo[5]
					NewObject.AppendObject(NewObject)
		if(FileType=="imenu"):
			# new menu style with kde link
			IconInfo=self.Engine.CfgLinker.Load(FileName)
			if(len(IconInfo)>6):
				# Formats are:
				# 0	Icon
				# 1	Exec
				# 2	Name
				# 3	SwallowTitle
				# 4	Comment
				# 5	SwallowExec
				# 6	TerminalOptions
				# 7	GenericName [Description]
				# Searching for the name
				IndexName=-1
				for i in range(len(self.Engine.Objects)):
					if(self.Engine.Objects[i].Name==IconInfo[2]):
						# Found!
						# We have to add the Multiobject
						# not all data
						IndexName=i
						break
				if(IndexName>=0):
					#self.Engine.Command.MultiObject[IndexName][0].MenuString=IconInfo[7]
					#self.Engine.Command.MultiObject[IndexName][0].MenuCommand=IconInfo[1]
					#self.Engine.Command.MultiObject[IndexName][0].MenuIcon=IconInfo[0]
					self.Engine.Objects[IndexName].MenuString.append(IconInfo[7])
					self.Engine.Objects[IndexName].MenuCommand.append(IconInfo[1])
					self.Engine.Objects[IndexName].MenuIcon.append(IconInfo[0])
		if(FileType=="iconf"):
			# Old style with names
			# iLink must be done before
			pass
	def LoadCfg(self,FileName):
		# Path
		self.Engine.Configuration["pathTheme"]=karamba.getThemePath(self.Engine.Widget)
		self.Engine.Configuration["pathIcons"]=self.Engine.Configuration["pathTheme"] + "themes/icons/"
		self.Engine.Configuration["pathBar"]=self.Engine.Configuration["pathTheme"] + "themes/bar/"
		self.Engine.Configuration["pathArrow"]=self.Engine.Configuration["pathTheme"] + "themes/arrow/"
		kdedir = os.getenv("KDEDIR")
		if (not kdedir):
			fp = os.popen("kde-config --prefix")
			if (fp):
				tmp = fp.read()
				tmp = tmp.replace('\n', '')
				kdedir = tmp
				del tmp
		if (not kdedir):
			kdedir = "/opt/kde"
		if(type(kdedir)!=str):
			kdedir = "/usr"
		user_theme=self.getKDEConfigValue(os.getenv("HOME") + "/.kde/share/config/kdeglobals", "Icons", "Theme")
		if (not user_theme or type(user_theme)!=str):
			user_theme = "crystalsvg"
			print "Warning Default theme crystalsvg enabled!!!"
		self.Engine.Configuration["pathKDEIcons"]=kdedir+"/share/icons/"+user_theme
		# the user icons
		self.Engine.Configuration["pathUserIcons"]=[]
		print self.Engine.Configuration["osXBar"] + ": Theme " + str(self.Engine.Configuration["pathTheme"])
		print self.Engine.Configuration["osXBar"] + ": Icons " + str(self.Engine.Configuration["pathIcons"])
		print self.Engine.Configuration["osXBar"] + ": KDE   " + str(self.Engine.Configuration["pathKDEIcons"])
		print self.Engine.Configuration["osXBar"] + ": Bar   " + str(self.Engine.Configuration["pathBar"])
		print self.Engine.Configuration["osXBar"] + ": Arrow " + str(self.Engine.Configuration["pathArrow"])
		# Detect Resolution
		self.System.detectResolution()
	        if (os.path.exists(os.getenv("HOME") + "/.kde/share/config/kdeglobals")):
			ndesktop=self.getKDEConfigValue( os.getenv("HOME") + "/.kde/share/config/kdeglobals", "Desktops","Number")
			if (not ndesktop or type(ndesktop)!=str):
				ndesktop=0
			self.Engine.Configuration["VirtualDesktop"] = int(ndesktop)
		print self.Engine.Configuration["osXBar"] + ": Display resolution " + str(self.Engine.Configuration["DisplayX"]) +"x"+str(self.Engine.Configuration["DisplayY"])
		self.GetIconsPath()
		while (not os.path.exists(FileName)):
			# You dont have configured osxbar > 1.0.18
			os.system(self.Engine.Configuration["pathTheme"]+"osXBar.configure")

		self.readConfigurationFile(FileName)
		for ipath in range(len(self.Engine.Configuration["pathUserIcons"])):
			print self.Engine.Configuration["osXBar"] + ": User " +self.Engine.Configuration["pathUserIcons"][ipath]

	def getKDEConfigValue(self,filename, section, option):
		try:
			file = open(filename,"r")
		except IOError:
			print
			print "ERROR While opening the configuration file [" + filename + "]"
			print
			return ("")
		## Read through each line of the file
		while 1:
			line = file.readline()                        ## Read a line from the file
			if len(line) == 0:                            ## Break this while loop if we're at the end of the file
				break
			line = re.sub("#.*$", "", line)               ## Remove comments
			line = re.sub("//.*$", "", line)              ## Remove comments
			line = line.strip()                           ## Remove line ending characters, and extra whitespace
			if re.search("^\[" + section + "\]", line):   ## If we're entering the right section
				while 1:
					line = file.readline()
					if len(line) == 0:            ## Break this while loop if we're at the end of the file
						break
					line = line.strip()
					if re.search("^" + option + "=", line):
						(name, value) = re.split("=", line, 1)
						file.close
						return(str(value))
		## Close the coniguration file and return an error if we didn't find what we were looking for
		file.close()
		return("")
	def FindIcon(self,icon):
		# Absolute PATH
		if (os.path.exists(icon)):
			return icon
		# Local Path PNG
		iconpath=self.Engine.Configuration["pathTheme"]+"themes/"+self.Engine.Configuration["IconsTheme"]+"/"+icon+".png"
		if (os.path.exists(iconpath)):
			return iconpath
		iconpath=self.Engine.Configuration["pathTheme"]+"themes/"+self.Engine.Configuration["IconsTheme"]+"/"+icon+".svg"
		if (os.path.exists(iconpath)):
			return iconpath
		iconpath=self.Engine.Configuration["pathIcons"]+icon+".png"
		if (os.path.exists(iconpath)):
			return iconpath
		# Local Path SVG
		iconpath=self.Engine.Configuration["pathIcons"]+icon+".svg"
		if (os.path.exists(iconpath)):
			return iconpath
		iconpath=self.Engine.Configuration["pathKDEIcons"]
		for selectedSize in self.sizes:
			for selectedType in self.types:
				iconfound=(iconpath+"/"+selectedSize+"/"+selectedType+"/"+icon+".png")
				if (os.path.exists(iconfound)):
					return iconfound
				iconfound=(iconpath+"/"+selectedSize+"/"+selectedType+"/"+icon+".svg")
				if (os.path.exists(iconfound)):
					return iconfound
		for userpath in range(len(self.Engine.Configuration["pathUserIcons"])):
			iconpath=self.Engine.Configuration["pathUserIcons"][userpath]
			for selectedSize in self.sizes:
				for selectedType in self.types:
					iconfound=(iconpath+"/"+selectedSize+"/"+selectedType+"/"+icon+".png")
					if (os.path.exists(iconfound)):
						return iconfound
					iconfound=(iconpath+"/"+selectedSize+"/"+selectedType+"/"+icon+".svg")
					if (os.path.exists(iconfound)):
						return iconfound
		return self.Engine.Configuration["pathIcons"]+"default.png"
	def Init(self,NextStatus):
		if(NextStatus==0):
			self.sizes=[]
			self.sizes.append("128x128")
			self.sizes.append("96x96")
			self.sizes.append("64x64")
			self.sizes.append("48x48")
			self.sizes.append("32x32")
			self.sizes.append("22x22")
			self.sizes.append("16x16")
			self.types=[]
			self.types.append("apps")
			self.types.append("devices")
			self.types.append("filesystems")
			self.types.append("mimetypes")
	def AliasAppendIcon(self,InfoIcon):
		# this is called when we have to add new alias
		# 0 icon
		# 1 cmd
		# 2 name
		# 3 title
		# 4 TTL
		if(len(InfoIcon)<3):
			return

		self.Engine.Sensor.SysSensorsAliasIcon.append(InfoIcon[0])
		self.Engine.Sensor.SysSensorsAliasCmd.append(InfoIcon[1])
		self.Engine.Sensor.SysSensorsAlias.append(InfoIcon[2])
		# TODO: title
		if(len(InfoIcon)>=5):
			if(len(InfoIcon[4])>0):
				self.Engine.Sensor.SysSensorMaxTimeMoltiplier.append(int(InfoIcon[4]))
		else:
			self.Engine.Sensor.SysSensorMaxTimeMoltiplier.append(1)
		# TOTO: Menu files
		self.Engine.Sensor.SysSensorsAliasMenu.append([])


	def readConfigurationFile(self,filename):
		## Open the configuration file
		try:
			file = open(filename,"r")
		except IOError:
			print "ERROR While opening the configuration file [" + filename + "]"
			return
		## Read through each line of the file
		# Last added Object
		NewObject=0
		ThisMultiObject=0
		VetMultiObject=[]
		# AliasSensor Menu
		AliasMenu=0
		AliasMenuDevice=0
		while 1:
			line = file.readline()                        ## Read a line from the file
			if len(line) == 0:                            ## Break this while loop if we're at the end of the file
				break
			line = re.sub("#.*$", "", line)               ## Remove comments
			line = re.sub("//.*$", "", line)              ## Remove comments
			line = line.strip()                           ## Remove line ending characters, and extra whitespace
			if re.search("\s+=>\s+", line):               ## If it looks like a valid configuration line
				## Extract the name/value pair
				(name, value) = re.split("\s+=>\s+", line, 1)
				## Add a command
				if (name == "addCommand"):
					# Multi Choice
					ThisMultiObject=osXBarObject.osXBarObject()
					self.Engine.Command.MultiObjectIndex.append(0)
					VetMultiObject=[]
					VetMultiObject.append(ThisMultiObject)
					self.Engine.Command.MultiObject.append(VetMultiObject)

					if(NewObject!=0):
						# We have to store the latest Object
						NewObject.AppendObject(NewObject)
					NewObject=osXBarObject.osXBarObject()
					# Ok rememeber the Array must be reallocated!
					NewObject.MenuString=[]
					NewObject.MenuCommand=[]
					NewObject.MenuIcon=[]
					NewObject.Sound="bounce.wav"
					# Static icons cannot removed
					# This will be default on engine 2.0 :)
					NewObject.Locked=1
					NewObject.currentZ=self.Engine.Configuration["ImageSize"]
					(NewObject.currentX,NewObject.currentY)=self.Matrix.MakeSpace(len(self.Engine.Objects))
					(NewObject.centerX,NewObject.centerY)=self.Matrix.MakeCenter(len(self.Engine.Objects))
					# 20031018
					(NewObject.defaultX,NewObject.defaultY)=(NewObject.currentX,NewObject.currentY)
					NewObject.Engine=self.Engine
					# Command
					NewObject.Command=value
					ThisMultiObject.Command=value
				# MultiChoice
				elif (name == "addMultiCommand"):
					# ok add new MultiChoice
					ThisMultiObject=osXBarObject.osXBarObject()
					VetMultiObject.append(ThisMultiObject)
					ThisMultiObject.Command=value
				elif (name == "addMultiIcon"):
					ThisMultiObject.imgSource=value
				elif (name == "addMultiTextString"):
					ThisMultiObject.TextString=value
				## Add an icon name
				elif (name == "addArrow"):
					NewObject.arrowSource=value
					ThisMultiObject.arrowSource=value
				elif (name == "addIcon"):
					NewObject.imgSource=value
					ThisMultiObject.imgSource=value
				elif (name == "addSound"):
					NewObject.Sound=value
				elif (name == "addMultiDropCmd"):
					ThisMultiObject.DropCommand=value
				elif (name == "addDropCmd"):
					ThisMultiObject.DropCommand=value
					NewObject.DropCommand=value
				elif (name == "addMultiTaskAlias"):
					ThisMultiObject.WindowTitle=value
				elif (name == "addTaskAlias"):
					ThisMultiObject.WindowTitle=value
					NewObject.WindowTitle=value
				elif (name == "addTextString"):
					ThisMultiObject.TextString=value
					NewObject.TextString=value
				elif (name == "addMenuString"):
					NewObject.MenuString.append(value)
				elif (name == "addMenuCommand"):
					NewObject.MenuCommand.append(value)
				elif (name == "addMenuIcon"):
					NewObject.MenuIcon.append(value)
				elif (name == "AddSpecialCommand"):
					self.Engine.Command.SpecialCommand.append(int(value))
				elif (name == "addSensorType"):
					NewObject.SensorType=int(value)
				elif (name == "addSensorRefresh"):
					NewObject.SensorRefresh=int(value)
				#elif (name == "addSensorTTLMoltiplier"):
				#	NewObject.MaxTimeMoltiplier=int(value)
				elif (name == "addSensorCmd"):
					# We have to try to find the cmd
					# if it starts with . it's on themepath
					# otherwise i dunno :)
					if(value[0]=="."):
						NewObject.SensorCmd=self.Engine.Configuration["pathTheme"]+value
					else:
						NewObject.SensorCmd=value
				elif (name == "addExtraSensorRefresh"):
					self.Sensor.SysExtraSensorRefresh.append(int(value))
				#elif (name == "addExtraSensorTTLM"):
				#	self.Sensor.SysExtraSensorMaxTimeMoltiplier.append(int(value))
				elif (name == "addExtraSensorIcon"):
					try:
						self.Sensor.SysExtraSensorIcon.append(int(value))
					except:
						iIndex=-1
						for isss in range(len(self.Engine.Objects)):
							if(self.Engine.Objects[isss].Name==value):
								iIndex=isss
								break
						if(iIndex>=0):
							self.Sensor.SysExtraSensorIcon.append(iIndex)
						else:
							self.Sensor.SysExtraSensorIcon.append(-1)
				elif (name == "addExtraSensorCmd"):
					if(value[0]=="."):
						self.Sensor.SysExtraSensorCmd.append(self.Engine.Configuration["pathTheme"]+value)

					else:
						self.Sensor.SysExtraSensorCmd.append(value)
					self.Sensor.SysExtraSensorTimeOut.append(0)
					self.Sensor.SysExtraSensorThread.append(0)
				elif (name == "addExtraSensorType"):
					self.Sensor.SysExtraSensorType.append(int(value))
				elif (name == "AddSpecialAction"):
					self.Engine.Command.SpecialAction.append(int(value))
				elif (name == "addSensorAlias"):
					# This must be the first, it will allocate menu
					self.Engine.Sensor.SysSensorsAlias.append(value)
					# we can add 0, or structure
					if(AliasMenuDevice!=0):
						self.Engine.Sensor.SysSensorsAliasMenu.append(AliasMenuDevice)
					AliasMenuDevice=[]

				elif (name == "addSensorAliasIcon"):
					self.Engine.Sensor.SysSensorsAliasIcon.append(value)
				elif (name == "addSensorAliasTTL"):
					self.Engine.Sensor.SysSensorMaxTimeMoltiplier.append(int(value))
				elif (name == "addSensorAliasCmd"):
					self.Engine.Sensor.SysSensorsAliasCmd.append(value)
				elif (name == "addSensorAliasMenuIcon"):
					# Now loading extra menu actions on sensors
					# like mounts
					# cardctl
					# bluez
					if(AliasMenu!=0):
						#if(AliasMenu["MenuIcon"]==""):
						AliasMenu["MenuIcon"]=value
						# this must be the last !!!!!
						AliasMenuDevice.append(AliasMenu)

					AliasMenu={
						"MenuString":[],
						"MenuIcon":[],
						"MenuCmd":[],
					}
					AliasMenu["MenuIcon"]=value
					#self.Engine.Sensor.SysSensorsAliasMenu.append(value)
					#AliasMenu
				elif (name == "addSensorAliasMenuCmd"):
					# Now loading extra menu actions on sensors
					# like mounts
					# cardctl
					# bluez
					if(AliasMenu==0):
						AliasMenu={
							"MenuString":[],
							"MenuIcon":[],
							"MenuCmd":[],
						}
					AliasMenu["MenuCmd"]=value
					#self.Engine.Sensor.SysSensorsAliasMenu.append(value)
					#AliasMenu
				elif (name == "addSensorAliasMenuString"):
					# Now loading extra menu actions on sensors
					# like mounts
					# cardctl
					# bluez
					if(AliasMenu==0):
						AliasMenu={
							"MenuString":[],
							"MenuIcon":[],
							"MenuCmd":[],
						}
					AliasMenu["MenuString"]=value
					#self.Engine.Sensor.SysSensorsAliasMenu.append(value)
					#AliasMenu

				elif (name == "addPathIcons"):
					self.Engine.Configuration["pathUserIcons"].append(value)
				elif (name == "addTaskIgnore"):
					self.Engine.TaskMgr.TaskListIgnore.append(value)

				## Must be a generic configuration parameter, store it in conf
				else:
					if(name=="iconRaise"):
						# workaround for int in -
						self.Engine.Configuration[name] = int(value)
						continue
					if(name=="ArrowUpdate"):
						# workaround for int in -
						self.Engine.Configuration[name] = int(value)
						continue
					if(name=="ArrowY"):
						# workaround for int in -
						self.Engine.Configuration[name] = int(value)
						continue
					if(name=="SleepTime"):
						# workaround for float
						self.Engine.Configuration[name] = float(value)
						continue
					if (re.match("^\d+$", value)):
						self.Engine.Configuration[name] = int(value)
					else:
						self.Engine.Configuration[name] = value
		## Close the coniguration file
		if(NewObject!=0):
			NewObject.AppendObject(NewObject)
		if(AliasMenuDevice!=0):
			self.Engine.Sensor.SysSensorsAliasMenu.append(AliasMenuDevice)

		file.close()
	def GetIconsPath(self):
		fp = os.popen("kde-config --path icon")
		output = []
		if (fp):
			output = fp.read()
			## Strip newlines
			output = output.replace('\n', '')
			output = output.split(":")
		self.Engine.Configuration["pathUserIcons"]=output

