##########################################
# osXBar 1.0 20030923 - 20031001 -20031015
# Source code GPL
# stefano@xiaprojects.com
# http://www.xiaproject.com
#
#





#this import statement allows access to the karamba functions
import karamba

## System
import string, re, os
import thread

## Other Stuff
try:
	import xcursor
except ImportError:
	print "osXBar 1.0 FATAL ERROR:"
	print "Cannot load module: xcursor.so"
	print "FAQ:"
	print "- Where I can get a working xcursor.so module?"
	print "  You can get it after you have compiled superkaramba in [examples/globalMouse/xcursor.so]"
	print "- Are you using a distro and don't know how to do this?"
	print "  Try to download it from [http://www.xiaprojects.com/www/prodotti/osxbar/main.php]"
	print "- I have xcursor.so but it does not work for me"
	print "  Send email to me: stefano _@_ xiaprojects.com "
	print ""
	class MyCursor:
		def position(self):
			return 0,0
	xcursor=MyCursor()
try:
	import time
except ImportError:
	print "osXBar 1.0 FATAL ERROR:"
	print "Cannot load module: time"
	class MyTime:
		def time(self):
			os.times()[-1]
		def sleep(self, time=0):
			return
	time = MyTime()


## Objects

## osXBar :)
import osXBarEngine


## Common modules-class
theEngine=osXBarEngine.osXBarEngine()


#this is called when you widget is initialized
def initWidget(widget):
	global confosXBar
	## Setup Engine
	#karamba.stopWidgetTimer(widget)
	theEngine.Widget=widget
	theEngine.Me=theEngine
	## Init
	theEngine.Init(0)
	theEngine.Init(1)
	theEngine.Init(2)
	theEngine.Init(3)
	theEngine.Init(4)
	theEngine.Init(5)
	karamba.redrawWidgetBackground(widget)
	pass

#this is called everytime your widget is updated
#the update inverval is specified in the .theme file
def widgetUpdated(widget):
	global theEngine
	#karamba.redrawWidgetBackground(widget)
	if(theEngine.HasMoved2!=0):
		theEngine.Update()
	#else:
	#	karamba.setWidgetFaketop(widget,0)
	#	karamba.redrawWidgetBackground(widget)
	if(theEngine.Sensor.Ready!=0):
		theEngine.Sensor.Dispatch()
	#print "Sleeping: " + str(theEngine.IncrementalSleep)
	#time.sleep(theEngine.IncrementalSleep)
	pass

#This gets called everytime our widget is clicked.
#Notes:
#  widget = reference to our widget
#  x = x position (relative to our widget)
#  y = y position (relative to our widget)
#  botton = button clicked:
#                    1 = Left Mouse Button
#                    2 = Middle Mouse Button
#                    3 = Right Mouse Button, but this will never happen
#                        because the right mouse button brings up the
#                        Karamba menu.
#                    4,5 = Scroll wheel up and down
def widgetClicked(widget, x, y, button):
	theEngine.Command.DispatchClick(x,y,button)
	pass

#This gets called everytime our widget is clicked.
#Notes
#  widget = reference to our widget
#  x = x position (relative to our widget)
#  y = y position (relative to our widget)
#  botton = button being held:
#                    0 = No Mouse Button
#                    1 = Left Mouse Button
#                    2 = Middle Mouse Button
#                    3 = Right Mouse Button, but this will never happen
#                        because the right mouse button brings up the
#                        Karamba menu.
def widgetMouseMoved(widget, x, y, button):
	#Warning:  Don't do anything too intensive here
	#You don't want to run some complex piece of code everytime the mouse moves
	global theEngine
	# We have to stop any animations
	theEngine.Animator.Animating=0
	theEngine.MouseMoved(x,y,button)
	pass
def menuItemClicked(widget,Ilmenu,command):
	global theEngine
	theEngine.Command.menuItemClicked(widget,Ilmenu,command)

def menuOptionChanged(widget, key, value):
	theEngine.Options.OptionChanged(key,value)

def itemDropped(widget,IconName):
	global theEngine
	print IconName
	theEngine.DropTest=1
	theEngine.Drop=IconName

def taskAdded(widget, task):
	#return
	theEngine.TaskMgr.TaskAdded(task)
def taskRemoved(widget, task):
	#return
	theEngine.TaskMgr.TaskRemoved(task)
def activeTaskChanged(widget, task):
	#return
	theEngine.TaskMgr.TaskChanged(task)


# This will be printed when the widget loads.
print "Ready"

