#include <math.h>
#include <stdlib.h>
#include <scicos/scicos_block.h>
#ifdef MODEL
#include <devices.h>
#endif

#ifndef MODEL
#include <math.h>
#include <stdlib.h>
#include <scicos/scicos_block.h>
#endif

void o_scope_TEST(scicos_block *block,int flag)
{
#ifdef MODEL
static int port;
int i;
double u[2];
double t = get_scicos_time();
  switch(flag) {
  case 4:
    port=out_rtai_scope_init(2,"TEST");
    break;
  case 2:
    for (i=0;i<2;i++) u[i]=block->inptr[i][0];
    out_rtai_scope_output(port,u,t);
    break;
  case 5:
    out_rtai_scope_end(port);
    break;
  }
#endif
}
#include <math.h>
#include <stdlib.h>
#ifndef MODEL
#include <scicos/scicos_block.h>
#endif


#define M_PI		3.14159265358979323846

/* noiseblkv_c routine de calcul d'-bchantillons bruits par la mthode "Box Muller Law"
 *
 * Entres :
 * n    : taille des vecteurs
 * typ  : type de sortie (0:cos/1:sin)
 * sig  : vecteurs des variances
 * mean : vecteurs des moyennes
 * Sorties :
 * y    : vecteur des sorties
 *
 * dpendances
 * math.h
 */
void noiseblkv_c2(int *n,int *typ,double *sig,double *mean,double *y_i,double *y_q)
{
 /*dclaration des variables*/
 int i;
 double rand1, rand2;
 double rand_m;
 double ampl, phase;

 /*rcupration de la valeur de RAND_MAX*/
 rand_m=RAND_MAX;

 for(i=0;i<(*n);i++)
 {
  /*calcul rand1*/
  rand1=rand()/rand_m;
  /*test rand1*/
  while((rand1<=0)||(rand1>=1)) rand1=rand()/rand_m;

  /*calcul rand2*/
  rand2=rand()/rand_m;
  /*test rand2*/
  while((rand2<=0)||(rand2>=1)) rand2=rand()/rand_m;

  /*Calcul amplitude et phase*/
  ampl=sig[i]*sqrt(2*-log(rand1));
  phase=2*M_PI*rand2;

  /*Calcul y*/
  switch(*typ)
  {
   case 0 :
   {
    /*Calcul amplitude et phase*/
    ampl=sig[i]*sqrt(2*-log(rand1));
    phase=2*M_PI*rand2;
    y_i[i]=mean[i]+ampl*cos(phase);
    break;
   }

   case 1 :
   {
    /*Calcul amplitude et phase*/
    ampl=sig[i]*sqrt(2*-log(rand1));
    phase=2*M_PI*rand2;
    y_q[i]=mean[i]+ampl*sin(phase);
    break;
   }

   case 2 :
   {
    /*Calcul amplitude et phase*/
    ampl=sig[i]*sqrt(-log(rand1));
    phase=2*M_PI*rand2;
    y_i[i]=mean[i]+ampl*cos(phase);
    y_q[i]=mean[i]+ampl*sin(phase);
    break;
   }
  }
 }
 return;
}

void noiseblk2(scicos_block *block,int flag)
{
  /*Dclaration des variables*/
  double *y1;
  double *y2=NULL;
  int ny,typ;

  /*rcupration de l'adresses des ports rguliers*/
  y1=(double *)block->outptr[0];

  /*rcupre taille de sortie*/
  ny=block->outsz[0];

  /*rcupre le type de gnrateur*/
  typ=block->ipar[1];

  if(flag==6)
  {
   srand(block->ipar[0]);
  }

  else if(flag==1)
  {
   switch(typ)
   {
    case 0 :
    {
     /*Appel noiseblk_c*/
     noiseblkv_c2(&ny,&typ,&block->rpar[0],&block->rpar[ny],&y1[0],y2);
     break;
    }

    case 1 :
    {
     /*Appel noiseblk_c*/
     noiseblkv_c2(&ny,&typ,&block->rpar[0],&block->rpar[ny],y2,&y1[0]);
     break;
    }

    case 2 :
    {
     /*rcupration de l'adresse de sortie*/
     y2=(double *)block->outptr[1];
     /*Appel noiseblk_c*/
     noiseblkv_c2(&ny,&typ,&block->rpar[0],&block->rpar[ny],&y1[0],&y2[0]);
     break;
    }
   }
  }
}
#include <math.h>
#include <stdlib.h>
#ifndef MODEL
#include <scicos/scicos_block.h>
#endif


#define M_PI		3.14159265358979323846

/* noiseblkv_c routine de calcul d'-bchantillons bruits par la mthode "Box Muller Law"
 *
 * Entres :
 * n    : taille des vecteurs
 * typ  : type de sortie (0:cos/1:sin)
 * sig  : vecteurs des variances
 * mean : vecteurs des moyennes
 * Sorties :
 * y    : vecteur des sorties
 *
 * dpendances
 * math.h
 */
void noiseblkv_c(int *n,int *typ,double *sig,double *mean,double *y_i,double *y_q)
{
 /*dclaration des variables*/
 int i;
 double rand1, rand2;
 double rand_m;
 double ampl, phase;

 /*rcupration de la valeur de RAND_MAX*/
 rand_m=RAND_MAX;

 for(i=0;i<(*n);i++)
 {
  /*calcul rand1*/
  rand1=rand()/rand_m;
  /*test rand1*/
  while((rand1<=0)||(rand1>=1)) rand1=rand()/rand_m;

  /*calcul rand2*/
  rand2=rand()/rand_m;
  /*test rand2*/
  while((rand2<=0)||(rand2>=1)) rand2=rand()/rand_m;

  /*Calcul amplitude et phase*/
  ampl=sig[i]*sqrt(2*-log(rand1));
  phase=2*M_PI*rand2;

  /*Calcul y*/
  switch(*typ)
  {
   case 0 :
   {
    /*Calcul amplitude et phase*/
    ampl=sig[i]*sqrt(2*-log(rand1));
    phase=2*M_PI*rand2;
    y_i[i]=mean[i]+ampl*cos(phase);
    break;
   }

   case 1 :
   {
    /*Calcul amplitude et phase*/
    ampl=sig[i]*sqrt(2*-log(rand1));
    phase=2*M_PI*rand2;
    y_q[i]=mean[i]+ampl*sin(phase);
    break;
   }

   case 2 :
   {
    /*Calcul amplitude et phase*/
    ampl=sig[i]*sqrt(-log(rand1));
    phase=2*M_PI*rand2;
    y_i[i]=mean[i]+ampl*cos(phase);
    y_q[i]=mean[i]+ampl*sin(phase);
    break;
   }
  }
 }
 return;
}

void noiseblk(scicos_block *block,int flag)
{
  /*Dclaration des variables*/
  double *y1;
  double *y2=NULL;
  int ny,typ;

  /*rcupration de l'adresses des ports rguliers*/
  y1=(double *)block->outptr[0];

  /*rcupre taille de sortie*/
  ny=block->outsz[0];

  /*rcupre le type de gnrateur*/
  typ=block->ipar[1];

  if(flag==6)
  {
   srand(block->ipar[0]);
  }

  else if(flag==1)
  {
   switch(typ)
   {
    case 0 :
    {
     /*Appel noiseblk_c*/
     noiseblkv_c(&ny,&typ,&block->rpar[0],&block->rpar[ny],&y1[0],y2);
     break;
    }

    case 1 :
    {
     /*Appel noiseblk_c*/
     noiseblkv_c(&ny,&typ,&block->rpar[0],&block->rpar[ny],y2,&y1[0]);
     break;
    }

    case 2 :
    {
     /*rcupration de l'adresse de sortie*/
     y2=(double *)block->outptr[1];
     /*Appel noiseblk_c*/
     noiseblkv_c(&ny,&typ,&block->rpar[0],&block->rpar[ny],&y1[0],&y2[0]);
     break;
    }
   }
  }
}
#ifndef MODEL
#include <math.h>
#include <stdlib.h>
#include <scicos/scicos_block.h>
#endif

void o_mbx_ovrwr_send_FDBK(scicos_block *block,int flag)
{
#ifdef MODEL
static int port;
int i;
double u[1];
double t = get_scicos_time();
  switch(flag) {
  case 4:
    port=out_mbx_ovrwr_send_init(1,"FDBK","0");
    break;
  case 2:
    for (i=0;i<1;i++) u[i]=block->inptr[i][0];
    out_mbx_ovrwr_send_output(port,u,t);
    break;
  case 5:
    out_mbx_ovrwr_send_end(port);
    break;
  }
#endif
}
#ifndef MODEL
#include <math.h>
#include <stdlib.h>
#include <scicos/scicos_block.h>
#endif

void i_mbx_rcvif_PLANT(scicos_block *block,int flag)
{
#ifdef MODEL
static int port;
int i;
double y[2];
double t = get_scicos_time();
  switch(flag) {
  case 4:
    port=inp_mbx_receive_if_init(2,"PLANT","0");
    break;
  case 1:
    inp_mbx_receive_if_input(port,y,t);
    for (i=0;i<2;i++) block->outptr[i][0] = y[i];
    break;
  case 5:
    inp_mbx_receive_if_end(port);
    break;
  }
#endif
}
