//
// C++ Interface: %{MODULE}
//
// Description: 
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GPLUGINSDK_H
#define GPLUGINSDK_H

#include <qobject.h>
#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
#include <kpopupmenu.h>

class gPluginSDKCfgWnd;


/**
@author Stefano Zingarini
*/
class gPluginSDK : public QObject
{
Q_OBJECT
public:
    gPluginSDK(QObject *parent = 0, const char *name = 0);

    ~gPluginSDK();
protected:
	int lastValue;
	int Value;
	QObject			*xGDocker;
	QObject			*xGIcon;
	QImage			*xImgSource;
	const QDomNodeList	*xXMLIconConfig;
	QString			IconsPath;
	QString			ToolTip;
	QStringList		PluginInformations;
	KPopupMenu		*PluginPopupMenu;

public slots:
    virtual void xSetup();
    virtual void xRefreshIcon(QObject *);
    virtual void xStop();
    virtual void xStart();
    virtual void xAttach(QObject *);
    virtual void xApplyCfg();
    virtual void polling();
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xGetParameter(const QString, QString&);
    virtual void xGetInfo(QStringList &);
    virtual void xRunConfigurator();
    virtual void xEnabledClick(int &);
    virtual void xPaint(int);
    virtual void xEventClick(void *,int,int,int,int);

public:
signals:
    void cachePurge();
    void xSetSmoothZoom();
    void xDockerRedraw(QObject *);
    void xGetDocker(QObject *&);
    void xSetText(const QString &);
    void xGetImage(QImage *&);
    void xGetPluginConfiguration(const QDomNodeList *&);
    void xFindResource(const QString, QString&);
    void xGetPluginPopupMenu(KPopupMenu *&,const QObject *);

protected:
    void createXMLTree();
	gPluginSDKCfgWnd *ConfigurationWindow;
	int isStopped;
};

#endif
