/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_mounts.h"


#include <kmountpoint.h>
#include <kpopupmenu.h>
#include <kdebug.h>
#include <kdirwatch.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="xMounts";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_Mounts(parent,NOME));
}


#include "xeplugin_mounts.moc"



XEPlugin_Mounts::XEPlugin_Mounts(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xPluginAdd(this);
	KDEWatch	=new KDirWatch();
}


XEPlugin_Mounts::~XEPlugin_Mounts()
{
	XEObject::xPluginDel(this);
}

void XEPlugin_Mounts::xSetup()
{
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	// reload xml
	onClickExec="konqueror --caption \"browse %MOUNTPOINT%\" \"%MOUNTPOINT%\"";
	prefixCaption="browse ";
	// supported formats:
	// %MOUNTPOINT%
	// %DEVICE%
	// %DEVICETYPE%

	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
			{
			AutoAddMounts=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("AutoAddMounts","yes");
			onClickExec=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickExec","konqueror --caption \"browse %MOUNTPOINT%\" \"%MOUNTPOINT%\"");
			prefixCaption=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("prefixCaption","browse ");
			ExternalEntryManager=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("ExternalEntryManager","GMount");

			}
			else
			{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
			
			}
			break;
		}
	}



}


/*!
    \fn XEPlugin_Mounts::xStart()
 */
void XEPlugin_Mounts::xStart()
{
	
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (uint i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
#ifndef ENABLE_FINAL
		qWarning(DeviceMounted->mountPoint());
#endif
		
		MountAdded(DeviceMounted->mountPoint(),DeviceMounted->realDeviceName(),DeviceMounted->mountType());
		
	}
	
	KDEWatch->addFile("/etc/mtab");
	connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->startScan();
	
	
}


/*!
    \fn XEPlugin_Mounts::xStop()
 */
void XEPlugin_Mounts::xStop()
{
	disconnect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->stopScan();
}


/*!
    \fn XEPlugin_Mounts::MountAdded(const QString &)
 */
void XEPlugin_Mounts::MountAdded(const QString &newMount,const QString &device,const QString &devicetype)
{
	for(uint i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
#ifndef ENABLE_FINAL
			qWarning("Matched icon for this mountpoint");
#endif
			// searching if it's being showed
			for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
#ifndef ENABLE_FINAL
				qWarning("xeplugin_gmounts.cpp:108");
#endif
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_Mounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
#ifndef ENABLE_FINAL
				qWarning("NON e' null");
				qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->OverText);
#endif
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
#ifndef ENABLE_FINAL
			qWarning("xeplugin_gmounts.cpp:115");
#endif
		// is disabled?
		if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Info.className=="disabled")return;
	// if there are too icons, we can exit because no more will be added
	// TODO: MaxIconsShowed=0
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
			// 0.35
	XSGObjectIcon *addedCfg=Configurator->iconAdd();

	int autoAddSeparator=1;

			if(autoAddSeparator)
			{
				XSGObjectIcon *iP=ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1);
				QString cn=iP->Info.className;
				if(!cn.startsWith("x") && cn!="GSeparator" && iP->TimeToLive==0)
					{
						XSGObjectIcon *addedSpace=Configurator->iconAddSeparator();
						ActiveConfiguration->ObjectsIcons.append(addedSpace);
						xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
					}
			}


//			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;

			addedCfg->Tasks.Proces.clear();
			addedCfg->Actions.iAnimationMask=0;
			addedCfg->Tasks.TaskInfo=NULL;

			//addedCfg->Info.className=name();
			if(ExternalEntryManager!="")addedCfg->Info.className=ExternalEntryManager;
			else addedCfg->Info.className="xGMounts";
			// 0.39

			addedCfg->TimeToLive=-1;
			addedCfg->Tasks.MiniTextShow=2;
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;
			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
			return;
		}
	}

	// 0.34
	// check if we like to auto attach
	if(AutoAddMounts!="no")
	{
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
	//if(device=="udev")return;
	//if(newMount=="/dev")return;
	if(devicetype=="sysfs")return;
	else if(devicetype=="autofs")return;
	else if(devicetype=="tmpfs")return;
	else if(devicetype=="usbfs")return;
	else if(devicetype=="nfsd")return;
	else if(devicetype=="rpc_pipefs")return;
	else if(devicetype=="proc")return;
	else if(devicetype=="procfs")return;
	else if(devicetype=="devpts")return;
	else if(devicetype=="binfmt_misc")return;
			//XSGObjectIcon *addedCfg=new XSGObjectIcon;
			// 0.35
	XSGObjectIcon *addedCfg=Configurator->iconAdd();

			
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			//ActiveConfiguration->ObjectsIcons.append(addedCfg);
			//ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=newMount;
			addedCfg->Info.fileName=newMount;
			addedCfg->Info.Name=newMount;
			addedCfg->Info.Group=newMount;
			//addedCfg->Info.className="xMounts";
			
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.MiniTextShow=2;
			addedCfg->Actions.iAnimationMask=0;
			addedCfg->Tasks.ShowThumbnail=0;
			// alias time
			addedCfg->TimeToLive=0;
			addedCfg->Tasks.TaskInfo=NULL;
			//addedCfg->Tasks.TaskName=newMount;
			//addedCfg->Tasks.WindowTitle=newMount;
			if(devicetype=="")addedCfg->Images.imgFileName="hdd_mount";
			else addedCfg->Images.imgFileName=QString("mount_%1").arg(devicetype);
			//addedCfg->Actions.onClickExec=QString("konqueror %1").arg(newMount);
			// 0.37 0.38
			addedCfg->Actions.onClickExec=onClickExec;
			//addedCfg->Actions.onClickExec=onClickExec
			//		.replace("%MOUNTPOINT%",newMount);
			addedCfg->Actions.onClickExec=addedCfg->Actions.onClickExec.replace("%MOUNTPOINT%",newMount);
					//.replace("%DEVICE%",newMount)


			XSCfgMatchIcons *addedCfgMatch=new XSCfgMatchIcons;
			//XSGObjectIcon *addedCfg2=new XSGObjectIcon;
			//addedCfg2=addedCfg;
			//addedCfg2->OverText="pippo";
			//addedCfg2->Info.className="GMounts";
			addedCfg->Info.className="GMounts";
			addedCfgMatch->Icon=addedCfg;
			addedCfgMatch->SystemName=newMount;
			addedCfg->Tasks.WindowTitle=QString("%1%1").arg(prefixCaption).arg(newMount);

			ActiveConfiguration->Plugins.Matches.append(addedCfgMatch);
			// 0.35
			MountAdded(newMount,device,devicetype);
//			ActiveConfiguration->ObjectsIcons.count()++;
			//xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
			return;
	}
}


/*!
    \fn XEPlugin_Mounts::dirty(const QString &)
 */
void XEPlugin_Mounts::dirty(const QString &)
{
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (uint i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
//		qWarning(DeviceMounted->mountPoint());

		MountAdded(DeviceMounted->mountPoint(),DeviceMounted->realDeviceName(),DeviceMounted->mountType());
		
	}
	// ok now removing the old one
	int indexfind;
	int checkSeparators=0;

	for(int iconIndex=(int)ActiveConfiguration->ObjectsIcons.count()-1;iconIndex>=0;iconIndex--)
	{
/*
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==name())
		{
*/
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==name()
||(ExternalEntryManager!="" && ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==ExternalEntryManager
&&ActiveConfiguration->ObjectsIcons.at(iconIndex)->TimeToLive==-1))
		{

			indexfind=-1;
			for (uint i=0;i<devList.count();i++)
			{
				DeviceMounted=devList[i];
				if(DeviceMounted==NULL)break;
				
if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==DeviceMounted->mountPoint()){
					indexfind=i;
					break;
				}
			}
			if(indexfind<0)
			{
				// remove it
				Configurator->xEventInRemovingIcon(iconIndex,0);
				checkSeparators++;

			}
		}
	}

	if(checkSeparators)xGDocker->xCheckBackgroundSeparators();

	
}


/*!
    \fn XEPlugin_Mounts::xGetParameter(const QString,QString&)
 */
void XEPlugin_Mounts::xGetParameter(const QString vname,QString& vvalue)
{
	if(vname=="AutoAddMounts")vvalue=(AutoAddMounts);
	if(vname=="onClickExec")vvalue=(onClickExec);
	if(vname=="prefixCaption")vvalue=(prefixCaption);
	if(vname=="ExternalEntryManager")vvalue=(ExternalEntryManager);
}


/*!
    \fn XEPlugin_Mounts::xGetParameterList(QStringList*)
 */
void XEPlugin_Mounts::xGetParameterList(QStringList* a)
{
	a->append("AutoAddMounts");
	a->append("onClickExec");
	a->append("prefixCaption");
	a->append("ExternalEntryManager");

}


/*!
    \fn XEPlugin_Mounts::xGetInfo(QStringList &)
 */
void XEPlugin_Mounts::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version=KXDOCKERVERSION;
	Version=Version+"-1.0.0";
	PluginInformations.append("KXDocker GMounts");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append(KXDOCKERDATE); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	
	a=PluginInformations;

}


/*!
    \fn XEPlugin_Mounts::xSetupParameter(const QString, const QString)
 */
void XEPlugin_Mounts::xSetupParameter(const QString sName, const QString sValue)
{
/*
	bool okRet=false;
	if(sName=="desktopPreview")
	{
		desktopPreview=sValue.toInt(&okRet);
		if(okRet==false)
		{
			desktopPreview=0;
		}
	}
*/
	if(sName=="ExternalEntryManager")
	{
		ExternalEntryManager=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("ExternalEntryManager",ExternalEntryManager);
			}
		}	
	}

	if(sName=="AutoAddMounts")
	{
		AutoAddMounts=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("AutoAddMounts",AutoAddMounts);
			}
		}	
	}
	if(sName=="prefixCaption")
	{
		prefixCaption=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("prefixCaption",prefixCaption);
			}
		}	
	}
	if(sName=="onClickExec")
	{
		onClickExec=sValue;
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
			{
			// update xml configuration
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("onClickExec",onClickExec);
			}
		}
	}
}

