/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wmconfiguationwindow.h"

#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>


WMConfigurationWindow::WMConfigurationWindow(QObject *parent, const char *name)
 : GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));
}


WMConfigurationWindow::~WMConfigurationWindow()
{
}

void WMConfigurationWindow::pOK_clicked()
{

	xApplyParameter("themepath",ThemePath->text());
	xApplyParameter("cpuname",mPName->currentText());
	QString stringa;
	stringa.setNum(GaugeInfo0->currentItem());
	xApplyParameter("GaugeInfo0",stringa);
	stringa.setNum(GaugeInfo1->currentItem());
	xApplyParameter("GaugeInfo1",stringa);
	stringa.setNum(GaugeInfo2->currentItem());
	xApplyParameter("GaugeInfo2",stringa);

	stringa.setNum(GaugeInfo1min->value());
	xApplyParameter("GaugeInfo1min",stringa);
	stringa.setNum(GaugeInfo2min->value());
	xApplyParameter("GaugeInfo2min",stringa);

	stringa.setNum(GaugeInfo1max->value());
	xApplyParameter("GaugeInfo1max",stringa);
	stringa.setNum(GaugeInfo2max->value());
	xApplyParameter("GaugeInfo2max",stringa);

	hide();
}

void WMConfigurationWindow::xSetupParameter(QString vname,QString vvalue)
{
	bool okRet=false;
	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	if(vname=="cpuname")
	{
		mPName->setCurrentText(vvalue);
	}
	if(vname=="GaugeInfo0")
	{
		GaugeInfo0->setCurrentItem(vvalue.toInt(&okRet));
	}
	if(vname=="GaugeInfo1")
	{
		GaugeInfo1->setCurrentItem(vvalue.toInt(&okRet));
	}
	if(vname=="GaugeInfo2")
	{
		GaugeInfo2->setCurrentItem(vvalue.toInt(&okRet));
	}
	if(vname=="GaugeInfo1min")
	{
		GaugeInfo1min->setValue(vvalue.toInt(&okRet));
		if(!okRet)GaugeInfo2min->setValue(0);
	}
	if(vname=="GaugeInfo2min")
	{
		GaugeInfo2min->setValue(vvalue.toInt(&okRet));
		if(!okRet)GaugeInfo2min->setValue(0);
	}
	if(vname=="GaugeInfo1max")
	{
		GaugeInfo1max->setValue(vvalue.toInt(&okRet));
		if(!okRet)GaugeInfo2max->setValue(100);
	}
	if(vname=="GaugeInfo2max")
	{
		GaugeInfo2max->setValue(vvalue.toInt(&okRet));
		if(!okRet)GaugeInfo2max->setValue(100);
	}
}
void WMConfigurationWindow::pBrowseTheme_clicked()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	ThemePath->setText(cfgPath);
}

#include "wmconfiguationwindow.moc"
