/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gdate.h"
#include "xeplugin_gdate.moc"

#include <wmconfigurationwindow.h>


#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>
#include <string.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <krun.h>
#include <qtimer.h>
#include <qdatetime.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	return new GDate(parent,"GDate");
}



GDate::GDate(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{

	/* Standard plugin information since kxdocker 0.29 */
	QString Version="1.0.0";
	// Project name
	PluginInformations.append("KXDocker GDate");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20060128");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gdate");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gdate");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	IconsPath="kxdocker/plugins/gdate/";
	iMiniText=1;
	ita=1;
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);

}

GDate::~GDate()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

QObject *   GDate::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GDate(p,"GDate");
}

void GDate::xSetupParameter(const QString vname, const QString vvalue)
{

	if(vname=="themepath")
	{
		IconsPath=vvalue;
	}
	bool okRet=false;
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;
		ToolTip2="";
	}
	if(vname=="italian")
	{
		ita=vvalue.toInt(&okRet);
		if(okRet==false)ita=1;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{

		xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		xXMLIconConfig->item(0).toElement().setAttribute("italian",ita);

	}
	else
	{
		createXMLTree();
	}
	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(IconsPath);
	lastValue=-1;
	xRefreshIcon(xGIcon);
}

void GDate::xGetParameter(const QString vname, QString&vvalue)
{

	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	if(vname=="italian")
	{
		vvalue.setNum(ita);
	}
	gPluginSDK::xGetParameter(vname, vvalue);

}
void GDate::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("minitext");
	a->append("italian");

	gPluginSDK::xGetParameterList(a);
}


void GDate::xPaint(int)
{
	ToolTip=QString("%1 %1 %1 %1").arg(QDate::shortDayName(QDate::currentDate().dayOfWeek ())).arg(QDate::currentDate().day()).arg(QDate::longMonthName (QDate::currentDate().month())).arg(QDate::currentDate().year());

	if(iMiniText>0)ToolTip2="";
	char filename[10];
	switch(iMiniText)
	{
		case 1:
			ToolTip2=QDate::shortDayName(QDate::currentDate().dayOfWeek ());
		break;
		case 2:
			ToolTip2=QDate::longDayName(QDate::currentDate().dayOfWeek ());
		break;
		case 3:
			if(ita==0)sprintf(filename,"%02d/%02d/%04d",QDate::currentDate().month(),QDate::currentDate().day(),QDate::currentDate().year());
			else sprintf(filename,"%02d/%02d/%04d",QDate::currentDate().day(),QDate::currentDate().month(),QDate::currentDate().year());
			ToolTip2=filename;
		break;
		case 4:
			if(ita==0)sprintf(filename,"%d-%02d",QDate::currentDate().month(),QDate::currentDate().day());
			else sprintf(filename,"%d-%02d",QDate::currentDate().day(),QDate::currentDate().month());
			ToolTip2=filename;
		break;
		case 5:
			ToolTip2=QDate::currentDate().day();
		break;
		case 6:
			ToolTip2=QDate::currentDate().month();
		break;
	}

	*xImgSource=bufferImage;
	
}


void GDate::polling()
{

	if(isStopped){
		qWarning("void GDate::polling() exiting...");
		return;
	}
	oldPaint();
	Value++;
	xRefreshIcon(xGIcon);

	QTimer::singleShot(1000+ 60*1000*(60-QTime::currentTime().minute()), this, SLOT(polling()) );
	//QTimer::singleShot(10000, this, SLOT(polling()));
}


void GDate::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{

		IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gdate/");
		if(IconsPath=="")IconsPath="kxdocker/plugins/gdate/";
		QString vvalue=xXMLIconConfig->item(0).toElement().attribute("minitext","1");
		bool okRet=false;
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;
		vvalue=xXMLIconConfig->item(0).toElement().attribute("ita","1");
		ita=vvalue.toInt(&okRet);
		if(okRet==false)ita=1;
	}
	Original=*xImgSource;
	// to enable the first pass
	lastValue=-1;
	// update the resources
	loadResources(IconsPath);
}


void GDate::xStop()
{

	gPluginSDK::xStop();

}


void GDate::xStart()
{
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new WMConfigurationWindow(this);
	}

	gPluginSDK::xStart();
}


void GDate::loadResources(const QString)
{
	oldPaint();
}

/*!
    \fn GDate::oldPaint()
 */
void GDate::oldPaint()
{

	//qWarning("void GDate::oldPaint()");

	QString pngPath;
	QString pngsPath;
	QFile a;

	pngPath=IconsPath+"/gdate.png";
	pngPath=::locate("data",pngPath);
	a.setName(pngPath);

	if(!a.exists() || pngPath==QString::null)
	{
		pngPath="kxdocker/plugins/gdate/gdate.png";
		pngsPath="kxdocker/plugins/gdate/";
	}
	else
	{
		pngsPath=IconsPath+"/";
	}
	//qWarning(pngsPath);
	
	char filename[20];
	sprintf(filename,"%02d_%02d.png",QDate::currentDate().month(),QDate::currentDate().day());
	pngPath=pngsPath;
	pngPath=pngPath+filename;
	pngPath=::locate("data",pngPath);
	a.setName(pngPath);
	//qWarning(pngPath);
	//qWarning(filename);

	if(!a.exists() || pngPath==QString::null)
	{
	}
	else
	{
		// old style 1 png for every day
		bufferImage.load(pngPath);
		return;
	}

	int riempito=0;
	// this will help to auto create transparency
	strcpy(filename,"gdate.png");
	pngPath=pngsPath;
	pngPath=pngPath+filename;
	pngPath=::locate("data",pngPath);
	a.setName(pngPath);
	// loading background
	if(!a.exists() || pngPath==QString::null)
	{
		QImage TBuffer;
		TBuffer.create(
			SizeBig,
			SizeBig,
			32);
		
		TBuffer.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		//px.convertFromImage(TBuffer);
		bufferImage=TBuffer;
	}
	else
	{
		riempito++;
		bufferImage.load(pngPath);
	}
	
	// loading day
	sprintf(filename,"%02dd.png",QDate::currentDate().day());
	pngPath=pngsPath;
	pngPath=pngPath+filename;
	pngPath=::locate("data",pngPath);
	a.setName(pngPath);
	if(!a.exists() || pngPath==QString::null)
	{
	}
	else
	{
		riempito++;
		bufferDay.load(pngPath);
		bitBlt(&bufferImage,0,0,&bufferDay,0,Qt::CopyROP);
	}


	// loading month
	sprintf(filename,"%02dm.png",QDate::currentDate().month());
	pngPath=pngsPath;
	pngPath=pngPath+filename;
	pngPath=::locate("data",pngPath);
	a.setName(pngPath);
	if(!a.exists() || pngPath==QString::null)
	{
	}
	else
	{
		riempito++;
		bufferDay.load(pngPath);
		bitBlt(&bufferImage,0,0,&bufferDay,0,Qt::CopyROP);
	}


	// loading week
	sprintf(filename,"%02dw.png",QDate::currentDate().dayOfWeek ());
	pngPath=pngsPath;
	pngPath=pngPath+filename;
	pngPath=::locate("data",pngPath);
	a.setName(pngPath);
	if(!a.exists() || pngPath==QString::null)
	{
	}
	else
	{
		riempito++;
		bufferDay.load(pngPath);
		bitBlt(&bufferImage,0,0,&bufferDay,0,Qt::CopyROP);
	}

	// the sun is not copyed because the theme may not support it
	/*
	sprintf(filename,"%02dh.png",QTime::currentTime().hour());
	sprintf(filename,"%02dhm.png",QTime::currentTime().minute());
	}
	*/

	if(!riempito)
	{
		pngsPath="kxdocker/themes/gdate/";
		sprintf(filename,"%02d_%02d.png",QDate::currentDate().month(),QDate::currentDate().day());
		pngPath=pngsPath;
		pngPath=pngPath+filename;
		pngPath=::locate("data",pngPath);
		a.setName(pngPath);
	
		if(!a.exists() || pngPath==QString::null)
		{
			bufferImage=Original;
		}
		else
		{
			// old style 1 png for every day
			bufferImage.load(pngPath);
			//qWarning("bufferImage.load(pngPath);");
			return;
		}
	}
}

