/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gcpu.h"
#include "xeplugin_gcpu.moc"
#include <wmconfigurationwindow.h>


#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kglobalsettings.h>
#include <klocale.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	//qWarning("GCpu xeplugin_register()");
	return new GCpu(parent,"GCpu");
}


GCpu::GCpu(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="CPU Usage Meter";


	// compatibility with 0.29
	QString Version="1.0.0";
	PluginInformations.append("KXDocker GCpu");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20060129"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gcpu");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gcpu");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update


#ifdef Q_OS_LINUX
  m_procStream = 0L;
  if ((m_procFile = fopen("/proc/stat", "r")))
    m_procStream = new QTextStream(m_procFile, IO_ReadOnly);
#endif
	IconsPath="kxdocker/plugins/gcpu/";
	PollingRate=1000;

	iMiniText=1;
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);

}



GCpu::~GCpu()
{
	delete m_procStream;

	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

QObject *   GCpu::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GCpu(p,"GCpu");
}



/*!
    \fn GCpu::xGetParameterList(QStringList *a)
 */
void GCpu::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("polling");
	a->append("minitext");
	a->append("dotpitch");
	a->append("drawdirection");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}






/*!
    \fn GCpu::xGetParameter(const QString vname, QString&vvalue)
 */
void GCpu::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}
	if(vname=="polling")
	{
		vvalue.setNum(PollingRate);
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	if(vname=="dotpitch")
	{
		vvalue.setNum(dotPitch);
	}
	if(vname=="drawdirection")
	{
		vvalue.setNum(drawDirection);
	}


	gPluginSDK::xGetParameter(vname,vvalue);
}

#include <kdebug.h>

void GCpu::xSetupParameter(const QString vname, const QString vvalue)
{
	kdWarning()<<QString("xSetupParameter(%1,%1)\n").arg(vname).arg(vvalue);
	if(vname=="themepath")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(IconsPath=="")IconsPath="kxdocker/plugins/gcpu/";
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		}
		// done in 0.4
		//lastValue=-1;
		loadResources(IconsPath);
		//xRefreshIcon(xGIcon);
	}



	bool okRet=false;
	if(vname=="polling")
	{
		PollingRate=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			PollingRate=1000;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("polling",PollingRate);
		}
	}
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}

	if(vname=="drawdirection")
	{
		drawDirection=vvalue.toInt(&okRet);
		if(okRet==false)drawDirection=0;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("drawdirection",vvalue);
		}
		xRefreshIcon(xGIcon);
	}


	if(vname=="dotpitch")
	{
		dotPitch=vvalue.toInt(&okRet);
		if(okRet==false)dotPitch=0;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("dotpitch",vvalue);
		}
		xRefreshIcon(xGIcon);
	}
	gPluginSDK::xSetupParameter(vname,vvalue);
}

void GCpu::xStart()
{
	//0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new WMConfigurationWindow(this);
	}

	gPluginSDK::xStart();
}


void GCpu::xStop()
{
	gPluginSDK::xStop();
}


void GCpu::polling()
{
	if(isStopped){
		return;
	}

	//qWarning("CPU0 Status:");
	CpuData cpuData;
	int cpuNumber=0;
	updateCpu(cpuData,cpuNumber);
	
	/*
	qWarning(QString("name: [%1] user: [%1] nice: [%1] sys: [%1] idle: [%1]")
		.arg(cpuData.name)
		.arg(cpuData.user)
		.arg(cpuData.nice)
		.arg(cpuData.sys)
		.arg(cpuData.idle)
		);
	*/	
	int cpuDiff = 0;
	current.setData(cpuData);
	cpuData -= current.oldData();
	cpuDiff = cpuData.sys + cpuData.user + cpuData.nice;
	//cpuDiff = cpuData.user;
	if (cpuDiff > 100)
		cpuDiff = 100;
	Value=cpuDiff;
	QTimer::singleShot( PollingRate, this, SLOT(polling()));
	xRefreshIcon(xGIcon);

}


void GCpu::xPaint(int nPercentage)
{
	ToolTip=QString("CPU0: %1%").arg(nPercentage);
	if(iMiniText==1)
	{
		if(nPercentage>0)ToolTip2=QString("%1%").arg(nPercentage);
		else ToolTip2="";
	}

	//imgBuffer=imgTrans.copy();
	imgBuffer=imgBackground.copy();
	imgOffscreen2=imgOffscreen.copy();
	imgOffscreen=imgTrans.copy();
	int h=imgOffscreen.height();
	// shift
	int xStartDirection;
	if(drawDirection>0)
	{
		bitBlt(&imgOffscreen,14,14,&imgOffscreen2,15,14,imgOffscreen.width()-1-14-14,h-14,Qt::CopyROP);
		xStartDirection=h-1-14;
	}
	else 
	{
		xStartDirection=14;
		bitBlt(&imgOffscreen,15,14,&imgOffscreen2,14,14,imgOffscreen.width()-1-14-14,h-14,Qt::CopyROP);
	}
//	if(drawSum){
		// draw line or dot
		if(dotPitch>0)bitBlt(&imgOffscreen,xStartDirection,14+100-nPercentage,&imgLine,0,100-nPercentage,imgLine.width(),dotPitch,Qt::CopyROP);
		else bitBlt(&imgOffscreen,xStartDirection,14+100-nPercentage,&imgLine,0,100-nPercentage,imgLine.width(),nPercentage,Qt::CopyROP);
//	}

	bitBlt(&imgBuffer,0,0,&imgOffscreen,0,0,imgOffscreen.width(),h,Qt::CopyROP);
	
	*xImgSource=imgBuffer;

}


/*!
    \fn GCpu::xApplyCfg()
 */
void GCpu::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker");
			QString sMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1");

			bool okRet=false;
			iMiniText=sMiniText.toInt(&okRet);
			if(okRet==false)iMiniText=1;
			dotPitch=xXMLIconConfig->item(0).toElement().attribute("dotpitch","0").toInt(&okRet);
			if(okRet==false)dotPitch=0;

			drawDirection=xXMLIconConfig->item(0).toElement().attribute("drawdirection","0").toInt(&okRet);
			if(okRet==false)drawDirection=0;

	}
//	BasePixmap.convertFromImage(*xImgSource);
	this->imgOriginal=*xImgSource;
	loadResources(IconsPath);
	lastValue=-1;
}



/*!
    \fn GCpu::updateCpu(CpuData &cpu, int cpuNumber)
 */
void GCpu::updateCpu(CpuData &cpu, int cpuNumber)
{
#ifdef Q_OS_LINUX
  if (!m_procStream)
    return;

  bool cpuFound = false;
  QString output;
  QString parser;
  QString cpuString;
  cpuString.setNum(cpuNumber).prepend("cpu");

  // Parse the proc file
  while (!m_procStream->atEnd()) {
    parser = m_procStream->readLine();
    // remove all the entries apart from the line containing 'cpuString'
    if (!cpuFound && parser.find(QRegExp(cpuString)) != -1) {
      output = parser;
      cpuFound = true;
    }
  }

  QStringList cpuList = QStringList::split(' ', output);

  if (!cpuList.isEmpty()) {
    cpu.name = cpuList[0].stripWhiteSpace();
    cpu.user = cpuList[1].toULong();
    cpu.nice = cpuList[2].toULong();
    cpu.sys = cpuList[3].toULong();
    cpu.idle = cpuList[4].toULong();
  }

  fseek(m_procFile, 0L, SEEK_SET);
#endif

#ifdef Q_OS_FREEBSD
#warning "add support for SMP on FreeBSD"
  static int name2oid[2] = { 0, 3 };
  static int oidCpuTime[CTL_MAXNAME + 2];
  static size_t oidCpuTimeLen = sizeof(oidCpuTime);
  long cpuTime[CPUSTATES];
  size_t cpuTimeLen = sizeof(cpuTime);
  static char *name = "kern.cp_time";
  static int initialized = 0;

  if (!initialized) {
    if (sysctl(name2oid, 2, oidCpuTime, &oidCpuTimeLen,
       name, strlen(name)) < 0)
      return;

    oidCpuTimeLen /= sizeof(int);
    initialized = 1;
  }

  if (sysctl(oidCpuTime, oidCpuTimeLen,
     cpuTime, &cpuTimeLen, 0, 0) < 0)
    return;

  cpu.user = cpuTime[CP_USER];
  cpu.nice = cpuTime[CP_NICE];
  cpu.sys = cpuTime[CP_SYS];
  cpu.idle = cpuTime[CP_IDLE];
#endif

#if defined(Q_OS_OPENBSD) || defined(Q_OS_NETBSD)
#warning "add support for SMP on OpenBSD and NetBSD"
  int name2oid[2] = { CTL_KERN, KERN_CPTIME };
  long cpuTime[CPUSTATES];
  unsigned int cpuTimeLen = sizeof(cpuTime);

  if (sysctl(name2oid, 2, &cpuTime, &cpuTimeLen,
     0, 0) < 0)
    return;

  cpu.user = cpuTime[CP_USER];
  cpu.nice = cpuTime[CP_NICE];
  cpu.sys = cpuTime[CP_SYS];
  cpu.idle = cpuTime[CP_IDLE];
#endif
}


/*!
    \fn GCpu::loadResources(const QString &)
 */
void GCpu::loadResources(const QString &newPath)
{

	//**********************************************************
	QString fbackground;
	QString ClockPaths;
	QFile a;


	fbackground="line.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gcpu/";
		ClockPaths=ClockPaths+fbackground;
	}

	imgLine.load(::locate("data",ClockPaths));


	fbackground="background.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gcpu/";
		ClockPaths=ClockPaths+fbackground;
	}

	imgBackground.load(::locate("data",ClockPaths));

	if(imgBackground.width()>1)imgTrans.create(imgBackground.width(),imgBackground.height(),32);
	else {
		imgTrans.create(128,128,32);
	}
	imgTrans.setAlphaBuffer(false);
	imgTrans.fill(0);
	imgTrans.setAlphaBuffer(true);

	if(imgBackground.width()<2)imgBackground=imgTrans.copy();

	imgOffscreen=imgTrans.copy();
	imgOffscreen2=imgTrans.copy();
}
