/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gamarok.h"
#include "xeplugin_iconconfigurationwindow.h"


#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>
#include <klocale.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>

extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("XEPlugin_GAmarok xeplugin_register()");
	return new XEPlugin_GAmarok(parent,"GAmarok");
}


#include "xeplugin_gamarok.moc"



XEPlugin_GAmarok::XEPlugin_GAmarok(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
    themepath="kxdocker/plugins/gamarok/default/";
    
	/* Standard plugin information since kxdocker 0.29 */
	QString Version="1.0.0";
	// Project name
	PluginInformations.append("KXDocker GAmarok");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20060116");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gamarok");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gamarok");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	//IconSize=128;

	client= new DCOPClient();
	client->attach();
	defaultBackground="amarok";
	Title=i18n("Not playing");
	lastTitle="";
	//Painter=new gPluginPainter(0,"current",DRAW_GaugeVert2);
	//Painter->setRect(QRect(1,0,IconSize,IconSize));
		theme_xalbum=22;
		theme_yalbum=7;
		theme_zalbum=96;
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);
}

XEPlugin_GAmarok::~XEPlugin_GAmarok()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

void XEPlugin_GAmarok::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		themepath=vvalue;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
	}
	else
	{
		createXMLTree();
	}

	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(themepath);
}

void XEPlugin_GAmarok::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void XEPlugin_GAmarok::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
}


void XEPlugin_GAmarok::xPaint(int)
{
	if(lastTitle!="")ToolTip=lastTitle;
	else ToolTip=i18n("Not playing");
	/*
	if(newValue)
	{
		Painter->setValue(QString("%1").arg(newValue));
		Painter->paint(&lastImage);
 	}
	*/
	*xImgSource=lastImage;//.convertToImage();
}


void XEPlugin_GAmarok::polling()
{
/*
	Value++;
	xRefreshIcon(xGIcon);
	QTimer::singleShot(1000, this, SLOT(polling()));
*/

	if(isStopped){
		qWarning("void XEPlugin_GAmarok::polling exiting...");
		return;
	}

	QString AlbumImage;
	getAlbumImage(AlbumImage);
	getTitle(Title);
	//qWarning(AlbumImage);
	dirty(AlbumImage);
	QTimer::singleShot(5000, this, SLOT(polling()));
}


void XEPlugin_GAmarok::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gamarok/default/");
	}

	Original=xImgSource->copy();
	loadResources(themepath);
	// to enable the first pass
	lastValue=-1;
	//dirty("");
}


void XEPlugin_GAmarok::dirty(const QString &AlbumImage)
{

	if(isStopped){
		return;
	}
	
	int percent=getPlayPercentage();
	if(AlbumImage==lastAlbumImage && Title==lastTitle && percent==Value)return;
	//Value++;
	lastValue=-1;
	//qWarning(QString("Totale: %1 %1").arg(percent).arg(AlbumImage));
	//Value=getPlayPercentage();
	Value=percent;
	setAlbum(AlbumImage);
	lastAlbumImage=AlbumImage;
	lastTitle=Title;

	// apply the background image
	//lastImage=background;
	
	// 
	
	xRefreshIcon(xGIcon);
}


void XEPlugin_GAmarok::xStop()
{
	gPluginSDK::xStop();

}


void XEPlugin_GAmarok::xStart()
{
	gPluginSDK::xStart();
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new XEPlugin_IconConfigurationWindow(this);
	}

}


void XEPlugin_GAmarok::loadResources(const QString newPath)
{
	//**********************************************************
	// path where to find images

	QString ClockPaths;
	QFile a;


	ClockPaths=newPath;
	QString xmlName="theme.xml";
	ClockPaths=ClockPaths+"/"+xmlName;
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gamarok/default/";
		ClockPaths=ClockPaths+xmlName;
	}
	//qWarning(ClockPaths);
	//qWarning(::locate("data",ClockPaths));
	loadThemeScheme(::locate("data",ClockPaths));

	/*******************************************************/
	QString fminiPlay="play.png";
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+fminiPlay;
	// check if it exists
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gamarok/default/";
		ClockPaths=ClockPaths+fminiPlay;
	}
	
	miniPlay.load(::locate("data",ClockPaths));

	/*******************************************************/
	fminiPlay="background.png";
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+fminiPlay;
	// check if it exists
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gamarok/default/";
		ClockPaths=ClockPaths+fminiPlay;
	}
	
	background.load(::locate("data",ClockPaths));

	/*******************************************************/
	a.setName(ClockPaths);
	ClockPaths=newPath;
	QString FanV=theme_gaugefilename;
	ClockPaths=ClockPaths+"/"+FanV;
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gamarok/default/";
		ClockPaths=ClockPaths+FanV;
	}
	//Painter->load(::locate("data",ClockPaths));
	gaugeFilled.load(::locate("data",ClockPaths));
/*
	qWarning(QString("xml=%1 type=%1 gauge=%1")
		.arg(::locate("data",ClockPaths))
		.arg(theme_gaugetype)
		.arg(theme_gaugefilename)
		);
*/
	/*
	if(lastImage.isNull())
	{
		lastImage.create(1,1,32);
		lastImage.setAlphaBuffer(false);
		lastImage.fill(0);
		lastImage.setAlphaBuffer(true);
	}
	*/
	if(background.isNull())
	{
		background.create(1,1,32);
		background.setAlphaBuffer(false);
		background.fill(0);
		background.setAlphaBuffer(true);
	}
	if(gaugeFilled.isNull())
	{
		gaugeFilled.create(1,1,32);
		gaugeFilled.setAlphaBuffer(false);
		gaugeFilled.fill(0);
		gaugeFilled.setAlphaBuffer(true);
	}
	if(miniPlay.isNull())
	{
		miniPlay.create(1,1,32);
		miniPlay.setAlphaBuffer(false);
		miniPlay.fill(0);
		miniPlay.setAlphaBuffer(true);
	}
	if(Album.isNull())
	{
		Album.create(1,1,32);
		Album.setAlphaBuffer(false);
		Album.fill(0);
		Album.setAlphaBuffer(true);
	}
}


/*!
    \fn XEPlugin_GAmarok::setAlbum(const QString)
 */
void XEPlugin_GAmarok::setAlbum(const QString filename)
{
	//qWarning(filename);
	if(filename=="")
	{
		//qWarning("resetto");
		lastImage=Original.copy();
	}
	else
	{
		// background skin
		lastImage=background.copy();
		if(lastAlbumImage!=filename)
		{
			//qWarning("carico");
			Album.load(filename);
			Album=Album.smoothScale(theme_zalbum,theme_zalbum,QImage::ScaleMax);
		}
		bitBlt(&lastImage,theme_xalbum,theme_yalbum,&Album,0,0,theme_zalbum,theme_zalbum,Qt::CopyROP);

		if(Value)
		{
			int iTemp=int(double(double(gaugeFilled.height())/double(100))*double(Value));
			if(theme_gaugetype==1)
			{
				bitBlt(&lastImage,
						0,0+gaugeFilled.height()-iTemp,
						&gaugeFilled,
						0,gaugeFilled.height()-iTemp,
						gaugeFilled.width(),iTemp,
						Qt::CopyROP);
			}
			else
			{
				bitBlt(&lastImage,
						0,0,
						&gaugeFilled,
						0,0,
						iTemp,gaugeFilled.height(),
						Qt::CopyROP);
			}
			bitBlt(&lastImage,0,0,&miniPlay,0,0,miniPlay.width(),miniPlay.height(),Qt::CopyROP);
		}
		else
		{
			//bitBlt(&lastImage,0,0,&miniPause,0,0,Qt::CopyROP);
		}
	}

}


/*!
    \fn XEPlugin_GAmarok::getAlbumImage(QString &)
 */
void XEPlugin_GAmarok::getAlbumImage(QString &a)
{
	a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "coverImage()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
				
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}
}


/*!
    \fn XEPlugin_GAmarok::getTitle(QString &)
 */
void XEPlugin_GAmarok::getTitle(QString &a)
{
	a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "nowPlaying()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
				
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}
}


/*!
    \fn XEPlugin_GAmarok::getTotalTime()
 */
int XEPlugin_GAmarok::getTotalTime()
{
	QString a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "totalTime()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
					
					// ok than the format is
					// Minutes:Seconds
					int seconds=0;
					bool f=0;
					QStringList seekable;
					seekable=seekable.split(":",a);
					for(uint i=0;i<seekable.count();i++)
					{
						seconds=seconds*60;
						seconds=seconds+seekable[i].toInt(&f);
					}
					return seconds;
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}

	return 0;
}


/*!
    \fn XEPlugin_GAmarok::getCurrentTime()
 */
int XEPlugin_GAmarok::getCurrentTime()
{
	QString a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "currentTime()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
					
					// ok than the format is
					// Minutes:Seconds
					int seconds=0;
					bool f=0;
					QStringList seekable;
					seekable=seekable.split(":",a);
					for(uint i=0;i<seekable.count();i++)
					{
						seconds=seconds*60;
						seconds=seconds+seekable[i].toInt(&f);
					}
					return seconds;
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}

	return 0;
}


/*!
    \fn XEPlugin_GAmarok::getPlayPercentage()
 */
int XEPlugin_GAmarok::getPlayPercentage()
{
	int totale=getTotalTime();
	int attuale=getCurrentTime();

	if(totale>0)return 100-(totale-attuale)*100/totale;
	return 0;
}


/*!
    \fn XEPlugin_GAmarok::loadThemeScheme(const QString &)
 */
void XEPlugin_GAmarok::loadThemeScheme(const QString &XMLConf)
{
	if(XMLConf=="")
	{

		theme_xalbum=22;
		theme_yalbum=7;
		theme_zalbum=96;
		theme_gaugetype=0;
		theme_gaugefilename="gauge.png";
		return;
	}
	QFile 	xmlFile;
	xmlFile.setName(XMLConf);
	QDomDocument doc( "KXDocker_Plugin_ThemeScheme" );
	if ( !xmlFile.open( IO_ReadOnly ) )
	{
		return;
	}
	if ( !doc.setContent( &xmlFile) ) {
		xmlFile.close();
		return;
	}
	xmlFile.close();
	QDomElement docElem = doc.documentElement();
	//QDomNodeList xmlTheme=docElem.elementsByTagName(name());
	//if(xmlTheme.count()>0)
	{
		//qWarning("caricato");
		bool okRet=false;
		theme_gaugetype=docElem.attribute("gaugetype","1").toInt(&okRet);
		if(okRet==false)theme_gaugetype=0;
		theme_gaugefilename=docElem.attribute("gaugefilename","gauge.png");
		theme_zalbum=docElem.attribute("theme_zalbum","128").toInt(&okRet);
		if(okRet==false)theme_zalbum=128;
		theme_xalbum=docElem.attribute("theme_xalbum","0").toInt(&okRet);
		if(okRet==false)theme_xalbum=0;
		theme_yalbum=docElem.attribute("theme_yalbum","0").toInt(&okRet);
		if(okRet==false)theme_yalbum=0;

	}

}


/*!
    \fn XEPlugin_GAmarok::Respawn(QObject *)
 */
QObject *  XEPlugin_GAmarok::Respawn(QObject *p)
{
	//0.40 
	return (QObject *)new XEPlugin_GAmarok(p,name());
}
