/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gaclock.h"
#include "wmconfigurationwindow.h"

#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	return new GAClock(parent,"GAClock");
}



#include "xeplugin_gaclock.moc"


GAClock::GAClock(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
    themepath="kxdocker/plugins/gaclock/themes/default";
    besmooth="yes";
    background="gclock.png";
    foreground="gclock_fg.png";
    hour_hand="gclock_h0.png";
    min_hand="gclock_m0.png";
    sec_hand="gclock_s0.png";
    day_image="gclock_c";
    alwaysShowDate="no";
    ruota=&GAClock::ruotaSimply;
	/* Standard plugin information since kxdocker 0.29 */
	QString Version="1.0.0";
	// Project name
	PluginInformations.append("KXDocker GAClock");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20060212");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gaclock");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gaclock");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	iMiniText=1;
	italian=1;
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);
}

GAClock::~GAClock()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

void GAClock::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		themepath=vvalue;
	}
	if(vname=="besmooth")
	{
		besmooth=vvalue;
	}
	if(vname=="alwaysShowDate")
	{
		alwaysShowDate=vvalue;
	}
	bool okRet;
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}
	if(vname=="italian")
	{
		italian=vvalue.toInt(&okRet);
		if(okRet==false)italian=1;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
		xXMLIconConfig->item(0).toElement().setAttribute("besmooth",besmooth);
		xXMLIconConfig->item(0).toElement().setAttribute("alwaysShowDate",alwaysShowDate);
		xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		xXMLIconConfig->item(0).toElement().setAttribute("italian",italian);
	}
	else
	{
		createXMLTree();
	}
	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(themepath);
	if(besmooth=="no")
	{
		ruota=&GAClock::ruotaSimply;
	}
	else
	{
		ruota=&GAClock::ruotaSmooth;
	}

}

void GAClock::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="besmooth")
	{
		vvalue=besmooth;
	}
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	if(vname=="alwaysShowDate")
	{
		vvalue=alwaysShowDate;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	if(vname=="italian")
	{
		vvalue.setNum(italian);
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void GAClock::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("besmooth");
	a->append("alwaysShowDate");
	a->append("minitext");
	a->append("italian");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
	
}


void GAClock::xPaint(int)
{
	char filename[50];
	if(italian==1)
	{
	sprintf(filename,"%d:%02d %d/%d/%d",
		QTime::currentTime().hour(),
		QTime::currentTime().minute(),
		QDate::currentDate().day(),
		QDate::currentDate().month(),
		QDate::currentDate().year()
		);
	}
	else
	{
	sprintf(filename,"%d:%02d %d/%d/%d",
		QTime::currentTime().hour(),
		QTime::currentTime().minute(),
		QDate::currentDate().month(),
		QDate::currentDate().day(),
		QDate::currentDate().year()
		);
	}
	ToolTip=filename;
	switch(iMiniText)
	{
		case 1:
			// like pillow
			ToolTip2=ToolTip;
		break;
		case 2:
			sprintf(filename,"%d:%02d",
				QTime::currentTime().hour(),
				QTime::currentTime().minute()
				);

			ToolTip2=filename;
		break;
		case 3:
			if(italian==1)
			{
			sprintf(filename,"%d/%d/%d",
				QDate::currentDate().day(),
				QDate::currentDate().month(),
				QDate::currentDate().year()
				);
			}
			else
			{
			sprintf(filename,"%d/%d/%d",
				QDate::currentDate().month(),
				QDate::currentDate().day(),
				QDate::currentDate().year()
				);
			}

			ToolTip2=filename;
		break;
		case 4:
			ToolTip2=QDate::longDayName(QDate::currentDate().dayOfWeek());
		break;
		case 5:
			ToolTip2=QString("%1 %1").arg(QDate::longDayName(QDate::currentDate().dayOfWeek()))
					.arg(QDate::currentDate().day());
		break;
		case 6:
			ToolTip2=QString("%1 %1").arg(QDate::longDayName(QDate::currentDate().dayOfWeek()))
					.arg(QDate::longMonthName(QDate::currentDate().month ()));
		break;
		case 7:
			if(italian==1)
			{
			sprintf(filename,"%d/%d",
				QDate::currentDate().day(),
				QDate::currentDate().month()
				);
			}
			else
			{
			sprintf(filename,"%d/%d",
				QDate::currentDate().month(),
				QDate::currentDate().day()
				);
			}

			ToolTip2=filename;
		break;
		case 8:
			ToolTip2=QString("%1 %1").arg(QDate::shortDayName(QDate::currentDate().dayOfWeek()))
					.arg(QDate::currentDate().day());
		break;
		case 9:
			ToolTip2=QString("%1 %1").arg(QDate::currentDate().day())
					.arg(QDate::shortMonthName(QDate::currentDate().month()));
		break;
	}
	*xImgSource=theClockPixmap.convertToImage();
}


void GAClock::polling()
{

	if(isStopped){
		return;
	}
	dirty("");
}


void GAClock::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
		besmooth=xXMLIconConfig->item(0).toElement().attribute("besmooth","yes");
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gaclock/themes/default");
		alwaysShowDate=xXMLIconConfig->item(0).toElement().attribute("alwaysShowDate","no");
			QString sMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1");

			bool okRet=false;
			iMiniText=sMiniText.toInt(&okRet);
			if(okRet==false)iMiniText=1;

			sMiniText=xXMLIconConfig->item(0).toElement().attribute("italian","1");
			italian=sMiniText.toInt(&okRet);
			if(okRet==false)italian=1;

	}
	loadResources(themepath);
	if(besmooth=="no")
	{
		ruota=&GAClock::ruotaSimply;
	}
	else
	{
		ruota=&GAClock::ruotaSmooth;
	}
	// to enable the first pass
	lastValue=-1;
	//dirty("");
}


void GAClock::dirty(const QString &)
{

	if(isStopped){
		return;
	}
	double h_degree=0;
	double m_degree=0;
	double s_degree=0;
	
	
	
	if(QTime::currentTime().hour()>=12){
		h_degree=(360/12)*(QTime::currentTime().hour()-12);
	}
	else
	{
		h_degree=(360/12)*(QTime::currentTime().hour());
	}
	
	m_degree=(360/60)*QTime::currentTime().minute();
	s_degree=(360/60)*QTime::currentTime().second();
	h_degree=h_degree+(360/12)*(m_degree/360);

	
	
	
	//QImage iPixmap;
	// Reset the clock
	// background
	
	theClockPixmap=background_pixmap;
	
	
	
	//theClockPixmap.detach();
	//ImageBuffer=background_pixmap.convertToImage();
	// day
	if(sec_hand_pixmap.isNull())
	{
		// delay...
		QTimer::singleShot( 60*1000, this, SLOT(polling()) );
		Value=(int)(h_degree*60*60+m_degree*60);
		if(lastValue!=Value)
		{
			bitBlt(&theClockPixmap,0,0,&day_image_pixmap,0,Qt::CopyROP);
			(this->*ruota)(theClockPixmap,min_hand_pixmap,m_degree);
			(this->*ruota)(theClockPixmap,hour_hand_pixmap,h_degree);
			bitBlt(&theClockPixmap,0,0,&foreground_pixmap,0,Qt::CopyROP);
			xRefreshIcon(xGIcon);
		}
	}
	else
	{
		QTimer::singleShot( 1000, this, SLOT(polling()) );
		Value=(int)(h_degree*60*60+m_degree*60+s_degree);
		if(lastValue!=Value)
		{
			bitBlt(&theClockPixmap,0,0,&day_image_pixmap,0,Qt::CopyROP);
			(this->*ruota)(theClockPixmap,min_hand_pixmap,m_degree);
			(this->*ruota)(theClockPixmap,hour_hand_pixmap,h_degree);
			// 0.3 version
			//(this->*ruota)(theClockPixmap,sec_hand_pixmap,s_degree);
			ruotaSimply(theClockPixmap,sec_hand_pixmap,s_degree);
			bitBlt(&theClockPixmap,0,0,&foreground_pixmap,0,Qt::CopyROP);
			xRefreshIcon(xGIcon);
			
		}
	}

}


void GAClock::xStop()
{
	gPluginSDK::xStop();
}


void GAClock::xStart()
{
	gPluginSDK::xStart();
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new WMConfigurationWindow(this);
	}
}


void GAClock::loadResources(const QString newPath)
{
	//**********************************************************
	// path where to find images
	QString ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+background;
	// check if it exists
	QFile a(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gaclock/themes/default/";
		ClockPaths=ClockPaths+background;
	}
	
	background_pixmap.load(::locate("data",ClockPaths));
	
	//**********************************************************
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+hour_hand;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gaclock/themes/default/";
		ClockPaths=ClockPaths+hour_hand;
	}
	
	hour_hand_pixmap.load(::locate("data",ClockPaths));
	
	//**********************************************************
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+min_hand;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gaclock/themes/default/";
		ClockPaths=ClockPaths+min_hand;
	}
	
	min_hand_pixmap.load(::locate("data",ClockPaths));
	//**********************************************************
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+sec_hand;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gaclock/themes/default/";
		ClockPaths=ClockPaths+sec_hand;
	}
	
	sec_hand_pixmap.load(::locate("data",ClockPaths));
	
	loadDateResource();
	
	//**********************************************************
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+foreground;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gaclock/themes/default/";
		ClockPaths=ClockPaths+foreground;
	}
	
	foreground_pixmap.load(::locate("data",ClockPaths));
	
	//if(foreground_pixmap.isNull())qWarning("foreground_pixmap");
	
}


/*!
    \fn GAClock::ruota(QPixmap &,const QPixmap,double degree)
 */
void GAClock::ruotaSimply(QPixmap &target,const QPixmap &source,double gradi)
{
	m.reset();
	m.rotate(gradi);
	rotatedPixmap.resize(0,0);
	rotatedPixmap=source.xForm(m);
	
	int x=abs((int)(source.width()*cos((gradi/360)*6.28)))
		+abs((int)(source.height()*sin((gradi/360)*6.28)));
	int y=abs((int)(source.width()*sin((gradi/360)*6.28)))
		+abs((int)(source.height()*cos((gradi/360)*6.28)));
	bitBlt(&target,
		0,
		0,
		&rotatedPixmap,
		(x-source.width())/2
		,
		(y-source.width())/2
		,
		x,
		y,
		Qt::CopyROP);
}


/*!
    \fn GAClock::loadDateResource()
 */
void GAClock::loadDateResource()
{
	//**********************************************************
	static int lastDate=0;
	int todayDate=QDate::currentDate().day();
	if(lastDate==todayDate)
	{
		return;
	}
	lastDate=todayDate;
	QString ClockPaths=themepath;
	QString RealDateFile = QString("/%1%1.png")
		.arg(day_image)
		.arg(lastDate);

	// 0.3
	// not all theme has date support...
	// than we can do user choice
	ClockPaths=ClockPaths+"/"+RealDateFile;
	QFile a(ClockPaths);
	
	if((!a.exists() || ClockPaths==QString::null) && alwaysShowDate!="no")
	{
		ClockPaths="kxdocker/plugins/gaclock/themes/default/";
		ClockPaths=ClockPaths+RealDateFile;
	}
	if(!a.exists() || ClockPaths==QString::null)
	{
		day_image_pixmap.resize(0,0);
	}
	else
	{
		day_image_pixmap.load(::locate("data",ClockPaths));
	}
}


/*!
    \fn GAClock::ruotaSmooth(QPixmap &target,const QPixmap &source,double gradi)
 */
void GAClock::ruotaSmooth(QPixmap &target,const QPixmap &source,double gradi)
{
	m.reset();
	m.rotate(gradi);
	QImage bigBuffer=source.convertToImage();
	bigBuffer=bigBuffer.smoothScale(256,256);
	//bigBuffer=bigBuffer.smoothScale(128,128);

	bigBuffer=bigBuffer.xForm(m);
	
	int x=abs((int)(source.width()*cos((gradi/360)*6.28)))
		+abs((int)(source.height()*sin((gradi/360)*6.28)));
	int y=abs((int)(source.width()*sin((gradi/360)*6.28)))
		+abs((int)(source.height()*cos((gradi/360)*6.28)));
	
	bigBuffer=bigBuffer.smoothScale(x,y);
	rotatedPixmap=(bigBuffer);
	
	bitBlt(&target,
		0,
		0,
		&rotatedPixmap,
		(x-source.width())/2
		,
		(y-source.width())/2
		,
		x,
		y,
		Qt::CopyROP);
}



/*!
    \fn GAClock::Respawn(QObject *p)
 */
QObject * GAClock::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GAClock(p,"GAClock");

}
