/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "btmanager.h"
#include <qmutex.h>
#include <qprocess.h>
#include <stdio.h>
#include <string.h>


BTManager::BTManager()
 : QThread()
{
	//proc=NULL;
	semaforo=new QMutex();
	localSpawn=0;
	dropLines=1;
	localCmd="";
}


BTManager::~BTManager()
{
}


#include "btmanager.moc"


/*!
    \fn BTManager::run()
 */
void BTManager::run()
{
	if(localCmd==QString::null)return;
	if(localCmd=="")return;
	
	while(localSpawn)
	{
		localList.clear();

		FILE *pf=popen(localCmd,"r");
		if ( !pf )
		{
			//qWarning("Cannot run");
		}
		else
		{
			char charBuffer[1025];
			char nomeDevice[1025];
			int skipLine=0;
			memset(charBuffer,0,1025);
			QString riga="";
			while(fgets(charBuffer, 1024, pf))
			{
				skipLine++;
				if(skipLine<=dropLines)continue;
				int len=strlen(charBuffer);
				if(len<4)continue;
				int startsel=0;
				int endsel=len-1;
				//    00:02:C7:17:DF:23       hp3970
				memset(nomeDevice,0,1025);
				for(;endsel>=0;endsel--)
				{
					if(charBuffer[endsel]!=' ' && charBuffer[endsel]!='\n' && charBuffer[endsel]!='\r')
					{
						break;
					}
				}
				for(startsel=endsel;startsel>=0;startsel--)
				{
					if(charBuffer[startsel]==' ' ||charBuffer[startsel]=='\t')
					{
						startsel++;
						break;
					}
				}
				strncpy(nomeDevice,charBuffer+startsel,endsel-startsel+1);
				riga=nomeDevice;
				localList.append(riga);
				memset(charBuffer,0,1025);
			}
			pclose(pf);
			pf=NULL;
			dirty(localList);
		}
		sleep(localSpawn);
	}
}


/*!
    \fn BTManager::polling()
 */
void BTManager::polling()
{
    /// @todo implement me
}


/*!
    \fn BTManager::setCmd(const QString, const QString, int,int)
 */
void BTManager::setCmd(const QString newCmd, const QString, int newSpawn,int newLine)
{
	localCmd=newCmd;
	localSpawn=newSpawn;
	dropLines=newLine;
}
