/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeobject.h"

#include <kdebug.h>


QObject * XEObject::xEngineRoot=NULL;
QObject * XEObject::xEngineMatrix=NULL;
QObject * XEObject::xEngineDocker=NULL;
QObject * XEObject::xXMLParser=NULL;
QObject * XEObject::xEngineEvents=NULL;
QObject * XEObject::xEngineConfiguration=NULL;
QPtrList<QObject> XEObject::xPlugins;
QStringList	XEObject::xPluginList;


//timespec microSeconds;


XEObject::XEObject(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


XEObject::~XEObject()
{
}


#include "xeobject.moc"


/*!
    \fn XEObject::xGetRoot()
 */
QObject * XEObject::xGetRoot()
{
	return xEngineRoot;
}


/*!
    \fn XEObject::xGetMatrix()
 */
QObject * XEObject::xGetMatrix()
{
	return xEngineMatrix;
}


/*!
    \fn XEObject::xGetDocker()
 */
QObject * XEObject::xGetDocker()
{
	return xEngineDocker;
}


/*!
    \fn XEObject::xSetEngineDocker(QObject *)
 */
void XEObject::xSetEngineDocker(QObject *newDocker)
{
	xEngineDocker=newDocker;
}


/*!
    \fn XEObject::xSetEngineEvents(QObject *)
 */
void XEObject::xSetEngineEvents(QObject *newEvents)
{
	xEngineEvents=newEvents;
}


/*!
    \fn XEObject::xSetEngineConfiguration(QObject *)
 */
void XEObject::xSetEngineConfiguration(QObject *newCfg)
{
	xEngineConfiguration=newCfg;
}


/*!
    \fn XEObject::xSetEngineMatrix(QObject *)
 */
void XEObject::xSetEngineMatrix(QObject *newMatrix)
{
	xEngineMatrix=newMatrix;
}


/*!
    \fn XEObject::xWarningMsg(const QObject *, const QString &)
 */
void XEObject::xWarningMsg(const QObject *Sender, const QString &Message)
{
	QString WarningMsg=Sender->name();
	WarningMsg=WarningMsg+": ";
	WarningMsg=WarningMsg+(Message);
	kdWarning() <<(WarningMsg);
}


/*!
    \fn XEObject::xFindObject(const QString &hisName)
 */
QObject * XEObject::xFindObject(const QString &hisName)
{
//qWarning("Searching for:");
//qWarning(hisName);
	for(unsigned int i=0;i<xPlugins.count();i++)
	{
//qWarning(xPlugins.at(i)->name());
		if(xPlugins.at(i)->name()==hisName)return xPlugins.at(i);
	}
	return NULL;
}


/*!
    \fn XEObject::xPluginAdd(QObject *)
 */
void XEObject::xPluginAdd(QObject *item)
{
	if(xFindObject(item->name())!=NULL)
	{
		xPlugins.append(item);
	}
	else
	{
		xPlugins.append(item);
		xPluginList.append(item->name());
	}
}

/*!
    \fn XEObject::xPluginAdd(QObject *)
 */
void XEObject::xPluginDel(QObject *item)
{
	xPlugins.remove(item);
	if(xFindObject(item->name())!=NULL)
	{
	}
	else
	{
		xPluginList.remove(item->name());
	}
}


/*!
    \fn XEObject::xGetConfiguration()
 */
QObject * XEObject::xGetConfiguration()
{
	return xEngineConfiguration;
}

QObject * XEObject::xGetXMLParser()
{
	return xXMLParser;
}
void XEObject::xSetXMLParser(QObject *newDocker)
{
	xXMLParser=newDocker;
}


/*!
    \fn XEObject::xGetPluginListNames()
 */
const QStringList XEObject::xGetPluginListNames()
{
	return xPluginList;
}


/*!
    \fn XEObject::xGetDocker(QObject *&)
 */
void XEObject::xGetDocker(QObject *&a)
{
   a=xGetDocker();
}


/*!
    \fn XEObject::xGetConfiguration(QObject  *&)
 */
void XEObject::xGetConfiguration(QObject  *&a)
{
	a=xGetConfiguration();
}


/*!
    \fn XEObject::xParseTo(const QString &, int, void *)
 */
void XEObject::xParse(const QString &, int, void *)
{
    /// @todo implement me
}


/*!
    \fn XEObject::xGetPluginIndex(QObject *)
 */
int XEObject::xGetPluginIndex(QObject *p)
{
	return xPlugins.find(p);
}
