/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGPILLOWCOMPOSITE_H
#define XGPILLOWCOMPOSITE_H

#include <qwidget.h>
#include <xeplugin_gepillow.h>

#include <qpixmap.h>
#include <qimage.h>

#include <kwin.h>
class XSConfigurations;
class XGDocker;
class KRootPixmap;


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XGPillowComposite : public XEPlugin_GEPillow
{
Q_OBJECT
public:
    XGPillowComposite(QWidget *parent = 0, const char *name = 0);

    ~XGPillowComposite();

public slots:
    virtual void show();
    virtual void xSetup();
    virtual void xStart();
    virtual void xStop();
    virtual void paintEvent( QPaintEvent *e);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xRefresh();
    virtual void externalDrawPillow(QObject *,int,int);
    virtual void xGetInfo(QStringList &);
    virtual void xEventWidgetMoved(int,int,int,int,int,int);
    virtual void hide();
protected slots:
    virtual void hideMe();
    virtual void backgroundUpdated(const QPixmap &);

protected:
    virtual void setUnShadowed();
	QTimer 			*_timerHide;
	QImage			paintBuffer;
	KWin::WindowInfo	*info( WId win );
	XSConfigurations 	*ActiveConfiguration;
	XGDocker		*xGDocker;
	QPixmap			pixmapBackground;
	KRootPixmap		*KDesktopBackground;
	int			NegativeX;
	int			NegativeY;
	int			img_Height;
	QRect rect;
	int l;
	int t;
	int w;
	int h;
	double _alpha;
	int lastX;
	QImage _blendedText;
};

#endif
