/***************************************************************************
 *   Copyright (C) 2006 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeconfiguration.h"
#include "xeobject.h"
#include <kstandarddirs.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <qdir.h>
#include <qlibrary.h>
#include <kdebug.h>
#include <klocale.h>
#include <stdlib.h>

//#undef ENABLE_FINAL


XEConfiguration::XEConfiguration(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xSetEngineConfiguration(this);
	
	xReset();
}


XEConfiguration::~XEConfiguration()
{
}


#include "xeconfiguration.moc"
typedef QObject *(*pPluginGenerator)(QObject *parent);


/*!
    \fn XEConfiguration::xReset()
 */
void XEConfiguration::xReset()
{

	ActiveConfiguration.AutoSave=1;
	ActiveConfiguration.Version=KXDOCKERVERSION;
	ActiveConfiguration.Icons.Size=32;
	ActiveConfiguration.Icons.SizeBig=128;
	ActiveConfiguration.Icons.Separation=5;
	ActiveConfiguration.Icons.Raise=-50;
	ActiveConfiguration.Icons.Horiz=32;
	ActiveConfiguration.Icons.EnableThumbnail=0;
	
	ActiveConfiguration.Window.FastHide=0;
	ActiveConfiguration.Window.borderLeft=200;
	ActiveConfiguration.Window.borderTop=200;
	ActiveConfiguration.Window.Width=1024;
	ActiveConfiguration.Window.Height=300;
	ActiveConfiguration.Window.Top=100;
	ActiveConfiguration.Window.Left=0;
	ActiveConfiguration.Window.HeightDesktop=0;
	ActiveConfiguration.Window.LeftForce=0;
	ActiveConfiguration.Window.TopForce=0;
	
	ActiveConfiguration.Window.HideTimeout=0;
	ActiveConfiguration.Window.HideMouseEdge=1;
	
	
	
	ActiveConfiguration.Window.SendToForgroundTimeout=500;
	ActiveConfiguration.Window.RaiseOnEvents=0;
	
	// 0.27
	ActiveConfiguration.Matrix.XMatrix=NULL;
	ActiveConfiguration.Matrix.YMatrix=NULL;
	ActiveConfiguration.Matrix.ZMatrix=NULL;
	ActiveConfiguration.Matrix.KMatrix=NULL;
	ActiveConfiguration.Matrix.DMatrix=NULL;
	
	ActiveConfiguration.Matrix.DesignDMoltiplier=1;
	ActiveConfiguration.Matrix.DesignYMoltiplier=1;
	ActiveConfiguration.Matrix.DesignXMoltiplier=1;
	ActiveConfiguration.Matrix.Design="panther";

	
	
	ActiveConfiguration.Engine.SmoothTimeout=200;
	//strcpy(ActiveConfiguration.Engine.XMLConf,"kxdocker_conf.xml");
	KConfig *cfg=KGlobal::config();
	//cfg->setGroup("");
	ActiveConfiguration.Engine.XMLConf=cfg->readEntry("KXDockerXMLConf","kxdocker/kxdocker_conf.xml");
	if(ActiveConfiguration.Engine.XMLConf=="" 
		||ActiveConfiguration.Engine.XMLConf==NULL
		||ActiveConfiguration.Engine.XMLConf==QString::null)
	{
		ActiveConfiguration.Engine.XMLConf="kxdocker/kxdocker_conf.xml";
	}
	ActiveConfiguration.Engine.XMLConf=::locate("data",ActiveConfiguration.Engine.XMLConf);
#ifndef ENABLE_FINAL
	 kdWarning() << (ActiveConfiguration.Engine.XMLConf)<<"\n";
#endif
	QFile a(ActiveConfiguration.Engine.XMLConf);
	if(!a.exists() || ActiveConfiguration.Engine.XMLConf==QString::null)
	{
		QString cfgPath="kxdocker/kxdocker_conf.xml";
		ActiveConfiguration.Engine.XMLConf=::locate("data",cfgPath);
		if(ActiveConfiguration.Engine.XMLConf==NULL)
		{
			KFileDialog fd(QString::null,QString::null,0,"openXMLConf",true);
			cfgPath=fd.getOpenFileName(QString::null,QString::null,0,"Open KXDocker XML Configuration");
			ActiveConfiguration.Engine.XMLConf=::locate("data",cfgPath);
			if(ActiveConfiguration.Engine.XMLConf==NULL)
			{
				qWarning("cannot find kxdocker_conf.xml");
				exit(1);
			}
		}
		cfg->writeEntry("KXDockerXMLConf",ActiveConfiguration.Engine.XMLConf);
	}
	
	// checkout if resources are correctly installed
	QString ResourcesPath=QString("kxdocker/kxdocker_resources-%1").arg(KXDOCKERNEED);
	ResourcesPath=::locate("data",ResourcesPath);
	if(!a.exists() || ResourcesPath==QString::null)
	{
		kdWarning()<<QString("%1\n").arg(i18n("Cannot find updated resources: you may need to update or reinstall KXDocker resources, checkout http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download#resources"));
	}
	
	ActiveConfiguration.Engine.SleepFPS=100;
	ActiveConfiguration.Engine.SleepThreads=1000;
	ActiveConfiguration.Engine.SleepAnimations=1000;
	ActiveConfiguration.Engine.MaxIconsShowed=MAX_ICONS;
	ActiveConfiguration.Engine.AndZoomCache=0;
	
	ActiveConfiguration.Window.Align="bottom";

	QString backgroundPath="kxdocker/themes/bar/default/";
	ActiveConfiguration.Theme.ArrowsPath="kxdocker/themes/arrows/";
	
	ActiveConfiguration.Theme.BackgroundPath=::locate("data",backgroundPath);
	if(ActiveConfiguration.Theme.BackgroundPath==NULL)
	{
#ifndef ENABLE_FINAL
		qWarning("Cannot find background themes!");
#endif
		ActiveConfiguration.Theme.BackgroundPath="kxdocker/themes/bar/default";
	}
	ActiveConfiguration.Theme.Background.Tiled=1;
	ActiveConfiguration.Theme.Background.Desaturate=0;
	ActiveConfiguration.Theme.Background.imgBackgroundCenter="background-center.png";
	ActiveConfiguration.Theme.Background.imgBackgroundLeft="background-left.png";
	ActiveConfiguration.Theme.Background.imgBackgroundRight="background-right.png";
	ActiveConfiguration.Theme.Background.imgBackgroundOver="background-over.png";
	
	ActiveConfiguration.Plugins.PluginsPaths.clear();
	
#ifdef ENABLE_SPECIALENGINE2
	ActiveConfiguration.Engine.InterpolationValue=2;
#endif
	ActiveConfiguration.Window.SendToBackground=1;
	
	ActiveConfiguration.ConfigurationsPaths.clear();
	ActiveConfiguration.ConfigurationsPaths.append("kxdocker/xml/");
}


/*!
    \fn XEConfiguration::xGetConfiguration()
 */
XSConfigurations * XEConfiguration::xGetConfiguration()
{
	return &ActiveConfiguration;
}


/*!
    \fn XEConfiguration::xCfgDefault()
 */
void XEConfiguration::xCfgDefault()
{
    /// @todo implement me
}


/*!
    \fn XEConfiguration::xSetup()
 */
void XEConfiguration::xSetup()
{
    /// @todo implement me
}


/*!
    \fn XEConfiguration::iconRemove(int)
 */
void XEConfiguration::xEventInRemovingIcon(int icon,int AnimationType)
{
	// removing all dead info
//	kdWarning()<<QString("XEConfiguration::xEventInRemovingIcon(%1,%1) 1\n").arg(icon).arg(AnimationType);
	emit xEventRemovingIcon(icon,AnimationType);
//	kdWarning()<<QString("XEConfiguration::xEventInRemovingIcon(%1,%1) 2\n").arg(icon).arg(AnimationType);
	ActiveConfiguration.ObjectsIcons.remove(icon);
//	kdWarning()<<QString("XEConfiguration::xEventInRemovingIcon(%1,%1) 3\n").arg(icon).arg(AnimationType);
	emit xEventRemovedIcon(icon);
//	kdWarning()<<QString("XEConfiguration::xEventInRemovingIcon(%1,%1) end\n").arg(icon).arg(AnimationType);

}

void XEConfiguration::xLoadModules()
{
	for(unsigned int i=0;i<ActiveConfiguration.ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration.ObjectsIcons.at(i)->Info.className!="GIcon")
		{
			QObject *GClass
				=
				XEObject::xFindObject(
					ActiveConfiguration.ObjectsIcons.at(i)->Info.className
				);
			if(GClass==NULL)
			{
#ifndef ENABLE_FINAL
				qWarning("xeconfiguration.cpp:194 Module not found, try to load it...");
#endif
				xLoadModule(ActiveConfiguration.ObjectsIcons.at(i)->Info.className);
			}
			else
			{
#ifndef ENABLE_FINAL
				qWarning("xeconfiguration.cpp:199 Module FOUND!");
#endif
			}
		}
	}
}


void XEConfiguration::xLoadModule(const QString moduleName)
{
#ifndef ENABLE_FINAL
	kdWarning() <<"void XEConfiguration::xLoadModule("<<moduleName<<")\n";
#endif
	QStringList typeList;
	typeList.append("data");
	typeList.append("lib");
	typeList.append("module");
for(uint typeIndex=0;typeIndex<typeList.count();typeIndex++)
{
	for(unsigned int i=0; i<ActiveConfiguration.Plugins.PluginsPaths.count();i++)
	{
		if (ActiveConfiguration.Plugins.PluginsPaths[i].length()>0&&ActiveConfiguration.Plugins.PluginsPaths[i]
			[ActiveConfiguration.Plugins.PluginsPaths[i].length()-1]!='/')
				ActiveConfiguration.Plugins.PluginsPaths[i]=
				ActiveConfiguration.Plugins.PluginsPaths[i]+"/";

		// 0.40 test auto find
		//QString SOName=::locate(typeList[typeIndex],ActiveConfiguration.Plugins.PluginsPaths[i]);
		//SOName=SOName+moduleName+".so";
		QString SOName=ActiveConfiguration.Plugins.PluginsPaths[i]+moduleName;
		SOName=::locate(typeList[typeIndex],SOName);
		int okLoaded=0;
		okLoaded=xLoadModuleTest(SOName);
		if(okLoaded<1)
		{
			SOName=ActiveConfiguration.Plugins.PluginsPaths[i]+moduleName+".so";
			SOName=::locate(typeList[typeIndex],SOName);
			okLoaded=xLoadModuleTest(SOName);
		if(okLoaded<1)
		{
			SOName=ActiveConfiguration.Plugins.PluginsPaths[i]+"lib"+moduleName+".so";
			SOName=::locate(typeList[typeIndex],SOName);
			okLoaded=xLoadModuleTest(SOName);
		}
		}
		if(okLoaded>0)
		{
			return;
		}
	}
}
}


/*!
    \fn XEConfiguration::pluginRemove(const QString)
 */
void XEConfiguration::pluginRemove(const QString removeName)
{
	for(uint k=0;k<ActiveConfiguration.Plugins.Plugin.count();k++)
	{
		if(ActiveConfiguration.Plugins.Plugin.at(k)->Info.Name=removeName)
		{
			ActiveConfiguration.Plugins.Plugin.remove(k);
			return;
		}
	}
}


/*!
    \fn XEConfiguration::pluginAdd(const QString)
 */
void XEConfiguration::pluginAdd(const QString newName)
{
	XSGObjectPlugin	*newPlugin=new XSGObjectPlugin();
	newPlugin->Info.Name=newName;

			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			newPlugin->xmlConfiguration=fakeRoot.childNodes();//fa	
	

	ActiveConfiguration.Plugins.Plugin.append(newPlugin);
}


/*!
    \fn XEConfiguration::xGetConfiguration(XSConfiguration *&)
 */
void XEConfiguration::xGetConfiguration(void *&a,const QString Version, int SizeOf)
{
a=NULL;
if(Version==KXDOCKERHEADERVERSION && SizeOf==sizeof(ActiveConfiguration))a=&ActiveConfiguration;
}


/*!
    \fn XEConfiguration::xGetConfigurationVersion(int &, QString)
 */
void XEConfiguration::xGetConfigurationVersion(int &i, QString &s)
{

s=KXDOCKERHEADERVERSION;
i=sizeof(ActiveConfiguration);

}


/*!
    \fn XEConfiguration::xGetConfigurationValue(const QString, QStringList &)
 */
void XEConfiguration::xGetConfigurationValue(const QString vpath, QStringList &vvalue)
{
	QStringList *pV=(QStringList *)xGetConfigurationPointer(vpath);
	if(pV!=NULL)vvalue=*pV;
	else vvalue="";
}


/*!
    \fn XEConfiguration::xGetConfigurationValue(const QString, int &)
 */
void XEConfiguration::xGetConfigurationValue(const QString vpath, int &vvalue)
{	
	int *pV=(int *)xGetConfigurationPointer(vpath);
	if(pV!=NULL)vvalue=*pV;
	else vvalue=0;
}


/*!
    \fn XEConfiguration::xGetConfigurationValue(const QString, QString &)
 */
void XEConfiguration::xGetConfigurationValue(const QString vpath, QString &vvalue)
{
	
	QString *pV=(QString *)xGetConfigurationPointer(vpath);
	if(pV!=NULL)vvalue=*pV;
	else vvalue="";
}

/*!
    \fn XEConfiguration::xGetConfigurationPointer(const QString)
 */
void * XEConfiguration::xGetConfigurationPointer(const QString vpath)
{
	QStringList lpath=QStringList::split ("/",vpath,FALSE);
	if(lpath.count()<1)return &ActiveConfiguration;
	if(lpath[0]=="icons")
	{
		if(lpath.count()<2)return &ActiveConfiguration.Icons;
		if(lpath[1]=="size")return &ActiveConfiguration.Icons.Size;
		if(lpath[1]=="sizebig")return &ActiveConfiguration.Icons.SizeBig;
		if(lpath[1]=="sizeprefer")return &ActiveConfiguration.Icons.SizePrefer;
		if(lpath[1]=="list()")
		{
			_ValuesList.clear();
			_ValuesList.append("size");
			_ValuesList.append("sizebig");
			_ValuesList.append("sizeprefer");
			return &_ValuesList;
		}

		if(lpath[1]=="minitextfont" || lpath[1]=="overtextfont")
		{
			XSCfgTextFont *pFont=NULL;
			if(lpath[1]=="minitextfont")pFont=&ActiveConfiguration.Icons.MiniTextFont;
			if(lpath[1]=="overtextfont")pFont=&ActiveConfiguration.Icons.OverTextFont;
			if(lpath[1]=="list()")
			{
				_ValuesList.clear();
				_ValuesList.append("minitextfont");
				_ValuesList.append("overtextfont");
				return &_ValuesList;
			}

			if(lpath.count()<3)return pFont;
			if(lpath[2]=="alias")return &pFont->Alias;
			if(lpath[2]=="backgroundpath")return &pFont->BackgroundPath;
			if(lpath[2]=="bold")return &pFont->Bold;
			if(lpath[2]=="fontblue")return &pFont->FontBlue;
			if(lpath[2]=="fontfamily")return &pFont->FontFamily;
			if(lpath[2]=="fontgreen")return &pFont->FontGreen;
			if(lpath[2]=="fontred")return &pFont->FontRed;
			if(lpath[2]=="fontsize")return &pFont->FontSize;
			if(lpath[2]=="italic")return &pFont->Italic;
			if(lpath[2]=="other")return &pFont->Other;
			if(lpath[2]=="otherbinaryvalue")return &pFont->OtherBinaryValue;
			if(lpath[2]=="weight")return &pFont->Weight;
			if(lpath[2]=="list()")
			{
				_ValuesList.clear();
				_ValuesList.append("alias");
				_ValuesList.append("backgroundpath");
				_ValuesList.append("backgroundpath");
				_ValuesList.append("bold");
				_ValuesList.append("fontblue");
				_ValuesList.append("fontfamily");
				_ValuesList.append("fontgreen");
				_ValuesList.append("fontred");
				_ValuesList.append("fontsize");
				_ValuesList.append("italic");
				_ValuesList.append("other");
				_ValuesList.append("otherbinaryvalue");
				_ValuesList.append("weight");
				return &_ValuesList;
			}
		}
	}
	if(lpath[0]=="window")
	{
		if(lpath.count()<2)return &ActiveConfiguration.Window;
		if(lpath[1]=="width")return &ActiveConfiguration.Window.Width;
		if(lpath[1]=="height")return &ActiveConfiguration.Window.Height;
		if(lpath[1]=="left")return &ActiveConfiguration.Window.Left;
		if(lpath[1]=="top")return &ActiveConfiguration.Window.Top;
			if(lpath[1]=="list()")
			{
				_ValuesList.clear();
				_ValuesList.append("width");
				_ValuesList.append("height");
				_ValuesList.append("left");
				_ValuesList.append("top");
				return &_ValuesList;
			}
	}


	if(lpath[0]=="objectsicons" ||lpath[0]=="rollingicons")
	{
		// You are searching for objects
		static QPtrList<XSGObjectIcon> *pObjects;
		pObjects=NULL;
		if(lpath[0]=="objectsicons")pObjects=&ActiveConfiguration.ObjectsIcons;
		if(lpath[0]=="rollingicons")pObjects=&ActiveConfiguration.RollingIcons;

		if(lpath.count()<2)return &pObjects;

		// you select 1 object
		bool bObjectIndex=false;
		int iObjectIndex=lpath[1].toInt(&bObjectIndex);
		if(bObjectIndex==true)
		{
			// pointed by Index
			if(iObjectIndex>=0 && pObjects->count()>(uint)iObjectIndex)
			{
				// ok got it
				if(lpath.count()<3)return pObjects->at(iObjectIndex);
				return getConfigurationPointerObject(lpath,2,pObjects->at(iObjectIndex));
			}
		}
		else
		{
			if(lpath[1]=="list()")
			{
				_ValuesList.clear();
				for(uint iObjectIndex=0;iObjectIndex<pObjects->count();iObjectIndex++)
						_ValuesList.append(pObjects->at(iObjectIndex)->Info.Name);
				return &_ValuesList;
			}

			// search by name
			for(uint iObjectIndex=0;iObjectIndex<pObjects->count();iObjectIndex++)
			{
				if(pObjects->at(iObjectIndex)->Info.Name==lpath[1])
				{
				if(lpath.count()<3)return pObjects->at(iObjectIndex);
				return getConfigurationPointerObject(lpath,2,pObjects->at(iObjectIndex));
				}
			}
		}
	}

	return NULL;
}


/*!
    \fn XEConfiguration::iconAdd()
 */
XSGObjectIcon * XEConfiguration::iconAdd()
{
			// 0.35
	XSGObjectIcon *addedCfg=new XSGObjectIcon;

	//addedCfg->Actions.ActionList.clear();
	addedCfg->Actions.onClickExec="";
	addedCfg->Actions.onDropExec="";
	addedCfg->Images.imgFileArrow="arrow.png";
	addedCfg->Images.imgFileDrop="drop.png";
	addedCfg->Images.imgFileOverlay="";
	addedCfg->Images.imgFileName="default";
	addedCfg->Info.Group=addedCfg->Info.Name=QString("Added%1").arg((long)addedCfg);
	addedCfg->Info.className="GIcon";
	addedCfg->Info.fileName="";
	addedCfg->OverText="";
	//addedCfg->PluginConfiguration
	addedCfg->PluginPopupMenu=NULL;
	addedCfg->PoofName="poof.png";
	addedCfg->Tasks.ClassName.clear();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->Tasks.Proces.clear();
	addedCfg->Tasks.MiniTextShow=1;
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->Tasks.TaskInfo=NULL;
	addedCfg->TimeToLive=0;

	addedCfg->Tasks.TaskName.clear();
	addedCfg->Tasks.Thumbnail.reset();
	addedCfg->Tasks.WindowTitle.clear();
	addedCfg->Tasks.dcopClose="";
	addedCfg->Tasks.dcopName.clear();
	addedCfg->Tasks.dcopNewWindow="";
	addedCfg->Tasks.dcopReady=0;
	addedCfg->Tasks.dcopRestore="";
	addedCfg->Tasks.forceRunning=0;
	// 0.39
	addedCfg->TimeToLive=0;


	// 0.38 with auto loading modules need to have xml creation
	// Ok, You don't have specified the xml configuration, we have to create it!!
	
	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	/*
	xGetParameterList(&a);
	for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		xGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	*/
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	addedCfg->PluginConfiguration=fakeRoot.childNodes();

	return addedCfg;
}


/*!
    \fn XEConfiguration::xEventConfigurationUpdated(const QString)
 */
void XEConfiguration::xEventConfigurationUpdated(const QString vpath)
{
	QStringList lpath=QStringList::split ("/",vpath,FALSE);
	if(lpath.count()<1)return;
	if(lpath[0]=="icons")
	{
		if(lpath.count()<2)return;
		if(lpath[1]=="size");
		if(lpath[1]=="sizebig");
		if(lpath[1]=="sizeprefer");
		if(lpath[1]=="minitextfont" || lpath[1]=="overtextfont")
		{
			// update all text over icons
		}
	}
	if(lpath[0]=="window")
	{
		if(lpath.count()<2)return;
	}
}


/*!
    \fn XEConfiguration::getConfigurationPointerObject(const QStringList,int,XSGObjectIcon *)
 */
void *XEConfiguration::getConfigurationPointerObject(const QStringList lpath,int iidPath,XSGObjectIcon *pObject)
{
	uint idPath=(uint)iidPath;
	if(lpath[idPath]=="list()")
	{
		_ValuesList.clear();
		_ValuesList.append("info");
		_ValuesList.append("images");
		_ValuesList.append("actions");
		_ValuesList.append("tasks");
		_ValuesList.append("statistics");
#ifdef ENABLE_STATS
		_ValuesList.append("actions");
#endif
		return &_ValuesList;
	}

	if(lpath[idPath]=="info")
	{
		idPath++;
		if(lpath.count()<idPath+1)return &pObject->Info;
		// single
		if(lpath.count()<idPath+2)
		{
			//idPath++;
			if(lpath[idPath]=="list()")
			{
				_ValuesList.clear();
				_ValuesList.append("group");
				_ValuesList.append("name");
				_ValuesList.append("classname");
				_ValuesList.append("filename");
				return &_ValuesList;
			}

		if(lpath[idPath]=="group")return &pObject->Info.Group;
		if(lpath[idPath]=="name")return &pObject->Info.Name;
		if(lpath[idPath]=="classname")return &pObject->Info.className;
		if(lpath[idPath]=="filename")return &pObject->Info.fileName;
		}

	}
	if(lpath[idPath]=="images")
	{
	}
	if(lpath[idPath]=="actions")
	{
		idPath++;
		if(lpath.count()<idPath+1)return &pObject->Actions;
		// single
		if(lpath.count()<idPath+2)
		{
			//idPath++;
			if(lpath[idPath]=="list()")
			{
				_ValuesList.clear();
				_ValuesList.append("actionlist");
				_ValuesList.append("ianimationmask");
				_ValuesList.append("onclickexec");
				_ValuesList.append("ondropexec");
				return &_ValuesList;
			}

		if(lpath[idPath]=="actionlist")return &pObject->Actions.ActionList;
		if(lpath[idPath]=="ianimationmask")return &pObject->Actions.iAnimationMask;
		if(lpath[idPath]=="onclickexec")return &pObject->Actions.onClickExec;
		if(lpath[idPath]=="ondropexec")return &pObject->Actions.onDropExec;
		}

	}
	if(lpath[idPath]=="overtext")return &pObject->OverText;
	if(lpath[idPath]=="pluginconfiguration")return &pObject->PluginConfiguration;
	if(lpath[idPath]=="pluginpopupmenu")return pObject->PluginPopupMenu;
	
	if(lpath[idPath]=="tasks")
	{
		//XSCfgTasks		Tasks;
		idPath++;
		if(lpath.count()<idPath+1)return &pObject->Tasks;
		// single
		if(lpath.count()<idPath+2)
		{
		if(lpath[idPath]=="minitext")return &pObject->Tasks.MiniText;
		if(lpath[idPath]=="minitextshow")return &pObject->Tasks.MiniTextShow;
		if(lpath[idPath]=="popupmenu")return &pObject->Tasks.PopupMenu;
		if(lpath[idPath]=="showthumbnail")return &pObject->Tasks.ShowThumbnail;
		if(lpath[idPath]=="thumbnail")return &pObject->Tasks.Thumbnail;
		if(lpath[idPath]=="forcerunning")return &pObject->Tasks.forceRunning;
		if(lpath[idPath]=="dcoprestore")return &pObject->Tasks.dcopRestore;
		if(lpath[idPath]=="dcopready")return &pObject->Tasks.dcopReady;
		if(lpath[idPath]=="dcopclose")return &pObject->Tasks.dcopClose;
		if(lpath[idPath]=="dcopnewwindow")return &pObject->Tasks.dcopNewWindow;
		// Multi
		if(lpath[idPath]=="classname")return &pObject->Tasks.ClassName;
		if(lpath[idPath]=="minitextproperty")return &pObject->Tasks.MiniTextProperty;
		if(lpath[idPath]=="proces")return &pObject->Tasks.Proces;
		if(lpath[idPath]=="taskinfo")return &pObject->Tasks.TaskInfo;
		if(lpath[idPath]=="taskname")return &pObject->Tasks.TaskName;
		if(lpath[idPath]=="windowtitle")return &pObject->Tasks.WindowTitle;
		}
		else
		{
			if(lpath[idPath]=="minitextproperty")
			{
				idPath++;
				if(lpath[idPath]=="alias")return &pObject->Tasks.MiniTextProperty.Alias;
				if(lpath[idPath]=="backgroundpath")return &pObject->Tasks.MiniTextProperty.BackgroundPath;
				if(lpath[idPath]=="bold")return &pObject->Tasks.MiniTextProperty.Bold;
				if(lpath[idPath]=="fontblue")return &pObject->Tasks.MiniTextProperty.FontBlue;
				if(lpath[idPath]=="fontfamily")return &pObject->Tasks.MiniTextProperty.FontFamily;
				if(lpath[idPath]=="fontgreen")return &pObject->Tasks.MiniTextProperty.FontGreen;
				if(lpath[idPath]=="fontred")return &pObject->Tasks.MiniTextProperty.FontRed;
				if(lpath[idPath]=="fontsize")return &pObject->Tasks.MiniTextProperty.FontSize;
				if(lpath[idPath]=="italic")return &pObject->Tasks.MiniTextProperty.Italic;
				if(lpath[idPath]=="other")return &pObject->Tasks.MiniTextProperty.Other;
				if(lpath[idPath]=="otherbinaryvalue")return &pObject->Tasks.MiniTextProperty.OtherBinaryValue;
				if(lpath[idPath]=="weight")return &pObject->Tasks.MiniTextProperty.Weight;
				if(lpath[idPath]=="xpercentagedisplacement")return &pObject->Tasks.MiniTextProperty.XPercentageDisplacement;
				if(lpath[idPath]=="ypercentagedisplacement")return &pObject->Tasks.MiniTextProperty.YPercentageDisplacement;
			}
			if(lpath[idPath]=="classname")
			{
			}
			if(lpath[idPath]=="proces")
			{
			}
			if(lpath[idPath]=="taskinfo")
			{
			}
			if(lpath[idPath]=="taskname")
			{
			}
			if(lpath[idPath]=="windowtitle")
			{
			}
		}
	}

#ifdef ENABLE_STATS
	if(lpath[idPath]=="statistics")
	{
		//XSGObjectIconStatistics	Statistics;
	}
#endif
	return NULL;
}
void XEConfiguration::xSetConfigurationValue(const QString vpath, QString & vvalue)
{
	QString *pV=(QString *)xGetConfigurationPointer(vpath);
	if(pV!=NULL)*pV=vvalue;
}
void XEConfiguration::xSetConfigurationValue(const QString vpath, int &vvalue)
{
	int *pV=(int *)xGetConfigurationPointer(vpath);
	if(pV!=NULL)*pV=vvalue;
}


/*!
    \fn XEConfiguration::xEventInReloadIcon(int)
 */
void XEConfiguration::xEventInReloadIcon(int i)
{
	emit xEventReloadIcon(i);
}


/*!
    \fn XEConfiguration::xFindResource(const QString &, QString &)
 */
void XEConfiguration::xFindResource(const QString &rscType, QString &Original)
{
	if(rscType=="icon")
	{
		Original=xFindIconFile(Original);
		//kdWarning() <<"xFindResource("<<rscType<<","<<Original<<");\n";
	}
}


/*!
    \fn XEConfiguration::xFindIconFile(const QString &)
 */
QString XEConfiguration::xFindIconFile(const QString &logicName)
{
	// new Engine 12 Mar 2004
	// multi path for icons before lets kde chose
	QString imgFileNameLogic=logicName;
	// We like the png before svg?
	QString imgFileNameReal;
	QFile ifr(logicName);
	if(ifr.exists())return logicName;
	
	
	for(uint ifl=0;ifl<ActiveConfiguration.Theme.IconsPaths.count();ifl++)
	{
		// PNG
		imgFileNameReal=ActiveConfiguration.Theme.IconsPaths[ifl];
		//imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".png";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;
		
		// SVG
		imgFileNameReal=ActiveConfiguration.Theme.IconsPaths[ifl];
		//imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;

		// 0.36 all *
		imgFileNameReal=ActiveConfiguration.Theme.IconsPaths[ifl];
		//imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		//imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;
	}


	if(ifr.exists() && imgFileNameReal!=QString::null)return imgFileNameReal;


	// trying from kdestandard paths:
		// PNG
		imgFileNameReal=imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".png";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)return imgFileNameReal;

	/*
	if(imgFileNameReal==QString::null)
	{
		imgFileNameReal=imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".png";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
	}
	else return imgFileNameReal;

	if(imgFileNameReal==QString::null)
	{
		// SVG
		imgFileNameReal=imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
	}
	else return imgFileNameReal;

	if(imgFileNameReal==QString::null)
	{
		imgFileNameReal=imgFileNameLogic;
		//imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
	}
	else return "";
	*/
	return "";
}


/*!
    \fn XEConfiguration::iconAddSeparator()
 */
XSGObjectIcon * XEConfiguration::iconAddSeparator()
{
	XSGObjectIcon *addedCfg=iconAdd();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	addedCfg->Tasks.Proces.clear();
	addedCfg->Tasks.MiniTextShow=0;
	addedCfg->Info.fileName="";
	addedCfg->Info.Name=QString("AutoAddedSeparator%1").arg((long)addedCfg);
	addedCfg->Info.Group=
	addedCfg->Actions.onClickExec="";
	addedCfg->OverText="";
	addedCfg->Images.imgFileName="";
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.ClassName.clear();
	addedCfg->Tasks.WindowTitle.clear();
	addedCfg->Tasks.TaskName.clear();
	addedCfg->Tasks.Proces.clear();
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->Tasks.TaskInfo=NULL;
	addedCfg->TimeToLive=0;
	addedCfg->Tasks.MiniTextShow=0;
	addedCfg->Tasks.dcopReady=0;
	addedCfg->Tasks.forceRunning=0;
	addedCfg->Info.className="GSeparator";
	// we will not the icon to Rolling Icons because i don't like to save the added Separator
	//ActiveConfiguration.ObjectsIcons.append(addedCfg);
	// You must send this event to the docker as iconAdd
	//xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
	//createBackgroundSeparators();
	return addedCfg;
}


/*!
    \fn XEConfiguration::xLoadModuleTest(const QString &)
 */
int XEConfiguration::xLoadModuleTest(const QString &SOName)
{
	pPluginGenerator PluginGenerator;
	PluginGenerator=(pPluginGenerator)QLibrary::resolve(SOName,"xeplugin_register");
	if(PluginGenerator)
	{
		QObject *LoadedModule=PluginGenerator(XEObject::xGetRoot());
		if(LoadedModule!=NULL)
		{
		}
		return 1;
	}
	else
	{
		return 0;
	}
	return 0;
}


/*!
    \fn XEConfiguration::xParse(const QString &, int, void *)
 */
void XEConfiguration::xParse(const QString &action, int, void *)
{
	if(action.startsWith("xLoadModule("))
	{
		QString ModuleToLoad=action.mid(strlen("xLoadModule("));
		if(ModuleToLoad.length()>0&&ModuleToLoad[ModuleToLoad.length()-1]==')')
		{
			ModuleToLoad=ModuleToLoad.left(ModuleToLoad.length()-1);
		}
		kdWarning()<<"Trying to load: "<<ModuleToLoad<<"\n";
		xLoadModule(ModuleToLoad);
	}
}


/*!
    \fn XEConfiguration::xSwapIcons(int,int)
 */
void XEConfiguration::xSwapIcons(int a,int b)
{
	int c=ActiveConfiguration.ObjectsIcons.count();
	if(a==b|| a<0||b<0||a>=c||b>=c)return;
	XSGObjectIcon *pa=ActiveConfiguration.ObjectsIcons.at(a);
	XSGObjectIcon *pb=ActiveConfiguration.ObjectsIcons.at(b);
	if(pa==NULL || pb==NULL)return;
/*
	ActiveConfiguration.ObjectsIcons.remove(a);
	ActiveConfiguration.ObjectsIcons.remove(b);
	ActiveConfiguration.ObjectsIcons.insert(a,pb);
	ActiveConfiguration.ObjectsIcons.insert(b,pa);
*/
	// may be more stable
	ActiveConfiguration.ObjectsIcons.replace(a,pb);
	ActiveConfiguration.ObjectsIcons.replace(b,pa);
}
