/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GPLUGINPAINTER_H
#define GPLUGINPAINTER_H

/*--HEADERSTART--*/

const int DRAW_Pixmap		=0;
const int DRAW_GaugeHoriz	=1;
const int DRAW_GaugeVert	=2;
const int DRAW_GaugeVert2	=3;
const int DRAW_Text		=4;
const int DRAW_ImageFX		=5;

#include <qwidget.h>
#include <qrect.h>


class QImage;
class QPixmap;
class KImageEffect;

/**
@author Stefano Zingarini
*/
class gPluginPainter : public QWidget
{
Q_OBJECT
public:
    gPluginPainter(gPluginPainter *parent = 0, const char *name = 0, int type=0);
    ~gPluginPainter();
    void paint(QPixmap *);
    QImage setFX(QImage &, int,int,int,int);
    QImage setFXRotateX(QImage &,int);
    QImage setFXRotateY(QImage &,int);
    QImage setFXIntensity(QImage &,int);
    QImage setFXGray(QImage &);
	static int SizeBig;
//	KImageEffect *ImageEffect;
protected:
		QRect Zone;
		int Type;
		// custom var
		QPixmap *Pixmap;
		QString Value;
public slots:
    void setValue(const QString);
    void setRect(const QRect);
    void load(const QString);
};

/*--HEADERSTOP--*/


#endif
