/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "xeplugin_mouse.h"

#define XK_XKB_KEYS
#define XK_MISCELLANY
#include <X11/keysymdef.h>
#include <X11/Xlib.h>
#include <X11/extensions/XTest.h>


#include <xeobject.h>
#include <xeconfiguration.h>
#include <xgdocker.h>
#include <xgicon.h>
#include <qevent.h> 
#include <kapplication.h>
//#include <kmainwindow.h>
#include <qtimer.h>
#include <qmutex.h>
#include <stdlib.h>
#include <kdebug.h>

#include <kxdocker_setup_sources.h>
//#undef ENABLE_FINAL




extern "C" QObject *xeplugin_register(QObject *)
{
	const char NOME[]="xMouse";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_Mouse(NULL,NOME));
}



XEPlugin_Mouse::XEPlugin_Mouse(QObject *parent, const char *name)
 : QObject(parent, name)
{
	if(name!=NULL)XEObject::xPluginAdd(this);
	display = kapp->getDisplay();
	root = RootWindow(display,DefaultScreen(display));
	MouseTimer=new QTimer();
	PollingTimeout=100;
	MousePollingMutex=new QMutex();

	onBOTTOMLEFT="0";
	onBOTTOMRIGHT="0";
	onTOPLEFT="0";
	onTOPRIGHT="0";

	MonoGo=0;
	tMonoGo=new QTimer();
	connect(tMonoGo,SIGNAL(timeout()),this,SLOT(releaseKeyForNext()));


	iBOTTOMLEFT=0;
	iBOTTOMRIGHT=0;
	iTOPLEFT=11;
	iTOPRIGHT=12;
}


XEPlugin_Mouse::~XEPlugin_Mouse()
{
	XEObject::xPluginDel(this);
}


#include "xeplugin_mouse.moc"

/*!
    \fn XEPlugin_Mouse::xSetup()
 */
void XEPlugin_Mouse::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("Mouse::xSetup");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	xGDockerWindow=(QWidget *)xGDocker;
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

}


/*!
    \fn XEPlugin_Mouse::xStart()
 */
void XEPlugin_Mouse::xStart()
{
#ifndef ENABLE_FINAL
	qWarning("Mouse::xStart");
#endif
	connect(xGDocker,SIGNAL(xEventMouseMoved(int,int)),
		this,SLOT(xEventMouseMoved(int,int)));
	
	connect(xGDocker,SIGNAL(xEventDockerHidden()),
		this,SLOT(xEventDockerHidden()));
	
	connect(xGDocker,SIGNAL(xEventDockerSendToBackground()),this,SLOT(xEventDockerSendToBackground()));
	connect(MouseTimer,SIGNAL(timeout()),this,SLOT(stepMouseTracking()));
	/*
	connect(this,SIGNAL(xGetWidget(QWidget*& )),
		xGDocker,SLOT(xGetWidget(QWidget*& )));
	*/
	connect(this,SIGNAL(mouseMoveSoftware(int, int )),
		xGDocker,SLOT(xMouseMoveSoftware(int, int )));
	//xGetWidget(xGDockerWindow);

	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xMouse")
		{

		if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
		{
			onBOTTOMRIGHT=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onBOTTOMRIGHT", "0");
			onTOPLEFT=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onTOPLEFT", "0");
			onTOPRIGHT=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onTOPRIGHT", "0");
			onBOTTOMLEFT=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onBOTTOMLEFT", "0");
			bool okRet=false;
			iBOTTOMRIGHT=onBOTTOMRIGHT.toInt(&okRet);
			iTOPRIGHT=onTOPRIGHT.toInt(&okRet);
			iBOTTOMLEFT=onBOTTOMLEFT.toInt(&okRet);
			iTOPLEFT=onTOPLEFT.toInt(&okRet);
		}
	else
		{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
		
		}
		
		break;
		}
	}
}


/*!
    \fn XEPlugin_Mouse::xStop()
 */
void XEPlugin_Mouse::xStop()
{
	MousePollingMutex->tryLock();
}


/*!
    \fn XEPlugin_Mouse::xEventMouseMoved(int x, int y, int button)
 */
void XEPlugin_Mouse::xEventMouseMoved(int nx,int ny)
{
	x=nx;
	y=ny;
#ifndef ENABLE_FINAL
	qWarning("MouseTracking");
#endif
	stepMouseTimer();
	
}


/*!
    \fn XEPlugin_Mouse::stepMouseTimer()
 */
void XEPlugin_Mouse::stepMouseTimer()
{
	if(MousePollingMutex->tryLock()==false)return;
	QPoint pos, mouse, vect;
	int WinX, WinY;
	int XCoord,YCoord;
	XQueryPointer(display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
	//mouse = xGDocker->mapFromGlobal(QPoint(XCoord,YCoord));
	mouse = xGDockerWindow->mapFromGlobal(QPoint(XCoord,YCoord));
	//if(mouse.x()==x||mouse.y()==y)return;
	if(mouse.y()>=0)
	{
		MousePollingMutex->unlock();
		return;
	}
	mouseMoveSoftware(mouse.x(),mouse.y());
//	xGDocker->mouseMoveSoftware(mouse.x(),mouse.y());
#ifndef ENABLE_FINAL
	qWarning("MouseTracking:End");
#endif
	MousePollingMutex->unlock();
	
}

/*!
    \fn XEPlugin_Mouse::xEventDockerSendToBackground()
 */
void XEPlugin_Mouse::xEventDockerSendToBackground()
{
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Mouse::xEventDockerHidden()");
#endif
	// TODO: we have to do only ontop :)
	// but we have to manage a better mutex
	if(!MouseTimer->isActive())
	{
		while(MousePollingMutex->tryLock());
		MousePollingMutex->unlock();
	
		MouseTimer->start(PollingTimeout);
	}
	//stepMouseTracking();
}


/*!
    \fn XEPlugin_Mouse::xEventDockerHidden()
 */
void XEPlugin_Mouse::xEventDockerHidden()
{
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Mouse::xEventDockerHidden()");
#endif
	if(!MouseTimer->isActive())
	{
		while(MousePollingMutex->tryLock());
		MousePollingMutex->unlock();
	
		MouseTimer->start(PollingTimeout);
	}
	//stepMouseTracking();
}


/*!
    \fn XEPlugin_Mouse::stepMouseTracking()
 */
void XEPlugin_Mouse::stepMouseTracking()
{
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Mouse::stepMouseTracking()");
#endif
	
	static int CountStep=0;
	static int PollingConversion=ActiveConfiguration->Window.SendToForgroundTimeout/PollingTimeout;

	// 0.22 support send to background which is not compatible with this!
	//if(xGDocker->getRaised()>0 || !xGDocker->isHidden())return;
	//0.27
	/*
	if(xGDocker->getRaised()>0 )return;
	if(MousePollingMutex->tryLock()==false)return;
	*/
	if(xGDocker->getRaised()>0 ||MousePollingMutex->tryLock()==false)
	{
		MouseTimer->stop();
		return;
	}
	
	
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Mouse::stepMouseTracking() 179");
#endif

	// 0.28
	// TODO: this work only on bottom
	XGIcon *borderIcons;
	int CoordsXIconsStop=ActiveConfiguration->Window.Width;
	int CoordsXIconsStart=0;
	// first icon
	borderIcons=xGDocker->xGetPointerObjectIcon(0);
	if(borderIcons!=NULL)CoordsXIconsStart=borderIcons->xPosDefault.x()-(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	// last icon
	borderIcons=xGDocker->xGetPointerObjectIcon(ActiveConfiguration->ObjectsIcons.count()-1);
	if(borderIcons!=NULL)CoordsXIconsStop=borderIcons->xPosDefault.x()+(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	
	
	
	QPoint pos, mouse, vect;
	int WinX, WinY;
	int XCoord,YCoord;
	XQueryPointer(display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
	checkForExpose( XCoord,YCoord);
	
	mouse = xGDocker->mapFromGlobal(QPoint(XCoord,YCoord));
	
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Mouse::stepMouseTracking() 190");
#endif
	if(strcmp(ActiveConfiguration->Window.Align,"bottom")==0)
	{
		// idea from georg
		// raise the bar only if there are 2 corner
		int MouseIsOk=0;
		
		if(ActiveConfiguration->Window.HideMouseCornerRight)
		{
		if(XCoord>=
		QApplication::desktop()->width()-
		ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;

		}
		if(ActiveConfiguration->Window.HideMouseCornerLeft)
		{
		if(XCoord<=
		ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;
		}
		if(
		(YCoord>=
		QApplication::desktop()->height()-
		ActiveConfiguration->Window.HideMouseEdge
		)
		&&
		(mouse.x()>=CoordsXIconsStart)
		&&
		(mouse.x()<=CoordsXIconsStop)
		// 0.28 patch enable only if you are over the icons
		)
		{
			MouseIsOk++;

		}
		else MouseIsOk--;

		if(MouseIsOk>0)
		{
				
			if(CountStep<PollingConversion)CountStep++;
			else
			{
			CountStep=0;
			// ok than we have to raise the widget!
			// 0.27
#ifndef ENABLE_FINAL
			qWarning("MouseTracking: xGDocker->showRaised();");
#endif
			MouseTimer->stop();
			xGDocker->xEventShowRaised();
			//xGDocker->show();
#ifndef ENABLE_FINAL
			qWarning("MouseTracking:End RAISED!!!");
#endif
			//MousePollingMutex->unlock();
			return;
			}

		}
		else CountStep=0;

	}
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Mouse::stepMouseTracking() 253");
#endif

/*
	if(strcmp(ActiveConfiguration->Window.Align,"top")==0)
	{
		// idea from georg
		// raise the bar only if there are 2 corner
		int MouseIsOk=0;
		
		if(ActiveConfiguration->Window.HideMouseCornerRight)
		{
		if(XCoord>=
		QApplication::desktop()->width()-
		ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;
		
		}
		if(ActiveConfiguration->Window.HideMouseCornerLeft)
		{
		if(XCoord<=
		ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;
		
		}

		if(YCoord<=ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;

		if(MouseIsOk>0)
		{
			if(CountStep<PollingConversion)CountStep++;
			else
			{
			CountStep=0;
			// 0.27
#ifndef ENABLE_FINAL
			qWarning("MouseTracking: xGDocker->showRaised();");
#endif
			MouseTimer->stop();
			xGDocker->xEventShowRaised();
			//xGDocker->show();
#ifndef ENABLE_FINAL
			qWarning("MouseTracking:End RAISED!!!");
#endif
			//MousePollingMutex->unlock();
			return;
			}
		}
		else CountStep=0;

	}
*/

	if(strcmp(ActiveConfiguration->Window.Align,"top")==0)
	{
		// idea from georg
		// raise the bar only if there are 2 corner
		int MouseIsOk=0;
		
		if(ActiveConfiguration->Window.HideMouseCornerRight)
		{
		if(XCoord>=
		QApplication::desktop()->width()-
		ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;

		}
		if(ActiveConfiguration->Window.HideMouseCornerLeft)
		{
		if(XCoord<=
		ActiveConfiguration->Window.HideMouseEdge
		)
		{
			MouseIsOk++;
		}
		else MouseIsOk--;
		}
		if(
		(YCoord<=ActiveConfiguration->Window.HideMouseEdge
		)
		&&
		(mouse.x()>=CoordsXIconsStart)
		&&
		(mouse.x()<=CoordsXIconsStop)
		// 0.28 patch enable only if you are over the icons
		)
		{
			MouseIsOk++;

		}
		else MouseIsOk--;

		if(MouseIsOk>0)
		{
				
			if(CountStep<PollingConversion)CountStep++;
			else
			{
			CountStep=0;
			// ok than we have to raise the widget!
			// 0.27
#ifndef ENABLE_FINAL
			qWarning("MouseTracking: xGDocker->showRaised();");
#endif
			MouseTimer->stop();
			xGDocker->xEventShowRaised();
			//xGDocker->show();
#ifndef ENABLE_FINAL
			qWarning("MouseTracking:End RAISED!!!");
#endif
			//MousePollingMutex->unlock();
			return;
			}

		}
		else CountStep=0;

	}

#ifndef ENABLE_FINAL
	qWarning("MouseTracking:End 317");
#endif
	//QTimer::singleShot(PollingTimeout,this,SLOT(stepMouseTracking()));
	MousePollingMutex->unlock();
}
void XEPlugin_Mouse::xGetParameter(const QString sName,QString&sValue)
{
	if(sName=="onTOPLEFT")
	{
		sValue=(onTOPLEFT);
	}
	if(sName=="onTOPRIGHT")
	{
		sValue=(onTOPRIGHT);
	}
	if(sName=="onBOTTOMLEFT")
	{
		sValue=(onBOTTOMLEFT);
	}
	if(sName=="onBOTTOMRIGHT")
	{
		sValue=(onBOTTOMRIGHT);
	}
}

void XEPlugin_Mouse::xGetParameterList(QStringList*a)
{
	a->append("onBOTTOMRIGHT");
	a->append("onTOPRIGHT");
	a->append("onTOPLEFT");
	a->append("onBOTTOMLEFT");
}


/*!
    \fn XEPlugin_Mouse::xSetupParameter(const QString sName,const QString sValue)
 */
void XEPlugin_Mouse::xSetupParameter(const QString sName,const QString sValue)
{
	bool okRet=false;
	if(sName=="onBOTTOMLEFT")
	{
		onBOTTOMLEFT=sValue;
		iBOTTOMLEFT=sValue.toInt(&okRet);
		if(!okRet)
		{
			iBOTTOMLEFT=0;
			onBOTTOMLEFT="0";
		}
	}
	if(sName=="onTOPLEFT")
	{
		onTOPLEFT=sValue;
		iTOPLEFT=sValue.toInt(&okRet);
		if(!okRet)
		{
			iTOPLEFT=0;
			onTOPLEFT="0";
		}
	}
	if(sName=="onBOTTOMRIGHT")
	{
		onBOTTOMRIGHT=sValue;
		iBOTTOMRIGHT=sValue.toInt(&okRet);
		if(!okRet)
		{
			iBOTTOMRIGHT=0;
			onBOTTOMRIGHT="0";
		}
	}
	if(sName=="onTOPRIGHT")
	{
		onTOPRIGHT=sValue;
		iTOPRIGHT=sValue.toInt(&okRet);
		if(!okRet)
		{
			iTOPRIGHT=0;
			onTOPRIGHT="0";
		}

	}
	updateCfg(sName,sValue);
}


/*!
    \fn XEPlugin_Mouse::updateCfg(const QString, const QString)
 */
void XEPlugin_Mouse::updateCfg(const QString a, const QString b)
{
		for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xMouse")
			{
			// update xml configuration
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
			(a,b);
			}
	
		}
}


/*!
    \fn XEPlugin_Mouse::sendKeyToX11(int)
 */
void XEPlugin_Mouse::sendKeyToX11(uint displace)
{
	//qWarning("Monogo!");
	if(MonoGo)return;
	//tMonoGo->stop();
	const uint baseF1=XK_F1-1;
    /// @todo implement me
	displace=baseF1+displace;
    Display* pDisplay = XOpenDisplay( NULL );
//Display* pDisplay = x11AppDisplay();
    if( pDisplay == NULL )return;

    XTestFakeKeyEvent ( pDisplay, XKeysymToKeycode( pDisplay, displace ),True, CurrentTime );
	// issue on latest Compiz
    XTestFakeKeyEvent ( pDisplay, XKeysymToKeycode( pDisplay, displace ),False, CurrentTime );

    XCloseDisplay(pDisplay);
	MonoGo++;
	tMonoGo->start(500);
}


/*!
    \fn XEPlugin_Mouse::checkForExpose(int,int)
 */
void XEPlugin_Mouse::checkForExpose(int XCoord,int YCoord)
{
	//qWarning(QString("[%1][%1]").arg(XCoord).arg(YCoord));
	static int LastXCoord=0;
	static int LastYCoord=0;
	if(LastXCoord==XCoord && LastYCoord==YCoord)return;
	LastXCoord=XCoord;
	LastYCoord=YCoord;
	if(XCoord<=1)
	{
		if(YCoord<=1)
		{
			if(iTOPLEFT)
			{
				sendKeyToX11(iTOPLEFT);
			}
		}
		else if(YCoord>=QApplication::desktop()->height()-1)
		{
			if(iBOTTOMLEFT)
			{
				sendKeyToX11(iBOTTOMLEFT);
			}
		}
	}
	else if(XCoord>=QApplication::desktop()->width()-1)
		{
			if(YCoord<=1)
			{
				if(iTOPRIGHT)
				{
					sendKeyToX11(iTOPRIGHT);
				}
			}
			else if(YCoord>=QApplication::desktop()->height()-1)
			{
				if(iBOTTOMRIGHT)
				{
					sendKeyToX11(iBOTTOMRIGHT);
				}
			}
	}
}


/*!
    \fn XEPlugin_Mouse::releaseKeyForNext()
 */
void XEPlugin_Mouse::releaseKeyForNext()
{
	tMonoGo->stop();
	MonoGo=0;
}


/*!
    \fn XEPlugin_Mouse::xGetInfo(QStringList &)
 */
void XEPlugin_Mouse::xGetInfo(QStringList &PluginInformations)
{
	PluginInformations.append("KXDocker Mouse");
	// version
	PluginInformations.append(KXDOCKERVERSION);
	// date
	PluginInformations.append(KXDOCKERDATE);
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php"));
}
