/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_animator.h"
#include <kdebug.h>
#include <xeobject.h>
#include <qwidget.h>
#include <qtimer.h>
#include <kwin.h>
#include <xgfloater.h>
#include <time.h>
#include <kxdocker_setup_sources.h>
#include <xgicon.h>
#include <xgdocker.h>
#include <xeconfiguration.h>

// #undef ENABLE_FINAL
extern QImage *setIntensity(class QImage &,double);


extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="xAnimator";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_Animator(parent,NOME));
}

#include "xeplugin_animator.moc"


/*!
    \fn XEPlugin_Animator::xParse(const QString &, int, void *)
 */
void XEPlugin_Animator::xParse(const QString &opType, int iconIndex, void *pointer)
{
	if(opType=="xAnimateBounce")
	{
		XGIcon *ic=xGDocker->xGetPointerObjectIcon(iconIndex);
		if(ic)xAnimateBounce(ic);
	}
	if(opType=="xStartAnimate")
	{
		XGIcon *ic=xGDocker->xGetPointerObjectIcon(iconIndex);
		if(ic)xStartAnimate(ic);
	}
	if(opType=="xStopAnimate")
	{
		//XGIcon *ic=xGDocker->xGetPointerObjectIcon(iconIndex);
		//if(ic)xStopAnimate(ic);
		xStopAnimate();
	}
}



XEPlugin_Animator::XEPlugin_Animator(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xPluginAdd(this);
	animatorCounter=0;
	BounceHigh=15;
	LocalDetachedWindow=NULL;
	bounceTimer=new QTimer(this);
	connect(bounceTimer,SIGNAL(timeout()),this,SLOT(xAnimateStepBounce()));
	bounceDetachedTimer=new QTimer(this);
	connect(bounceDetachedTimer,SIGNAL(timeout()),this,SLOT(xAnimateStepBounceDetached()));
	fadeTimer=new QTimer(this);
	connect(fadeTimer,SIGNAL(timeout()),this,SLOT(xAnimateStepFadeIcon()));
	overlayPollTimer=new QTimer(this);
	connect(overlayPollTimer,SIGNAL(timeout()),this,SLOT(xAnimateStepOverlay()));

	highlightAnimation=1;
}


XEPlugin_Animator::~XEPlugin_Animator()
{
	XEObject::xPluginDel( this);
}




/*!
    \fn XEPlugin_Animator::xSetup
 */
void XEPlugin_Animator::xSetup()
{
#ifndef ENABLE_FINAL
	qWarning("Animator::xSetup");
#endif
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

	onClickAnimation="bouncelong";
	onRaiseAnimation="bounce";
	onCloseAnimation="poof";
	onHideAnimation="slide";
	onShowAnimation="slide";
	onAddAnimation="fade";
	onSlideAnimation="slide";
	highlightAnimation=1;

	req.tv_nsec=ActiveConfiguration->Engine.SleepAnimations;
	req.tv_sec=0;

}


/*!
    \fn XEPlugin_Animator::xEventMouseClick(int,int,int,int)
 */
void XEPlugin_Animator::xEventMouseClick(int icon,int ,int ,int button)
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Animator::xEventMouseClick(int icon,int ,int ,int button)");
#endif
	if(icon<0)return;
	uint TargetIcon=(uint)icon;
	if(TargetIcon>=ActiveConfiguration->ObjectsIcons.count())return;
#ifndef ENABLE_FINAL
	qWarning("xeplugin_animator.cpp:67");
#endif

	if(button!=Qt::LeftButton)return;

	// 0.38 with inverted mask animations
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.iAnimationMask&1)return;
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.onClickExec.startsWith("kxdocker:/",false))return;
	
	//0.25 patch
	// this will not animate a separator
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.className=="GSeparator")return;
	
	// 0.32
	// with plugin click we dont bounce
	XGIcon *target=xGDocker->xGetPointerObjectIcon(TargetIcon);
	if(target!=NULL	&& target->xEnabledClickClass())
	{
		return;
	}
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks.TaskInfo==NULL)
	{
//qWarning("209");
		if(onClickAnimation=="bouncelong"
		// We check if we may trace the window, not all has got the dcop or task interface configured so:
			&&
			ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Tasks.WindowTitle.count()>0
		)
		{
//qWarning("216");
			xStartAnimate(this->xGDocker->xGetPointerObjectIcon(TargetIcon));
		}
		else
			if(onClickAnimation=="bounce")
			{
//qWarning("222");
				xAnimateBounce(xGDocker->xGetPointerObjectIcon(TargetIcon));
			}
		else
			if(onClickAnimation=="overlay")
			{
//qWarning("228");
				xAnimateOverlay(xGDocker->xGetPointerObjectIcon(TargetIcon));
			}
//qWarning("231");
	}
	else
	{
		xAnimateMicro(xGDocker->xGetPointerObjectIcon(TargetIcon));
	}

	// 0.40
	emit xEventStartAnimating(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.Name);
}


/*!
    \fn XEPlugin_Animator::xStop()
 */
void XEPlugin_Animator::xStop()
{
	//if(AnimationsMutex.tryLock()==false)return;
	AnimationsMutex.tryLock();
}


/*!
    \fn XEPlugin_Animator::xStart()
 */
void XEPlugin_Animator::xStart()
{
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Animator::xStart() [97]");
#endif
	// 0.39
	connect(xGDocker,SIGNAL(xEventHighlightIcon(int, void* )),this,SLOT(xEventHighlightIcon(int, void* )));

	// 0.27
	connect(xGDocker,SIGNAL(xEventDockerShowed()),this,SLOT(xEventDockerShowed()));
	connect(xGDocker,SIGNAL(xEventDockerHidden()),this,SLOT(xEventDockerHidden()));
	// 0.38
	connect(xGDocker,SIGNAL(xEventAddedIcon(int)),this,SLOT(xEventIconAdded(int)));

	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
#ifndef ENABLE_FINAL
		qWarning(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name);
#endif
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
#ifndef ENABLE_FINAL
		qWarning("void XEPlugin_Animator::xStart() parsing xml configuration");
#endif
		if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
		{
#ifndef ENABLE_FINAL
			qWarning("parsing...");
			qWarning(
ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickAnimation")
			);
#endif
			
			onClickAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickAnimation", "bouncelong");
			onRaiseAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onRaiseAnimation", "micro");
			onCloseAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onCloseAnimation", "poof");
			onAddAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onAddAnimation", "fade");
			onSlideAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onSlideAnimation", "slide");
			onHideAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onHideAnimation", "slide");
			onShowAnimation=
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onShowAnimation", "slide");
			bool okRet=false;
			QString vvalue=
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("BounceHigh", "10");
			BounceHigh=vvalue.toInt(&okRet);
			highlightAnimation=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("highlightAnimation", "1").toInt(&okRet);

		}
		else
		{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
		
		}
		
		break;
		}
	
	}
	
	//if(onClickAnimation=="bounce")
	// 0.38
	connect(xGDocker,SIGNAL(xEventMouseClick(int,int,int,int)),this,SLOT(xEventMouseClick(int,int,int,int)));

	if(onSlideAnimation=="slide")connect(xGDocker,SIGNAL(xEventWidgetBeforeMoved(int, int, int, int, int, int, int, int )),this,SLOT(xAnimateDockerSlideRight(int,int,int,int,int,int,int,int)));


	//if(onClickAnimation=="bouncelong")
	//connect(xGDocker,SIGNAL(xEventMouseClick(int,int,int,int)),
	//	this,SLOT(xEventMouseClick(int,int,int,int)));
	// 0.40
	connect(Configurator,SIGNAL(xEventRemovingIcon(int,int)),this,SLOT(xEventRemovingIcon(int,int)));

	connect(xGDocker,SIGNAL(xEventReset(int,int)),this,SLOT(xEventReset(int,int)));
	connect(xGDocker,SIGNAL(xEventAnimateTo(int,int,int,int)),this,SLOT(xEventAnimateTo(int,int,int,int)));

	QObject *TaskManager=XEObject::xFindObject("xTaskManager");
	if(TaskManager!=NULL)
	{
		connect(TaskManager,SIGNAL(xEventTaskOpen(int)),this,SLOT(xEventTaskOpen(int)));
		connect(TaskManager,SIGNAL(xEventStartAnimating(int)),this,SLOT(xEventStartupAdded( int )));
		connect(TaskManager,SIGNAL(xEventStopAnimating(int)),this,SLOT(xEventStartupRemoved( int )));
		connect(TaskManager,SIGNAL(xEventTaskClosed(int)),this,SLOT(xEventTaskClosed(int)));
	}
	lastIcon=NULL;
	mouse.setX(0);
	mouse.setY(0);
	mousef.setX(0);
	mousef.setY(0);
	moltiplier=0;
	lastRaise=0;
	AnimationsMutex.unlock();
	
}


/*!
    \fn XEPlugin_Animator::xAnimateBounce(XGIcon *)
 */
void XEPlugin_Animator::xAnimateBounce(XGIcon *Icon)
{

	//xGDocker->isAnimating=0;
	if(AnimationsMutex.tryLock()==false)return;
	//AnimationsMutex.lock();
	lastIcon=Icon;
	mousef.setY(Icon->xPosition.y());
	mouse.setX(xGDocker->xLastX);
	mouse.setY(xGDocker->xLastY);
	//xAnimateStepBounce();
	//xAnimateStepBounceDetached();
	this->radians=0;
	/*
	if((mouse.y()-BounceHigh)<0)xAnimateStepBounceDetached();
	else xAnimateStepBounce();
	*/
	/*
	if((mouse.y()-BounceHigh)<0)bounceDetachedTimer->start(ActiveConfiguration->Engine.SleepAnimations/10);
	else bounceTimer->start(ActiveConfiguration->Engine.SleepAnimations/10);
	*/
	bounceDetachedTimer->start(ActiveConfiguration->Engine.SleepAnimations/10);
}


/*!
    \fn XEPlugin_Animator::xEventTaskOpen(int)
 */
void XEPlugin_Animator::xEventTaskOpen(int icon)
{
	//if(AnimationsMutex.tryLock()==false)return;
#ifndef ENABLE_FINAL
	char pippo[50];
	sprintf(pippo,"void XEPlugin_Animator::xEventTaskOpen(int %d)",icon);
	qWarning(pippo);
#endif
	if(icon<0)return;
	const uint TargetIcon=(uint)icon;
	if(TargetIcon>=ActiveConfiguration->ObjectsIcons.count())return;

	// 0.40
	emit xEventStopAnimating(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.Name);

	// 0.38 with inverted mask animations
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.iAnimationMask&1<<1)return;

	if(onRaiseAnimation=="bounce")xAnimateBounce(xGDocker->xGetPointerObjectIcon(TargetIcon));
	if(onRaiseAnimation=="micro")xAnimateMicro(xGDocker->xGetPointerObjectIcon(icon));
}


/*!
    \fn XEPlugin_Animator::xEventReset()
 */
void XEPlugin_Animator::xEventReset(int x, int y)
{
	if(AnimationsMutex.tryLock()==false)return;
#ifndef ENABLE_FINAL
	qWarning("Animating reset");
#endif
	
	
	mouse.setX(x);
	mouse.setY(y);
	xGDocker->isAnimating=1;
	moltiplier=1;
	xAnimate();
}


/*!
    \fn XEPlugin_Animator::xAnimate(int)
 */
void XEPlugin_Animator::xAnimate()
{
	// 0.27 code clean
	//timespec req,   rem;
	//req.tv_nsec=ActiveConfiguration->Engine.SleepAnimations;
	
	if(xGDocker->getRaised()&&xGDocker->xLastX==mouse.x()&&xGDocker->xLastY==mouse.y())
	{
		mouse.setY(mouse.y()-moltiplier);
		moltiplier++;
		//QMouseEvent e(QEvent::MouseMove,mouse,0,0);
		//xGDocker->mouseMoveEventSW(&e);
		xGDocker->mouseMoveEventSW(mouse.x(),mouse.y());
		xGDocker->xUpdate();
		//nanosleep(&req,&rem);
		//QTimer::singleShot(0,this,SLOT(xAnimate()));
		xGDocker->repaint(false);
		xAnimate();
	}
	else
	{
		xGDocker->isAnimating=0;
		
		AnimationsMutex.unlock();
	}
}


/*!
    \fn XEPlugin_Animator::xEventAnimateTo(int,int,int,int)
 */
void XEPlugin_Animator::xEventAnimateTo(int x,int y,int fx,int fy)
{
	//if(AnimationsMutex.tryLock()==false)return;
#ifndef ENABLE_FINAL
	qWarning("undoreset start");
#endif
	mouse.setX(x);
	mouse.setY(y);
	mousef.setX(fx);
	mousef.setY(fy);
	xGDocker->isAnimating=1;
	moltiplier=1;

	xAnimateTo();
}


/*!
    \fn XEPlugin_Animator::xAnimateTo()
 */
void XEPlugin_Animator::xAnimateTo()
{
//	timespec req,   rem;
//	req.tv_nsec=ActiveConfiguration->Engine.SleepAnimations;
	//qWarning("undoreset polling");
	if(
	xGDocker->xLastX<mousef.x()+20&&xGDocker->xLastX>mousef.x()-20 &&
	xGDocker->xLastY<mousef.y()+20&&xGDocker->xLastY>mousef.y()-20)
	{
		if(mousef.y()<=mouse.y())
		{
			mousef.setY(mousef.y()+moltiplier);
			moltiplier++;
			//QMouseEvent e(QEvent::MouseMove,mousef,0,0);
			//xGDocker->mouseMoveEventSW(&e);
			//mouseMoveEventSW(int x,int y,int force,Qt::ButtonState button)
			xGDocker->mouseMoveEventSW(mousef.x(),mousef.y());
			xGDocker->xUpdate();
			xGDocker->repaint(false);
			//nanosleep(&req,&rem);
			
			QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations/10
				,this,SLOT(xAnimateTo()));
				
			//xAnimateTo();
		}
	}
	else
	{
		xGDocker->isAnimating=0;
		AnimationsMutex.unlock();

	}
}


/*!
    \fn XEPlugin_Animator::xAnimateBounce(XGIcon *Icon)
 */
void XEPlugin_Animator::xAnimateMicro(XGIcon *Icon)
{
	if(AnimationsMutex.tryLock()==false)return;
	//AnimationsMutex.lock();
#ifndef ENABLE_FINAL
	qWarning("Animate::Micro");
#endif
	if(Icon==NULL)return;
#ifndef ENABLE_FINAL
	qWarning("Animate::Micro 311");
#endif
	//xGDocker->isAnimating=0;
	lastIcon=Icon;
	mousef.setY(Icon->xPosition.y());
	mousef.setX(Icon->xPosition.x());
	mouse.setX(xGDocker->xLastX);
	mouse.setY(xGDocker->xLastY);
	moltiplier=Icon->xZoom;
	lastRaise=xGDocker->getRaised();
#ifndef ENABLE_FINAL
	qWarning("Animate::Micro 319");
#endif
	xAnimateStepMicro();
#ifndef ENABLE_FINAL
	qWarning("Animate::Micro 321");
#endif
	
	return;
}


/*!
    \fn XEPlugin_Animator::xEventRemoveIcon(int)
 */
void XEPlugin_Animator::xEventRemoveIcon(int icon)
{
	if(icon<0)return;
	const uint TargetIcon=(uint)icon;
	if(TargetIcon>=ActiveConfiguration->ObjectsIcons.count())return;
	// 0.38 with inverted mask animations
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.iAnimationMask&1<<2)return;
	if(AnimationsMutex.tryLock()==false)return;
	XGIcon *Icon=xGDocker->xGetPointerObjectIcon(icon);
	int lastz=Icon->xZoom;
	QImage Poof=Icon->Poof;
	if(Poof.isNull())
	{
		Poof=ActiveConfiguration->Theme.Poof;
	}
#ifndef ENABLE_FINAL
	char pippo[50];
	sprintf(pippo,"Poof: %d %d %d",
		lastz,
		Poof.width(),
		Poof.height());
#else
#endif
	Poof=Poof.smoothScale(lastz,lastz,QImage::ScaleMax);
#ifndef ENABLE_FINAL
	qWarning(pippo);
	sprintf(pippo,"Poof Size: %d %d",
		lastz,
		Poof.width(),
		Poof.height());
	// now paint this
	qWarning(pippo);
#endif
	QImage RenderBuffer,Rendered;
	RenderBuffer.create(lastz,lastz,32);
	RenderBuffer.setAlphaBuffer(false);
	RenderBuffer.fill(0);
	RenderBuffer.setAlphaBuffer(true);
	for(int i=0;i*lastz<Poof.height();i=i+1)
	{
		Rendered.reset();
		Rendered=RenderBuffer.copy();
		bitBlt(&Rendered,0,0,&Poof,0,i*lastz,lastz,lastz);
		Icon->xImgShowed=Rendered;
		//xGDocker->xDockerRedraw(lastIcon);
		xGDocker->xDockerRedraw(Icon);
		//xGDocker->xUpdate();
		//xGDocker->repaint(false);
		//req*10);
		//usleep(ActiveConfiguration->Engine.SleepAnimations*100);
		nanosleep(&req,&rem);
		nanosleep(&req,&rem);
		nanosleep(&req,&rem);
#ifndef ENABLE_FINAL
		qWarning("Poof Animations !!!");
#endif

	}
#ifndef ENABLE_FINAL
	qWarning("Poof End");
#endif
	//Icon->xSetUpdate=1;
	Icon->xZoom=0;
	Icon->xSetZoom(lastz);
	AnimationsMutex.unlock();
	
}


/*!
    \fn XEPlugin_Animator::xAnimateStepBounce()
 */
void XEPlugin_Animator::xAnimateStepBounce()
{
	//qWarning("Animate::Bounce Step!");
	bounceTimer->stop();
	bounceDetachedTimer->stop();
	if(lastIcon==NULL)
	{
		if(LocalDetachedWindow!=NULL)LocalDetachedWindow->hide();
		return;
	}

	if(xGDocker->xGetIconIndex(lastIcon)<0)
	{
		if(LocalDetachedWindow!=NULL)LocalDetachedWindow->hide();
		return;
	}

	
	const double radr=6.28/360;
	const double rfine=radr*360;
	double acc;
	static double radians=0;
	int lasty=mousef.y();

	
	if(radians<rfine
	&&
	xGDocker->xLastX==mouse.x()
	&&
	!xGDocker->isAnimating
//	&&
//	xGDocker->getRaised()
	&&
	xGDocker->xLastY==mouse.y())
	{
		radians=radians+radr*8;
		acc=1.1/(0.1+sin(radians)*sin(radians));
		lastIcon->xPosition.setY(
		int(
		lasty-sin(radians)*15*acc*sin(radians)
		)
		);
		//xGDocker->xUpdate();
		// new engine 20040611
		// let's redraw only 1 icon :)
		xGDocker->xDockerRedraw(lastIcon);
		//xGDocker->repaint(false);
		bounceTimer->start(ActiveConfiguration->Engine.SleepAnimations/10);
		/*
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations/10
				,this,SLOT(xAnimateStepBounce()));
		*/

	}
	else
	{
		if(radians>=rfine)lastIcon->xPosition.setY(lasty);
		
		radians=0;
#ifndef ENABLE_FINAL
		qWarning("Interrotta animazione! 2");
#endif
#ifdef ENABLE_SPECIALENGINE2
		if(0)
#else
#ifdef ENABLE_FINAL		
		qWarning("2");
#endif
		if(xGDocker->isAnimating)// ||!xGDocker->getRaised())
#endif
		{
#ifndef ENABLE_FINAL
			qWarning("Interrotta animazione! 1");
#endif
			AnimationsMutex.unlock();

			return;
		}
#ifndef ENABLE_FINAL		
		qWarning("lastIcon->xPosition.setY(lasty);");
#endif
		lastIcon->xPosition.setY(lasty);
		//xGDocker->isAnimating=0;
		//xGDocker->xUpdate();
#ifdef ENABLE_SPECIALENGINE2
		// isAnimating is useful but on sp2 the  are not right than we ask to redraw all :(
		qWarning("sp2 enabled");
		xGDocker->mouseMoveEventSW(xGDocker->xLastX,xGDocker->xLastY,1);
#else
		xGDocker->xDockerRedraw(lastIcon);
#endif
		//xGDocker->repaint(false);
		AnimationsMutex.unlock();
		
	}
	
}


/*!
    \fn XEPlugin_Animator::xAnimateStepMicro()
 */
void XEPlugin_Animator::xAnimateStepMicro()
{
	
	
#ifndef ENABLE_FINAL
	qWarning("Animate::Bounce Step!");
 #endif
	if(lastIcon==NULL){
		AnimationsMutex.unlock();
		return;
	}
	if(xGDocker->xGetIconIndex(lastIcon)<0)
	{
		AnimationsMutex.unlock();
		return;
	}
	if(lastIcon->hidden)
	{
		AnimationsMutex.unlock();
		return;
	}
	
	static int i=0;
	int lasty=mousef.y();
	int lastx=mousef.x();
	int lastZoom=moltiplier;
	
	
	if(i<16 && (lastZoom-i*2)>3
	&&
	lastIcon->xZoom==(lastZoom-i*2)
	&&
	!xGDocker->isAnimating
	&&
	xGDocker->getRaised()==lastRaise
	&&
	xGDocker->xLastX==mouse.x()
	&&
	xGDocker->xLastY==mouse.y())
	{
#ifndef ENABLE_FINAL
		qWarning("Animate::Bounce Step! 487");
#endif		
		i=i+2;
		
		lastIcon->xPosition.setY(lasty+i);
		lastIcon->xPosition.setX(lastx+i);
		lastIcon->xSetZoom(lastZoom-i*2);
		//xGDocker->xUpdate();
		xGDocker->xDockerRedraw(lastIcon);
		//xGDocker->repaint(false);
#ifndef ENABLE_FINAL
		qWarning("Animate::Bounce Step! 496");
#endif
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations/10
				,this,SLOT(xAnimateStepMicro()));
	}
	else
	{
	
		i=0;
		if(xGDocker->getRaised()!=lastRaise 
			||xGDocker->isAnimating
			||
			xGDocker->xLastX!=mouse.x()
			||
			xGDocker->xLastY!=mouse.y()
			//||lastIcon->xZoom!=(lastZoom-i*2)
			)
		{
			AnimationsMutex.unlock();
			return;
		}
	
#ifndef ENABLE_FINAL
		qWarning("Animate::Bounce Step! 503");
#endif
		//xGDocker->isAnimating=0;
		lastIcon->xPosition.setY(lasty);
		lastIcon->xPosition.setX(lastx);
		lastIcon->xSetZoom(lastZoom);
		//xGDocker->xUpdate();
		xGDocker->xDockerRedraw(lastIcon);
		//xGDocker->repaint(false);
		AnimationsMutex.unlock();
//		xGDocker->mouseMoveSoftware(xGDocker->xLastX,xGDocker->xLastY);
		//xGDocker->repaint(false);
		
	}
	
#ifndef ENABLE_FINAL
	qWarning("Animate::Bounce Step! 514");
#endif	
	
}


/*!
    \fn XEPlugin_Animator::xGetParameter(const QString, QString&)
 */
void XEPlugin_Animator::xGetParameter(const QString sName, QString& sValue)
{
	if(sName=="onCloseAnimation")
	{
		sValue=(onCloseAnimation);
	}
	if(sName=="onAddAnimation")
	{
		sValue=(onAddAnimation);
	}
	if(sName=="onSlideAnimation")
	{
		sValue=(onSlideAnimation);
	}
	if(sName=="highlightAnimation")
	{
		sValue.setNum(highlightAnimation);
	}
	if(sName=="onShowAnimation")
	{
		sValue=(onShowAnimation);
	}
	if(sName=="onClickAnimation")
	{
		sValue=(onClickAnimation);
	}
	if(sName=="onRaiseAnimation")
	{
		sValue=(onRaiseAnimation);
	}
	if(sName=="onHideAnimation")
	{
		sValue=(onHideAnimation);
	}

	if(sName=="BounceHigh")
	{
		sValue.setNum(BounceHigh);
	}
}


/*!
    \fn XEPlugin_Animator::xGetParameterList(QStringList *)
 */
void XEPlugin_Animator::xGetParameterList(QStringList *a)
{
	a->append("onClickAnimation");
	a->append("onRaiseAnimation");
	a->append("onCloseAnimation");
	a->append("onAddAnimation");
	a->append("onSlideAnimation");
	a->append("onHideAnimation");
	a->append("onShowAnimation");
	a->append("BounceHigh");
	a->append("highlightAnimation");

}


/*!
    \fn XEPlugin_Animator::xSetupParameter(const QString, const QString)
 */
void XEPlugin_Animator::xSetupParameter(const QString sName,const QString sValue)
{

	if(sName=="onHideAnimation")
	{
		onHideAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onHideAnimation",onHideAnimation);
		}

	}
	}
	if(sName=="onShowAnimation")
	{
		onShowAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onShowAnimation",onShowAnimation);
		}

	}
	}
	if(sName=="onCloseAnimation")
	{
		onCloseAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onCloseAnimation",onCloseAnimation);
		}

	}
	}
	if(sName=="onAddAnimation")
	{
		onAddAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onAddAnimation",onAddAnimation);
		}

	}
	}
	if(sName=="onSlideAnimation")
	{
		onSlideAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onSlideAnimation",onSlideAnimation);
		}

	}
	}
	if(sName=="onRaiseAnimation")
	{
		onRaiseAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onRaiseAnimation",onRaiseAnimation);
		}

	}
	}
	if(sName=="onClickAnimation")
	{
		onClickAnimation=sValue;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("onClickAnimation",onClickAnimation);
		}

	}
	}
	if(sName=="BounceHigh")
	{
		bool okRet=false;
		BounceHigh=sValue.toInt(&okRet);
		if(okRet==false)BounceHigh=10;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("BounceHigh",BounceHigh);
		}

	}
	}
	if(sName=="highlightAnimation")
	{
		bool okRet=false;
		highlightAnimation=sValue.toInt(&okRet);
		if(okRet==false)highlightAnimation=1;
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
		{
		// update xml configuration
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute
		("highlightAnimation",highlightAnimation);
		}

	}
	}
}


/*!
    \fn XEPlugin_Animator::xEventDockerShowed()
 */
void XEPlugin_Animator::xEventDockerShowed()
{

#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Animator::xEventDockerShowed()");
#endif
	
	//if(xGDocker->isShown())return;
	if(xGDocker->getRaised() )return;
	if(onShowAnimation=="slide")xAnimateDockerSlideShow();
	if(onShowAnimation=="fade")xAnimateDockerFadeShow();

//	timespec req,   rem;
//	req.tv_nsec=ActiveConfiguration->Engine.SleepAnimations*1000*1000;
//	req.tv_sec=0;
	// poof animation
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Animator::xEventDockerShowed() Animations");
#endif

}


/*!
    \fn XEPlugin_Animator::xEventDockerHidden()
 */
void XEPlugin_Animator::xEventDockerHidden()
{
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Animator::xEventDockerHidden()");
#endif
	
	//if(xGDocker->isShown())return;
	if(xGDocker->getRaised())return;
	if(onHideAnimation=="slide")xAnimateDockerSlideHide();
	if(onHideAnimation=="fade")xAnimateDockerFadeHide();

	// try workaround to hide all of detached icons!
	if(LocalDetachedWindow!=NULL)LocalDetachedWindow->hide();

}


/*!
    \fn XEPlugin_Animator::xGetInfo(QStringList &)
 */
void XEPlugin_Animator::xGetInfo(QStringList &PluginInformations)
{
	PluginInformations.append("KXDocker Animator");
	// version
	PluginInformations.append(KXDOCKERVERSION);
	// date
	PluginInformations.append(KXDOCKERDATE);
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php"));
}


/*!
    \fn XEPlugin_Animator::xStopAnimate()
 */
void XEPlugin_Animator::xStopAnimate()
{
	animatingIcon=NULL;
}


/*!
    \fn XEPlugin_Animator::xStartAnimate(XGIcon *)
 */
void XEPlugin_Animator::xStartAnimate(XGIcon *TargetIcon)
{
	animatingIcon=TargetIcon;
	xAnimateBounce((TargetIcon));
	xStartAnimate();
}
void XEPlugin_Animator::xStartAnimate()
{
	int exint=0;
	if(animatingIcon && ((exint=xGDocker->xGetIconIndex(animatingIcon))>=0)&&
		ActiveConfiguration->ObjectsIcons.at(exint)->Tasks.TaskInfo==NULL &&
		ActiveConfiguration->ObjectsIcons.at(exint)->Tasks.dcopReady==0
		&&
		ActiveConfiguration->ObjectsIcons.at(exint)->Tasks.forceRunning==0
		&&
		animatorCounter<30)
	{
		xAnimateBounce((animatingIcon));
		QTimer::singleShot(2000,this,SLOT(xStartAnimate()));
	}
	else
	{
		animatorCounter=0;
		return;
	}
}

/*!
    \fn XEPlugin_Animator::xAnimateStepBounceDetached()
 */
void XEPlugin_Animator::xAnimateStepBounceDetached()
{
	//qWarning("xAnimateStepBounceDetached()");
	bounceTimer->stop();
	bounceDetachedTimer->stop();
	if(lastIcon==NULL)
	{
		if(LocalDetachedWindow!=NULL)LocalDetachedWindow->hide();
		return;
	}
	if(xGDocker->xGetIconIndex(lastIcon)<0)
	{
		if(LocalDetachedWindow!=NULL)LocalDetachedWindow->hide();
		return;
	}
	//qWarning("xAnimateStepBounceDetached() 2");
	xGFloater *DetachedWindow=(xGFloater *)lastIcon->wExternal;
	lastIcon->hidden=1;

	static int yAxisInverted=1;

	if(DetachedWindow==NULL)
	{
		xGDocker->xDockerRedraw(lastIcon);
		if(LocalDetachedWindow==NULL)
		{
			LocalDetachedWindow=new xGFloater();
		}
		DetachedWindow=LocalDetachedWindow;
		lastIcon->wExternal=(QWidget *)DetachedWindow;
	
		DetachedWindow->move(
				lastIcon->xPosition.x()+xGDocker->x(),
				lastIcon->xPosition.y()+xGDocker->y(),1
				);
		//QPixmap pImgShowed;
		//pImgShowed.convertFromImage(lastIcon->xImgShowed);
		DetachedWindow->setPixmap(lastIcon->xImgShowed);
		DetachedWindow->resize(lastIcon->xZoom,lastIcon->xZoom);
		DetachedWindow->show();
		DetachedWindow->MaxY=lastIcon->xPosDefault.y()+lastIcon->xPosition.y()+xGDocker->y();
		//DetachedWindow->MinY=lastIcon->xPosDefault.y()+lastIcon->xPosition.y()+xGDocker->y();
		DetachedWindow->Direction=-1;


		// 
		if(strcmp(ActiveConfiguration->Window.Align,"top")==0)yAxisInverted=-1;
		else yAxisInverted=1;
	}
	//qWarning("xAnimateStepBounceDetached() 3");
	
	//lastIcon->wExternal=DetachedWindow;

	
	int lasty=mousef.y();

	const int STEPS=20+BounceHigh/10;
	const double inc=6.28/STEPS;
	double acc;
	if(radians<6.28
	&&
	xGDocker->xLastX==mouse.x()
	&&
	!xGDocker->isAnimating
	&&
	xGDocker->xLastY==mouse.y())
	{
#ifndef ENABLE_FINAL
		qWarning("if(");
#endif
		//qWarning("xAnimateStepBounceDetached() 4");

		radians=radians+inc;
		acc=1.1/(0.1+sin(radians)*sin(radians));
		lastIcon->xPosition.setY(
			int(
			lasty-sin(radians)*BounceHigh*acc*sin(radians)*yAxisInverted
			)
		);

		DetachedWindow->move(
			lastIcon->xPosition.x()+xGDocker->x(),
			lastIcon->xPosition.y()+xGDocker->y(),1
			);
		if(sin(radians)>0)DetachedWindow->Direction=1;
		else DetachedWindow->Direction=-1;


		//xGDocker->xUpdate();
		// new engine 20040611
		// let's redraw only 1 icon :)
		//xGDocker->xDockerRedraw(lastIcon);
		//xGDocker->repaint(false);
		/*
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations/10
				,this,SLOT(xAnimateStepBounceDetached()));
		*/
		bounceDetachedTimer->start(ActiveConfiguration->Engine.SleepAnimations/(5+BounceHigh/50));

	}
	else
	{
#ifndef ENABLE_FINAL
		qWarning("else{");
#endif

		//qWarning("xAnimateStepBounceDetached() 5");

		//if(radians>=rfine)lastIcon->xPosition.setY(lasty);
		if(radians>=6.28)lastIcon->xPosition.setY(lasty);
		lastIcon->hidden=0;
		xGDocker->xDockerRedraw(lastIcon);
		DetachedWindow->hide();
		lastIcon->wExternal=NULL;

		radians=0;

#ifndef ENABLE_FINAL
		qWarning("Interrotta animazione! 2");
#endif
		if(0)
		{
#ifndef ENABLE_FINAL
			qWarning("Interrotta animazione! 1");
#endif
			AnimationsMutex.unlock();

			return;
		}
#ifndef ENABLE_FINAL
		qWarning("lastIcon->xPosition.setY(lasty);");
#endif
		lastIcon->xPosition.setY(lasty);
		//xGDocker->isAnimating=0;
		//xGDocker->xUpdate();
		// isAnimating is useful but on sp2 the  are not right than we ask to redraw all :(
		//qWarning("sp2 enabled");
		xGDocker->mouseMoveEventSW(xGDocker->xLastX,xGDocker->xLastY,1);

		//xGDocker->repaint(false);
		AnimationsMutex.unlock();

	}
	
}


/*!
    \fn XEPlugin_Animator::xAnimateDockerSlideShow()
 */
inline void XEPlugin_Animator::xAnimateDockerSlideShow()
{
	// TODO: update with new transparency engine
	if(ActiveConfiguration->Window.Align=="top")
	{
		XGIcon *Icon=xGDocker->xGetPointerObjectIcon(0);
		uint iconCicle=0;
		int lasty=Icon->xPosition.y();
		int lastybar=Icon->xPosDefault.y();
		int showSteps=10;
		int fary=-ActiveConfiguration->Window.Height;
		int moltipler=fary/showSteps;
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
				
				Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
				if(Icon->xExclude)continue;
				Icon->xPosition.setY(fary);
				
		}
		
		for(int i=abs(moltipler/3);i>=0;i--)
		{
		
			for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
			{
				Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
				if(Icon->xExclude)continue;
				Icon->xPosition.setY(lasty+i*moltipler);
				
			}
			xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setY(lastybar+i*moltipler);
			//xGDocker->xBackgroundMove(lastxbar,);
	
			xGDocker->xDockerRedraw();
			nanosleep(&req,&rem);
			nanosleep(&req,&rem);
	#ifndef ENABLE_FINAL
			qWarning(QString("i:%1 Y:%1 height:%1").arg(i).arg(Icon->xPosition.y()).arg(ActiveConfiguration->Window.Height));
			qWarning("void XEPlugin_Animator::xEventDockerShowed() Animations !!!");
	#endif
		}

	}
	else
	{
	XGIcon *Icon=xGDocker->xGetPointerObjectIcon(0);
	
	uint iconCicle=0;
	int lasty=Icon->xPosition.y();
	int lastybar=Icon->xPosDefault.y();
	// TODO: yBar and xBar static
	//int lastxbar;
	//xGDocker->xBackgroundGetCoords(lastxbar,lastybar);
	
	int showSteps=10;
	int moltipler=ActiveConfiguration->Window.Height/showSteps;
	for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
	{
			
			Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
			if(Icon->xExclude)continue;
			Icon->xPosition.setY(ActiveConfiguration->Window.Height);
			
	}
	
	for(int i=moltipler/3;i>=0;i--)
	{
	
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
			Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
			if(Icon->xExclude)continue;
			Icon->xPosition.setY(lasty+i*moltipler);
			
		}
		xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setY(lastybar+i*moltipler);
		//xGDocker->xBackgroundMove(lastxbar,);

		xGDocker->xDockerRedraw();
		nanosleep(&req,&rem);
		nanosleep(&req,&rem);
		nanosleep(&req,&rem);
		nanosleep(&req,&rem);
		nanosleep(&req,&rem);
#ifndef ENABLE_FINAL
		qWarning(QString("i:%1 Y:%1 height:%1").arg(i).arg(Icon->xPosition.y()).arg(ActiveConfiguration->Window.Height));
		qWarning("void XEPlugin_Animator::xEventDockerShowed() Animations !!!");
#endif
	}
	}
#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Animator::xEventDockerShowed() Animations End");
#endif
}


/*!
    \fn XEPlugin_Animator::xAnimateDockerFadeShow
 */
inline void XEPlugin_Animator::xAnimateDockerFadeShow()
{
	QImage paintBufferBackground;
	QImage paintBufferOrig;
	QImage paintBuffer;
	paintBufferBackground.create(
		ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,
		32);
paintBufferBackground.setAlphaBuffer(false);
paintBufferBackground.fill(0);
paintBufferBackground.setAlphaBuffer(true);

// Compiz

/*
	bitBlt(&paintBufferBackground,0,0,xGDocker->xGetBackground(),
		0,0,
		ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,
		Qt::CopyROP);
*/
	paintBufferOrig.create(
		ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,
		32);
paintBufferOrig.setAlphaBuffer(false);
paintBufferOrig.fill(0);
paintBufferOrig.setAlphaBuffer(true);
	// draw docker without background, like when composite will be ready
	xGDocker->xUpdate(1,1);
	// paint locally
	xGDocker->paint(paintBufferOrig);
	xGDocker->xUpdate(2,1);

	for(double alpha=0.1;alpha<1;alpha=alpha+alpha)
	{
		//alpha=alpha+0.1
		//qWarning(QString("for(double alpha=0.1;%1<1;alpha=alpha+0.1)").arg(alpha));
		paintBuffer=paintBufferOrig;
		paintBuffer.detach();
		// update alpha
		setIntensity(paintBuffer,alpha);
		xGDocker->paintIn(paintBufferBackground,0);
		xGDocker->paintIn(paintBuffer,0);
		xGDocker->repaint(false);
		qApp->syncX();
		
	}
}


/*!
    \fn XEPlugin_Animator::xAnimateDockerFadeHide()
 */
void XEPlugin_Animator::xAnimateDockerFadeHide()
{
	QImage paintBufferBackground;
	QImage paintBufferOrig;
	QImage paintBuffer;

	paintBufferBackground.create(
		ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,
		32);
paintBufferBackground.setAlphaBuffer(false);
paintBufferBackground.fill(0);
paintBufferBackground.setAlphaBuffer(true);

// Compiz

/*
	bitBlt(&paintBufferBackground,0,0,xGDocker->xGetBackground(),
		0,0,
		ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,
		Qt::CopyROP);
*/
	paintBufferOrig.create(
		ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,
		32);
paintBufferOrig.setAlphaBuffer(false);
paintBufferOrig.fill(0);
paintBufferOrig.setAlphaBuffer(true);
	// draw docker without background, like when composite will be ready
	xGDocker->xUpdate(1,1);
	// paint locally
	xGDocker->paint(paintBufferOrig);
	xGDocker->xUpdate(2,1);
	
	for(double alpha=0.8;alpha>0;alpha=alpha-0.3)
	{
		//alpha=alpha+0.1
		//qWarning(QString("for(double alpha=0.1;%1<1;alpha=alpha+0.1)").arg(alpha));
		paintBuffer=paintBufferOrig;
		paintBuffer.detach();
		// update alpha
		setIntensity(paintBuffer,alpha);
		xGDocker->paintIn(paintBufferBackground,0);
		xGDocker->paintIn(paintBuffer,0);
		xGDocker->repaint(false);
		qApp->syncX();
		
	}
}


/*!
    \fn XEPlugin_Animator::xAnimateDockerSlideHide()
 */
void XEPlugin_Animator::xAnimateDockerSlideHide()
{
	

	//timespec req,   rem;
	//req.tv_nsec=ActiveConfiguration->Engine.SleepAnimations*1000*1000;
	//req.tv_sec=0;
	// poof animation
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Animator::xEventDockerHidden() Animations");
#endif
		XGIcon *Icon=xGDocker->xGetPointerObjectIcon(0);
		
		uint iconCicle=0;
		int lasty=Icon->xPosition.y();
		int lastybar=Icon->xPosDefault.y();
		int fary=ActiveConfiguration->Window.Height;

	if(ActiveConfiguration->Window.Align=="top")
	{
		fary=-ActiveConfiguration->Window.Height;
	}
	else
	{

		int showSteps=10;
		int moltipler=fary/showSteps;
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
				Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
				if(Icon->xExclude)continue;
				Icon->xPosition.setY(fary);
		}
		int i;
		for(i=0;i<moltipler/3;i++)
		{
			for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
			{
				Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
				if(Icon->xExclude)continue;
				Icon->xPosition.setY(lasty+i*moltipler);
				
			}
			xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setY(lastybar+i*moltipler);
			xGDocker->xDockerRedraw();
			nanosleep(&req,&rem);
			nanosleep(&req,&rem);
#ifndef ENABLE_FINAL
			qWarning(QString("i:%1 Y:%1 height:%1").arg(i).arg(Icon->xPosition.y()).arg(ActiveConfiguration->Window.Height));
			qWarning("XEPlugin_Animator::xEventDockerHidden() Animations !!!");
#endif
		}
		// restore all right coords
		i=0;
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
			Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
			if(Icon->xExclude)continue;
			Icon->xPosition.setY(lasty+i*moltipler);
			
		}
		xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setY(lastybar+i*moltipler);
	}
#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Animator::xEventDockerHidden() Animations End");
#endif
}


/*!
    \fn XEPlugin_Animator::xEventIconAdded(int)
 */
void XEPlugin_Animator::xEventIconAdded(int icon)
{
// qWarning("void XEPlugin_Animator::xEventIconAdded(int icon)");
	if(icon<0)return;
	uint TargetIcon=(uint)icon;
// qWarning("void XEPlugin_Animator::xEventIconAdded(int icon) 1");
	if(TargetIcon>=ActiveConfiguration->ObjectsIcons.count())return;
	// 0.38 with inverted mask animations
// qWarning("void XEPlugin_Animator::xEventIconAdded(int icon) 2");
	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Actions.iAnimationMask&1<<3)return;
// qWarning("void XEPlugin_Animator::xEventIconAdded(int icon) 3");

	if(ActiveConfiguration->ObjectsIcons.at(TargetIcon)->Info.className=="GSeparator")return;
//qWarning("void XEPlugin_Animator::xEventIconAdded(int icon) 5");

	XGIcon *target=xGDocker->xGetPointerObjectIcon(TargetIcon);
	if(target!=NULL)
	{
		if(onAddAnimation=="fade")
		{
			//	xAnimateFadeIcon(target);
			// New engine
			target->xFade((double)0.025);
			target->xFadeTo(1);
			xGDocker->polling->start(150);

		}
	}
//qWarning("void XEPlugin_Animator::xEventIconAdded(int icon) 6");

	
}


/*!
    \fn XEPlugin_Animator::xAnimateStepFadeIcon()
 */
void XEPlugin_Animator::xAnimateStepFadeIcon()
{
fadeTimer->stop();

	if(xGDocker->getRaised()>0){
		AnimationsMutex.unlock();
		return;
	}

	if(lastIcon==NULL){
		AnimationsMutex.unlock();
		return;
	}
	if(xGDocker->xGetIconIndex(lastIcon)<0)
	{
		AnimationsMutex.unlock();
		return;
	}
	if(lastIcon->hidden)
	{
		AnimationsMutex.unlock();
		return;
	}

	static QImage localBufferResized;
	if(localBufferResized.isNull ())
	{
		localBufferResized=lastIcon->xImgShowed;
		// may be we need to resize?
		//localBufferResized.detach();
	}
	
	
	if(radians>0.2
	&&
	!xGDocker->isAnimating
	&&
	xGDocker->getRaised()==lastRaise
	&&
	xGDocker->xLastX==mouse.x()
	&&
	xGDocker->xLastY==mouse.y())
	{


		lastIcon->xImgShowed=localBufferResized;
		lastIcon->xImgShowed.detach();
		setIntensity(lastIcon->xImgShowed,radians);
		radians=radians/2;

		xGDocker->xDockerRedraw(lastIcon);
		//xGDocker->repaint(false);
fadeTimer->start(ActiveConfiguration->Engine.SleepAnimations/5);
#ifndef ENABLE_FINAL
		qWarning("void XEPlugin_Animator::xAnimateStepFadeIcon()");
#endif
	}
	else
	{
// 		qWarning("void XEPlugin_Animator::xAnimateStepFadeIcon() ending");
		if(xGDocker->getRaised()!=lastRaise 
			||xGDocker->isAnimating
			||
			xGDocker->xLastX!=mouse.x()
			||
			xGDocker->xLastY!=mouse.y()
			)
		{
			localBufferResized.reset();
			AnimationsMutex.unlock();
			return;
		}
		lastIcon->xImgShowed=localBufferResized;
		lastIcon->xImgShowed.detach();
		localBufferResized.reset();
		//xGDocker->xDockerRedraw(lastIcon);
		AnimationsMutex.unlock();
	}
}


/*!
    \fn XEPlugin_Animator::xAnimateFadeIcon(XGIcon *)
 */
void XEPlugin_Animator::xAnimateFadeIcon(XGIcon *Icon)
{
	//qWarning("void XEPlugin_Animator::xAnimateFadeIcon(XGIcon *Icon)");
	if(AnimationsMutex.tryLock()==false)return;
	lastIcon=Icon;
	mousef.setY(Icon->xPosition.y());
	mouse.setX(xGDocker->xLastX);
	mouse.setY(xGDocker->xLastY);
	radians=0.05;
	fadeTimer->start(ActiveConfiguration->Engine.SleepAnimations/10);
}


/*!
    \fn XEPlugin_Animator::xAnimateOverlay(XGIcon *)
 */
void XEPlugin_Animator::xAnimateOverlay(XGIcon *Icon)
{
//qWarning("void XEPlugin_Animator::xAnimateOverlay(XGIcon *Icon)");
	int exint=xGDocker->xGetIconIndex(Icon);
	if(exint<0 || Icon==NULL)return;
	//if(AnimationsMutex.tryLock()==false)return;
	//lastIcon=Icon;

	// 0.38 with multiple animations
	// we need to now if we will never be stopped
	if(ActiveConfiguration->ObjectsIcons.at(exint)->Tasks.WindowTitle.count()<1)return;
	// bad idea having 2 duplicates ;)
	if(lastIcons.find(Icon)>=0)return;

	if(ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner=="")
	{
		ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner="spin_";
		ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner=ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner+ActiveConfiguration->ObjectsIcons.at(exint)->Info.Name;
		Configurator->xFindResource("icon",ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner);
		if(ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner=="")
		{
			ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner="spin_";
			ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner=ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner+ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileName;
			Configurator->xFindResource("icon",ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner);
			if(ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner=="")ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner="spin_waiting";
		}
	}
	QString spinnerName=ActiveConfiguration->ObjectsIcons.at(exint)->Images.imgFileOverlaySpinner;
	Configurator->xFindResource("icon",spinnerName);
	Icon->xSetOverlayImage(-2,-2,spinnerName);
	xGDocker->polling->start(200);
	overlayPollTimer->start(1000);
	lastIcons.append(Icon);
}


/*!
    \fn XEPlugin_Animator::xAnimateStepOverlay()
 */
void XEPlugin_Animator::xAnimateStepOverlay()
{
	//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay()\n");
	overlayPollTimer->stop();
	if(lastIcons.count()<1)
	{
		return;
	}
	//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 1\n");
	for(int lastIconsCounter=0;lastIconsCounter<(int)lastIcons.count();lastIconsCounter++)
	{
		XGIcon *thilastIcon=lastIcons.at(lastIconsCounter);
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 2\n");
		int iconDockerIndex=xGDocker->xGetIconIndex(thilastIcon);
		if(iconDockerIndex<0)// ||thilastIcon->hidden)
		{
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 2.1\n");
			// icon removed from the dock
			lastIcons.remove(lastIconsCounter);
			if(lastIcons.count()<1)
			{
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 2.2\n");
				return;
			}
			else
			{
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 2.3\n");
				lastIconsCounter--;
				continue;
			}
		}
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 3\n");
		if(
			ActiveConfiguration->ObjectsIcons.at(iconDockerIndex)->Tasks.TaskInfo==NULL
			&&
			ActiveConfiguration->ObjectsIcons.at(iconDockerIndex)->Tasks.dcopReady==0
			&&
			ActiveConfiguration->ObjectsIcons.at(iconDockerIndex)->Tasks.forceRunning==0
			//&&
			//ActiveConfiguration->ObjectsIcons.at(iconDockerIndex)->Tasks.WindowTitle.count()>0
			//QStringList	TaskName;
			//QStringList	ClassName;
			//&&
			//animatorCounter<30
			)
		{
			//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay(%1)\n").arg(ActiveConfiguration->ObjectsIcons.at(iconDockerIndex)->Info.Name);
		}
		else
		{
			thilastIcon->xSetOverlayImage(0,0,"");
			// 0.40 remove the icon
			lastIcons.remove(thilastIcon);
			if(lastIcons.count()<1)
			{
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 4.2\n");
				return;
			}
			else
			{
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 4.3\n");
				lastIconsCounter--;
				continue;
			}

		}
		//kdWarning()<<QString("void XEPlugin_Animator::xAnimateStepOverlay() 4\n");
	}
	if(lastIcons.count())overlayPollTimer->start(1000);
	else
	{
		//AnimationsMutex.unlock();
	}
}


/*!
    \fn XEPlugin_Animator::xAnimateDockerSlideRight(int,int,int,int,int,int)
 */
void XEPlugin_Animator::xAnimateDockerSlideRight(int dockerX,int,int ,int ,int ,int ,int nextX,int )
{
//int dockerX,int dockerY,int X0,int Y0,int XLast,int YLast,int nextX,int nextY)
	//return;
	if(!xGDocker->isShown())return;
	// 0.38
	// this is a sync call when we return docker will be moved
	/*
			x(),
			y(),
			activeIcons[0]->xPosDefault.x(),
			activeIcons[0]->xPosDefault.y(),
			activeIcons[activeIconsCounter-1]->xPosDefault.x(),
			activeIcons[activeIconsCounter-1]->xPosDefault.y(),
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top
	*/

	int diffX=nextX-dockerX;
	if(diffX==0)return;
	//int diffY=nextY-dockerY;


#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Animator::xAnimateDockerSlideRight(int,int,int,int,int,int)");
#endif
	XGIcon *Icon=xGDocker->xGetPointerObjectIcon(0);
	
	uint iconCicle=0;
	/*
	int lasty=Icon->xPosition.y();
	int lastxbar=Icon->xPosDefault.y();
	*/
	int showSteps=abs(diffX);

	// we like only X
	//int moltipler=showSteps/2;//diffX/showSteps;

	int i;
	int neg=diffX/showSteps;
	int least=showSteps;
	//qWarning(QString("Before %1 %1 %1").arg(xGDocker->xGetPointerObjectIcon(0)->xPosition.x()).arg(xGDocker->xGetPointerObjectIcon(0)->xPosDefault.x()).arg(X0));
	for(i=showSteps/2;i>1;)
	{
		//qWarning(QString("Step: %1/%1").arg(i).arg(showSteps));
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
			Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
			//if(Icon->xExclude)continue;
			//Icon->xPosition.setX(Icon->xPosition.x()+(double(diffX)-double(diffX)/i));
			//(showSteps/2)
			Icon->xPosition.setX(Icon->xPosition.x()+i*neg);

		}
		//xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setX(xGDocker->xGetPointerObjectIcon(0)->xPosDefault.x()+i*neg);

		xGDocker->xDockerRedraw();
		
		//usleep(ActiveConfiguration->Engine.SleepAnimations/2);
		nanosleep(&req,&rem);
		least=least-i;
		if((least-i/2)<0)break;
		if(i<8)i--;
		else i=i/2;
		//nanosleep(&req,&rem);
	}
/*
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
			Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
			//if(Icon->xExclude)continue;
			//Icon->xPosition.setX(Icon->xPosition.x()+(double(diffX)-double(diffX)/i));
			//(showSteps/2)
			Icon->xPosition.setX(Icon->xPosition.x()-diffX);

		}
		xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setX(xGDocker->xGetPointerObjectIcon(0)->xPosDefault.x()-diffX);
*/
/*
	for(i=0;i<showSteps;i++)
	{
		qWarning(QString("Step: %1/%1 (%1)").arg(i).arg(showSteps).arg(neg));
		for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
		{
			Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
			//if(Icon->xExclude)continue;
			//Icon->xPosition.setX(Icon->xPosition.x()+(double(diffX)-double(diffX)/i));
			//(showSteps/2)
			Icon->xPosition.setX(Icon->xPosition.x()+neg);

		}
		xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setX(xGDocker->xGetPointerObjectIcon(0)->xPosDefault.x()+neg);

		xGDocker->xDockerRedraw();
		
		usleep(ActiveConfiguration->Engine.SleepAnimations);
		//nanosleep(&req,&rem);
	}
*/
	// restore all right coords
	//i=0;
/*
	for(iconCicle=0;iconCicle<ActiveConfiguration->ObjectsIcons.count();iconCicle++)
	{
		Icon=xGDocker->xGetPointerObjectIcon(iconCicle);
		//if(Icon->xExclude)continue;
		Icon->xPosition.setX(Icon->xPosition.x()-diffX+least*neg);
		
	}
	xGDocker->xGetPointerObjectIcon(0)->xPosDefault.setX(X0);
*/
	//xGDocker->xUpdate(0,1);
	//qWarning(QString("After %1 %1 %1").arg(xGDocker->xGetPointerObjectIcon(0)->xPosition.x()).arg(xGDocker->xGetPointerObjectIcon(0)->xPosDefault.x()).arg(X0));
	//xGDocker->xDockerRedraw();

#ifndef ENABLE_FINAL
	qWarning("XEPlugin_Animator::xEventDockerHidden() Animations End");
#endif


}


/*!
    \fn XEPlugin_Animator::xEventHighlightIcon(int,void *)
 */
void XEPlugin_Animator::xEventHighlightIcon(int,void *gIcon)
{
	switch(highlightAnimation)
	{
		case 1:
			((XGIcon *)gIcon)->xColorize(1.0,0.0,0.0,1.0);
		break;
		case 2:
			((XGIcon *)gIcon)->xColorize(0.0,1.0,0.0,1.0);
		break;
		case 3:
			((XGIcon *)gIcon)->xColorize(0.0,0.0,1.0,1.0);
		break;
		case 4:
			((XGIcon *)gIcon)->xSetIntensity(0.2);
		break;
	}
}





/*!
    \fn XEPlugin_Animator::xEventRemovingIcon(int,int)
 */
void XEPlugin_Animator::xEventRemovingIcon(int icon,int skip)
{
	if(skip>0)return;
	xEventTaskClosed(icon);
}


/*!
    \fn XEPlugin_Animator::xEventStartupRemoved(int)
 */
void XEPlugin_Animator::xEventStartupRemoved(int)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Animator::xEventStartupAdded(int)
 */
void XEPlugin_Animator::xEventStartupAdded(int icon)
{
	//kdWarning()<<"void XEPlugin_Animator::xEventStartupAdded(int icon)\n";
	xEventMouseClick(icon,0,0,Qt::LeftButton);
}


/*!
    \fn XEPlugin_Animator::xEventTaskClosed(int)
 */
void XEPlugin_Animator::xEventTaskClosed(int icon)
{
	if(onCloseAnimation=="poof")xEventRemoveIcon(icon);
	if(onCloseAnimation=="micro")xEventTaskOpen(icon);
}
