/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gpluginsdk.h"
#include "gpluginpainter.h"

#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
#include <kpopupmenu.h>
#include <kdebug.h>
#include "gpluginsdk.moc"


gPluginSDK::gPluginSDK(QObject *parent, const char *name)
 : QObject(parent, name)
{
	// pointer to the icon into the docker
	// remember if you have been stopped you cannot
	// use this pointer because you can crash kxdocker
	// ex: the icon may be removed
	xGIcon=NULL;
	PluginPopupMenu=NULL;
	// pointer to xGDocker which will send to you events
	xGDocker=NULL;
	// default tooltip displayed over the icon
	ToolTip=name;
	ToolTip="";
	LastToolTip2="";
	
	// this is a integer
	// it's used to know if you have to update the icon
	lastValue=0;
	Value=0;
	// 0.40
	//ConfigurationWindow=new gPluginSDKCfgWnd((QObject *)this,name);
	ConfigurationWindow=NULL;
	isStopped=1;

	SizeBig=128;
	ImageFX_Y_degree=0;
	ImageFX_X_degree=0;
	ImageFX_GrayScale=0;
	ImageFX_Intensity=100;
	ImageFX_Painter=new gPluginPainter(0,"ImageFX",DRAW_ImageFX);
}


gPluginSDK::~gPluginSDK()
{
	/*
	ConfigurationWindow->close();
	delete ConfigurationWindow;
	delete ImageFX_Painter;
	*/
}


void gPluginSDK::xSetup()
{
	// this function will attach the docker to this plugin
	//kdWarning()<<QString("%1::xSetup() start\n").arg(name());
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
	
	connect(this,SIGNAL(xGetConfigurator(QObject *&)),parent(),SLOT(xGetConfiguration(QObject *&)));
	xGetConfigurator(xEConfigurator);
	connect(this,SIGNAL(xGetConfiguration(void *&,const QString, int)),xEConfigurator,SLOT(xGetConfiguration(void *&,const QString, int)));
	connect(this,SIGNAL(xGetConfigurationVersion(int &, QString &)),xEConfigurator,SLOT(xGetConfigurationVersion(int &, QString &)));

	connect(this,SIGNAL(xFindResource(const QString &, QString &)),xEConfigurator,SLOT(xFindResource(const QString &, QString &)));

	ActiveConfigurationVersion="";
	ActiveConfigurationSizeOf=0;
	xGetConfigurationVersion(ActiveConfigurationSizeOf,ActiveConfigurationVersion);
	xGetConfiguration(pActiveConfiguration,ActiveConfigurationVersion,ActiveConfigurationSizeOf);

	connect(this,SIGNAL(xGetConfigurationValue(const QString, int &)),xEConfigurator,SLOT(xGetConfigurationValue(const QString, int &)));
	connect(this,SIGNAL(xGetConfigurationValue(const QString, QString &)),xEConfigurator,SLOT(xGetConfigurationValue(const QString, QString &)));

	xGetConfigurationValue("icons/sizebig",SizeBig);
	gPluginPainter::SizeBig=SizeBig;
	//kdWarning()<<QString("%1::xSetup() end\n").arg(name());
}


/*!
    \fn gPluginSDK::xRefreshIcon(QObject *)
 */
void gPluginSDK::xRefreshIcon(QObject *newIcon)
{
	// called every time by xGDocker to update the icon
	
	// do you have an icon?
	if(xGIcon==NULL || newIcon!=xGIcon)return;
	
	if(lastValue!=Value)
	{
		// call a virtual function to draw the icon
		xPaint(Value);
		// 0.4 check for apply fx
		xPaintFX(Value);
		// send signal to icon to invalidate the icon
		cachePurge();
		// this will re-zoom the new pixmap
		xSetSmoothZoom();
		// setup new tooltip
		xSetText(ToolTip);
		// 0.36 we need to check if enabled ToolTip2
		if(LastToolTip2!=ToolTip2)
		{
			LastToolTip2=ToolTip2;
			//xSetText(ToolTip2,1);
			xSetMiniText(ToolTip2);
		}

		// to avoid the full redraw
		// send signal to the docker to redraw only the updated icon
		xDockerRedraw(xGIcon);
		lastValue=Value;
	}
}


/*!
    \fn gPluginSDK::xPaint(int)
 */
void gPluginSDK::xPaint(int)
{
	qWarning("KXDocker Plugin: You have to derivate this function to draw the icon xImgSource");
}


/*!
    \fn gPluginSDK::xStop()
 */
void gPluginSDK::xStop()
{
	//qWarning("void gPluginSDK::xStop()");
	isStopped=1;
}


/*!
    \fn gPluginSDK::xStart()
 */
void gPluginSDK::xStart()
{
	if(!isStopped)return;
	// xSetTextManagedBy(idText,Manager);
	// idText  = 0 -> ToolTip (OverText)
	// idText  = 1 -> ToolTip2 (MiniText)
	// Manager = 0 -> Disabled
	// Manager = 2 -> TaskManager (number of windows)
	// Manager = 3 -> Plugin Managed

	xSetTextManagedBy(1,2);
	//qWarning("gPluginSDK::xStart()");
	isStopped=0;
	QTimer::singleShot(1000, this, SLOT(polling()));
}

// 0.40
//extern "C" QObject *xeplugin_register(QObject *parent);

void gPluginSDK::xAttach(QObject *newIcon)
{
	// this will be called by the icon to be attached to this plugin
	// first icon to attach
	//qWarning("void gPluginSDK::xAttach(QObject *newIcon)");
	if(xGIcon==NULL)
	{
		//qWarning("xReAttach(newIcon);");
		xReAttach(newIcon);
		//qWarning("xApplyCfg();");
		xApplyCfg();
		//0.4
		if(xXMLIconConfig->count()>0)
		{
			QString vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_Intensity","100");
			
			bool okRet=false;
			ImageFX_Intensity=vvalue.toInt(&okRet);
			if(okRet==false)
			{
				ImageFX_Intensity=100;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_X_degree","0");

			ImageFX_X_degree=vvalue.toInt(&okRet);
		
			if(okRet==false)
			{
				ImageFX_X_degree=0;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_Y_degree","0");

			ImageFX_Y_degree=vvalue.toInt(&okRet);
			
			if(okRet==false)
			{
				ImageFX_Y_degree=0;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_GrayScale","no");

			if(vvalue=="no"||vvalue=="0")ImageFX_GrayScale=0;
			else ImageFX_GrayScale=1;
		}

	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
		//gPluginSDK *MayManageMore=(gPluginSDK *)xeplugin_register(parent());
		// 0.40
		gPluginSDK *MayManageMore=(gPluginSDK *)Respawn(parent());
		if(MayManageMore==NULL)
		{
			//kdWarning()<<"Error while duplicating icons\n";
			return;
		}
		// Now simulatin the startup procedure
		// this may work <= 0.26
		MayManageMore->xSetup();
		MayManageMore->xAttach(newIcon);
		// make links for kxdocker >=0.26
		//qWarning("gPluginSDK: duplicate icons may not work properly");
	}

}


/*!
    \fn gPluginSDK::xApplyCfg()
 */
void gPluginSDK::xApplyCfg()
{
	qWarning("gPluginSDK::xApplyCfg() You must derivate this function to parse the configuration");
	/*
	if(xXMLIconConfig->count()>0)
	{
		IconsPath=xXMLIconConfig->item(0).toElement().attribute("path");
	}
	*/
}


/*!
    \fn gPluginSDK::polling()
 */
void gPluginSDK::polling()
{
	qWarning("gPluginSDK::polling() You must derivate this function to play ;)");
}


/*!
    \fn gPluginSDK::xSetupParameter(const QString, const QString)
 */
void gPluginSDK::xSetupParameter(const QString vname, const QString vvalue)
{
	// 0.4
	//qWarning("gPluginSDK::xSetupParameter(const QString, const QString) You must derivate this function");
	bool okRet=false;

	if(vname=="ImageFX_Intensity")
	{
		ImageFX_Intensity=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			ImageFX_Intensity=100;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_Intensity",ImageFX_Intensity);
		}
	}
	if(vname=="ImageFX_X_degree")
	{
		ImageFX_X_degree=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			ImageFX_X_degree=0;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_X_degree",ImageFX_X_degree);
		}
	}

	if(vname=="ImageFX_Y_degree")
	{
		ImageFX_Y_degree=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			ImageFX_Y_degree=0;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_Y_degree",ImageFX_Y_degree);
		}
	}

	if(vname=="ImageFX_GrayScale")
	{
		if(vvalue=="no"||vvalue=="0")ImageFX_GrayScale=0;
		else ImageFX_GrayScale=1;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_GrayScale",ImageFX_GrayScale);
		}
	}

	lastValue=-1;
	xRefreshIcon(xGIcon);

}


/*!
    \fn gPluginSDK::xGetParameterList(QStringList *)
 */
void gPluginSDK::xGetParameterList(QStringList *a)
{
	// 0.4
	//qWarning("gPluginSDK::xGetParameterList(QStringList *) You must derivate this function");
	a->append("ImageFX_GrayScale");
	a->append("ImageFX_X_degree");
	a->append("ImageFX_Y_degree");
	a->append("ImageFX_Intensity");
}


/*!
    \fn gPluginSDK::xGetParameter(const QString, QString &)
 */
void gPluginSDK::xGetParameter(const QString vname, QString & vvalue)
{
	if(vname=="ImageFX_GrayScale")
	{
		if(ImageFX_GrayScale)vvalue="yes";
		else vvalue="no";
	}
	if(vname=="ImageFX_Intensity")
	{
		vvalue.setNum(ImageFX_Intensity);
	}
	if(vname=="ImageFX_Y_degree")
	{
		vvalue.setNum(ImageFX_Y_degree);
	}
	if(vname=="ImageFX_X_degree")
	{
		vvalue.setNum(ImageFX_X_degree);
	}

	// 0.4
	//qWarning("gPluginSDK::xGetParameter(const QString, QString &) You must derivate this function");
}


/*!
    \fn gPluginSDK::createXMLTree()
 */
void gPluginSDK::createXMLTree()
{
	
}



/*!
    \fn gPluginSDK::xGetInfo(QStringList &)
 */
void gPluginSDK::xGetInfo(QStringList &a)
{
	a=PluginInformations;
}


/*!
    \fn gPluginSDK::xRunConfigurator()
 */
void gPluginSDK::xRunConfigurator()
{
	if(ConfigurationWindow==NULL)return;
//void xWMGetParameter(const QString, QString&);
//void xWMSetupParameter(const QString, const QString);

connect(this,SIGNAL(xWMSetupParameter(const QString, const QString)),ConfigurationWindow,SLOT(xSetupParameter(const QString, const QString)));
connect(this,SIGNAL(xWMShow()),ConfigurationWindow,SLOT(show()));

	QStringList a;
	xGetParameterList(&a);
	for(uint i=0;i<a.count();i++)
	{
		QString b;
		emit xGetParameter(a[i],b);
		//ConfigurationWindow->xSetParameter(a[i],b);
		emit xWMSetupParameter(a[i],b);
	}
	//ConfigurationWindow->show();
	emit xWMShow();
	disconnect(SIGNAL(xWMSetupParameter(const QString, const QString)));
	disconnect(SIGNAL(xWMShow()));
}


/*!
    \fn gPluginSDK::xEventClick(void *,int,int,int)
 */
void gPluginSDK::xEventClick(void *,int,int,int,int)
{
    /// @todo implement me
}


/*!
    \fn gPluginSDK::xEnabledClick()
 */
void gPluginSDK::xEnabledClick(int &)
{
    /// @todo implement me
}


/*!
    \fn gPluginSDK::xRefreshIconFromKXDocker(QObject *)
 */
void gPluginSDK::xRefreshIconFromKXDocker(QObject *a)
{
	lastValue=0;
	xRefreshIcon(a);
}


/*!
    \fn gPluginSDK::xPaintFX(int)
 */
void gPluginSDK::xPaintFX(int)
{
	*xImgSource=ImageFX_Painter->setFX(*xImgSource,
		ImageFX_Intensity,
		ImageFX_GrayScale,
		ImageFX_X_degree,
		ImageFX_Y_degree
		);
}



/*!
    \fn gPluginSDK::xGetParameterType(const QString &, QString &)
 */
void gPluginSDK::xGetParameterType(const QString &vname, QString &vvalue)
{
	if(vname=="ImageFX_GrayScale")
	{
		vvalue=KXDOCKER_VARTYPE_BOOL;
	}
	if(vname=="ImageFX_Intensity")
	{
		vvalue=KXDOCKER_VARTYPE_PERCENT;
	}
	if(vname=="ImageFX_Y_degree")
	{
		vvalue=KXDOCKER_VARTYPE_RANGE;
		vvalue=vvalue+":int:0:360";
	}
	if(vname=="ImageFX_X_degree")
	{
		vvalue=KXDOCKER_VARTYPE_RANGE;
		vvalue=vvalue+":int:0:360";
	}
}


/*!
    \fn gPluginSDK::xContinue()
 */
void gPluginSDK::xContinue()
{
    /// @todo implement me
}


/*!
    \fn gPluginSDK::xPause()
 */
void gPluginSDK::xPause()
{
    /// @todo implement me
}



/*!
    \fn gPluginSDK::Respawn(QObject *)
 */
QObject * gPluginSDK::Respawn(QObject *)
{
	return NULL;
}


/*!
    \fn gPluginSDK::xReAttach(QObject *)
 */
void gPluginSDK::xReAttach(QObject *newIcon)
{
		// unique instance
		xGIcon=newIcon;
		// the xGIcon pointer
		disconnect(this,SIGNAL(xGetImage(QImage *&)));
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		//
		disconnect(this,SIGNAL(cachePurge()));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		//
		disconnect(this,SIGNAL(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		//
		disconnect(this,SIGNAL(xSetText(const QString &)));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		// 0.36
		disconnect(this,SIGNAL(xSetMiniText(const QString &)));
		disconnect(this,SIGNAL(xSetText(const QString &,int)));
		disconnect(this,SIGNAL(xSetTextManagedBy(int,int)));
		connect(this,SIGNAL(xSetMiniText(const QString &)),xGIcon,SLOT(xSetMiniText(const QString &)));
		connect(this,SIGNAL(xSetText(const QString &,int)),xGIcon,SLOT(xSetText(const QString &,int)));
		connect(this,SIGNAL(xSetTextManagedBy(int,int)),xGIcon,SLOT(xSetTextManagedBy(int,int)));
		// 0.37
		disconnect(this,SIGNAL(xSetOverlayImage(int,int,const QString &)));
		disconnect(this,SIGNAL(xSetOverlayImage(int,int,const QImage &)));
		disconnect(this,SIGNAL(xSetOverlayImage(int,int,const QPixmap &)));
		connect(this,SIGNAL(xSetOverlayImage(int,int,const QString &)),xGIcon,SLOT(xSetOverlayImage(int,int,const QString &)));
		connect(this,SIGNAL(xSetOverlayImage(int,int,const QImage &)),xGIcon,SLOT(xSetOverlayImage(int,int,const QImage &)));
		connect(this,SIGNAL(xSetOverlayImage(int,int,const QPixmap &)),xGIcon,SLOT(xSetOverlayImage(int,int,const QPixmap &)));

		//
		disconnect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));

		disconnect(this,SIGNAL(xSetIconEXE(const QString &)));
		disconnect(this,SIGNAL(xGetIconEXE(QString &)));
		disconnect(this,SIGNAL( xGetIconName(QString &)));
		disconnect(this,SIGNAL(xSetIconImgFile(const QString &)));
		disconnect(this,SIGNAL(xSetIconName(const QString &)));
		disconnect(this,SIGNAL(xSetOverText(const QString &)));

		connect(this,SIGNAL(xSetIconEXE(const QString &)),xGIcon,SLOT(xSetIconEXE(const QString &)));
		connect(this,SIGNAL(xGetIconEXE(QString &)),xGIcon,SLOT(xGetIconEXE(QString &)));
		connect(this,SIGNAL( xGetIconName(QString &)),xGIcon,SLOT( xGetIconName(QString &)));
		connect(this,SIGNAL(xSetIconImgFile(const QString &)),xGIcon,SLOT(xSetIconImgFile(const QString &)));
		connect(this,SIGNAL(xSetIconName(const QString &)),xGIcon,SLOT(xSetIconName(const QString &)));
		connect(this,SIGNAL(xSetOverText(const QString &)),xGIcon,SLOT(xSetOverText(const QString &)));
		//
		//connect(this,SIGNAL(xGetPluginPopupMenu(KPopupMenu*& ,const QObject *)),xGIcon,SLOT(createPopup(KPopupMenu*& ,const QObject *)));
		disconnect(this,SIGNAL(xGetPluginPopupMenu(KPopupMenu*& ,const QObject *)));
		connect(this,SIGNAL(xGetPluginPopupMenu(KPopupMenu*& ,const QObject *)),xGDocker,SLOT(createPopup(KPopupMenu*& ,const QObject *)));
		
		// fetch the icon configuration
		//qWarning("xGetPluginConfiguration(xXMLIconConfig);");
		xGetPluginConfiguration(xXMLIconConfig);
		
		xGetImage(xImgSource);
		xGetPluginPopupMenu(PluginPopupMenu,xGIcon);

		// 0.39
		disconnect(this,SIGNAL(xStartStepping()));
		connect(this,SIGNAL(xStartStepping()),xGDocker,SLOT(xStartStepping()));
		//connect(this,SIGNAL(xAskContinue(QObject *)),xGDocker,SLOT(xAskContinue(QObject *)));

		//connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		disconnect(this,SIGNAL(xDockerRedraw(QObject *)));
		connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		disconnect(xGIcon,SIGNAL(xRefresh(QObject *)));
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIconFromKXDocker(QObject *)));
		
		// kxdocker 0.29 support
		// 0.40
		disconnect(xGIcon,SIGNAL(xEnabledClick(int& )));
		disconnect(xGIcon,SIGNAL(xEventClick(void*, int, int, int, int )));

		disconnect(xGIcon,SIGNAL(xStart()));
		disconnect(xGIcon,SIGNAL(xRunConfigurator()));
		disconnect(xGIcon,SIGNAL(xStop()));

		// - click events
		connect(xGIcon,SIGNAL(xEnabledClick(int& )),this,SLOT(xEnabledClick(int& )));
		connect(xGIcon,SIGNAL(xEventClick(void*, int, int, int, int )),this,SLOT(xEventClick(void*, int, int, int, int )));

		connect(xGIcon,SIGNAL(xStart()),this,SLOT(xStart()));
		connect(xGIcon,SIGNAL(xRunConfigurator()),this,SLOT(xRunConfigurator()));
		connect(xGIcon,SIGNAL(xStop()),this,SLOT(xStop()));
}
