/*
 * Copyright (C) 2006 Stefano <stefano@xiaprojects.com>
 */

#include "kxdocker.h"
#include <kapplication.h>

#include <dcopclient.h>

#include <qlabel.h>

#include <kmainwindow.h>
#include <time.h>
#include <kdebug.h>
#include <klocale.h>

extern timespec microSeconds;


#include "xeobject.h"
#include "xeroot.h"
#include "xeconfiguration.h"
#include "xeplugin_xmlconf.h"

// External Optional-required modules
//#include "xematrixpanther.h"

/*
#include "xeplugin_mouse.h"
#include "xeplugin_command.h"
#include "xeplugin_animator.h"
#include "xeplugin_taskmanager.h"
#include "xeplugin_gapplet.h"
#include "xeplugin_gatrash.h"
#include "xeplugin_gmounts.h"
#include "xeplugin_gaclock.h"
#include "xeplugin_dcop.h"
#include "xeplugin_gepager.h"
#include "xeplugin_configurator.h"
#include "xeplugin_gepillow.h"
#include "xeplugin_garp.h"
#include "xgtaskbar.h"
*/

XERoot		*EngineRoot=NULL;
//XGDocker		*EngineDocker=NULL;
XEPlugin_XMLConf	*PluginXMLConf=NULL;

#include "kxdocker.moc"


KXDocker::KXDocker(Display *display, Qt::HANDLE visual, Qt::HANDLE colormap, bool allowStyles, bool configUnique): KUniqueApplication(display,visual,colormap, allowStyles, configUnique)
{
	// set the shell's ui resource file
//	setXMLFile("kxdockerui.rc");
	XEConfiguration 	*EngineConfiguration=NULL;
//    XEPlugin_GEPager	*PluginGEPager=NULL;
//    XEPlugin_Configurator *PluginConfigurator=NULL;
//    XEPlugin_GARP	*PluginARP=NULL;
    // Plugins
	EngineRoot	= new XERoot(this,"xRoot");
	EngineConfiguration=new XEConfiguration(EngineRoot,"xConfiguration");
	PluginXMLConf=new XEPlugin_XMLConf(EngineRoot,"xXML");
	kdWarning() <<("loading xml...\n");
	PluginXMLConf->xSetup();
	PluginXMLConf->xStart();
	PluginXMLConf->xImportXMLs();
	kdWarning() <<("loading plugins...\n");
	for(uint i=0; i<EngineConfiguration->xGetConfiguration()->Plugins.Plugin.count(); i++)
	{
		if(XEObject::xFindObject(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name)!=NULL)continue;
		//kdWarning() <<"Trying to load: "<<(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name)<<"\n";
		// Loading externals
		// 0.40 with multi class into 1 .so
		if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.fileName.length()>0)
		{
		EngineConfiguration->xLoadModule(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.fileName);
		}
		else{
		EngineConfiguration->xLoadModule(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name);
		}
	}

	// Searching for External Engine Modules
	// at least we need:
	// xMatrix
	/*
	if(XEObject::xFindObject("xMatrix")==NULL)
	{
		new XEMatrixPanther(EngineRoot,"xMatrix");
	}
	*/
	// xTray
	QObject *m_tray=XEObject::xFindObject("xTray");
	if(m_tray!=NULL)connect(m_tray,SIGNAL(quitSelected()),this,SLOT(QueryClose()));


	// Engine Setup
	EngineConfiguration->xSetup();
	PluginXMLConf->xXMLExplode();
	EngineRoot->xSetup();
	// modules list
	const QStringList pl=XEObject::xGetPluginListNames();
	kdWarning() <<"Plugins loaded:\n";
	for(uint i=0;i<pl.count();i++)
	{
		kdWarning() <<QString("[%1] ").arg(i)<<pl[i]<<"\n";
	}
	// Engine Start
	EngineRoot->xStart();

	// After starts
	kapp->setMainWidget((QWidget *)XEObject::xGetDocker());
	kdWarning() <<i18n("Going to background...")<<"\n";
	connect(this, SIGNAL( shutDown() ), this, SLOT(xStop()));
}

KXDocker::~KXDocker()
{
}



/*!
    \fn KXDocker::QueryClose()
 */
void KXDocker::QueryClose()
{

}


/*!
    \fn KXDocker::xStop()
 */
void KXDocker::xStop()
{
	PluginXMLConf->xStop();
	EngineRoot->xStop();
}
