/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGDOCKERFAKE_H
#define XGDOCKERFAKE_H

#include <xgdocker.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qpixmap.h>
#include <qstring.h>
#include <time.h>
#include "xgicon.h"



class XEMatrix;
class QTimer;
class QRect;
class QPoint;
class QMutex;
class QString;
class QTime;
class XEConfiguration;
class KIconLoader;
class KRootPixmap;
class KPixmapIO;
class KSharedPixmap;
class XEPlugin_GEPillow;


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XGDockerFake : public XGDocker
{
Q_OBJECT
public:
    XGDockerFake(QWidget *parent = 0, const char *name = 0);
    ~XGDockerFake();
/** import **/
protected:
	void (XGDockerFake::*funz1)(int,int,int,Qt::ButtonState);
protected:

	#ifdef ENABLE_SPECIALENGINE2
		int xLastX_notmanaged;
		int xLastY_notmanaged;
	#endif

	int 		backgroundBarAniFrame;
	float maxDesaturate;
	int xBar;
	int yBar;
	int dxBar;
	int dyBar;
	int LayoutPosition;
	int mayRequireDoChangeBackground;
	int lastActionis;
	int l;
	int t;
	int w;
	int h;
	int xMakeWidgetCenterDeltaX;
	int isLowering;
	int isDropping;
	int isDragging;
	int hasDragged;
	int m_Desk;
	int fakeHeightDesktop;
	int alternativeHeightDesktop;
	int AxisAreInverted;
	int xLastY_real;
	int xLastX_real;
	int isRaised,xDesignVirtualYMatrix, lastRaise, lastIcon;
	int lastIconActivated;
	int 		RefreshMask;
	uint 		activeIconsCounter;
	float lastDesaturate;
	float Desaturate;
	Qt::ButtonState lastButtonStatus;
	QBitmap 	maskBackground;
	QBitmap 	maskSliding;
	QBitmap 	maskBuffer;
	QBitmap		maskFull;
	QBitmap		fakeDesktop;
	QImage		imgWindow;
/*
	QImage		imgFakeBackground;
	QImage		imgFakeBackgroundGlobal;
	QImage		imgFakeBackgroundAfterTransparency;
*/
	//QImage 		imgBackground;
	QImage 		paintBuffer;
	QValueList<int> xcache;
	QValueList<int> ycache;
	timespec 	req,   rem;
	timespec 	req2,   rem2;
	QMutex 		*Busy;
	QMutex 		*cacheBusy;
	QPoint		 *p1;
	QPoint 		*p2;
	QRect		 rect;
	QRect 		m_Rect;
	QString 	pattern;
	QString 	lastBackgroundPath;
	QTime 		*mouseMoveTimeElapsed;
	//QTimer 		* polling;
	QTimer		*tMouseMoved;
	QTimer		*tAutoHideTimer;
	QTimer		*tPostIconAdd;
	//QTimer		*tPostShowRaise;
	QTimer		*tAutoSendBGTimer;
	QTimer		*tAnimateBackground;
	XSConfigurations * ActiveConfiguration;
	XEMatrix 	*Matrix;
	XGIcon 		*activeIcons[MAX_ICONS];
	XGIcon 		*lastIconDrag;
	XGIcon		backgroundBar;
	XGIcon		backgroundBarAni[64];
	XGIcon		backgroundBarLeft;
	XGIcon		backgroundBarRight;
	XGIcon		backgroundBarOver;
	XGIcon		OriginalbackgroundBar;
	XGIcon		OriginalbackgroundBarLeft;
	XGIcon		OriginalbackgroundBarRight;
	XGIcon		OriginalbackgroundBarOver;
	KIconLoader	*KDEIconLoader;
	//KRootPixmap	*KDesktopBackground;
	KPixmapIO	*PixmapConverter;
	//KSharedPixmap 	*m_pPixmap;
	XEConfiguration *Configurator;
	XEPlugin_GEPillow	*xPillow;
protected:
	void xReset();
    void xRecalibrate();
public:
	QImage * xGetBackground();
	void mouseMoveEventSW(int x,int y,int force=0,Qt::ButtonState button=Qt::NoButton);
	int xGetIconIndex(const QObject*);
	XGIcon * xGetPointerObjectIcon(int);
	int getRaised();
	void xUpdate(int EnableTransparency=0, int pass=0);
	void xCheckBackgroundSeparators();
public slots:
	void paint(QImage &);
	void xStopAnimateBackground();
	void xStartAnimateBackground();
	void xBliz(int);
	//void xBliz(int isDesktop=0);
	void xMouseMoveSoftware(int,int);
	void xEventShowRaised();
	void xEventRemovedIcon(int);
	void xStart();
	void xStop();
	void xSetup();
	void wheelEvent(QWheelEvent *);
	void xChangeBackground(const QString &);
	void xGetObjectIcon(int,XGIcon *&);
	//void xReloadIcon(int);
	void xEventTaskAppend(int);
	void xGetInfo(QStringList &);
	void xEventReloadIcon(int);
	void xParse(const QString &, int, void *);
	void xUpdateRepaint(int);
	void xGetParameterList(QStringList *);
	void xGetParameter(const QString, QString&);
	void xSetupParameter(const QString, const QString);
	void xDockerRedraw();
	void xDockerRedraw(QObject *);
	void createPopup(KPopupMenu *&,const QObject *);
	void getPopupMenu(KPopupMenu *&, const QObject *);
	void xUpdateSense();
protected slots:
void backgroundPostDone(bool);
//void showRaisedPost2();
void xEventTaskAppendPost();
//void showRaisePost();
void xIRQ_MouseTimeout();
void backgroundCicle();
void xIRQ_Reset();
void xPostStart();
void xSendToBackground();
void mouseMoveEvent( QMouseEvent *e );
void paintEvent( QPaintEvent *e);
void xRestore();
void polish();
void dragEnterEvent(QDragEnterEvent* event);
void dragLeaveEvent (QDragLeaveEvent * );
void xStep();
void xHide();
void hide();
void show();
void lower();
void xStartStepping();
    void xSwapIcons(int,int);
private:
/***************************/
void mouseMoveSoftware(int,int);
//void reloadIcon(int icon);
void dropEvent(QDropEvent* event);
void dragMoveEvent( QDragMoveEvent * );
void mouseReleaseEvent ( QMouseEvent * e );
int xGetLayout();
void xUpdateRepaintFast(int myIndex);
void xUpdateMatrix();
void xCfgChanged(QObject *XECfgObject=NULL);
void mousePressEvent( QMouseEvent *e );
void iconAdd(const XSGObjectIcon *, int index=-1);
void changeBackground(const QString basePath);
void xDrawPillow();
void purgeCacheMovements();
void xMoveWidgetCenter();
void xGetWidget(QWidget *&);
void xDockerRedrawFast(QObject *);
void xBackgroundMove(int,int);
void xBackgroundGetCoords(int &,int &);
void xSetDesaturate(float);
void paintIn(QImage &,int Erase=0);
void setUnShadowed();
void applyCfg();
void maskGenerareBigFake();
int checkBackgroundSeparators();
void xUpdateSmooth();
void xUpdateDrawBackground(int);
void xUpdateDrawBackgroundPass2();
//void drawVeryFakeBackground();
void xUpdateBackgroundCoords();
void changeBackgroundForce(const QString basePath);
void createBackgroundSeparators();
void updateBackgroundSeparator(int);
void xUpdateRepaintInline(int);
void xDrawPillow2();
void xUpdateRepaintMiniTextInline(int);
void startDrag();
//QPixmap xEventGetBackground(int,int,int,int);
void xUpdatePart1(int,int);
signals:
void xWarningMsg(const QObject *, const QString &);
void xEventMouseMoved(int,int);
void xEventMouseClick(int,int,int,int);
void xEventReset(int,int);
void xEventAnimateTo(int,int,int,int);
void xEventMouseWheel(int,int,int,int);
void xEventDockerHidden();
void xEventWidgetMoved(int,int,int,int,int,int);
void xEventWidgetBeforeMoved(int,int,int,int,int,int,int,int);
void xEventDockerShowed();
void xEventDockerSendToBackground();
void dropIcon(int,QDropEvent*);
void xEventAddedIcon(int);
void xSetup(const QString &);
void xStart(const QString &);
void xStop(const QString &);
void xEventHighlightIcon(int,void *);
/**************************/


};

#endif
