/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_COMMAND_H
#define XEPLUGIN_COMMAND_H

#include <qobject.h>
#include <qstring.h>

/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_Command : public QObject
{
Q_OBJECT
public:
    XEPlugin_Command(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_Command();
protected:
class XEConfiguration *Configurator;
class XSConfigurations *ActiveConfiguration;
class XGDocker	*xGDocker;
QString lastIconExec;
class XSCfgTasks *lastProcess;
class XSGObjectIcon *lastIcon;
void preloadXMLcfg();
QString onClickMiddle;
QString onClickLeft;
public slots:
    void xGetParameter(const QString,QString&);
    void xEventMouseClick(int,int,int,int);
    void xSetup();
    void xStop();
    void xStart();
    void xEventMouseWheel(int,int,int,int);
    void xGetParameterList(QStringList*);
    void dropIcon(int,QDropEvent*);
    void dropIconAddIcon(int,QDropEvent*);
    void xGetInfo(QStringList &);
    void xSetupParameter(const QString, const QString);
protected:
    void popMenu(class XSCfgTasks *);
    void clickMiddle(int iconIndex);
    void updateXMLcfg(const QString sName);
    void popMenuFunction(XSCfgTasks *Process, int isSmall);
    void restore_hideAll();
protected slots:
    void RunLastCmd();
    void closeAll();
    void maximizeAll();
    void minimizeAll();
    void activated(int);
    void KeepInDock();
    void popMenuPost();
    void RunLastdcopClose();
    void clickMiddleExec(int);
    void clickMiddleExplode(int);
    void RunLastKill();
    void RunLastRemoveIcon();
    void restoreAll();
    void xParse(const QString &, int, void *);
    void RunLastConfigureIcon();
signals:
    void xParseTo(const QString &, int, void *);
};

#endif
