/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini                               *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _LIBKXDOCKER_H_
#define _LIBKXDOCKER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>

#define DCOPKXDOCKERNAME "kxdocker"
#define DCOPKXDOCKERIFACE "docker"
#define DCOPINDEXNONE -1
#define DCOPINDEXROLLING -2


class DCOPClient;


/**
 * @short Application Main Window
 * @author Stefano Zingarini <stefano@xiaprojects.com>
 * @version 0.2
 */
class libkxdocker : public QObject
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    libkxdocker(QWidget* parent, const char* name);

    /**
     * Default Destructor
     */
    virtual ~libkxdocker();
protected:
    DCOPClient *client;
    int kxdockerIconIndex;
    QString iconName;
    QString iconImg;
    QString overText;
    QString onClickExec;
    QString iconClass;
    QString groupName;
    QString fileName;
    QString windowTitle;
    QString taskName;
    QString taskClass;

public slots:
    void setPixmap(const QPixmap &);
    void bounce();
    void setClientCaption(const QString &);
    void setClientTask(const QString &);
    void hide();
    void show();
    void loadIcon(const QString &);
    void clear();
    void roll(bool);
    void rollDown();
    void rollUp();
    void setText(const QString &);
    void setClientClass(const QString &);
    void setAliasName(const QString &);
    void setGroup(const QString &);
    void setIconClassName(const QString &);
    void setName(const QString &);
    void setOnClickExec(const QString &);
    void setIconData(const QString &,const QString &,const QString &,const QString &,const QString &,const QString &,const QString &,const QString &,const QString &,const QString &);
    void repaint();
    void reset();
protected slots:
    void stopBounce();
    void startBounce();
protected:
    int findIcon();
    void dcopSetImage(const QString &);
    void dcopSetText(const QString &);
    void dcopAddIcon();
    void dcopRemoveIcon();
};

#endif // _LIBKXDOCKER_H_
