/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_THEMEBROWSER_H
#define XEPLUGIN_THEMEBROWSER_H

#include "wnd_browse_themes.h"
#include <qxml.h>
#include <qdom.h>
#include <libkxdocker.h>


class XEPlugin_ThemeBrowser: public wndbrowser {
Q_OBJECT
public:
    XEPlugin_ThemeBrowser(QWidget *parent = 0, const char *name = 0);
    ~XEPlugin_ThemeBrowser();
public slots:
    void xLoadXmlUrl(const QString &);
    void xParse(const QString &, int, void *);
    void xConfigure();
    virtual void update_clicked();
    virtual void lineEdit3_textChanged(const QString&);
    virtual void Mirror_textChanged(const QString&);
    virtual void Username_textChanged(const QString&);
    virtual void install_clicked();
    virtual void filter_textChanged(const QString&);
    virtual void themelist_selectionChanged(QListViewItem*);
    void xGetInfo(QStringList &);
    void xGetParameter(const QString, QString &);
    void xGetParameterList(QStringList *);
    void xSetup();
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void install_theme(const QString, const QString);
    virtual void apply_clicked();
    virtual void remove_clicked();
protected:
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	class XEConfiguration *Configurator;
	void cfg_fill_theme_list(QDomNodeList &);
	void cfg_fill_theme_mirror(QDomNodeList &);
	void cfg_fill_theme_menu(QDomNodeList &);
	QString  fetch_label_type(const QString &);
	void updateXMLcfg(const QString, const QString);
	QDomNodeList xmlContent;
	QDomNodeList xmlMenu;
	QDomNodeList xmlMirrors;
	int EditingFields;
	QString lastTheme;
	QString m_TARBZ2;
	QString m_Name;
	QString m_Type;
	QString m_Uninstall;
	QString prev_lastTheme;
signals:
    void xSetupParameterTo(const QString,const QString);
};

#endif
