/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_TASKMANAGER_H
#define XEPLUGIN_TASKMANAGER_H

#include <qobject.h>
#include <qstring.h>

#include <qobject.h>
#include <klocale.h>
#include <kwinmodule.h>
//#include "taskmanager.h"
#include <libkxdocker.h>

#include <stdlib.h>
#include <unistd.h>
#include <time.h>


class DCOPClient;

/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_TaskManager : public QObject
{
Q_OBJECT
public:
    XEPlugin_TaskManager(QObject *parent = 0, const char *name = 0);

    ~XEPlugin_TaskManager();

protected:
	QString TracingName1;
	QString TracingName2;
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	class KWinModule	*KDEWM;
	class TaskManager	*KDETaskManager;
	class XEConfiguration *Configurator;
	int showWindowsOnlyFromThisDesktop;
	int showGroupWindows;
	int autoAddSeparator;
	int thumbnailShowIcon;
	DCOPClient    * dcopClient;
	timespec	req,rem;
	QString		activeOverlay;
	void removeIcon(Task *);
	void clonate(class XSGObjectIcon *,XSGObjectIcon *);
	void gotTaskInCache(class XSGObjectIcon *);
	void updateXMLcfg(const QString Name);
	void taskActivatedMultipass(Task *t);
	void taskActivatedCheckTitle(Task *t);
	void xUpdateMiniText(int);
	void dockAppAdded(class XGIcon *,Task *);
protected slots:
    void currentDesktopChanged(int desktop);
    void startupAdded(Startup*);
    void startupRemoved(Startup*);
    void taskAdded(Task*);
    void taskRemoved(Task*);
    void thumbnailChanged(Task *);
    void taskActivated(Task*);
    void dcopPolling();
    void dcop_applicationRemoved(const QCString &);
    void dcop_applicationRegistered(const QCString &);
public slots:
    void xSetup();
    void xStart();
    void xStop();
    void xSetupParameter(const QString, const QString);
    void xSetupParameter(const QString sName, int iValue);
    void xGetParameter(const QString, QString&);
    void xGetParameter(const QString, int&);
    void xToggleShowAll();
    void xGetParameterList(QStringList *);
signals:
    void xEventStartAnimating(const QString &);
    void xEventStopAnimating(const QString &);
    void xEventStartAnimatingUnknown(const QString &);
    void xEventStopAnimatingUnknown(const QString &);
    void xEventStartAnimating(int);
    void xEventStopAnimating(int);
    void xEventTaskClosed(int);
    void xEventTaskOpen(int);
    void xEventTaskAppend(int);
    void xBliz(int);

};

#endif
