/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <xeplugin_gapplet.h>
#include <xeobject.h>
#include <xeconfiguration.h>
#include <xgicon.h>
#include <xgdocker.h>

#include <kstandarddirs.h>
#include <kiconloader.h>
#include <qpopupmenu.h>
#include <kpopupmenu.h>
#include <qdatetime.h>

XEPlugin_GApplet::XEPlugin_GApplet(QObject *parent, const char *name)
 : QObject(parent, name)
{
	XEObject::xPluginAdd(this);
	xGIcon=NULL;
	PluginName="gdate";
}


XEPlugin_GApplet::~XEPlugin_GApplet()
{
}


#include "xeplugin_gapplet.moc"


/*!
    \fn XEPlugin_GApplet::xSetup()
 */
void XEPlugin_GApplet::xSetup()
{
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	
	QString cfgPath="kxdocker/plugins/";
	cfgPath=cfgPath+PluginName;
	cfgPath=cfgPath+"/";
	IconsPath=::locate("data",cfgPath);
}


/*!
    \fn XEPlugin_GApplet::xRefresh()
 */
void XEPlugin_GApplet::xRefresh()
{
	if(xGIcon==NULL)return;
	xPaint();
	
	xGIcon->xImgSource=xImgSource;
	
	xGIcon->cachePurge();
//	xGIcon->xSetSmoothZoom(xGIcon->xZoom);
	xGIcon->xSetSmoothZoom();
	//xGIcon->xSetUpdate=1;
	
	//xGDocker->xUpdate();
	xGDocker->xDockerRedraw(xGIcon);
	QTimer::singleShot(1000+ 60*1000*(60-QTime::currentTime().minute()), this, SLOT(xRefresh()) );
	//xGDocker->repaint(false);
}


/*!
    \fn XEPlugin_GApplet::xStart()
 */
void XEPlugin_GApplet::xStart()
{
	if(xGIcon!=NULL){
	
	if(xGIcon->iconConfiguration->PluginConfiguration.count()>0)
	{
		IconsPath=
			xGIcon->iconConfiguration->PluginConfiguration
			.item(0).toElement().attribute("path",IconsPath);
	}
	}

	xRefresh();
}


/*!
    \fn XEPlugin_GApplet::xStop()
 */
void XEPlugin_GApplet::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GApplet::xAttach(XGIcon *)
 */
void XEPlugin_GApplet::xAttach(QObject *newIcon)
{
	// ok have to write the buffer into
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=(XGIcon *)newIcon;
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
		
		if(!xGIcon->iconConfiguration->PluginPopupMenu)
		{
			KIconLoader KDEIcons;

//			xGIcon->iconConfiguration->PluginPopupMenu=new KPopupMenu();
			//xGDocker->createPopup(xGIcon);
			xGDocker->createPopup(PluginPopup,xGIcon);
			//xGIcon->createPopup();
			//if(!xGIcon->iconConfiguration->PluginPopupMenu)return;
			//xGIcon->iconConfiguration->PluginPopupMenu->
			if(!PluginPopup)return;
			PluginPopup->insertItem(
			KDEIcons.loadIcon("window_new",KIcon::Small)
			,"Refresh",
			this,SLOT(xRefresh()));
		}
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
	//xRefresh();
}


/*!
    \fn XEPlugin_GApplet::xPaint();
 */
void XEPlugin_GApplet::xPaint()
{

	// 20040612 patch
	// now icons are search from: refer to manual
	// example:
	// 2004-06-12  04PM
	QString cfgPath="kxdocker/plugins/";
	cfgPath=cfgPath+PluginName;
	cfgPath=cfgPath+"/";
	QString IconsPath2=::locate("data",cfgPath);
	
	if(IconsPath==NULL)IconsPath=IconsPath2;
	
	char filename[20];
	sprintf(filename,"%02d_%02d.png",QDate::currentDate().month(),QDate::currentDate().day());
	QPixmap px=findBase(filename,IconsPath);
	if(!px.isNull())
	{
		xImgSource=px.convertToImage();
		return;
	}
	int riempito=0;
	// this will help to auto create transparency
	QImage pi;
	px=findBase("gdate.png",IconsPath);
	if(px.isNull())
	{
		px=findBase("gdate.png",IconsPath2);
	}
	
	if(px.isNull())
	{
		QImage TBuffer;
		TBuffer.create(
			ActiveConfiguration->Icons.SizeBig,
			ActiveConfiguration->Icons.SizeBig,
			32);
		
		TBuffer.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		//px.convertFromImage(TBuffer);
		pi=TBuffer;
	}
	else
	{
		riempito++;
		pi=px.convertToImage();
	}
	
	sprintf(filename,"%02dd.png",QDate::currentDate().day());
	QPixmap pxd=findBase(filename,IconsPath);
	if(pxd.isNull())
	{
		pxd=findBase(filename,IconsPath2);
	}
	if(!pxd.isNull())
	{
		riempito++;
		QImage pid=pxd.convertToImage();
		bitBlt(&pi,0,0,&pid,0,Qt::CopyROP);
	}
	sprintf(filename,"%02dm.png",QDate::currentDate().month());
	QPixmap pxm=findBase(filename,IconsPath);
	if(pxm.isNull())
	{
		pxm=findBase(filename,IconsPath2);
	}
	if(!pxm.isNull())
	{
		riempito++;
		QImage pim=pxm.convertToImage();
		bitBlt(&pi,0,0,&pim,0,Qt::CopyROP);
	}
	sprintf(filename,"%02dw.png",QDate::currentDate().dayOfWeek ());
	QPixmap pxw=findBase(filename,IconsPath);
	if(pxw.isNull())
	{
		pxw=findBase(filename,IconsPath2);
	}
	if(!pxw.isNull())
	{
		riempito++;
		QImage piw=pxw.convertToImage();
		bitBlt(&pi,0,0,&piw,0,Qt::CopyROP);
	}
	// the sun is not copyed because the theme may not support it
	sprintf(filename,"%02dh.png",QTime::currentTime().hour());
	QPixmap pxh=findBase(filename,IconsPath);
	if(!pxh.isNull())
	{
		riempito++;
		QImage pih=pxh.convertToImage();
		bitBlt(&pi,0,0,&pih,0,Qt::CopyROP);
	}
	sprintf(filename,"%02dhm.png",QTime::currentTime().minute());
	QPixmap pxhm=findBase(filename,IconsPath);
	if(!pxhm.isNull())
	{
		riempito++;
		QImage pihm=pxhm.convertToImage();
		bitBlt(&pi,0,0,&pihm,0,Qt::CopyROP);
	}



	xImgSource=pi;
	if(!riempito)
	{
	px=findBase(filename,IconsPath2);
	if(!px.isNull())
	{
		xImgSource=px.convertToImage();
//		return;
	}
	}
}


/*!
    \fn XEPlugin_GApplet::xRefreshIcon(QObject *)
 */
void XEPlugin_GApplet::xRefreshIcon(QObject *newIcon)
{
	if(newIcon==xGIcon)
	{
		xPaint();
	xGIcon->xImgSource=xImgSource;
	
	xGIcon->cachePurge();
//	xGIcon->xSetSmoothZoom(xGIcon->xZoom);
	xGIcon->xSetSmoothZoom();
		// xGDocker will auto - repaint
	}
}


/*!
    \fn XEPlugin_GApplet::findBase(const QString, const QString)
 */
QPixmap XEPlugin_GApplet::findBase(const QString fn, const QString fp)
{
	QString a=fp;
	a=a+"/";
	a=a+fn;
	QPixmap px(a);
    	return px;
}


/*!
    \fn XEPlugin_GApplet::xGetParameter(const QString vname, QString&vvalue)
 */
void XEPlugin_GApplet::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="path")
	{
	vvalue=	IconsPath;
	}
}


/*!
    \fn XEPlugin_GApplet::xSetupParameter(const QString vname, const QString vvalue)
 */
void XEPlugin_GApplet::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="path")
	{
		IconsPath=vvalue;
	}
	// refreshing XML Data
	if(xGIcon!=NULL){
	if(xGIcon->iconConfiguration->PluginConfiguration.count()>0)
	{
		xGIcon->iconConfiguration->PluginConfiguration
			.item(0).toElement().setAttribute("path",IconsPath);
	}
	else
	{
		qWarning("Error: loaded xml doesn't store all data:");
		qWarning("void XEPlugin_GAClock::xSetupParameter(const QString vname, const QString vvalue)");
		
		//qWarning("Trying to add this parameter...");
		
	}
	}
}


/*!
    \fn XEPlugin_GApplet::xGetParameterList(QStringList *a)
 */
void XEPlugin_GApplet::xGetParameterList(QStringList *a)
{
	a->append("path");
}
