/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_configurator.h"

#include <xeconfiguration.h>
#include <xgdocker.h>

#include <qtabwidget.h>
#include <qvbox.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qsizepolicy.h>
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qcheckbox.h> 
#include <qradiobutton.h>
#include <qbuttongroup.h> 
#include <qvbuttongroup.h> 
#include <qslider.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qgrid.h> 
#include <qlistview.h>
#include <qstatusbar.h>
#include <qdatetime.h> 
#include <qtextedit.h>

#include <kmainwindow.h>
#include <kfontrequester.h>
#include <kcolorbutton.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kicondialog.h>
#include <knuminput.h> 
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kcombobox.h> 

#include <xematrix.h>


XEPlugin_Configurator::XEPlugin_Configurator(QWidget *, const char *name)
 : KMainWindow(0, name)
{
	XEObject::xPluginAdd(this);
//	LastItem=NULL;
	guiCreate();
	guiDefault();
	guiPrepare();
}


XEPlugin_Configurator::~XEPlugin_Configurator()
{
}


#include "xeplugin_configurator.moc"


/*!
    \fn XEPlugin_Configurator::xConfigure()
 */
void XEPlugin_Configurator::xConfigure()
{
	#ifndef ENABLE_FINAL
		qWarning("void XEPlugin_Configurator::xConfigure()");
	#endif
	show();
}


/*!
    \fn XEPlugin_Configurator::xStart()
 */
void XEPlugin_Configurator::xStart()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Configurator::xStop()
 */
void XEPlugin_Configurator::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Configurator::xSetup()
 */
void XEPlugin_Configurator::xSetup()
{
	#ifndef ENABLE_FINAL
		qWarning("void XEPlugin_Configurator::xSetup()");
	#endif
	
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();if(Configurator==NULL || xGDocker==NULL)
	{
		// Emits Signal of warning
		//xWarningMsg(this,"error while searching for plugin");
		qWarning(i18n("KXDocker: Error while searching for plugin"));
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	// new configuration engine without plugins
	//QObject *xmlWriter=XEObject::xFindObject("xXML");
	
	QObject *xmlWriter=XEObject::xGetXMLParser();
	if(xmlWriter)
		connect(
		this,
		SIGNAL(xCfgWrite(const QString &)),
		xmlWriter,
		SLOT(xXMLStore(const QString &)));
	
	guiRefreshValues();
}


/*!
    \fn XEPlugin_Configurator::guiCreate()
 */
void XEPlugin_Configurator::guiCreate()
{
	//QVBox	*kdialogv=new QVBox(this);
    ToolBar=new KToolBar(this);
    tabs=new QTabWidget(this);
    statusBar=new QStatusBar(this);
    
    QVBox	*vpage1=new QVBox(tabs);
    QVBox	*vpage2=new QVBox(tabs);
    QVBox	*vpage7=new QVBox(tabs);
    QVBox	*vpage3=new QVBox(tabs);
    QVBox	*vpage4=new QVBox(tabs);
    QVBox	*vpage5=new QVBox(tabs);
    QVBox	*vpage6=new QVBox(tabs);
    QVBox	*vpage8=new QVBox(tabs);

    tabs->insertTab(vpage1,i18n("Info"));
    tabs->insertTab(vpage2,i18n("Objects"));
    tabs->insertTab(vpage7,i18n("Alias"));
    tabs->insertTab(vpage3,i18n("Themes"));
    tabs->insertTab(vpage4,i18n("Window"));
    tabs->insertTab(vpage5,i18n("Icons"));
    tabs->insertTab(vpage8,i18n("Plugins"));
    tabs->insertTab(vpage6,i18n("Draw Engine"));
#ifdef ENABLE_STATS
    QVBox	*vpageStat=new QVBox(tabs);
    tabs->insertTab(vpageStat,i18n("Stats"));
    create_statistics(vpageStat);
#endif


    AutoSave=new QCheckBox(i18n("Auto save on exit"),vpage1);
    create_about(vpage1);
    
    
   // QHBox	*hpage3=new QHBox(vpage3);
    
    QGrid	*gpage3= new QGrid(3,vpage3);
    
    new QLabel(i18n("BackgroundPath"), gpage3);
    BackgroundPath=new QLineEdit(gpage3);
    pBackgroundPath=new QPushButton("...",gpage3);
    
   // hpage3=new QHBox(vpage3);
    new QLabel(i18n("PillowPath"), gpage3);
    PillowPath=new QLineEdit(gpage3);
    pPillowPath=new QPushButton("...",gpage3);
    new QLabel(i18n("MiniTextPath"), gpage3);
    PillowPath2=new QLineEdit(gpage3);
    pPillowPath2=new QPushButton("...",gpage3);
    
    //hpage3=new QHBox(vpage3);
    new QLabel(i18n("PoofPath"), gpage3);
    PoofPath=new QLineEdit(gpage3);
    QPushButton	*pPoofPath=new QPushButton("...",gpage3);
    
    new QLabel(i18n("ArrowPath"), gpage3);
    ArrowPath=new QLineEdit(gpage3);
    QPushButton	*pArrowPath=new QPushButton("...",gpage3);

    QVGroupBox *gb3_0=new QVGroupBox(i18n("Background images"),vpage3);
   
    QGrid	*gpage3_g0= new QGrid(2,gb3_0);
    new QLabel(i18n("Left"), gpage3_g0);
    imgBackgroundLeft=new QLineEdit(gpage3_g0);

    new QLabel(i18n("Center"), gpage3_g0);
    imgBackgroundCenter=new QLineEdit(gpage3_g0);
    new QLabel(i18n("Right"), gpage3_g0);
    imgBackgroundRight=new QLineEdit(gpage3_g0);
    new QLabel(i18n("Over"), gpage3_g0);
    imgBackgroundOver=new QLineEdit(gpage3_g0);
    new QLabel(i18n("Separator"), gpage3_g0);
    imgBackgroundSeparator=new QLineEdit(gpage3_g0);
    new QLabel(i18n("Desaturate background"), gpage3_g0);
    imgBackground_Desaturate=new KIntSpinBox(gpage3_g0);
    imgBackground_Tiled=new QCheckBox(i18n("Tile the background image"),gb3_0);
    
    QVGroupBox *gb3_1=new QVGroupBox(i18n("Icons themes (search paths)"),vpage3);
    //QHBox	*gpage3_h=new QHBox(gb3_1);
   iconsPathToolBar=new KToolBar(gb3_1);
    
    //QPushButton	*pIconsPathAdd=new QPushButton("Add",gpage3_h);
    //QPushButton	*pIconsPathRemove=new QPushButton("Remove",gpage3_h);
    iconsPaths= new QListBox(gb3_1);
    

    
    QVButtonGroup *gb4_0=new QVButtonGroup(i18n("Docker position"),vpage4);
    QGrid	*gpage4_g0= new QGrid(3,gb4_0);
    new QWidget(gpage4_g0);
    rAlignTop=new QRadioButton(i18n("Top"),gpage4_g0);
    new QWidget(gpage4_g0);
    
    rAlignLeft=new QRadioButton(i18n("Left"),gpage4_g0);
    new QWidget(gpage4_g0);
    rAlignRight=new QRadioButton(i18n("Right"),gpage4_g0);
    
    new QWidget(gpage4_g0);
    rAlignBottom=new QRadioButton(i18n("Bottom"),gpage4_g0);
    new QWidget(gpage4_g0);
    
    QVGroupBox *gb4_1=new QVGroupBox(i18n("Border (Icons)"),vpage4);
    QGrid	*ggpage4_h=new QGrid(2,gb4_1);
    //QHBox	*gpage4_h=new QHBox(gb4_1);
    new QLabel(i18n( "borderLeft"), ggpage4_h);
    borderLeft=new KIntSpinBox(ggpage4_h);
    //gpage4_h=new QHBox(gb4_1);
        
    new QLabel(i18n( "borderTop"), ggpage4_h);
    borderTop=new KIntSpinBox(ggpage4_h);
    //gpage4_h=new QHBox(gb4_1);
    
    new QLabel(i18n("TopForce"), ggpage4_h);
    QGrid	*gpage4_h=new QGrid(2,ggpage4_h);
    sTopForce=new QSlider(Qt::Horizontal,gpage4_h);
    TopForce=new KIntSpinBox(gpage4_h);
    
    new QLabel(i18n("LeftForce"), ggpage4_h);
    
    //gpage4_h=new QHBox(ggpage4_h);
    sLeftForce=new QSlider(Qt::Horizontal,gpage4_h);
    LeftForce=new KIntSpinBox(gpage4_h);
    
    QVButtonGroup *gb4_2=new QVButtonGroup(i18n("Desktop"),vpage4);
    
    QGrid	*gpage4_h2=new QGrid(1,gb4_2);
    
    SendToBackground=new QCheckBox(i18n("Auto Send to background"),gpage4_h2);
    RaiseOnEvents=new QCheckBox(i18n("Auto Raise on Events"),gpage4_h2);
    FastHide=new QCheckBox(i18n("Enable Fast Hiding"),gpage4_h2);
    
    HideMouseCornerRight=new QCheckBox(i18n("Mouse must touch Right corner"),gpage4_h2);
    HideMouseCornerLeft=new QCheckBox(i18n("Mouse must touch Left corner"),gpage4_h2);
    
    gpage4_h2=new QGrid(3,gb4_2);
        
    new QLabel(i18n("Auto hide timeout (s)"), gpage4_h2);
    sHideTimeout=new QSlider(Qt::Horizontal,gpage4_h2);
    HideTimeout=new KIntSpinBox(gpage4_h2);
    
    new QLabel(i18n("Auto Raise to Forground timeout (ms)"), gpage4_h2);
    sSendToForgroundTimeout=new QSlider(Qt::Horizontal,gpage4_h2);
    SendToForgroundTimeout=new KIntSpinBox(gpage4_h2);
    
    
    new QLabel(i18n("Dekstop resize"), gpage4_h2);
    sHeightDesktop=new QSlider(Qt::Horizontal,gpage4_h2);
    HeightDesktop=new KIntSpinBox(gpage4_h2);
    
    QVButtonGroup *gb5_0=new QVButtonGroup(i18n("Icons Sizes and positions"),vpage5);
    QGrid	*gpage5_h2=new QGrid(3,gb5_0);
    //QHBox	*gpage5_h2=new QHBox(gb5_0);
    new QLabel(i18n("Normal Size"), gpage5_h2);
    sSize=new QSlider(Qt::Horizontal,gpage5_h2);
    Size=new KIntSpinBox(gpage5_h2);
    
//     //gpage5_h2=new QHBox(gb4_2);
    new QLabel(i18n("Magnified Size"), gpage5_h2);
    sSizeBig=new QSlider(Qt::Horizontal,gpage5_h2);
    SizeBig=new KIntSpinBox(gpage5_h2);
    
    //gpage5_h2=new QHBox(gb4_2);
    new QLabel(i18n("Space between icons"), gpage5_h2);
    sSeparation=new QSlider(Qt::Horizontal,gpage5_h2);
    Separation=new KIntSpinBox(gpage5_h2);
    
    
    QVButtonGroup *gb4_3=new QVButtonGroup(i18n("Sliding parameters"),vpage5);
    //QHBox	*gpage4_h3=new QHBox(gb4_3);
    QGrid	*gpage4_h3=new QGrid(3,gb4_3);
    new QLabel(i18n("Design"), gpage4_h3);
    new QWidget(gpage4_h3);
    Design=new QComboBox(gpage4_h3);
    
    //gpage4_h3=new QHBox(gb4_3);
    new QLabel(i18n("How much raise icons"), gpage4_h3);
    sRaise=new QSlider(Qt::Horizontal,gpage4_h3);
    Raise=new KIntSpinBox(gpage4_h3);
    
    //gpage4_h3=new QHBox(gb4_3);
    new QLabel(i18n("unMagnify sliding"), gpage4_h3);
    sHoriz=new QSlider(Qt::Horizontal,gpage4_h3);
    Horiz=new KIntSpinBox(gpage4_h3);

    AutoResize=new QCheckBox(i18n("Auto resize icons if the dock does not fit into the screen"),gb4_3);

    
    QVButtonGroup *gb4_4=new QVButtonGroup(i18n("Visualizations Options"),vpage5);
    EnableThumbnail=new QCheckBox(i18n("Enable Thumbnails"),gb4_4);
    QGrid		*ggb4_4=new QGrid(2,gb4_4);
    new QLabel(i18n("Font"), ggb4_4);
    FontFamily=new KFontRequester(ggb4_4);
    new QLabel(i18n("Color"), ggb4_4);
    FontColor=new KColorButton(ggb4_4);

    new QLabel(i18n("Mini Font"), ggb4_4);
    FontFamilyMini=new KFontRequester(ggb4_4);
    new QLabel(i18n("Mini Color"), ggb4_4);
    FontColorMini=new KColorButton(ggb4_4);


    new QLabel(i18n("Max icons showed"), ggb4_4);
    MaxIconsShowed=new KIntSpinBox(ggb4_4);
    
    
    QVButtonGroup *gb6_0=new QVButtonGroup(i18n("Performance"),vpage6);
    QGrid		*ggb6_0=new QGrid(2,gb6_0);
    new QLabel(i18n("AND! Sizes Cached"), ggb6_0);
    AndZoomCache=new KIntSpinBox(ggb6_0);
#ifdef ENABLE_SPECIALENGINE2
    new QLabel(i18n("Interpolations (default=2)"), ggb6_0);
    InterpolationValue=new KIntSpinBox(ggb6_0);
#endif    
    

    
    QVButtonGroup *gb6_1=new QVButtonGroup(i18n("Sleep and Timers"),vpage6);
    QGrid		*ggb6_1=new QGrid(2,gb6_1);
    new QLabel(i18n("FPS 1/N(us)"), ggb6_1);
    SleepFPS=new KIntSpinBox(ggb6_1);
    
    new QLabel(i18n("SmoothTimeout (ms)"), ggb6_1);
    SmoothTimeout=new KIntSpinBox(ggb6_1);
    
    new QLabel(i18n("SleepThreads (ms)"), ggb6_1);
    SleepThreads=new KIntSpinBox(ggb6_1);
    new QLabel(i18n("SleepAnimations (us)"), ggb6_1);
    SleepAnimations=new KIntSpinBox(ggb6_1);
    

    ToolBar->insertButton("apply",4);
    ToolBar->insertButton("fileopen",1);
    ToolBar->insertButton("filesave",100,true,"Save");
    ToolBar->insertButton("filesaveas",2,true,"Save as");
    ToolBar->insertButton("fileclose",3,true,"Close");
    ToolBar->insertButton("wizard",101,true,"Wizard");
    //ToolBar->insertWidget(AutoSave,5);
    
    
    // * Icons *
    QHBox	*hbox_2=new QHBox(vpage2);
    iconsList= new KListView(hbox_2);
    iconsList->setSorting(-1);
    iconsList->addColumn(i18n("Name"));
    iconsList->addColumn(i18n("Group"));
    QVBox 	*vobjectsToolBar=new QVBox(hbox_2);
    objectsToolBar=new KToolBar(vobjectsToolBar);
    QTabWidget 	*objectsTabs=new QTabWidget(vobjectsToolBar);
    

    objectsToolBar->insertButton("apply",24);
    objectsToolBar->insertButton("wizard",5);
    objectsToolBar->insertButton("remove",6);
    objectsToolBar->insertButton("1downarrow",7);
    objectsToolBar->insertButton("1uparrow",8);
    
    iconsPathToolBar->insertButton("folder_new",9);
    iconsPathToolBar->insertButton("remove",10);
    iconsPathToolBar->insertButton("1downarrow",11);
    iconsPathToolBar->insertButton("1uparrow",12);

    
    
    QVBox	*objectsInfo=new QVBox(objectsTabs);
    QVBox	*objectsImages=new QVBox(objectsTabs);
    QVBox	*objectsActions=new QVBox(objectsTabs);
    QVBox	*objectsTasks=new QVBox(objectsTabs);
    QVBox	*objectsDCOP=new QVBox(objectsTabs);
    QVBox	*objectsPlugin=new QVBox(objectsTabs);
    objectsTabs->insertTab(objectsInfo,		i18n("Info"));
    objectsTabs->insertTab(objectsImages,	i18n("Images"));
    objectsTabs->insertTab(objectsActions,	i18n("Actions"));
    objectsTabs->insertTab(objectsTasks,	i18n("Tasks"));
    objectsTabs->insertTab(objectsDCOP,		i18n("DCOP"));
    objectsTabs->insertTab(objectsPlugin,	i18n("Plugin"));
    
    
	oPluginConfigure=new QPushButton("Configure",objectsPlugin);
	connect(oPluginConfigure,SIGNAL(clicked()),this,SLOT(xRunCfg()));
	QGrid *objectsPluginInfo=new QGrid(2,objectsPlugin);
	new QLabel(i18n("Name"),objectsPluginInfo);
	oPluginName=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("Version"),objectsPluginInfo);
	oPluginVersion=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("Date"),objectsPluginInfo);
	oPluginDate=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("Author"),objectsPluginInfo);
	oPluginAuthor=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("mail"),objectsPluginInfo);
	oPluginAuthorMail=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("Download"),objectsPluginInfo);
	oPluginUrlDownload=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("Documentation"),objectsPluginInfo);
	oPluginUrlDocumentation=new QLabel("",objectsPluginInfo);
	new QLabel(i18n("Updates"),objectsPluginInfo);
	oPluginUrlUpdate=new QLabel("",objectsPluginInfo);

    
    oPluginCfg	=new KListView(objectsPlugin);
    oPluginCfg->addColumn(i18n("Name"));
    oPluginCfg->addColumn(i18n("Value"));
    oPluginCfg->setItemsRenameable(true);
    oPluginCfg->setRenameable(0,false);
    oPluginCfg->setRenameable(1,true);
    
    objectsToolBarTasks=new KToolBar(objectsTasks);
    iconsListTasks= new KListView(objectsTasks);
    iconsListTasks->addColumn(i18n("Window Title"));
    iconsListTasks->addColumn(i18n("Task Name"));
    iconsListTasks->addColumn(i18n("Class Name"));
    iconsListTasks->setItemsRenameable(true);
    iconsListTasks->setRenameable(0,true);
    iconsListTasks->setRenameable(1,true);
    iconsListTasks->setRenameable(2,true);
    objectsToolBarTasks->insertButton("apply",17);
    objectsToolBarTasks->insertButton("window_new",15);
    objectsToolBarTasks->insertButton("remove",16);
    
    
    
	//0.29
	QGrid *objectsDCOPInfo=new QGrid(2,objectsDCOP);
	new QLabel("new window function",objectsDCOPInfo);
	odcopNewWindow=new QLineEdit(objectsDCOPInfo);
	new QLabel("raise function",objectsDCOPInfo);
	odcopRaise=new QLineEdit(objectsDCOPInfo);
	new QLabel(i18n("close function"),objectsDCOPInfo);
	odcopClose=new QLineEdit(objectsDCOPInfo);
    objectsToolBarDCOP=new KToolBar(objectsDCOP);
    iconsListDCOP= new KListView(objectsDCOP);
    iconsListDCOP->addColumn(i18n("dcop name"));
    iconsListDCOP->setItemsRenameable(true);
    iconsListDCOP->setRenameable(0,true);
    objectsToolBarDCOP->insertButton("apply",29);
    objectsToolBarDCOP->insertButton("window_new",30);
    objectsToolBarDCOP->insertButton("remove",31);

    
    
    QGrid	*gobjectsInfo=new QGrid(2,objectsInfo);
    new QLabel(i18n("Name"), gobjectsInfo);
    oName=new QLineEdit(gobjectsInfo);
//    new QTextEdit("Unique name for this object, you can manage this icon with DCOP by this name","", gobjectsInfo);
    new QLabel(i18n("Group"), gobjectsInfo);
    oGroup=new QLineEdit(gobjectsInfo);
//    new QLabel("Icons with same group will be \"rolled\" with mouse scroll", gobjectsInfo);
    new QLabel(i18n("className"), gobjectsInfo);
    oclassName=new KComboBox(true,gobjectsInfo);
//    new QLabel("Choose the right class, GIcon is a standard icon, GSeparator is a separaor, if you would like to load an external plugin installed you have to specify here the name, like GBattery", gobjectsInfo);
    new QLabel(i18n("Over Text showed"), gobjectsInfo);
    oOverText=new QLineEdit(gobjectsInfo);
//    new QLabel("Text showed over the icons when you move the mouse", gobjectsInfo);
       
    QGrid	*gobjectsImages=new QGrid(3,objectsImages);
    new QLabel(i18n("Icon"), gobjectsImages);
    oimgFileName=new QLineEdit(gobjectsImages);
    ioimgFileName=new KIconButton(gobjectsImages);
    new QLabel(i18n("Arrow Image (arrow.png)"), gobjectsImages);
    oimgFileArrow=new QLineEdit(gobjectsImages);
    new QLabel(i18n(""), gobjectsImages);
    new QLabel(i18n("Drop Image (drop.png)"), gobjectsImages);
    oimgFileDrop=new QLineEdit(gobjectsImages);
    new QLabel(i18n(""), gobjectsImages);

    
    new QWidget(gobjectsImages);
    
    QVBox	*vobjectsActions=new QVBox(objectsActions);
    QGrid	*gobjectsActions=new QGrid(2,vobjectsActions);
    new QLabel(i18n("onClickExec"), gobjectsActions);
    oonClickExec=new QLineEdit(gobjectsActions);
    new QLabel(i18n("onDropExec use %1 for filename"), gobjectsActions);
    oonDropExec=new QLineEdit(gobjectsActions);
    
    pXMLActionList=new KListView(vobjectsActions);
    pXMLActionList->addColumn(i18n("Info"));
    pXMLActionList->addColumn(i18n("Icon"));
    pXMLActionList->addColumn(i18n("Action"));
    pXMLActionList->addColumn(i18n("Data"));
    pXMLActionList->setItemsRenameable(true);
    pXMLActionList->setRenameable(0,true);
    pXMLActionList->setRenameable(1,true);
    pXMLActionList->setRenameable(2,true);
    pXMLActionList->setRenameable(3,true);
    
    
    QGrid	*gobjectsTasks=new QGrid(2,objectsTasks);
    
    // Alias
    hbox_2=new QHBox(vpage7);
    aliasList= new KListView(hbox_2);
    aliasList->setSorting(-1);
    aliasList->addColumn(i18n("Name"));
    aliasList->addColumn(i18n("Group"));
    aliasList->addColumn(i18n("Alias"));
    vobjectsToolBar=new QVBox(hbox_2);
    aliasToolBar=new KToolBar(vobjectsToolBar);
    QTabWidget 	*aliasTabs=new QTabWidget(vobjectsToolBar);
    
    objectsInfo=new QVBox(aliasTabs);
    objectsImages=new QVBox(aliasTabs);
    objectsActions=new QVBox(aliasTabs);
    objectsTasks=new QVBox(aliasTabs);
    objectsPlugin=new QVBox(aliasTabs);
    
    aliasTabs->insertTab(objectsInfo,i18n("Info"));
    aliasTabs->insertTab(objectsImages,i18n("Images"));
    aliasTabs->insertTab(objectsActions,i18n("Actions"));
    aliasTabs->insertTab(objectsTasks,i18n("Tasks"));
    aliasTabs->insertTab(objectsPlugin,i18n("Plugin"));
    
    aliasToolBar->insertButton("wizard",13);
    aliasToolBar->insertButton("remove",14);

    aliasToolBarTasks=new KToolBar(objectsTasks);
    aliasListTasks= new KListView(objectsTasks);
    aliasListTasks->addColumn(i18n("Window Title"));
    aliasListTasks->addColumn(i18n("Task Name"));
    aliasListTasks->addColumn(i18n("Class Name"));
    aliasListTasks->setItemsRenameable(true);
    aliasListTasks->setRenameable(0,true);
    aliasListTasks->setRenameable(1,true);
    aliasListTasks->setRenameable(2,true);
    aliasToolBarTasks->insertButton("apply",18);
    aliasToolBarTasks->insertButton("window_new",19);
    aliasToolBarTasks->insertButton("remove",20);
    
    gobjectsInfo=new QGrid(2,objectsInfo);
    new QLabel(i18n("Alias for"), gobjectsInfo);
    aSystem=new QLineEdit(gobjectsInfo);
    new QLabel(i18n("Name"), gobjectsInfo);
    aName=new QLineEdit(gobjectsInfo);
    new QLabel(i18n("Group"), gobjectsInfo);
    aGroup=new QLineEdit(gobjectsInfo);
    new QLabel(i18n("className"), gobjectsInfo);
    aclassName=new KComboBox(true,gobjectsInfo);
    new QLabel(i18n("Over Text showed"), gobjectsInfo);
    aOverText=new QLineEdit(gobjectsInfo);
    
    gobjectsImages=new QGrid(3,objectsImages);
    new QLabel(i18n("Icon"), gobjectsImages);
    aimgFileName=new QLineEdit(gobjectsImages);
    iaimgFileName=new KIconButton(gobjectsImages);
    new QLabel(i18n("Arrow Image (arrow.png)"), gobjectsImages);
    aimgFileArrow=new QLineEdit(gobjectsImages);
    new QLabel(i18n(""), gobjectsImages);
    new QLabel(i18n("Drop Image (drop.png)"), gobjectsImages);
    aimgFileDrop=new QLineEdit(gobjectsImages);
    new QWidget(gobjectsImages);
    new QLabel(i18n(""), gobjectsImages);
    
    gobjectsActions=new QGrid(2,objectsActions);
    new QLabel(i18n("onClickExec"), gobjectsActions);
    aonClickExec=new QLineEdit(gobjectsActions);
    new QLabel(i18n("onDropExec use %1 for filename"), gobjectsActions);
    aonDropExec=new QLineEdit(gobjectsActions);
    
    gobjectsTasks=new QGrid(2,objectsTasks);
    
    // Plugins
    hbox_2=new QHBox(vpage8);
  
    QVGroupBox *gbtplugin=new QVGroupBox(i18n("Plugins (search paths)"),vpage8);
    pluginsPathToolBar=new KToolBar(gbtplugin);
    pluginsPaths=new QListBox(gbtplugin);
    

    pluginsPathToolBar->insertButton("folder_new",25);
    pluginsPathToolBar->insertButton("remove",26);
    pluginsPathToolBar->insertButton("1downarrow",27);
    pluginsPathToolBar->insertButton("1uparrow",28);
    
    
    
    PluginsList= new KListView(hbox_2);
    PluginsList->setSorting(-1);
    PluginsList->addColumn(i18n("Name"));
    vobjectsToolBar=new QVBox(hbox_2);
   
    PluginsToolBar=new KToolBar(vobjectsToolBar);
    PluginsToolBar->insertButton("apply",21);
    PluginsToolBar->insertButton("window_new",22);
    PluginsToolBar->insertButton("remove",23);
    //objectsTabs=new QTabWidget(vobjectsToolBar);
    //objectsInfo=new QVBox(aliasTabs);
    gobjectsInfo=new QGrid(2,vobjectsToolBar);
    new QLabel(i18n("Name"), gobjectsInfo);
    pName=new QLineEdit(gobjectsInfo);
    new QLabel(i18n("XML Configuration"), vobjectsToolBar);
    pXMLConf=new KListView(vobjectsToolBar);
    pXMLConf->setSorting(-1);
    pXMLConf->addColumn(i18n("Name"));
    pXMLConf->addColumn(i18n("Value"));
    pXMLConf->setItemsRenameable(true);
    pXMLConf->setRenameable(0,true);
    pXMLConf->setRenameable(1,true);
    
    
    
    setCentralWidget(tabs);
}


/*!
    \fn XEPlugin_Configurator::guiDefault()
 */
void XEPlugin_Configurator::guiDefault()
{
	BackgroundPath->setText("kxdocker/themes/bar/default/");
	PillowPath->setText("kxdocker/themes/pillow/");
	PillowPath2->setText("kxdocker/themes/pillow/");
	PoofPath->setText("kxdocker/themes/poof/");
	ArrowPath->setText("kxdocker/themes/arrows");
	
	
	imgBackgroundLeft->setText("background-left.png");
	imgBackgroundCenter->setText("background-center.png");
	imgBackgroundRight->setText("background-right.png");
	imgBackgroundOver->setText("background-over.png");
	imgBackgroundSeparator->setText("background-separator.png");
	imgBackground_Tiled->setChecked(false);
	imgBackground_Desaturate->setValue(0);
	imgBackground_Desaturate->setMinValue(0);
	imgBackground_Desaturate->setMaxValue(100);
	iconsPaths->clear();
	
	rAlignTop->setEnabled(false);
	rAlignLeft->setEnabled(false);
	rAlignRight->setEnabled(false);
	rAlignBottom->setEnabled(true);
	
	rAlignTop->setChecked(false);
	rAlignLeft->setChecked(false);
	rAlignRight->setChecked(false);
	rAlignBottom->setChecked(true);
	
	
	borderLeft->setValue(200);
	borderTop->setValue(110);
	TopForce->setValue(0);
	LeftForce->setValue(0);
	HeightDesktop->setValue(48);
	sSendToForgroundTimeout->setValue(0);
	AutoSave->setChecked(true);
	AutoResize->setChecked(true);

	
	
	HideTimeout->setValue(60);
	sHideTimeout->setValue(60);
	
	HideTimeout->setMaxValue(3600);
	FastHide->setChecked(false);
	
	
	SendToForgroundTimeout->setMaxValue(36000);
	sSendToForgroundTimeout->setMaxValue(36000);
	sSendToForgroundTimeout->setMinValue(0);
	
	sHideTimeout->setMaxValue(36000);
	sHideTimeout->setMinValue(0);
	
	MaxIconsShowed->setMaxValue(MAX_ICONS);
	
	
	
	borderLeft->setEnabled(false);
	borderTop->setEnabled(false);
	TopForce->setEnabled(true);
	LeftForce->setEnabled(true);
	
	
	
	HeightDesktop->setEnabled(true);
	sHeightDesktop->setEnabled(true);
	sSendToForgroundTimeout->setEnabled(true);
	
	sHideTimeout->setEnabled(true);

	
	
	
	Design->clear();
	Design->insertItem("realosx");
	Design->insertItem("osxbar");
	Design->insertItem("panther");
	Design->setCurrentText("panther");
	
	
	EnableThumbnail->setChecked(true);
	//FontFamily;
	//FontColor;
	
	AndZoomCache->setValue(0);
	SleepFPS->setValue(1000);
	SmoothTimeout->setValue(50);
	SleepThreads->setValue(1000);
	SleepAnimations->setValue(100);
	InterpolationValue->setValue(2);
	InterpolationValue->setMinValue(1);
}


/*!
    \fn XEPlugin_Configurator::guiPrepare()
 */
void XEPlugin_Configurator::guiPrepare()
{
	sSeparation->setMaxValue(QApplication::desktop()->width());
	sRaise->setMaxValue(QApplication::desktop()->height());
	sHoriz->setMaxValue(QApplication::desktop()->width());
	
	sSeparation->setMinValue(0);
	sRaise->setMinValue(-QApplication::desktop()->height());
	sHoriz->setMinValue(0);

	sSeparation->setValue(5);
	sRaise->setValue(-50);
	sHoriz->setValue(32);
	
	
	Separation->setMaxValue(QApplication::desktop()->width());
	Raise->setMaxValue(QApplication::desktop()->height());
	Horiz->setMaxValue(QApplication::desktop()->width());
	
	Separation->setMinValue(0);
	Raise->setMinValue(-QApplication::desktop()->height());
	Horiz->setMinValue(0);

	Separation->setValue(5);
	Raise->setValue(-50);
	Horiz->setValue(32);
	

	
	borderLeft->setMaxValue(QApplication::desktop()->width());
	borderTop->setMaxValue(QApplication::desktop()->height());
	
	sLeftForce->setMaxValue(QApplication::desktop()->width());
	sTopForce->setMaxValue(QApplication::desktop()->height());
	
	LeftForce->setMaxValue(QApplication::desktop()->width());
	TopForce->setMaxValue(QApplication::desktop()->height());
	
	sLeftForce->setMinValue(-QApplication::desktop()->width());
	sTopForce->setMinValue(-QApplication::desktop()->height());
	
	LeftForce->setMinValue(-QApplication::desktop()->width());
	TopForce->setMinValue(-QApplication::desktop()->height());
	
	sLeftForce->setValue(LeftForce->value());
	sTopForce->setValue(TopForce->value());
	
	connect(sRaise,SIGNAL(sliderMoved(int)),Raise,SLOT(setValue(int)));
	connect(sHoriz,SIGNAL(sliderMoved(int)),Horiz,SLOT(setValue(int)));
	connect(sSeparation,SIGNAL(sliderMoved(int)),Separation,SLOT(setValue(int)));
	
	connect(Raise,SIGNAL(valueChanged(int)),sRaise,SLOT(setValue(int)));
	connect(Horiz,SIGNAL(valueChanged(int)),sHoriz,SLOT(setValue(int)));
	connect(Separation,SIGNAL(valueChanged(int)),sSeparation,SLOT(setValue(int)));
	
	connect(sLeftForce,SIGNAL(sliderMoved(int)),LeftForce,SLOT(setValue(int)));
	connect(sTopForce,SIGNAL(sliderMoved(int)),TopForce,SLOT(setValue(int)));
	
	connect(sHeightDesktop,SIGNAL(sliderMoved(int)),HeightDesktop,SLOT(setValue(int)));
	connect(sSendToForgroundTimeout,SIGNAL(sliderMoved(int)),SendToForgroundTimeout,SLOT(setValue(int)));
	connect(sHideTimeout,SIGNAL(sliderMoved(int)),HideTimeout,SLOT(setValue(int)));

	
	
	connect(LeftForce,SIGNAL(valueChanged(int)),sLeftForce,SLOT(setValue(int)));
	connect(TopForce,SIGNAL(valueChanged(int)),sTopForce,SLOT(setValue(int)));
	//ToolBar->setItemEnabled(4, false);
	
	
	Size->setMaxValue(256);
	Size->setMinValue(16);
	Size->setLineStep(16);
	
	SizeBig->setMaxValue(256);
	SizeBig->setMinValue(16);
	SizeBig->setLineStep(16);
	
	sSize->setMaxValue(256);
	sSize->setMinValue(16);
	sSize->setLineStep(16);
	sSize->setPageStep(16);
	
	sSizeBig->setMaxValue(256);
	sSizeBig->setMinValue(16);
	sSizeBig->setLineStep(16);
	sSizeBig->setPageStep(16);
	
	sSizeBig->setTickInterval(16);
	sSize->setTickInterval(16);
	sSize->setTickmarks(QSlider::Below);
	sSizeBig->setTickmarks(QSlider::Below);
	
	sSizeBig->setMaxValue(256);
	sSize->setMaxValue(256);
	Size->setValue(32);
	SizeBig->setValue(256);
	
	sSize->setValue(Size->value());
	sSizeBig->setValue(SizeBig->value());
	
	AndZoomCache->setMaxValue(256);
	SleepFPS->setMaxValue(50000);
	SmoothTimeout->setMaxValue(500);
	SleepThreads->setMaxValue(10000);
	SleepAnimations->setMaxValue(1000);
	
	connect(sSize,SIGNAL(sliderMoved(int)),Size,SLOT(setValue(int)));
	connect(sSizeBig,SIGNAL(sliderMoved(int)),SizeBig,SLOT(setValue(int)));
	
	connect(Size,SIGNAL(valueChanged(int)),sSize,SLOT(setValue(int)));
	connect(SizeBig,SIGNAL(valueChanged(int)),sSizeBig,SLOT(setValue(int)));
	
	connect(iconsList,
		SIGNAL(itemRenamed(QListViewItem *, int, const QString &)),
		this,SLOT(itemRenamed(QListViewItem *, int, const QString &)));
	connect(iconsListTasks,
		SIGNAL(itemRenamed(QListViewItem *, int, const QString &)),
		this,SLOT(iconsListTasks_itemRenamed(QListViewItem *, int, const QString &)));
	connect(PluginsList,
		SIGNAL(itemRenamed(QListViewItem *, int, const QString &)),
		this,SLOT(PluginsList_itemRenamed(QListViewItem *, int, const QString &)));
	
	connect(PluginsList,
		SIGNAL(selectionChanged(QListViewItem *)),
		this,SLOT(pluginsList_selectionChanged(QListViewItem *)));
	connect(iconsList,
		SIGNAL(selectionChanged(QListViewItem *)),
		this,SLOT(selectionChanged(QListViewItem *)));
	connect(aliasList,
		SIGNAL(selectionChanged(QListViewItem *)),
		this,SLOT(alias_selectionChanged(QListViewItem *)));
	// Object
	connect(ioimgFileName,
		SIGNAL(iconChanged(QString)),
		this,
		SLOT(imgFile_iconChanged(QString)));
		
	connect(oOverText,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oOverText_textChanged(const QString& )));
		
		
	connect(oName,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oName_textChanged(const QString& )));
	connect(oGroup,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oGroup_textChanged(const QString& )));
	connect(oclassName,
		SIGNAL(returnPressed(const QString &)),
		this,
		SLOT(slot_oClassName_textChanged(const QString& )));
	connect(oclassName,
		SIGNAL(activated(const QString &)),
		this,
		SLOT(slot_oClassName_textChanged(const QString& )));
	
	connect(oimgFileName,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oImgFileName_textChanged(const QString& )));
		
	connect(oimgFileArrow,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oImgArrow_textChanged(const QString& )));
	connect(oimgFileDrop,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oImgDrop_textChanged(const QString& )));
	connect(aimgFileDrop,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aImgDrop_textChanged(const QString& )));
		
	connect(oonClickExec,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oOnClickExec_textChanged(const QString& )));
	connect(oonDropExec,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_oOnDropExec_textChanged(const QString& )));
	connect(aonDropExec,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aOnDropExec_textChanged(const QString& )));
		
	// Alias
	connect(iaimgFileName,
		SIGNAL(iconChanged(QString)),
		this,
		SLOT(aimgFile_iconChanged(QString)));
		
	connect(aOverText,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aOverText_textChanged(const QString& )));
	connect(aName,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aName_textChanged(const QString& )));
	connect(aSystem,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aSystem_textChanged(const QString& )));
	connect(aGroup,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aGroup_textChanged(const QString& )));
	connect(aclassName,
		SIGNAL(returnPressed(const QString &)),
		this,
		SLOT(slot_aClassName_textChanged(const QString& )));
	connect(aclassName,
		SIGNAL(activated(const QString &)),
		this,
		SLOT(slot_aClassName_textChanged(const QString& )));
	
	connect(aimgFileName,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aImgFileName_textChanged(const QString& )));
		
	connect(aimgFileArrow,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aImgArrow_textChanged(const QString& )));
		
	connect(aonClickExec,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_aOnClickExec_textChanged(const QString& )));
	
	connect(pBackgroundPath,
		SIGNAL(clicked()),
		this,
		SLOT(backgroundChangePath()));
	
	// Tool Bars
	connect(objectsToolBarDCOP,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
	connect(aliasToolBar,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
		
	connect(aliasToolBarTasks,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
	connect(objectsToolBar,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
	connect(objectsToolBarTasks,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
		
	connect(PluginsToolBar,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
	connect(ToolBar,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
	connect(iconsPathToolBar,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
	connect(pluginsPathToolBar,
		SIGNAL(clicked(int)),
		this,
		SLOT(objectToolBar_clicked(int )));
		
		
		// TODO: it will crash
		/*
	connect(BackgroundPath,
		SIGNAL(textChanged(const QString &)),
		this,
		SLOT(slot_BackgroundPath_textChanged(const QString& )));
		*/
	
}


/*!
    \fn XEPlugin_Configurator::guiRefreshValues()
 */
void XEPlugin_Configurator::guiRefreshValues()
{

	iconsPaths->clear();
	iconsPaths->insertStringList(ActiveConfiguration->Theme.IconsPaths);
	
	KIconLoader KDEIconLoader;
	
	iconsList->clear();
	for(int i=ActiveConfiguration->RollingIcons.count()-1; i>=0;i--)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		
		if(icon==NULL)break;
		if(icon->Info.className.length()>0 && icon->Info.className[0]=='x')continue;
		if(icon->TimeToLive!=0)continue;
		QPixmap iconImg=
		KDEIconLoader.loadIcon(
				icon->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizePrefer
				);;
		//xGDocker->xFindIconFile(icon->Images.imgFileName));
		QListViewItem	*item=new QListViewItem(
			(QListView *)iconsList);
	
		//	iconImg,icon->Info.Name,
		//	iconImg,icon->Info.Group);
		item->setText(0,icon->Info.Name);
		item->setText(1,icon->Info.Group);
		
		item->setPixmap (0,iconImg);
		iconsList->insertItem(item);
		//insertItem(iconImg,icon->Info.Name);
	}
	PluginsList->clear();
	for(int i=ActiveConfiguration->Plugins.Plugin.count()-1; i>=0;i--)
	{
		XSGObjectPlugin	*theplugin=ActiveConfiguration->Plugins.Plugin.at(i);
	
		QListViewItem	*item=new QListViewItem(
			(QListView *)PluginsList);
		
		item->setText(0,theplugin->Info.Name);
		
		PluginsList->insertItem(item);
	}
	pluginsPaths->clear();
	pluginsPaths->insertStringList(ActiveConfiguration->Plugins.PluginsPaths);
	
	aliasList->clear();
	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		
		XSGObjectIcon *icon=newalias->Icon;
		if(icon==NULL)break;
		QPixmap iconImg=
		KDEIconLoader.loadIcon(
				icon->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizePrefer
				);;
		//xGDocker->xFindIconFile(icon->Images.imgFileName));
		QListViewItem	*item=new QListViewItem(
			(QListView *)aliasList);
	
		//	iconImg,icon->Info.Name,
		//	iconImg,icon->Info.Group);
		item->setText(0,icon->Info.Name);
		item->setText(1,icon->Info.Group);
		item->setText(2,newalias->SystemName);
		
		item->setPixmap (0,iconImg);
		aliasList->insertItem(item);
		//insertItem(iconImg,icon->Info.Name);
	}
/*
	//ActiveConfiguration->Engine.MaxIconsShowed; !!!!
	//ActiveConfiguration->Matrix.Design;
	
	//ActiveConfiguration->Plugins.Matches !!!!
	
	//ActiveConfiguration->Theme.ArrowsPath;

*/
	Design->setCurrentText(ActiveConfiguration->Matrix.Design);
	rAlignTop->setChecked(false);
	rAlignLeft->setChecked(false);
	rAlignRight->setChecked(false);
	rAlignBottom->setChecked(false);

	if(ActiveConfiguration->Window.Align=="bottom")rAlignBottom->setChecked(true);
	if(ActiveConfiguration->Window.Align=="top")rAlignTop->setChecked(true);
	if(ActiveConfiguration->Window.Align=="left")rAlignLeft->setChecked(true);
	if(ActiveConfiguration->Window.Align=="right")rAlignRight->setChecked(true);
	

	Size->setValue(ActiveConfiguration->Icons.SizePrefer);
	SizeBig->setValue(ActiveConfiguration->Icons.SizeBig);
	// background
	BackgroundPath->setText(ActiveConfiguration->Theme.BackgroundPath);
	PillowPath->setText(ActiveConfiguration->Icons.OverTextFont.BackgroundPath);
	PillowPath2->setText(ActiveConfiguration->Icons.MiniTextFont.BackgroundPath);
	PoofPath->setText(ActiveConfiguration->Theme.PoofPath);
	ArrowPath->setText(ActiveConfiguration->Theme.ArrowsPath);
	
	imgBackgroundSeparator->setText(ActiveConfiguration->Theme.Background.imgBackgroundSeparator);
	imgBackgroundLeft->setText(ActiveConfiguration->Theme.Background.imgBackgroundLeft);
	imgBackgroundRight->setText(ActiveConfiguration->Theme.Background.imgBackgroundRight);
	imgBackground_Desaturate->setValue(ActiveConfiguration->Theme.Background.Desaturate);
	imgBackgroundCenter->setText(ActiveConfiguration->Theme.Background.imgBackgroundCenter);
	imgBackgroundOver->setText(ActiveConfiguration->Theme.Background.imgBackgroundOver);
	if(ActiveConfiguration->Theme.Background.Tiled)imgBackground_Tiled->setChecked(true);
	else imgBackground_Tiled->setChecked(false);
	if(ActiveConfiguration->Icons.EnableThumbnail)EnableThumbnail->setChecked(true);
	else EnableThumbnail->setChecked(false);
	
	borderLeft->setValue(ActiveConfiguration->Window.borderLeft);
	borderTop->setValue(ActiveConfiguration->Window.borderTop);
	borderTop->setEnabled(false);
	
	HeightDesktop->setValue(ActiveConfiguration->Window.HeightDesktop);
	
	HeightDesktop->setMaxValue(ActiveConfiguration->Icons.SizePrefer+16);
	sHeightDesktop->setValue(ActiveConfiguration->Window.HeightDesktop);
	
	if(ActiveConfiguration->AutoSave)AutoSave->setChecked(true);
	else AutoResize->setChecked(false);
	if(ActiveConfiguration->AutoResize)AutoResize->setChecked(true);
	else AutoResize->setChecked(false);


	if(ActiveConfiguration->Window.FastHide)FastHide->setChecked(true);
	else FastHide->setChecked(false);
	//HeightDesktop->setEnabled(false);
	TopForce->setValue(ActiveConfiguration->Window.TopForce);
	LeftForce->setValue(ActiveConfiguration->Window.LeftForce);
	
	HideTimeout->setValue(ActiveConfiguration->Window.HideTimeout);

	if(ActiveConfiguration->Window.HideMouseCornerRight)HideMouseCornerRight->setChecked(true);
	else HideMouseCornerRight->setChecked(false);
	if(ActiveConfiguration->Window.HideMouseCornerLeft)HideMouseCornerLeft->setChecked(true);
	else HideMouseCornerLeft->setChecked(false);

	if(ActiveConfiguration->Window.SendToBackground)SendToBackground->setChecked(true);
	else SendToBackground->setChecked(false);
	if(ActiveConfiguration->Window.RaiseOnEvents)RaiseOnEvents->setChecked(true);
	else RaiseOnEvents->setChecked(false);	
	
	SendToForgroundTimeout->setValue(ActiveConfiguration->Window.SendToForgroundTimeout);
	sSendToForgroundTimeout->setValue(ActiveConfiguration->Window.SendToForgroundTimeout);
	HideTimeout->setValue(ActiveConfiguration->Window.HideTimeout);
	sHideTimeout->setValue(ActiveConfiguration->Window.HideTimeout);
	
	Separation->setValue(ActiveConfiguration->Icons.Separation);
	Raise->setValue(ActiveConfiguration->Icons.Raise);
	Horiz->setValue(ActiveConfiguration->Icons.Horiz);
	FontColor->setColor(QColor(
	ActiveConfiguration->Icons.OverTextFont.FontRed,
	ActiveConfiguration->Icons.OverTextFont.FontGreen,
	ActiveConfiguration->Icons.OverTextFont.FontBlue
			)
			);
	QFont carattere;
	carattere.setFamily(ActiveConfiguration->Icons.OverTextFont.FontFamily);
	carattere.setPointSize(ActiveConfiguration->Icons.OverTextFont.FontSize);
	// 0.36 
	carattere.setBold(ActiveConfiguration->Icons.OverTextFont.Bold?true:false);
	carattere.setItalic(ActiveConfiguration->Icons.OverTextFont.Italic?true:false);
	carattere.setWeight(ActiveConfiguration->Icons.OverTextFont.Weight);
	
	FontFamily->setFont(carattere);

	carattere.setFamily(ActiveConfiguration->Icons.MiniTextFont.FontFamily);
	carattere.setPointSize(ActiveConfiguration->Icons.MiniTextFont.FontSize);
	// 0.36 
	carattere.setBold(ActiveConfiguration->Icons.MiniTextFont.Bold?true:false);
	carattere.setItalic(ActiveConfiguration->Icons.MiniTextFont.Italic?true:false);
	carattere.setWeight(ActiveConfiguration->Icons.MiniTextFont.Weight);
	
	FontFamilyMini->setFont(carattere);



	MaxIconsShowed->setValue(ActiveConfiguration->Engine.MaxIconsShowed);
	

	AndZoomCache->setValue(ActiveConfiguration->Engine.AndZoomCache);
#ifdef ENABLE_SPECIALENGINE2
	InterpolationValue->setValue(ActiveConfiguration->Engine.InterpolationValue);
#endif    
	SleepFPS->setValue(ActiveConfiguration->Engine.SleepFPS);
	SmoothTimeout->setValue(ActiveConfiguration->Engine.SmoothTimeout);
	SleepThreads->setValue(ActiveConfiguration->Engine.SleepThreads);
	SleepAnimations->setValue(ActiveConfiguration->Engine.SleepAnimations);
	
	statusBar->message(ActiveConfiguration->Engine.XMLConf);
		objectsToolBar->setItemEnabled(7, false);
		objectsToolBar->setItemEnabled(8, false);


#ifdef ENABLE_STATS
	update_statistics();
#endif
}


/*!
    \fn XEPlugin_Configurator::itemRenamed(QListViewItem *, int, const QString &)
 */
void XEPlugin_Configurator::itemRenamed(QListViewItem *item, int col, const QString &text)
{
	int i=-1;
	for(uint f=0;f<ActiveConfiguration->RollingIcons.count();f++)
	{
		if(ActiveConfiguration->RollingIcons.at(f)->Info.Name
			==
			item->text(0)
		)
		{
		i=f;
		break;
		}
	}
	if(i<0)return;
	char pippo[50];
	sprintf(pippo,"you have renamed: %d",i);
	qWarning(pippo);
	if(col==0)
	{
		ActiveConfiguration->RollingIcons.at(i)->Info.Name=text;
	}
	if(col==1)
	{
		ActiveConfiguration->RollingIcons.at(i)->Info.Group=text;
	}
}


/*!
    \fn XEPlugin_Configurator::selectionChanged(QListViewItem *)
 */
void XEPlugin_Configurator::selectionChanged(QListViewItem *item)
{
	int i=-1;
//	LastItem=item;
	for(uint f=0;f<ActiveConfiguration->RollingIcons.count();f++)
	{
		if(ActiveConfiguration->RollingIcons.at(f)->Info.Name
			==
			item->text(0)
		)
		{
		i=f;
		break;
		}
	}
	if(i<0)return;
	//oName->setText(item->text(0));
	//oGroup->setText(item->text(1));
	XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
	LastIcon=icon;
	if(icon==NULL)return;
	KIconLoader KDEIconLoader;	
	oName->setText(icon->Info.Name);
	oGroup->setText(icon->Info.Group);
	
	oclassName->clear();
	
	
	oclassName->insertStringList(XEObject::xGetPluginListNames());
	oclassName->insertItem("disabled",0);
	oclassName->insertItem("GSeparator",0);
	oclassName->insertItem(icon->Info.className,0);
	
	//oclassName->setCurrentText(icon->Info.className);
	oclassName->setCurrentItem(0);
	
	
	oOverText->setText(icon->OverText);
	oimgFileName->setText(icon->Images.imgFileName);
	oimgFileArrow->setText(icon->Images.imgFileArrow);
	oimgFileDrop->setText(icon->Images.imgFileDrop);
	oonClickExec->setText(icon->Actions.onClickExec);
	oonDropExec->setText(icon->Actions.onDropExec);
	
	// 0.29 read only action list

	pXMLActionList->clear();
	pXMLActionList->setEnabled(false);
	for(uint a=0;a<icon->Actions.ActionList.count();a++)
	{
		// now supporting only exec action
		QString aAction=icon->Actions.ActionList.item(a).toElement().attribute("action");
		QString aIcon=icon->Actions.ActionList.item(a).toElement().attribute("image");
		if(aAction.isNull() || aAction=="")aAction="exec";
		if(aIcon.isNull() || aIcon=="" )aIcon="run";
		QString aInfo=icon->Actions.ActionList.item(a).toElement().attribute("info");
		QString aExe=icon->Actions.ActionList.item(a).toElement().attribute("data");
		if(aExe.isNull() || aExe=="" )continue;
		if(aInfo.isNull() || aInfo=="" )aInfo=aExe;
		QListViewItem	*item=new QListViewItem(
			(QListView *)pXMLActionList);
	
		//	iconImg,icon->Info.Name,
		//	iconImg,icon->Info.Group);
		item->setText(0,aInfo);
		item->setText(1,aIcon);
		item->setText(2,aAction);
		item->setText(3,aExe);
		//item->setPixmap (0,iconImg);
		pXMLActionList->insertItem(item);
	}

	// 0.29 read only dcop list
	iconsListDCOP->clear();
	//iconsListDCOP->setEnabled(false);
	for(uint dcopi=0;dcopi<icon->Tasks.dcopName.count();dcopi++)
	{
		QListViewItem	*item=new QListViewItem(
			(QListView *)iconsListDCOP);
		item->setText(0,icon->Tasks.dcopName[dcopi]);
		iconsListDCOP->insertItem(item);
	}
	
	
	/*
	ioimgFileName->setIconSet(QIconSet(
			KDEIconLoader.loadIcon(
				icon->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig
				)

	));
	*/
	ioimgFileName->setIcon(icon->Images.imgFileName);
	
	// Tasks Matched:
	iconsListTasks->clear();
	for(uint i=0;i<icon->Tasks.WindowTitle.count();i++)
	{
		QListViewItem	*item=new QListViewItem(
			(QListView *)iconsListTasks);
	
		//	iconImg,icon->Info.Name,
		//	iconImg,icon->Info.Group);
		item->setText(0,icon->Tasks.WindowTitle[i]);
		item->setText(1,icon->Tasks.TaskName[i]);
		item->setText(2,icon->Tasks.ClassName[i]);
		//item->setPixmap (0,iconImg);
		iconsListTasks->insertItem(item);
	}
	#ifndef ENABLE_FINAL
		qWarning("refreshPluginscfg(icon,oPluginCfg); 889");
	#endif
		refreshPluginscfg(icon,oPluginCfg);
	
	if(i>0 && i<ActiveConfiguration->RollingIcons.count()-1)
	{
		objectsToolBar->setItemEnabled(7, true);
		objectsToolBar->setItemEnabled(8, true);
		
	}
	if(i<=0)
	{
		objectsToolBar->setItemEnabled(7, true);
		objectsToolBar->setItemEnabled(8, false);
	}
	if(i>=ActiveConfiguration->RollingIcons.count()-1)
	{
		objectsToolBar->setItemEnabled(7, false);
		objectsToolBar->setItemEnabled(8, true);
	}
	
}


/*!
    \fn XEPlugin_Configurator::imgFile_iconChanged(QString)
 */
void XEPlugin_Configurator::imgFile_iconChanged(QString newicon)
{
	oimgFileName->setText(newicon);
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		LastIcon->Images.imgFileName=newicon;
		// ok now we have to check if it's displayed:
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->reloadIcon(idx);
		}
	}
}


/*!
    \fn XEPlugin_Configurator::show()
 */
void XEPlugin_Configurator::show()
{
	guiRefreshValues();
//	KMainWindow::show();
	QWidget::show();
}


/*!
    \fn XEPlugin_Configurator::queryClose()
 */
bool XEPlugin_Configurator::queryClose()
{
	hide();
	return false;
}



/*!
    \fn XEPlugin_Configurator::objectToolBar_clicked(int)
 */
void XEPlugin_Configurator::objectToolBar_clicked(int id)
{
/*
    PluginsToolBar->insertButton("apply",21);
    PluginsToolBar->insertButton("window_new",22);
    PluginsToolBar->insertButton("remove",23);

    pluginsPathToolBar->insertButton("folder_new",25);
    pluginsPathToolBar->insertButton("remove",26);
    pluginsPathToolBar->insertButton("1downarrow",27);
    pluginsPathToolBar->insertButton("1uparrow",28);

    objectsToolBar->insertButton("apply",4);
    objectsToolBar->insertButton("wizard",5);
    objectsToolBar->insertButton("remove",6);
//    objectsToolBar->insertButton("help",7);
    ToolBar->insertButton("filenew",0);
    ToolBar->insertButton("fileopen",1);
    ToolBar->insertButton("filesave",2);
    ToolBar->insertButton("fileclose",3);
*/
/*
    iconsPathToolBar->insertButton("folder_new",9);
    iconsPathToolBar->insertButton("remove",10);
    iconsPathToolBar->insertButton("1downarrow",11);
    iconsPathToolBar->insertButton("1uparrow",12);
*/	
	
	switch(id)
	{
		case 0: // new
		break;
		case 1: // open
			openCfg();
		break;
		case 2: // save
			saveTo();
		break;
		case 3: // close
			hide();
		break;
		case 4: //apply
			apply();
		break;
		case 5: // wizard
			addIcon();
		break;
		case 6: // remove
			xRemoveIcon();
		break;
		case 7: // help
			downIcon();
		break;
		case 8: 
			upIcon();
		break;
		case 9:
			addIconPath();
		break;
		case 10:
		if(iconsPaths->selectedItem ())iconsPaths->removeItem(iconsPaths->currentItem ());
		break;
		case 11:
		if(iconsPaths->selectedItem ())
		{
			QString a=iconsPaths->text(iconsPaths->currentItem ());
			iconsPaths->removeItem(iconsPaths->currentItem ());
			iconsPaths->insertItem(a,iconsPaths->currentItem ()+1);
			iconsPaths->setSelected(iconsPaths->currentItem ()+1,true);
		}
		break;
		case 12:
		if(iconsPaths->selectedItem ())
		{
			QString a=iconsPaths->text(iconsPaths->currentItem ());
			iconsPaths->removeItem(iconsPaths->currentItem ());
			if(iconsPaths->currentItem ())
			{
				iconsPaths->insertItem(a,iconsPaths->currentItem ()-1);
				iconsPaths->setSelected(iconsPaths->currentItem ()-2,true);
			}
			else {
				iconsPaths->insertItem(a,0);
				iconsPaths->setSelected(0,true);
			}
		}
		break;
		case 13:
			add_alias();
		break;
		case 14:
			remove_alias();
		break;
		case 15:
			tasks_add();
		break;
		case 16:
			tasks_remove();
		break;
		case 17:
			apply_tasks();
		break;
		case 19:
			atasks_add();
		break;
		case 20:
			atasks_remove();
		break;
		case 18:
			aapply_tasks();
		break;
		case 21:
			apply_plugins();
		break;
		case 22:
			// add plugin
			addPlugin();
			
		break;
		case 23:
			// remove plugin
			removePlugin();
		break;
		case 24:
			apply_objectsplugin();
		break;
		
		case 25:
			AddPluginPath();
		break;
		case 26:
		if(pluginsPaths->selectedItem ())pluginsPaths->removeItem(pluginsPaths->currentItem ());
		break;
		case 27:
		if(pluginsPaths->selectedItem ())
		{
			QString a=pluginsPaths->text(pluginsPaths->currentItem ());
			pluginsPaths->removeItem(pluginsPaths->currentItem ());
			pluginsPaths->insertItem(a,pluginsPaths->currentItem ()+1);
			pluginsPaths->setSelected(pluginsPaths->currentItem ()+1,true);
		}
		break;
		case 28:
		if(pluginsPaths->selectedItem ())
		{
			QString a=pluginsPaths->text(pluginsPaths->currentItem ());
			pluginsPaths->removeItem(pluginsPaths->currentItem ());
			if(pluginsPaths->currentItem ())
			{
				pluginsPaths->insertItem(a,pluginsPaths->currentItem ()-1);
				pluginsPaths->setSelected(pluginsPaths->currentItem ()-2,true);
			}
			else {
				pluginsPaths->insertItem(a,0);
				pluginsPaths->setSelected(0,true);
			}
		}
		break;
		case 29:
			object_dcop_apply();
		break;
		case 30:
			object_dcop_add();
		break;
		case 31:
			object_dcop_remove();

		break;

		case 100:
		saveDefault();
		break;
		case 101:
		qWarning("Not implemented yet");
		//addIconWizard();
		break;
		
		default:
		break;
	};
}


/*!
    \fn XEPlugin_Configurator::xRemoveIcon()
 */
void XEPlugin_Configurator::xRemoveIcon()
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		// ok now we have to check if it's displayed:
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->iconRemove(idx);
		}
		ActiveConfiguration->RollingIcons.remove(LastIcon);
	}
	guiRefreshValues();
	if(iconsList->firstChild())
		iconsList->setSelected(iconsList->firstChild() , true );
}
void XEPlugin_Configurator::saveDefault()
{
// before saving i will apply :)
this->apply();
//QString cfgPath=QDir::homeDirPath();
//cfgPath+="/.kde/share/apps/kxdocker/kxdocker_conf.xml";
QString cfgPath=::locateLocal("data","kxdocker/")+"kxdocker_conf.xml";

// E' mooolto brutto che l'utente pu usare pi file di configurazione.
// ce ne deve essere uno solo NASCOSTO!
// in questo caso io commento tutto per coerenza in quello che credo
// anche se lascio questo piccolo ed elegante controllino
if(ActiveConfiguration->Engine.XMLConf!=cfgPath){
KMessageBox::information(this,"Warning: you are saving in " + cfgPath +", that isn't your default config file ("+ActiveConfiguration->Engine.XMLConf+")");
}
ActiveConfiguration->Engine.XMLConf=cfgPath;
xCfgWrite(cfgPath);
//if(KMessageBox::warningYesNo(this,"Do you like to use this new xml configuration file at next KXDocker startup?","What XML configuration next time")==KMessageBox::Yes)
//{
//#ifndef ENABLE_FINAL
//qWarning("Warning we are going to update the user configuration!");
//#endif
KConfig *cfg=KGlobal::config();
cfg->setGroup("");
cfg->writeEntry("KXDockerXMLConf",ActiveConfiguration->Engine.XMLConf);
#ifndef ENABLE_FINAL
KMessageBox::information(this,"you have to manually restart KXDocker to load new configuration","XML configuration Activation");
#endif
//}
guiRefreshValues();
}
/*!
    \fn XEPlugin_Configurator::saveTo()
 */
void XEPlugin_Configurator::saveTo()
{
// before saving i will apply :)
this->apply();
/*
KFileDialog fd(QString::null,QString::null,0,"openXMLConf",true);
QString cfgPath=fd.getSaveFileName(QString::null,QString::null,0,"Save KXDocker XML Configuration");
*/
// Due soluzioni possibili: o apriamo la dir di configurazione di kxdocker,
// oppure ActiveConfiguration->Engine.XMLConf
//QString cfgDir=QDir::homeDirPath();
//cfgDir+="/.kde/share/apps/kxdocker/";
KFileDialog fd(QString::null,QString::null,0,i18n("openXMLConf"),true);
QString cfgPath=fd.getSaveFileName(ActiveConfiguration->Engine.XMLConf/*cfgDir*/,QString::null,0,i18n("Save KXDocker XML Configuration"));
if(cfgPath==NULL)
{
qWarning("cannot find kxdocker_conf.xml");
return;
}
ActiveConfiguration->Engine.XMLConf=cfgPath;
xCfgWrite(cfgPath);
if(KMessageBox::warningYesNo(this,"Do you like to use this new xml configuration file at next KXDocker startup?","What XML configuration next time")==KMessageBox::Yes)
{
#ifndef ENABLE_FINAL
qWarning("Warning we are going to update the user configuration!");
#endif
KConfig *cfg=KGlobal::config();
cfg->setGroup("");
cfg->writeEntry("KXDockerXMLConf",ActiveConfiguration->Engine.XMLConf);

#ifndef ENABLE_FINAL
KMessageBox::information 
(this,"you have to manually restart KXDocker to load new configuration","XML configuration Activation");
#endif
	}
	
	guiRefreshValues();
}


/*!
    \fn XEPlugin_Configurator::openCfg()
 */
void XEPlugin_Configurator::openCfg()
{
	KFileDialog fd(QString::null,QString::null,0,"openXMLConf",true);
	QString cfgPath=fd.getOpenFileName(QString::null,QString::null,0,"Open KXDocker XML Configuration");
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find kxdocker_conf.xml");
		return;
	}
	ActiveConfiguration->Engine.XMLConf=cfgPath;
	//xCfgWrite(cfgPath);
	
	if(KMessageBox::warningYesNo(this,"Do you like to use this new xml configuration file at next KXDocker startup?","What XML configuration next time")==KMessageBox::Yes)
	{
		qWarning("Warning we are going to update the user configuration!");
		KConfig *cfg=KGlobal::config();
		cfg->setGroup("");
		cfg->writeEntry("KXDockerXMLConf",ActiveConfiguration->Engine.XMLConf);
		
		KMessageBox::information 
(this,"you have to manually restart KXDocker to load new configuration","XML configuration Activation");
	}
	
	guiRefreshValues();
}


/*!
    \fn XEPlugin_Configurator::addIcon()
 */
void XEPlugin_Configurator::addIcon()
{
			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//	XSGObjectIcon *addedCfg=new XSGObjectIcon;
//	addedCfg->Tasks.PopupMenu=new KPopupMenu();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	ActiveConfiguration->ObjectsIcons.append(addedCfg);
	ActiveConfiguration->RollingIcons.append(addedCfg);
	
	addedCfg->Tasks.Proces.clear();
	addedCfg->Info.className="GIcon";
	addedCfg->Info.fileName="";
	QDateTime a=QDateTime::currentDateTime();
	QString randomName=a.toString("mmss");
	
	QString b="AddedIcon_";
	b=b+randomName;
	b="Group_";
	b=b+randomName;
	b="AddedIcon_";
	b=b+randomName;
	
	addedCfg->Info.Name=b;
	addedCfg->Info.Group=b;
	addedCfg->Actions.onClickExec="";
	addedCfg->Actions.onDropExec="";
	addedCfg->OverText=b;
	addedCfg->Images.imgFileName="default";
	
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->Tasks.TaskInfo=NULL;
	addedCfg->TimeToLive=0;

	//0.29
	addedCfg->Tasks.dcopReady=0;
		// 0.33
		addedCfg->Tasks.forceRunning=0;

	xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
	
	guiRefreshValues();
	
	if(iconsList->lastChild())
		iconsList->setSelected(iconsList->lastChild() , true );
}


/*!
    \fn XEPlugin_Configurator::downIcon()
 */
void XEPlugin_Configurator::downIcon()
{
	int idr=ActiveConfiguration->RollingIcons.find(LastIcon);
	if(LastIcon!=NULL && idr>=0)
	{
		// ok i hope it will exists
		// ok now we have to check if it's displayed:
		
		idr++;
		//idr=(idr)%ActiveConfiguration->RollingIcons.count();
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		int idx1=ActiveConfiguration->ObjectsIcons.find(
			ActiveConfiguration->RollingIcons.at(idr)
			);
		// 0.33
		// test if it's a separator
		if(idx1>=0)
		{
			if(ActiveConfiguration->ObjectsIcons.at(idx1)->Info.className=="GSeparator")
			{
				idr++;
				int idx1=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(idr)
			);

			}
		}
		if(idx>=0 && idx1>=0)
		{
			ActiveConfiguration->ObjectsIcons.replace
				(idx,
				ActiveConfiguration->RollingIcons.at(idr)
				);
			ActiveConfiguration->ObjectsIcons.replace
				(idx+1,
				LastIcon
				);

			xGDocker->reloadIcon(idx);
			xGDocker->reloadIcon(idx+1);
			// refresh icon on the docker
		}
		ActiveConfiguration->RollingIcons.replace
			(idr-1,
			ActiveConfiguration->RollingIcons.at(idr)
			);
		ActiveConfiguration->RollingIcons.replace
			(idr,
			LastIcon
			);

	}
	guiRefreshValues();
	//if(LastItem)
	//	iconsList->setSelected(LastItem, true );
	idr=ActiveConfiguration->RollingIcons.find(LastIcon);
	if(idr>=0)
	{
		QListViewItem *LastItem=iconsList->findItem (
		LastIcon->Info.Name,0); 
	if(LastItem)
		iconsList->setSelected(LastItem, true );
	}
}


/*!
    \fn XEPlugin_Configurator::upIcon()
 */
void XEPlugin_Configurator::upIcon()
{
	int idr=ActiveConfiguration->RollingIcons.find(LastIcon);
	if(LastIcon!=NULL && idr>=0)
	{
		// ok i hope it will exists
		// ok now we have to check if it's displayed:
		
		idr--;
		
		//idr=(idr)%ActiveConfiguration->RollingIcons.count();
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		int idx1=ActiveConfiguration->ObjectsIcons.find(
			ActiveConfiguration->RollingIcons.at(idr)
			);
		// 0.33
		// test if it's a separator
		if(idx1>=0)
		{
			if(ActiveConfiguration->ObjectsIcons.at(idx1)->Info.className=="GSeparator")
			{
				idr--;
				if(idr>=0)
				idx1=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(idr)
				);
				else return;

			}
		}

		if(idx>=0 && idx1>=0)
		{
			ActiveConfiguration->ObjectsIcons.replace
				(idx,
				ActiveConfiguration->RollingIcons.at(idr)
				);
			ActiveConfiguration->ObjectsIcons.replace
				(idx-1,
				LastIcon
				);

			xGDocker->reloadIcon(idx);
			xGDocker->reloadIcon(idx-1);
			// refresh icon on the docker
		}
		ActiveConfiguration->RollingIcons.replace
			(idr+1,
			ActiveConfiguration->RollingIcons.at(idr)
			);
		ActiveConfiguration->RollingIcons.replace
			(idr,
			LastIcon
			);

	}
	guiRefreshValues();
	idr=ActiveConfiguration->RollingIcons.find(LastIcon);
	if(idr>=0)
	{
		QListViewItem *LastItem=iconsList->findItem (
		LastIcon->Info.Name,0); 
	if(LastItem)
		iconsList->setSelected(LastItem, true );
	}
}


/*!
    \fn XEPlugin_Configurator::apply()
 */
void XEPlugin_Configurator::apply()
{
#ifndef ENABLE_FINAL
	KMessageBox::information 
(this,"A few parameters cannot be applyed at this time.\nRememeber to save and enable your configuration.\nYou can do this by saving your new configuration.","XML configuration Activation");
#endif

	// saving data
	ActiveConfiguration->Engine.AndZoomCache=AndZoomCache->value();
#ifdef ENABLE_SPECIALENGINE2
	ActiveConfiguration->Engine.InterpolationValue=InterpolationValue->value();
	if(ActiveConfiguration->Engine.InterpolationValue<1)ActiveConfiguration->Engine.InterpolationValue=1;
#endif    

	ActiveConfiguration->Engine.MaxIconsShowed=MaxIconsShowed->value(); 
	ActiveConfiguration->Engine.SleepAnimations=SleepAnimations->value();
	ActiveConfiguration->Engine.SleepFPS=SleepFPS->value();
	ActiveConfiguration->Engine.SleepThreads=SleepThreads->value();
	ActiveConfiguration->Engine.SmoothTimeout=SmoothTimeout->value();
	//ActiveConfiguration->Engine.XMLConf;
	
	ActiveConfiguration->Icons.EnableThumbnail=EnableThumbnail->isChecked();
	ActiveConfiguration->Window.SendToBackground=SendToBackground->isChecked();
	
	ActiveConfiguration->Window.HideMouseCornerLeft=HideMouseCornerLeft->isChecked();
	ActiveConfiguration->Window.HideMouseCornerRight=HideMouseCornerRight->isChecked();
	
	ActiveConfiguration->Icons.OverTextFont.FontBlue=FontColor->color().blue();
	ActiveConfiguration->Icons.OverTextFont.FontGreen=FontColor->color().green();
	ActiveConfiguration->Icons.OverTextFont.FontRed=FontColor->color().red();
	ActiveConfiguration->Icons.OverTextFont.FontFamily=FontFamily->font().family();
	ActiveConfiguration->Icons.OverTextFont.FontSize=FontFamily->font().pointSize();
	// 0.36
	ActiveConfiguration->Icons.OverTextFont.Bold=FontFamily->font().bold();
	ActiveConfiguration->Icons.OverTextFont.Italic=FontFamily->font().italic();
	ActiveConfiguration->Icons.OverTextFont.Weight=FontFamily->font().weight();

	ActiveConfiguration->Icons.Horiz=Horiz->value();
	ActiveConfiguration->Icons.Raise=Raise->value();
	ActiveConfiguration->Icons.Separation=Separation->value();
	ActiveConfiguration->Icons.SizePrefer=Size->value();

	//
	ActiveConfiguration->Icons.MiniTextFont.FontBlue=FontColorMini->color().blue();
	ActiveConfiguration->Icons.MiniTextFont.FontGreen=FontColorMini->color().green();
	ActiveConfiguration->Icons.MiniTextFont.FontRed=FontColorMini->color().red();
	ActiveConfiguration->Icons.MiniTextFont.FontFamily=FontFamilyMini->font().family();
	ActiveConfiguration->Icons.MiniTextFont.FontSize=FontFamilyMini->font().pointSize();
	// 0.36
	ActiveConfiguration->Icons.MiniTextFont.Bold=FontFamilyMini->font().bold();
	ActiveConfiguration->Icons.MiniTextFont.Italic=FontFamilyMini->font().italic();
	ActiveConfiguration->Icons.MiniTextFont.Weight=FontFamilyMini->font().weight();

	ActiveConfiguration->Icons.Horiz=Horiz->value();
	ActiveConfiguration->Icons.Raise=Raise->value();
	ActiveConfiguration->Icons.Separation=Separation->value();
	ActiveConfiguration->Icons.SizePrefer=Size->value();

	// 0.33
	if(!ActiveConfiguration->AutoResize)ActiveConfiguration->Icons.Size=ActiveConfiguration->Icons.SizePrefer;
	//0.30
	ActiveConfiguration->Icons.SizeBig=SizeBig->value();
	ActiveConfiguration->Matrix.Design=Design->currentText();
	
	//ActiveConfiguration->Plugins.Matches !!!!
	ActiveConfiguration->Window.HideTimeout=HideTimeout->value();
	ActiveConfiguration->Window.TopForce=TopForce->value();
	ActiveConfiguration->Window.LeftForce=LeftForce->value();
	
	ActiveConfiguration->Window.HeightDesktop=HeightDesktop->value();
	if(AutoSave->isChecked())ActiveConfiguration->AutoSave=1;
	else ActiveConfiguration->AutoSave=0;
	if(AutoResize->isChecked())ActiveConfiguration->AutoResize=1;
	else ActiveConfiguration->AutoResize=0;



	if(FastHide->isChecked())ActiveConfiguration->Window.FastHide=1;
	else ActiveConfiguration->Window.FastHide=0;

	ActiveConfiguration->Theme.Background.Desaturate=imgBackground_Desaturate->value();
	if(RaiseOnEvents->isChecked())ActiveConfiguration->Window.RaiseOnEvents=true;
	else ActiveConfiguration->Window.RaiseOnEvents=false;
	ActiveConfiguration->Window.SendToForgroundTimeout=SendToForgroundTimeout->value();
	
 	ActiveConfiguration->Theme.Background.Tiled=imgBackground_Tiled->isChecked();
	ActiveConfiguration->Theme.Background.imgBackgroundCenter=imgBackgroundCenter->text();
	ActiveConfiguration->Theme.Background.imgBackgroundLeft=imgBackgroundLeft->text();
	ActiveConfiguration->Theme.Background.imgBackgroundOver=imgBackgroundOver->text();
	ActiveConfiguration->Theme.Background.imgBackgroundRight=imgBackgroundRight->text();
	ActiveConfiguration->Theme.Background.imgBackgroundSeparator=imgBackgroundSeparator->text();
	ActiveConfiguration->Theme.BackgroundPath=BackgroundPath->text();
	ActiveConfiguration->Theme.IconsPaths.clear();
	for(uint i=0;i<iconsPaths->count();i++)
	{
	ActiveConfiguration->Theme.IconsPaths.append(iconsPaths->text(i));
	}
	ActiveConfiguration->Plugins.PluginsPaths.clear();
	for(uint i=0;i<pluginsPaths->count();i++)
	{
	ActiveConfiguration->Plugins.PluginsPaths.append(pluginsPaths->text(i));
	}
	
	if(rAlignTop->isChecked())ActiveConfiguration->Window.Align="top";
	if(rAlignLeft->isChecked())ActiveConfiguration->Window.Align="left";
	if(rAlignRight->isChecked())ActiveConfiguration->Window.Align="right";
	if(rAlignBottom->isChecked())ActiveConfiguration->Window.Align="bottom";
	
	
	ActiveConfiguration->Icons.OverTextFont.BackgroundPath=PillowPath->text();
	ActiveConfiguration->Icons.MiniTextFont.BackgroundPath=PillowPath2->text();
	ActiveConfiguration->Theme.PoofPath=PoofPath->text();
	ActiveConfiguration->Theme.ArrowsPath=ArrowPath->text();
	
	// reloading icons!
	for(int i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		xGDocker->reloadIcon(i);
	}
	
	// Engine with autoresize and dynamic update matrix
	// 25 Marzo 2005
	// 0.30
	//XEMatrix *XMatrix=(XEMatrix *)XEObject::xGetMatrix();
	
	//XMatrix->xUpdateMatrix();
	xGDocker->xUpdateSense();
	// new Engine 11 05 2004
	// change background must came at end
	//xGDocker->changeBackground(ActiveConfiguration->Theme.BackgroundPath);
	//xGDocker->xMoveWidgetCenter();
}


/*!
    \fn XEPlugin_Configurator::slot_oClassName_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oClassName_textChanged ( const QString & newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		LastIcon->Info.className=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oGroup_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oGroup_textChanged ( const QString & newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		LastIcon->Info.Group=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oImgArrow_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oImgArrow_textChanged ( const QString & newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		if(LastIcon->Images.imgFileArrow==newt)return;
		LastIcon->Images.imgFileArrow=newt;
		// ok now we have to check if it's displayed:
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->reloadIcon(idx);
		}
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oImgFileName_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oImgFileName_textChanged ( const QString & newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		if(LastIcon->Images.imgFileName==newt)return;
		LastIcon->Images.imgFileName=newt;
		// ok now we have to check if it's displayed:
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->reloadIcon(idx);
		}
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oName_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oName_textChanged ( const QString & newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		LastIcon->Info.Name=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oOnClickExec_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oOnClickExec_textChanged ( const QString &newt )
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		LastIcon->Actions.onClickExec=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oOverText_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_oOverText_textChanged ( const QString & newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		if(LastIcon->OverText==newt)return;
		LastIcon->OverText=newt;
		// ok now we have to check if it's displayed:
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->reloadIcon(idx);
		}
	}
}


/*!
    \fn XEPlugin_Configurator::addIconPath()
 */
void XEPlugin_Configurator::addIconPath()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenIconThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Icons Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	iconsPaths->insertItem(cfgPath,0);
	
}


/*!
    \fn XEPlugin_Configurator::slot_BackgroundPath_textChanged( const QString & newt)
 */
void XEPlugin_Configurator::slot_BackgroundPath_textChanged( const QString & newt)
{
	xGDocker->changeBackground(ActiveConfiguration->Theme.BackgroundPath);
}


/*!
    \fn XEPlugin_Configurator::alias_selectionChanged(QListViewItem *)
 */
void XEPlugin_Configurator::alias_selectionChanged(QListViewItem *item)
{
	int i=-1;
	for(uint f=0;f<ActiveConfiguration->Plugins.Matches.count();f++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(f)->Icon->Info.Name
			==
			item->text(0)
		)
		{
		i=f;
		break;
		}
	}
	if(i<0)return;
	//oName->setText(item->text(0));
	//oGroup->setText(item->text(1));
	XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
	LastAlias=newalias;
	XSGObjectIcon *icon=newalias->Icon;
	
	
	if(icon==NULL)return;
	
	KIconLoader KDEIconLoader;
	aName->setText(icon->Info.Name);
	aGroup->setText(icon->Info.Group);
	aSystem->setText(newalias->SystemName);
	
	aclassName->clear();
	
	aclassName->insertStringList(XEObject::xGetPluginListNames());
	aclassName->insertItem("GSeparator",0);
	aclassName->insertItem("disabled",0);
	aclassName->insertItem(icon->Info.className,0);
	
	//oclassName->setCurrentText(icon->Info.className);
	aclassName->setCurrentItem(0);
	
	aliasListTasks->clear();
	for(uint i=0;i<icon->Tasks.WindowTitle.count();i++)
	{
		QListViewItem	*item=new QListViewItem(
			(QListView *)aliasListTasks);
	
		//	iconImg,icon->Info.Name,
		//	iconImg,icon->Info.Group);
		item->setText(0,icon->Tasks.WindowTitle[i]);
		item->setText(1,icon->Tasks.TaskName[i]);
		item->setText(2,icon->Tasks.ClassName[i]);
		//item->setPixmap (0,iconImg);
		aliasListTasks->insertItem(item);
	}
	
	
	aOverText->setText(icon->OverText);
	aimgFileName->setText(icon->Images.imgFileName);
	aimgFileArrow->setText(icon->Images.imgFileArrow);
	aimgFileDrop->setText(icon->Images.imgFileDrop);
	aonClickExec->setText(icon->Actions.onClickExec);
	aonDropExec->setText(icon->Actions.onDropExec);
	
	iaimgFileName->setIcon(icon->Images.imgFileName);
}
void XEPlugin_Configurator::slot_aClassName_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Info.className=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oGroup_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_aGroup_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Info.Group=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oImgArrow_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_aImgArrow_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Images.imgFileArrow=newt;
	
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oImgFileName_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_aImgFileName_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Images.imgFileName=newt;
	
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oName_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_aName_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Info.Name=newt;
	
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oOnClickExec_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_aOnClickExec_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Actions.onClickExec=newt;
	
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oOverText_textChanged ( const QString & )
 */
void XEPlugin_Configurator::slot_aOverText_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->OverText=newt;
	
	}
}
void XEPlugin_Configurator::aimgFile_iconChanged(QString newicon)
{
	aimgFileName->setText(newicon);
}


/*!
    \fn XEPlugin_Configurator::iconsListTasks_itemRenamed(QListViewItem *, int, const QString &)
 */
void XEPlugin_Configurator::iconsListTasks_itemRenamed(QListViewItem *item, int col, const QString &newtext)
{
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Configurator::iconsListTasks_itemRenamed(QListViewItem *item, int col, const QString &newtext)");
	#endif
}


/*!
    \fn XEPlugin_Configurator::apply_tasks()
 */
void XEPlugin_Configurator::apply_tasks()
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
	#ifndef ENABLE_FINAL
		qWarning("xeplugin_configurator.cpp:1753");
	#endif
		// ok i hope it will exists
		QListViewItemIterator it(iconsListTasks);
		// flush old maps
		LastIcon->Tasks.ClassName.clear();
		LastIcon->Tasks.WindowTitle.clear();
		LastIcon->Tasks.TaskName.clear();
		while(it.current())
		{
			QListViewItem *item=it.current();
		LastIcon->Tasks.WindowTitle.append(item->text(0));
		LastIcon->Tasks.TaskName.append(item->text(1));
		LastIcon->Tasks.ClassName.append(item->text(2));
			++it;
		}
	}
}

#include <taskmanager.h>
/*!
    \fn XEPlugin_Configurator::tasks_add()
 */
void XEPlugin_Configurator::tasks_add()
{
	/*
	QListViewItem	*item=new QListViewItem(
		(QListView *)iconsListTasks);

	//	iconImg,icon->Info.Name,
	//	iconImg,icon->Info.Group);
	// 0.21
	item->setText(0,"Application Title");
	item->setText(1,"Task Name");
	item->setText(2,"Class Name");
	//item->setPixmap (0,iconImg);
	iconsListTasks->insertItem(item);
	*/
	
	for(int i=0; i< ActiveConfiguration->RollingIcons.count();i++)
	{
		for(int k=0; k<ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.count();k++)
		{
			QListViewItem	*item=new QListViewItem(
				(QListView *)iconsListTasks);
		
			Task *t=(Task *)ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.at(k);
			QString TaskName=t->className();
			QString WindowTitle=t->name();
			QString ClassName=t->classClass();
			item->setText(0,WindowTitle);
			item->setText(1,TaskName);
			item->setText(2,ClassName);
			iconsListTasks->insertItem(item);
		}
	
	}
	
}


/*!
    \fn XEPlugin_Configurator::tasks_remove()
 */
void XEPlugin_Configurator::tasks_remove()
{
		QListViewItem *item=iconsListTasks->currentItem();
		if(item==NULL)return;
		iconsListTasks->removeItem(item);
		// ok i hope it will exists
}
void XEPlugin_Configurator::aapply_tasks()
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
	
	#ifndef ENABLE_FINAL
		qWarning("xeplugin_configurator.cpp:1853");
	#endif
		// ok i hope it will exists
		QListViewItemIterator it(aliasListTasks);
		// flush old maps
		LastAlias->Icon->Tasks.ClassName.clear();
		LastAlias->Icon->Tasks.WindowTitle.clear();
		LastAlias->Icon->Tasks.TaskName.clear();
		while(it.current())
		{
			QListViewItem *item=it.current();
		LastAlias->Icon->Tasks.WindowTitle.append(item->text(0));
		LastAlias->Icon->Tasks.TaskName.append(item->text(1));
		LastAlias->Icon->Tasks.ClassName.append(item->text(2));
			++it;
		}
	}
}


/*!
    \fn XEPlugin_Configurator::tasks_add()
 */
void XEPlugin_Configurator::atasks_add()
{
        for(int i=0; i< ActiveConfiguration->RollingIcons.count();i++)
        {
                for(int k=0; k<ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.count();k++)
                {
                        QListViewItem   *item=new QListViewItem(
                                (QListView *)aliasListTasks);

                        Task *t=(Task *)ActiveConfiguration->RollingIcons.at(i)->Tasks.Proces.at(k);
                        QString TaskName=t->className();
                        QString WindowTitle=t->name();
                        QString ClassName=t->classClass();
                        item->setText(0,WindowTitle);
                        item->setText(1,TaskName);
                        item->setText(2,ClassName);
                        aliasListTasks->insertItem(item);
                }

        }


}


/*!
    \fn XEPlugin_Configurator::tasks_remove()
 */
void XEPlugin_Configurator::atasks_remove()
{
		QListViewItem *item=aliasListTasks->currentItem();
		if(item==NULL)return;
		aliasListTasks->removeItem(item);
		// ok i hope it will exists
}


/*!
    \fn XEPlugin_Configurator::pluginsList_selectionChanged(QListViewItem *)
 */
void XEPlugin_Configurator::pluginsList_selectionChanged(QListViewItem *item)
{
	int i=-1;
	for(int f=0;f<ActiveConfiguration->Plugins.Plugin.count();f++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(f)->Info.Name
			==
			item->text(0)
		)
		{
		i=f;
		break;
		}
	}
	if(i<0)return;
	//oName->setText(item->text(0));
	//oGroup->setText(item->text(1));
	XSGObjectPlugin *newplugin=ActiveConfiguration->Plugins.Plugin.at(i);
	LastPlugin=newplugin;
	pName->setText(newplugin->Info.Name);
	
	connect(this, SIGNAL(xGetParameterList(QStringList *)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameterList(QStringList *)));
	QStringList a;
	a.clear();
	pXMLConf->clear();
	xGetParameterList(&a);
	disconnect(this, SIGNAL(xGetParameterList(QStringList *)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameterList(QStringList *)));
	
	connect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameter(const QString,QString&)));
		
	for(int i=0;i<a.count();i++)
	{
		QListViewItem	*item=new QListViewItem(
			(QListView *)pXMLConf);
		
		item->setText(0,a[i]);
		
		QString b;
		xGetParameter(a[i],b);
		
		item->setText(1,b);
		
		
		pXMLConf->insertItem(item);
	
	}
	disconnect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameter(const QString,QString&)));
}


/*!
    \fn XEPlugin_Configurator::PluginsList_itemRenamed(QListViewItem *, int, const QString &)
 */
void XEPlugin_Configurator::PluginsList_itemRenamed(QListViewItem *item, int col, const QString &newtext)
{
	if(col!=1)return;
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Configurator::PluginsList_itemRenamed(QListViewItem *item, int col, const QString &newtext)");
	#endif
	if(LastPlugin!=NULL && ActiveConfiguration->Plugins.Plugin.find(LastPlugin)>=0)
	{
		// ok we are going on the same route
	connect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(LastPlugin->Info.Name),
		SLOT(xSetupParameter(const QString,const QString)));
		
		xSetupParameter(item->text(0),newtext);
	
	disconnect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(LastPlugin->Info.Name),
		SLOT(xSetupParameter(const QString,const QString)));
	
	}
}


/*!
    \fn XEPlugin_Configurator::apply_plugins()
 */
void XEPlugin_Configurator::apply_plugins()
{
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Configurator::apply_plugins() 2063");
	#endif
	if(LastPlugin!=NULL && ActiveConfiguration->Plugins.Plugin.find(LastPlugin)>=0)
	{
		// ok we are going on the same route
	connect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(LastPlugin->Info.Name),
		SLOT(xSetupParameter(const QString,const QString)));
		
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Configurator::apply_plugins() 2071");
	#endif
		QListViewItemIterator it(pXMLConf);
		// flush old maps
		while(it.current())
		{
			QListViewItem *item=it.current();
			xSetupParameter(item->text(0),item->text(1));
			++it;
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Configurator::apply_plugins() 2079");
	#endif
			
		}
		
	
	disconnect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(LastPlugin->Info.Name),
		SLOT(xSetupParameter(const QString,const QString)));
	
	}
}


/*!
    \fn XEPlugin_Configurator::refreshPluginscfg(XSGObjectIcon *, KListView *)
 */
void XEPlugin_Configurator::refreshPluginscfg(XSGObjectIcon *icon, KListView *list)
{
	list->clear();
	disconnect(this, SIGNAL(xPluginRunConfigurator()));

	connect(this, SIGNAL(xPluginRunConfigurator()),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xRunConfigurator()));
	
	oPluginName->setText("");
	oPluginVersion->setText("");
	oPluginDate->setText("");
	oPluginAuthor->setText("");
	oPluginAuthorMail->setText("");
	oPluginUrlDownload->setText("");
	oPluginUrlDocumentation->setText("");
	oPluginUrlUpdate->setText("");
	disconnect(this, SIGNAL(xFetchGetInfo(QStringList &)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetInfo(QStringList &)));
	if(
	connect(this, SIGNAL(xFetchGetInfo(QStringList &)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetInfo(QStringList &))))
	{
		QStringList getInfo;
		xFetchGetInfo(getInfo);
		int ivs=0;
		if(getInfo.count()>ivs)oPluginName->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginVersion->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginDate->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginAuthor->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginAuthorMail->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginUrlDownload->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginUrlDocumentation->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)oPluginUrlUpdate->setText(getInfo[ivs]);

	}
	
	
	#ifndef ENABLE_FINAL
	qWarning(icon->Info.className);
	#endif
	connect(this, SIGNAL(xGetParameterList(QStringList *)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameterList(QStringList *)));
	/*
	connect(this, SIGNAL(),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameterList(QStringList *)));
	*/	
		
	QStringList a;
	a.clear();
	pXMLConf->clear();
	xGetParameterList(&a);
	disconnect(this, SIGNAL(xGetParameterList(QStringList *)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameterList(QStringList *)));
	
	connect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameter(const QString,QString&)));
		
	for(int i=0;i<a.count();i++)
	{
		QListViewItem	*item=new QListViewItem(
			(QListView *)list);
		
		item->setText(0,a[i]);
		
		QString b;
		xGetParameter(a[i],b);
		
		item->setText(1,b);
		
		
		list->insertItem(item);
	
	}
	disconnect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameter(const QString,QString&)));
}


/*!
    \fn XEPlugin_Configurator::apply_objectsplugin()
 */
void XEPlugin_Configurator::apply_objectsplugin()
{
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_Configurator::apply_objectsplugin()");
	#endif
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok we are going on the same route
	connect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(LastIcon->Info.className),
		SLOT(xSetupParameter(const QString,const QString)));
		
		QListViewItemIterator it(oPluginCfg);
		// flush old maps
		while(it.current())
		{
			QListViewItem *item=it.current();
			xSetupParameter(item->text(0),item->text(1));
			++it;
			
		}
		
	
	disconnect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(LastIcon->Info.className),
		SLOT(xSetupParameter(const QString,const QString)));
	
	}

}


/*!
    \fn XEPlugin_Configurator::add_alias()
 */
void XEPlugin_Configurator::add_alias()
{
			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());

	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//	XSGObjectIcon *addedCfg=new XSGObjectIcon;
	XSCfgMatchIcons *addedMatch=new XSCfgMatchIcons;
	addedMatch->Icon=addedCfg;
	
	ActiveConfiguration->Plugins.Matches.append(addedMatch);
	
	addedMatch->SystemName="Your_Application_or_Plugin";
	
//	addedCfg->Tasks.PopupMenu=new KPopupMenu();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	addedCfg->Tasks.Proces.clear();
	addedCfg->Info.className="GIcon";
	addedCfg->Info.fileName="";
	QDateTime a=QDateTime::currentDateTime();
	QString randomName=a.toString("mmss");
	
	QString b="AddedIcon_";
	b=b+randomName;
	b="Group_";
	b=b+randomName;
	b="AddedIcon_";
	b=b+randomName;
	
	addedCfg->Info.Name=b;
	addedCfg->Info.Group=b;
	addedCfg->Actions.onClickExec="";
	addedCfg->Actions.onDropExec="";
	addedCfg->OverText=b;
	addedCfg->Images.imgFileName="default";
	
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->TimeToLive=0;

	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.TaskInfo=NULL;
	//0.29
	addedCfg->Tasks.dcopReady=0;
		// 0.33
		addedCfg->Tasks.forceRunning=0;

	guiRefreshValues();
	
	if(aliasList->lastChild())
		aliasList->setSelected(aliasList->lastChild() , true );
}


/*!
    \fn XEPlugin_Configurator::remove_alias()
 */
void XEPlugin_Configurator::remove_alias()
{

	// TODO: Garbage on remove ALIAS!!!
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		// ok now we have to check if it's displayed:
		ActiveConfiguration->Plugins.Matches.remove(LastAlias);
	}
	guiRefreshValues();
	if(aliasList->lastChild())
		aliasList->setSelected(aliasList->lastChild() , true );
}


/*!
    \fn XEPlugin_Configurator::slot_aSystem_textChanged ( const QString & newt)
 */
void XEPlugin_Configurator::slot_aSystem_textChanged ( const QString & newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->SystemName=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::create_about()
 */
void XEPlugin_Configurator::create_about(QVBox	*vpage1)
{
    new QLabel(i18n("Welcome to KXDocker"), vpage1);
    QVGroupBox *gvabout=new QVGroupBox(i18n("About:"),vpage1);
    QString a;
    a=QString(i18n("You are using KXDocker Version"));
    a=a+QString(" %1 ").arg(KXDOCKERVERSION);
    a=a+QString(i18n("released on"));
    a=a+QString(" %1 ").arg(KXDOCKERDATE);
    new QLabel(a, gvabout);
    a=QString(i18n("KXDocker is an innovative docker for KDE 3.x.x"));
    /*
 KXDocker is an innovative docker for KDE it's like Mac OSX Docker but more powerfull. 
 KXDocker target is to implement a new Docker idea to improve usability of Linux Desktops. 
 KXDocker is a VERY big project where the goal is desktop integration with Linux Operative System. 
 KXDocker is not only an "old school docker" !. 
    */
    
    new QLabel(a, gvabout);
    a=QString(i18n("KXDocker is a XIA Projects product"));
    new QLabel(a, gvabout);
    a=QString("http://www.xiaprojects.com");
    new QLabel(a, gvabout);

    gvabout=new QVGroupBox(i18n("Many thanks to contributors:"),vpage1);
    
    a=QString("Lucio");
    new QLabel(a, gvabout);
    a=QString("Magilla");
    new QLabel(a, gvabout);
    a=QString("Michel");
    new QLabel(a, gvabout);
    a=QString("Eric");
    new QLabel(a, gvabout);
QPushButton *pab=new QPushButton(i18n("About KXDocker (click on the tray, here not ready yet)"),vpage1);
//connect(pab,SIGNAL(clicked()),XEObject::xFindObject("xTray"),SLOT(xAbout()));


/*
    gvabout=new QVGroupBox(i18n("Developer Team:"),vpage1);
    a=QString(i18n("Main developer"));
    a=a+QString(": Stefano Zingarini stefano@xiaprojects.com");
    new QLabel(a, gvabout);
    a=QString(i18n("Many thanks to other minor developers:"));
    new QLabel(a, gvabout);
    
    QGrid	*griglia2=new QGrid(2,gvabout);
    a=QString("Bruno");
    new QLabel(a, griglia2);
    a=QString("Filip");
    new QLabel(a, griglia2);
    a=QString("Lucio");
    new QLabel(a, griglia2);
    a=QString("Magilla");
    new QLabel(a, griglia2);
    a=QString("Thomas");
    new QLabel(a, griglia2);
    a=QString("Saurabh");
    new QLabel(a, griglia2);
    a=QString("Vagninu");
    new QLabel(a, griglia2);
*/
    gvabout=new QVGroupBox(i18n("Read here:"),vpage1);
    
    a=QString(i18n("Configurator Version"));
    a=a+QString(" %1\n").arg(KX_CFG_VERSION);
    a=a+QString(i18n("If you update any parameter remeber: YOU MUST click on APPLY Button on top!"));
    
    new QLabel(a, gvabout);
    
    gvabout=new QVGroupBox(i18n("KXDocker compilation options:"),vpage1);
    QGrid	*griglia=new QGrid(2,gvabout);
    a=QString(i18n("you have enabled this switch at compile time:"));
    new QLabel(a, griglia);
    a=QString("");
    new QLabel(a, griglia);
    a=QString("Special Engine 2 with interpolation");
    new QLabel(a, griglia);
#ifdef ENABLE_SPECIALENGINE2
    a=QString("YES");
    new QLabel(a, griglia);
#else
    a=QString("NO");
    new QLabel(a, griglia);
#endif
    
    a=QString("debug messages");
    new QLabel(a, griglia);
#ifdef ENABLE_FINAL
    a=QString("NO");
    new QLabel(a, griglia);
#else
    a=QString("YES");
    new QLabel(a, griglia);
#endif

    a=QString("statistics");
    new QLabel(a, griglia);
#ifdef ENABLE_STATS
    a=QString("YES");
    new QLabel(a, griglia);
#else
    a=QString("NO");
    new QLabel(a, griglia);
#endif

}


/*!
    \fn XEPlugin_Configurator::AddPluginPath()
 */
void XEPlugin_Configurator::AddPluginPath()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenPluginsPath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Add KXDocker Plugin directory");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	pluginsPaths->insertItem(cfgPath,0);
}


/*!
    \fn XEPlugin_Configurator::backgroundChangePath()
 */
void XEPlugin_Configurator::backgroundChangePath()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenBackgroundThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Background Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	BackgroundPath->setText(cfgPath);
}


/*!
    \fn XEPlugin_Configurator::addPlugin()
 */
void XEPlugin_Configurator::addPlugin()
{
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator !=NULL)
	{
		Configurator->pluginAdd(pName->text());
	}
	KMessageBox::information 
(this,"you have to manually save and restart KXDocker apply this update","XML configuration Activation");
}


/*!
    \fn XEPlugin_Configurator::removePlugin()
 */
void XEPlugin_Configurator::removePlugin()
{
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator !=NULL)
	{
		Configurator->pluginRemove(pName->text());
	}
	
	KMessageBox::information 
(this,"you have to manually save and restart KXDocker apply this update","XML configuration Activation");
}


/*!
    \fn XEPlugin_Configurator::slot_aOnDropExec_textChanged(const QString&)
 */
void XEPlugin_Configurator::slot_aOnDropExec_textChanged(const QString &newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Actions.onDropExec=newt;
	
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oOnDropExec_textChanged(const QString&)
 */
void XEPlugin_Configurator::slot_oOnDropExec_textChanged(const QString &newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		LastIcon->Actions.onDropExec=newt;
	}
}


/*!
    \fn XEPlugin_Configurator::slot_oImgArrow_textChanged ( const QString &)
 */
void XEPlugin_Configurator::slot_oImgDrop_textChanged ( const QString &newt)
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
		// ok i hope it will exists
		if(LastIcon->Images.imgFileDrop==newt)return;
		LastIcon->Images.imgFileDrop=newt;
		// ok now we have to check if it's displayed:
		int idx=ActiveConfiguration->ObjectsIcons.find(LastIcon);
		if(idx>=0)
		{
			// refresh icon on the docker
			xGDocker->reloadIcon(idx);
		}
	}
}


/*!
    \fn XEPlugin_Configurator::slot_aImgDrop_textChanged (const QString &)
 */
void XEPlugin_Configurator::slot_aImgDrop_textChanged (const QString &newt)
{
	if(LastAlias!=NULL && ActiveConfiguration->Plugins.Matches.find(LastAlias)>=0)
	{
		// ok i hope it will exists
		LastAlias->Icon->Images.imgFileDrop=newt;
	
	}
}


/*!
    \fn XEPlugin_Configurator::xGetInfo(QStringList &)
 */
void XEPlugin_Configurator::xGetInfo(QStringList &)
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Configurator::xRunCfg()
 */
void XEPlugin_Configurator::xRunCfg()
{
	qWarning("Running plugin configuration...");
	this->xPluginRunConfigurator();
}

#ifdef ENABLE_STATS

void XEPlugin_Configurator::create_statistics(QVBox	*vpageStats)
{
	new QLabel(i18n("KXDocker Stats"), vpageStats);
	QGrid	*griglia=new QGrid(2,vpageStats);
	new QLabel(i18n("dockerStarts"), griglia);
	dockerStarts=new QLabel("0", griglia);

	new QLabel(i18n("dockerDaysRunning"), griglia);
	dockerDaysRunning=new QLabel("0", griglia);

	new QLabel(i18n("dockerHoursRunning"), griglia);
	dockerHoursRunning=new QLabel("0", griglia);

	new QLabel(i18n("dockerMinutesRunning"), griglia);
	dockerMinutesRunning=new QLabel("0", griglia);

	new QLabel(i18n("dockerSecondsRunning"), griglia);
	dockerSecondsRunning=new QLabel("0", griglia);

	new QLabel(i18n("dockerFirstStart"), griglia);
	dockerFirstStart=new QLabel("0", griglia);

	new QLabel(i18n("maxIconsDisplayed"), griglia);
	maxIconsDisplayed=new QLabel("0", griglia);

	new QLabel(i18n("avgIconsDisplayed"), griglia);
	avgIconsDisplayed=new QLabel("0", griglia);

	new QLabel(i18n("changedBackgroundTheme"), griglia);
	changedBackgroundTheme=new QLabel("0", griglia);

	new QLabel(i18n("startedConfigurator"), griglia);
	startedConfigurator=new QLabel("0", griglia);
}


void XEPlugin_Configurator::update_statistics()
{
	//0.36
	QDateTime tempo;
	tempo.setTime_t(ActiveConfiguration->Statistics.lastStart);
	int secConta=tempo.secsTo(QDateTime::currentDateTime());
	int minuti=secConta/60;
	int ore=minuti/60;
	int giorni=ore/24;
	secConta=secConta%60;
	minuti=minuti%60;
	ore=ore%24;

	startedConfigurator->setNum(ActiveConfiguration->Statistics.startedConfigurator);
	dockerStarts->setNum(ActiveConfiguration->Statistics.dockerStarts);
	dockerDaysRunning->setNum(giorni);

	dockerMinutesRunning->setNum(minuti);
	dockerHoursRunning->setNum(ore);

	dockerSecondsRunning->setNum(secConta);

	//dockerFirstStart->setNum(
	//ActiveConfiguration->Statistics.dockerFirstStart);
	tempo.setTime_t(ActiveConfiguration->Statistics.dockerFirstStart);
	
	dockerFirstStart->setText(tempo.toString("ddd d MMMM yyyy"));


	maxIconsDisplayed->setNum(
	ActiveConfiguration->Statistics.maxIconsDisplayed);

	changedBackgroundTheme->setNum(
	ActiveConfiguration->Statistics.changedBackgroundTheme);
	if(ActiveConfiguration->Statistics.avgCounter>0)
	{
	avgIconsDisplayed->setText(QString("%1 (%1)").arg(
	ActiveConfiguration->Statistics.avgIconsDisplayed/
		ActiveConfiguration->Statistics.avgCounter
	).arg(
	ActiveConfiguration->Statistics.avgCounter
	));
	}
}
#endif


/*!
    \fn XEPlugin_Configurator::object_dcop_apply()
 */
void XEPlugin_Configurator::object_dcop_apply()
{
	if(LastIcon!=NULL && ActiveConfiguration->RollingIcons.find(LastIcon)>=0)
	{
	#ifndef ENABLE_FINAL
		qWarning("xeplugin_configurator.cpp:1753");
	#endif
		// ok i hope it will exists
		QListViewItemIterator it(iconsListDCOP);
		// flush old maps
		LastIcon->Tasks.dcopName.clear();
		while(it.current())
		{
			QListViewItem *item=it.current();
			LastIcon->Tasks.dcopName.append(item->text(0));
			++it;
		}
	}
}


/*!
    \fn XEPlugin_Configurator::object_dcop_remove()
 */
void XEPlugin_Configurator::object_dcop_remove()
{
		QListViewItem *item=iconsListDCOP->currentItem();
		if(item==NULL)return;
		iconsListDCOP->removeItem(item);
}


/*!
    \fn XEPlugin_Configurator::object_dcop_add()
 */
void XEPlugin_Configurator::object_dcop_add()
{
			QListViewItem	*item=new QListViewItem(
				(QListView *)iconsListDCOP);
		
			item->setText(0,"DCOP_NAME");
			iconsListDCOP->insertItem(item);
}


/*!
    \fn XEPlugin_Configurator::xParse(const QString &parseCmd, int, void *)
 */
void XEPlugin_Configurator::xParse(const QString &parseCmd, int, void *)
{
	if(parseCmd=="show()")show();
	if(parseCmd=="hide()")hide();
}
