/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_NETWORKER_H
#define XEPLUGIN_NETWORKER_H

#include <qobject.h>

#include <qobject.h>
#include <libkxdocker.h>
#include <qstringlist.h>


/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_Networker : public QObject
{
Q_OBJECT
public:
    XEPlugin_Networker(QObject *parent = 0, const char *name = 0);
    ~XEPlugin_Networker();
public slots:
    void xGetInfo(QStringList &);
    void xGetParameter(const QString, QString&);
    void xGetParameterList(QStringList *);
    void xSetup();
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void dirty(const QStringList &);
    void polling();
    void discoveryNow();
    void discoveryStop();
protected:
	int showControlIcon;
	class XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	class XEConfiguration *Configurator;
	void updateXMLcfg(const QString sName);
	void Discovered(const QString &);
	class IFManager *ifManager;
	QStringList deviceList;
	int MutexData;
	QString ExternalEntryManager;
	QString AutoAddMounts;
	int checkEvery;
	QString onClickExec;
	QString prefixCaption;
signals:
	void xParseTo(const QString &, int, void *);
};

#endif
