/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ifmanager.h"
#include "ifmanager.moc"
#include <qmutex.h>
#include <qprocess.h>
#include <stdio.h>
#include <string.h>
#include <ktn_proc.h>


IFManager::IFManager()
 : QThread()
{
	//proc=NULL;
	semaforo=new QMutex();
	localSpawn=0;
	dropLines=1;
	localCmd="";
}


IFManager::~IFManager()
{
}

/*!
    \fn IFManager::run()
 */
void IFManager::run()
{
	if(localCmd==QString::null)return;
	if(localCmd=="")return;
	
	while(localSpawn)
	{
		localList.clear();
		KTN_Proc procIface;
		procIface.networkFindDevices(localList);
		dirty(localList);
		sleep(localSpawn);
	}
}

void IFManager::setCmd(const QString newCmd, const QString, int newSpawn,int newLine)
{
	localCmd=newCmd;
	localSpawn=newSpawn;
	dropLines=newLine;
}
