/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gthrottle.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <string.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>

#include "gpluginpainter.h"


#include "gthrottle.moc"


ACPI_CPU_Info::ACPI_CPU_Info()
{
	cpuName="CPU0";
	procTemperature="/proc/acpi/thermal_zone/THRM/temperature";
	procTemperature2="/proc/acpi/thermal_zone/THM/temperature";

	procThrottle="/proc/acpi/processor/%1/throttling";
	procI8K="/proc/i8k";
	fd = NULL;
	fdfan = NULL;
}

ACPI_CPU_Info::~ACPI_CPU_Info()
{
}

int ACPI_CPU_Info::open(const QString newcpuName)
{
	int RetCode=0;
	if((fd = fopen(procTemperature, "r")) == NULL )
	{
		if((fd = fopen(procTemperature2, "r")) == NULL )return RetCode;
	}
	if((fdfan = fopen(procI8K, "r")) == NULL)fdfan=0;
	cpuName=newcpuName;
	RetCode++;

	return RetCode;
}

void ACPI_CPU_Info::close()
{
	if(fd)fclose(fd);
	if(fdfan)fclose(fdfan);
	fd=NULL;
	fdfan=NULL;
}

int ACPI_CPU_Info::temperature()
{
	rewind(fd);
	memset(buf,0,128);
	fgets(buf, 128, fd);
	int conta=strlen(buf);
	int temperatura=0;
	
	for(;conta>0;conta--)
	{
		if(buf[conta]>='0' && buf[conta]<='9')break;
	}
	int deca=1;
	for(;conta>0;conta--)
	{
		if( buf[conta]<'0' ||  buf[conta]>'9')break;
		int cifra=buf[conta]-'0';
		cifra=cifra*deca;
		temperatura=temperatura+cifra;
		
		deca=10;
	}

	return temperatura;
}

int ACPI_CPU_Info::fan()
{//1.0 A07 8TJRT0J 71 -22 2 27660 135330 -1 0
	if(!fdfan)return 0;
	rewind(fdfan);
	memset(buf,0,128);
	fgets(buf, 128, fdfan);
//	int conta=strlen(buf);

	
	char i8k_Version[5];
	char i8k_Bios[5];
	char i8k_SN[15];
	int i8k_Temp;
	int i8k_Bo0;
	int i8k_Bo1;
	int i8k_FanLeft;
	int i8k_FanRight;
	int i8k_Bo2;
	int i8k_Bo3;
/*	
	int pos=0;
	for(int conta_spazi=0;conta_spazi<7;conta_spazi++)
	{
		for(;pos<conta;pos++)if(buf[pos]==' ')break;
	}
	char Numero[7];
	memset(Numero,0,7);
	for(int iN=0;pos<conta;pos++)
	{
		Numero[iN]=buf[pos];
		iN++;
		if(buf[pos]==' ')break;
	}
	if(pos>=conta)return 0;
*/
	sscanf(buf,"%s %s %s %d %d %d %d %d %d %d",
		i8k_Version,
		i8k_Bios,
		i8k_SN,
		&i8k_Temp,
		&i8k_Bo0,
		&i8k_Bo1,
		&i8k_FanLeft,
		&i8k_FanRight,
		&i8k_Bo2,
		&i8k_Bo3);
/*
	qWarning(QString("(%1)[%1][%1][%1][%1][%1]")
		.arg(buf)
		.arg(i8k_SN)
		.arg(i8k_Temp)
		.arg(i8k_FanLeft)
		.arg(i8k_FanRight)
		.arg(i8k_Bios)
		);
*/
	return i8k_FanRight;
}


extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GAmarok xeplugin_register()");
	return new GThrottle(parent,"GThrottle");
}



GThrottle::GThrottle(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
    themepath="kxdocker/plugins/gthrottle/";
    
	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.4";
	// Project name
	PluginInformations.append("KXDocker GThrottle");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20050627");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gthrottle");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	IconSize=128;
	acpi=new ACPI_CPU_Info();
	cpuName="centrino";

	Painter=new gPluginPainter(0,"temp",DRAW_GaugeVert2);
	Painter->setRect(QRect(1,0,128,128));

	PainterFan=new gPluginPainter(0,"fan",DRAW_GaugeVert2);
	PainterFan->setRect(QRect(107,0,128,128));
	


}

GThrottle::~GThrottle()
{

}

void GThrottle::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		themepath=vvalue;
	}
	if(vname=="cpuname")
	{
		cpuName=vvalue;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
		xXMLIconConfig->item(0).toElement().setAttribute("cpuname",cpuName);
	}
	else
	{
		createXMLTree();
	}
	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(themepath);
}

void GThrottle::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	if(vname=="cpuname")
	{
		vvalue=cpuName;
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void GThrottle::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("cpuname");
	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}


void GThrottle::xPaint(int newValue)
{
	ToolTip=QString("Temperature %1C").arg(newValue);

	lastImage=background;
	bitBlt(&lastImage,128/2-imgCPU.width()/2,10,&imgCPU,0);
	int decimale=(newValue%10);
	int deca=newValue/10;
	bitBlt(&lastImage,128/2-2-imgNumber[deca].width(),128-imgNumber[deca].height()-8,&imgNumber[deca],0);
	bitBlt(&lastImage,128/2+2,128-imgNumber[decimale].height()-8,&imgNumber[decimale],0);
	

	Painter->setValue(QString("%1").arg(newValue));
	Painter->paint(&lastImage);

	
	int rfan=0;
	if(fan){
		if(fan>50000)fan=fan-30000;
		rfan=(int)double(double(double(fan)/double(120000))*double(100));
	}
	//qWarning(QString("FAN:%1 %1 ").arg(rfan).arg(fan));
	PainterFan->setValue(QString("%1").arg(rfan));
	PainterFan->paint(&lastImage);


	*xImgSource=lastImage.convertToImage();
}


void GThrottle::polling()
{
/*
	Value++;
	xRefreshIcon(xGIcon);
	QTimer::singleShot(1000, this, SLOT(polling()));
*/
	//qWarning("void GThrottle::polling()");
	if(isStopped){
		qWarning("void GThrottle::polling() exiting...");
		return;
	}


	acpi->open("CPU0");
	int temp=acpi->temperature();
	//qWarning(QString("The fan is:%1").arg(acpi->fan()));
	fan=acpi->fan();


	acpi->close();
	
	//qWarning(QString("Temperatura: %1C").arg(temp));
	dirty(temp);
	
	QTimer::singleShot(5000, this, SLOT(polling()));
}


void GThrottle::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gthrottle");
		cpuName=xXMLIconConfig->item(0).toElement().attribute("cpuname","centrino");
	}
	loadResources(themepath);
	// to enable the first pass
	lastValue=-1;
	//dirty("");
	dirty(0);
}


void GThrottle::dirty(int newTemp)
{
	if(lastValue==newTemp)return;

	Value=newTemp;


	xRefreshIcon(xGIcon);
}


void GThrottle::xStop()
{
	//qWarning("void GThrottle::xStop()");
	gPluginSDK::xStop();
	//acpi->close();
	//qWarning("void GThrottle::xStop() end");
}


void GThrottle::xStart()
{
	gPluginSDK::xStart();
	//QTimer::singleShot(500, this, SLOT(polling()));
}


void GThrottle::loadResources(const QString newPath)
{
	//**********************************************************
	QString fbackground="background.png";
	QString ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+fbackground;
	// check if it exists
	QFile a(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gthrottle/";
		ClockPaths=ClockPaths+fbackground;
	}

	//qWarning(ClockPaths);
	background.load(::locate("data",ClockPaths));
	// KXDocker save icon states
	// 2/3
	emit xSetIconImgFile(::locate("data",ClockPaths));
	
	for(int i=0;i<=9;i++)
	{
		
		fbackground=QString("%1.png").arg(i);
		ClockPaths=newPath;
		ClockPaths=ClockPaths+"/"+fbackground;
		a.setName(ClockPaths);
		if(!a.exists() || ClockPaths==QString::null)
		{
			ClockPaths="kxdocker/plugins/gthrottle/";
			ClockPaths=ClockPaths+fbackground;
		}
		
		
		this->imgNumber[i].load(::locate("data",ClockPaths));
	}

	fbackground=cpuName+".png";
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+fbackground;
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gthrottle/";
		ClockPaths=ClockPaths+fbackground;
	}
	
	
	this->imgCPU.load(::locate("data",ClockPaths));

	fbackground="fanv.png";
	ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+fbackground;
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gthrottle/";
		ClockPaths=ClockPaths+fbackground;
	}

	Painter->load(::locate("data",ClockPaths));
	PainterFan->load(::locate("data",ClockPaths));
}
