//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gpluginsdk.h"

#include "gpluginsdkcfgwnd.h"
#include "gpluginpainter.h"

#include "gpluginsdk.moc"

gPluginSDK::gPluginSDK(QObject *parent, const char *name)
 : QObject(parent, name)
{
	// pointer to the icon into the docker
	// remember if you have been stopped you cannot
	// use this pointer because you can crash kxdocker
	// ex: the icon may be removed
	xGIcon=NULL;
	PluginPopupMenu=NULL;
	// pointer to xGDocker which will send to you events
	xGDocker=NULL;
	// default tooltip displayed over the icon
	ToolTip="Default Sensor";
	
	// this is a integer
	// it's used to know if you have to update the icon
	lastValue=0;
	Value=0;
	ConfigurationWindow=new gPluginSDKCfgWnd((QObject *)this,name);
	isStopped=1;

	SizeBig=128;
	ImageFX_Y_degree=0;
	ImageFX_X_degree=0;
	ImageFX_GrayScale=0;
	ImageFX_Intensity=100;
	ImageFX_Painter=new gPluginPainter(0,"ImageFX",DRAW_ImageFX);
}


gPluginSDK::~gPluginSDK()
{
	/*
	ConfigurationWindow->close();
	delete ConfigurationWindow;
	delete ImageFX_Painter;
	*/
}


// This is the main
// must do nothing you have to export extern "C" QObject *xeplugin_register(QObject *parent)
// like:
/*
extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	// put your class here
	qWarning("GPluginSDK xeplugin_register()");
	return new gPluginSDK(parent,"gPluginSDK");
}

*/
int main()
{
	qWarning("You cannot run this plugin, lets KXDocker load it");
	return 0;
}


/*!
    \fn gPluginSDK::xSetup()
 */
void gPluginSDK::xSetup()
{
	// this function will attach the docker to this plugin
	qWarning(QString("%1::xSetup()").arg(name()));
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
	
	connect(this,SIGNAL(xFindResource(const QString,QString&)),
		xGDocker,SLOT(xFindResource(const QString,QString&)));
}


/*!
    \fn gPluginSDK::xRefreshIcon(QObject *)
 */
void gPluginSDK::xRefreshIcon(QObject *newIcon)
{
	// called every time by xGDocker to update the icon
	
	// do you have an icon?
	if(xGIcon==NULL || newIcon!=xGIcon)return;
	
	if(lastValue!=Value)
	{
		// call a virtual function to draw the icon
		xPaint(Value);
		// 0.4 check for apply fx
		xPaintFX(Value);
		// send signal to icon to invalidate the icon
		cachePurge();
		// this will re-zoom the new pixmap
		xSetSmoothZoom();
		// setup new tooltip
		xSetText(ToolTip);
		// to avoid the full redraw
		// send signal to the docker to redraw only the updated icon
		xDockerRedraw(xGIcon);
		lastValue=Value;
	}
}


/*!
    \fn gPluginSDK::xPaint(int)
 */
void gPluginSDK::xPaint(int)
{
	qWarning("KXDocker Plugin: You have to derivate this function to draw the icon xImgSource");
}


/*!
    \fn gPluginSDK::xStop()
 */
void gPluginSDK::xStop()
{
	//qWarning("void gPluginSDK::xStop()");
	isStopped=1;
}


/*!
    \fn gPluginSDK::xStart()
 */
void gPluginSDK::xStart()
{
	if(!isStopped)return;
	//qWarning("gPluginSDK::xStart()");
	isStopped=0;
	QTimer::singleShot(1000, this, SLOT(polling()));
}

extern "C" QObject *xeplugin_register(QObject *parent);
/*!
    \fn gPluginSDK::xAttach(QObject *)
 */
void gPluginSDK::xAttach(QObject *newIcon)
{
	// this will be called by the icon to be attached to this plugin
	
	// first icon to attach
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		// the xGIcon pointer
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		//
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		//
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		//
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		//
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		connect(this,SIGNAL(xSetIconEXE(const QString &)),xGIcon,SLOT(xSetIconEXE(const QString &)));
		connect(this,SIGNAL(xGetIconEXE(QString &)),xGIcon,SLOT(xGetIconEXE(QString &)));
		connect(this,SIGNAL( xGetIconName(QString &)),xGIcon,SLOT( xGetIconName(QString &)));
		connect(this,SIGNAL(xSetIconImgFile(const QString &)),xGIcon,SLOT(xSetIconImgFile(const QString &)));
		connect(this,SIGNAL(xSetIconName(const QString &)),xGIcon,SLOT(xSetIconName(const QString &)));
		connect(this,SIGNAL(xSetOverText(const QString &)),xGIcon,SLOT(xSetOverText(const QString &)));
		//
		//connect(this,SIGNAL(xGetPluginPopupMenu(KPopupMenu*& ,const QObject *)),xGIcon,SLOT(createPopup(KPopupMenu*& ,const QObject *)));
		connect(this,SIGNAL(xGetPluginPopupMenu(KPopupMenu*& ,const QObject *)),xGDocker,SLOT(createPopup(KPopupMenu*& ,const QObject *)));
		
		// fetch the icon configuration
		xGetPluginConfiguration(xXMLIconConfig);
		
		xGetImage(xImgSource);
		xGetPluginPopupMenu(PluginPopupMenu,xGIcon);
		
		//connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIconFromKXDocker(QObject *)));
		
		// kxdocker 0.29 support
		// - click events
		connect(xGIcon,SIGNAL(xEnabledClick(int& )),this,SLOT(xEnabledClick(int& )));
		connect(xGIcon,SIGNAL(xEventClick(void*, int, int, int, int )),this,SLOT(xEventClick(void*, int, int, int, int )));

		connect(xGIcon,SIGNAL(xStart()),this,SLOT(xStart()));
		connect(xGIcon,SIGNAL(xRunConfigurator()),this,SLOT(xRunConfigurator()));
		connect(xGIcon,SIGNAL(xStop()),this,SLOT(xStop()));
		
		xApplyCfg();
		//0.4
		if(xXMLIconConfig->count()>0)
		{
			QString vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_Intensity","100");
			
			bool okRet=false;
			ImageFX_Intensity=vvalue.toInt(&okRet);
			if(okRet==false)
			{
				ImageFX_Intensity=100;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_X_degree","0");

			ImageFX_X_degree=vvalue.toInt(&okRet);
		
			if(okRet==false)
			{
				ImageFX_X_degree=0;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_Y_degree","0");

			ImageFX_Y_degree=vvalue.toInt(&okRet);
			
			if(okRet==false)
			{
				ImageFX_Y_degree=0;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("ImageFX_GrayScale","no");

			if(vvalue=="no"||vvalue=="0")ImageFX_GrayScale=0;
			else ImageFX_GrayScale=1;
		}

	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
		gPluginSDK *MayManageMore=(gPluginSDK *)xeplugin_register(parent());
		// Now simulatin the startup procedure
		// this may work <= 0.26
		MayManageMore->xSetup();
		MayManageMore->xAttach(newIcon);
		// make links for kxdocker >=0.26
		
		qWarning("gPluginSDK: duplicate icons may not work properly");
	}

}


/*!
    \fn gPluginSDK::xApplyCfg()
 */
void gPluginSDK::xApplyCfg()
{
	qWarning("gPluginSDK::xApplyCfg() You must derivate this function to parse the configuration");
	/*
	if(xXMLIconConfig->count()>0)
	{
		IconsPath=xXMLIconConfig->item(0).toElement().attribute("path");
	}
	*/
}


/*!
    \fn gPluginSDK::polling()
 */
void gPluginSDK::polling()
{
	qWarning("gPluginSDK::polling() You must derivate this function to play ;)");
}


/*!
    \fn gPluginSDK::xSetupParameter(const QString, const QString)
 */
void gPluginSDK::xSetupParameter(const QString vname, const QString vvalue)
{
	// 0.4
	//qWarning("gPluginSDK::xSetupParameter(const QString, const QString) You must derivate this function");
	bool okRet=false;

	if(vname=="ImageFX_Intensity")
	{
		ImageFX_Intensity=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			ImageFX_Intensity=100;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_Intensity",ImageFX_Intensity);
		}
	}
	if(vname=="ImageFX_X_degree")
	{
		ImageFX_X_degree=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			ImageFX_X_degree=0;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_X_degree",ImageFX_X_degree);
		}
	}

	if(vname=="ImageFX_Y_degree")
	{
		ImageFX_Y_degree=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			ImageFX_Y_degree=0;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_Y_degree",ImageFX_Y_degree);
		}
	}

	if(vname=="ImageFX_GrayScale")
	{
		if(vvalue=="no"||vvalue=="0")ImageFX_GrayScale=0;
		else ImageFX_GrayScale=1;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("ImageFX_GrayScale",ImageFX_GrayScale);
		}
	}

	lastValue=-1;
	xRefreshIcon(xGIcon);

}


/*!
    \fn gPluginSDK::xGetParameterList(QStringList *)
 */
void gPluginSDK::xGetParameterList(QStringList *a)
{
	// 0.4
	//qWarning("gPluginSDK::xGetParameterList(QStringList *) You must derivate this function");
	a->append("ImageFX_GrayScale");
	a->append("ImageFX_X_degree");
	a->append("ImageFX_Y_degree");
	a->append("ImageFX_Intensity");
}


/*!
    \fn gPluginSDK::xGetParameter(const QString, QString &)
 */
void gPluginSDK::xGetParameter(const QString vname, QString & vvalue)
{
	if(vname=="ImageFX_GrayScale")
	{
		if(ImageFX_GrayScale)vvalue="yes";
		else vvalue="no";
	}
	if(vname=="ImageFX_Intensity")
	{
		vvalue.setNum(ImageFX_Intensity);
	}
	if(vname=="ImageFX_Y_degree")
	{
		vvalue.setNum(ImageFX_Y_degree);
	}
	if(vname=="ImageFX_X_degree")
	{
		vvalue.setNum(ImageFX_X_degree);
	}

	// 0.4
	//qWarning("gPluginSDK::xGetParameter(const QString, QString &) You must derivate this function");
}


/*!
    \fn gPluginSDK::createXMLTree()
 */
void gPluginSDK::createXMLTree()
{
	// Ok, You don't have specified the xml configuration, we have to create it!!
	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	xGetParameterList(&a);
	for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		xGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	// this will do a right cast;
	QDomNodeList pfx=(QDomNodeList)*xXMLIconConfig;
	pfx=fakeRoot.childNodes();
//	*xXMLIconConfig=&fx;
	//xXMLIconConfig->appendChild(fakeRoot.childNodes());
	if(pfx.count()<1)
	{
		qWarning("Error! XML Plugin configuration will not be stored.");
	}
	else
		qWarning("kxdocker 0.19 will not store correctly the configuration, you have to add the path on pluginconf manually, please upgrade to kxdocker 0.20");
}



/*!
    \fn gPluginSDK::xGetInfo(QStringList &)
 */
void gPluginSDK::xGetInfo(QStringList &a)
{
	a=PluginInformations;
}


/*!
    \fn gPluginSDK::xRunConfigurator()
 */
void gPluginSDK::xRunConfigurator()
{
	// we load
	QStringList a;
	xGetParameterList(&a);
	for(uint i=0;i<a.count();i++)
	{
		QString b;
		xGetParameter(a[i],b);
		ConfigurationWindow->xSetParameter(a[i],b);
	}
	ConfigurationWindow->show();
}


/*!
    \fn gPluginSDK::xEventClick(void *,int,int,int)
 */
void gPluginSDK::xEventClick(void *,int,int,int,int)
{
    /// @todo implement me
}


/*!
    \fn gPluginSDK::xEnabledClick()
 */
void gPluginSDK::xEnabledClick(int &)
{
    /// @todo implement me
}


/*!
    \fn gPluginSDK::xRefreshIconFromKXDocker(QObject *)
 */
void gPluginSDK::xRefreshIconFromKXDocker(QObject *a)
{
	lastValue=0;
	xRefreshIcon(a);
}


/*!
    \fn gPluginSDK::xPaintFX(int)
 */
void gPluginSDK::xPaintFX(int)
{
	*xImgSource=ImageFX_Painter->setFX(*xImgSource,
		ImageFX_Intensity,
		ImageFX_GrayScale,
		ImageFX_X_degree,
		ImageFX_Y_degree
		);
}
