/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gpipe.h"
#include "gpipethread.h"



#include <qbitmap.h>
#include <qimage.h>

#include <kiconloader.h>
#include <kstandarddirs.h>
#include <qtimer.h>
/*
#include <qregexp.h>
#include <qstringlist.h>
#include <kmountpoint.h>
#include <kdirwatch.h>
*/


#include "gpipe.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GPipe xeplugin_register()");
	return new GPipe(parent,"GPipe");
}



GPipe::GPipe(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
	PipeThread	=NULL;
	cmdRun="kxdocker/gpipe/scripts/example.sh";
	SpawnEvery=600;
	slideSeconds=60;
	
	QString Version="0.3";
	PluginInformations.append("KXDocker GPipe");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20050605"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gpipe");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gpipe");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version)); // url update
	
}

GPipe::~GPipe()
{

}

void GPipe::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="cmdRun")
	{
		cmdRun=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("cmdRun",cmdRun);
		}
		else
		{
			createXMLTree();
		}
		xCheckRestart();
	}
	if(vname=="slideSeconds")
	{
		bool okRet=false;
		slideSeconds=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			slideSeconds=60;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("slideSeconds",slideSeconds);
		}
		else
		{
			createXMLTree();
		}
	}
	
	if(vname=="SpawnEvery")
	{
		bool okRet=false;
		SpawnEvery=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			SpawnEvery=600;
		}

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("SpawnEvery",SpawnEvery);
		}
		else
		{
			createXMLTree();
		}


	}

	gPluginSDK::xSetupParameter(vname,vvalue);

}

void GPipe::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="cmdRun")
	{
		vvalue=cmdRun;
	}
	if(vname=="SpawnEvery")
	{
		vvalue.setNum(SpawnEvery);
	}
	if(vname=="slideSeconds")
	{
		vvalue.setNum(slideSeconds);
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void GPipe::xGetParameterList(QStringList *a)
{
	a->append("cmdRun");
	a->append("slideSeconds");
	a->append("SpawnEvery");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
}

void GPipe::xPaint(int)
{
	if(isStopped){
		return;
	}
	QString targetFile=LastIcon;
	xFindResource("icon",targetFile);
	//if(targetFile!="")
	{
		Pixmap.load(::locate("data",targetFile));
		if(Pixmap.isNull())
		{
			KIconLoader KDEIconLoader;
			Pixmap=KDEIconLoader.loadIcon(
						LastIcon,
						KIcon::NoGroup,
						128
						);
			
		}
	
		*xImgSource=Pixmap.convertToImage();
	}
	ToolTip=LastIcon;
}

void GPipe::polling()
{
	if(isStopped){
		return;
	}
	Value++;
	xRefreshIcon(xGIcon);
/*
	QTimer::singleShot(1000, this, SLOT(polling()));
*/
}

void GPipe::xApplyCfg()
{
	//qWarning("void GPipe::xApplyCfg()");
	if(xXMLIconConfig->count()>0)
	{
		cmdRun=xXMLIconConfig->item(0).toElement().attribute("cmdRun","kxdocker/gpipe/scripts/example.sh");
		
		bool okRet=false;
		QString sOk=xXMLIconConfig->item(0).toElement().attribute("SpawnEvery","600");
		SpawnEvery=sOk.toInt(&okRet);
		
		if(okRet==false)
		{
			SpawnEvery=600;
		}
		sOk=xXMLIconConfig->item(0).toElement().attribute("slideSeconds","60");
		slideSeconds=sOk.toInt(&okRet);
		
		if(okRet==false)
		{
			slideSeconds=60;
		}		
	}
	// to enable the first pass
	//lastValue=-1;
	//dirty("");
}


void GPipe::dirty(const QString &newIcon)
{
	//qWarning(QString("void GPipe::dirty(const QString &%1)").arg(newIcon));
	if(LastIcon!=newIcon)
	{
		LastIcon=newIcon;
		// thread safe!
		QTimer::singleShot(100,this,SLOT(polling()));
		//Value++;
	}
	//xRefreshIcon(xGIcon);
}


void GPipe::xStop()
{
	//qWarning("void GPipe::xStop()");
	gPluginSDK::xStop();

	if(PipeThread!=NULL)
	{
		PipeThread->terminate();
		//qWarning("PipeThread->terminate();");

	}

	//qWarning("void GPipe::xStop() end");
}


void GPipe::xStart()
{
	if(xGIcon&&isStopped)
	{
		//qWarning("void GPipe::xStart()");
		if(PipeThread==NULL)
		{
			PipeThread=new GPipeThread(this);
			connect(PipeThread, SIGNAL(dirty(const QString&)),this, SLOT(dirty(const QString&)) );
			
		}
		else
		{
			xStop();
		}
		PipeThread->setCmd(::locate("data",cmdRun),SpawnEvery,slideSeconds);
		//qWarning("PipeThread->setCmd(cmdRun,SpawnEvery,slideSeconds);");
		PipeThread->start(QThread::IdlePriority);
		//qWarning("PipeThread->start(QThread::IdlePriority);");
		gPluginSDK::xStart();
	}
	else
	{
		// Simply plugin startup
	}
}


/*!
    \fn GPipe::xCheckRestart()
 */
void GPipe::xCheckRestart()
{
	if(xGIcon&&isStopped)
	{

		if(PipeThread==NULL)
		{
			return;
		}
		else
		{
			PipeThread->terminate();
		}
		PipeThread->setCmd(::locate("data",cmdRun),SpawnEvery,slideSeconds);
		PipeThread->start(QThread::IdlePriority);
	}
}
