/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gnetio.h"


#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kdebug.h>

#include "ktn_proc.cpp"

#include <pluginconfigurationwindow.h>

extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="GNetIO";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new GNetIO(parent,NOME));
}

#include "gnetio.moc"




GNetIO::GNetIO(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip=i18n("Network Activity");
	// compatibility with 0.29
	QString Version="0.8";
	PluginInformations.append("KXDocker GNetIO");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20060117"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gnetio");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gnetio");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update
	netWorkDevice="eth0";
	devicesList.clear();
	devicesList.append(netWorkDevice);
	proc.setDevicesNetwork(devicesList);
	Scale=1024;
	PollingRate=1000;
	iMiniText=1;
	ConfigurationWindow=NULL;
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);

}



GNetIO::~GNetIO()
{
	XEObject::xPluginDel(this);
}

void GNetIO::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("device");
	a->append("rate_bytes");
	a->append("polling");
	a->append("minitext");
	a->append("dotpitch");
	a->append("drawdirection");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}

void GNetIO::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}
	if(vname=="device")
	{
		vvalue=netWorkDevice;
	}
	if(vname=="rate_bytes")
	{
		vvalue.setNum(Scale);
	}
	if(vname=="polling")
	{
		vvalue.setNum(PollingRate);
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	if(vname=="dotpitch")
	{
		vvalue.setNum(dotPitch);
	}
	if(vname=="drawdirection")
	{
		vvalue.setNum(drawDirection);
	}

	gPluginSDK::xGetParameter(vname,vvalue);
}

void GNetIO::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		}
		// done in 0.4
		//lastValue=-1;
		loadResources(IconsPath);
		//xRefreshIcon(xGIcon);
	}



	bool okRet=false;
	if(vname=="device")
	{
		netWorkDevice=vvalue;
		devicesList.clear();
		devicesList.append(netWorkDevice);
		proc.setDevicesNetwork(devicesList);
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("device",netWorkDevice);
		}
		
	}
	if(vname=="polling")
	{
		PollingRate=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			PollingRate=1000;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("polling",PollingRate);
		}
	}
	if(vname=="rate_bytes")
	{
		Scale=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			Scale=1024;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("rate_bytes",Scale);
		}
	}
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}


	if(vname=="drawdirection")
	{
		drawDirection=vvalue.toInt(&okRet);
		if(okRet==false)drawDirection=0;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("drawdirection",vvalue);
		}
		xRefreshIcon(xGIcon);
	}


	if(vname=="dotpitch")
	{
		dotPitch=vvalue.toInt(&okRet);
		if(okRet==false)dotPitch=0;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("dotpitch",vvalue);
		}
		xRefreshIcon(xGIcon);
	}


	gPluginSDK::xSetupParameter(vname,vvalue);
}

void GNetIO::xStart()
{
	gPluginSDK::xStart();
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new PluginConfigurationWindow(this);
	}
}


void GNetIO::xStop()
{
	gPluginSDK::xStop();
	if(ConfigurationWindow!=NULL)
	{
		ConfigurationWindow->close();
		delete ConfigurationWindow;
		ConfigurationWindow=NULL;
	}
}


void GNetIO::polling()
{
	if(isStopped){
		return;
	}

	if(proc.networkPoll()==0);
	
	const float *newIns=proc.getNetworkRX();
	const float *newOuts=proc.getNetworkTX();
	ToolTip="";	

	for(uint i=0; i<10 && i<devicesList.count();i++)
	{
		float newIn=	newIns[i];
		float newOut=	newOuts[i];
		rateIn=newIn-totalIn[i];
		rateOut=newOut-totalOut[i];
		totalIn[i]=newIn;
		totalOut[i]=newOut;
		
		// only 1 device

		break;
	}
	
	// 0.1 version will show the sum
	Value=int((rateIn+rateOut)/Scale);
	int rateInRound=(int)rateIn;
	int rateOutRound=(int)rateOut;
	int rateInRoundt=(int)rateIn;
	int rateOutRoundt=(int)rateOut;
	QString labelIn="Bytes";
	QString labelOut="Bytes";


	rateInRoundt=rateInRound/1024;
	if(rateInRoundt>0)
	{
		labelIn="KB";
		rateInRound=rateInRoundt;
		rateInRoundt=rateInRound/1024;
		if(rateInRoundt>0)
		{
			labelIn="MB";
			rateInRound=rateInRoundt;
		}
	}



	rateOutRoundt=rateOutRound/1024;
	if(rateOutRoundt>0)
	{
		labelOut="KB";
		rateOutRound=rateOutRoundt;
		rateOutRoundt=rateOutRound/1024;
		if(rateOutRoundt>0)
		{
			labelOut="MB";
			rateOutRound=rateOutRoundt;
		}
	}

	ToolTip=ToolTip+i18n(devicesList[0]);
	ToolTip=ToolTip+QString(" %1% (%1%1/%1%1) ").arg(Value).arg(int(rateInRound)).arg(labelIn).arg(int(rateOutRound)).arg(labelOut);
	ToolTip=ToolTip+i18n("usage");

	if(iMiniText==1)ToolTip2="";
	switch(iMiniText)
	{
		case 0:
			// nothing
		break;
		case 1:
			// RX/TX
			ToolTip2=QString("%1%1/%1%1")
					.arg(int(rateInRound))
					.arg(labelIn)
					.arg(int(rateOutRound))
					.arg(labelOut);
		break;
		case 2:
			// RX
			ToolTip2=QString("%1%1")
					.arg(int(rateInRound))
					.arg(labelIn);
		break;
		case 3:
			// TX
			ToolTip2=QString("%1%1")
					.arg(int(rateOutRound))
					.arg(labelOut);
		break;
		case 4:
			// %
			if(Value>0)ToolTip2=QString("%1%").arg(Value);
			else ToolTip2="";
		break;
		case 5:
			// eth0
			ToolTip2=i18n(devicesList[0]);
		break;
		case 6:
			// funny
			//ToolTip2="";
			if(int(rateInRound)>0)ToolTip2=QString("%1%1/").arg(int(rateInRound)).arg(labelIn);
			else ToolTip2=QString("-/");
			if(int(rateOutRound)>0)ToolTip2=ToolTip2+QString("%1%1").arg(int(rateOutRound)).arg(labelOut);
			else ToolTip2=ToolTip2+QString("-");
		break;
	}




	QTimer::singleShot(PollingRate, this, SLOT(polling()));
	lastValue=-1;
	xRefreshIcon(xGIcon);

}

void GNetIO::xPaint(int nPercentage)
{

	//imgBuffer=imgTrans.copy();
	imgBuffer=imgBackground.copy();
	imgOffscreen2=imgOffscreen.copy();
	imgOffscreen=imgTrans.copy();
	int h=imgOffscreen.height();
	// shift
	int xStartDirection;
	if(drawDirection>0)
	{
		bitBlt(&imgOffscreen,14,14,&imgOffscreen2,15,14,imgOffscreen.width()-1-14-14,h-14,Qt::CopyROP);
		xStartDirection=h-1-14;
	}
	else 
	{
		xStartDirection=14;
		bitBlt(&imgOffscreen,15,14,&imgOffscreen2,14,14,imgOffscreen.width()-1-14-14,h-14,Qt::CopyROP);
	}
//	if(drawSum){
		// draw line or dot
		if(dotPitch>0)bitBlt(&imgOffscreen,xStartDirection,14+100-nPercentage,&imgLine,0,100-nPercentage,imgLine.width(),dotPitch,Qt::CopyROP);
		else bitBlt(&imgOffscreen,xStartDirection,14+100-nPercentage,&imgLine,0,100-nPercentage,imgLine.width(),nPercentage,Qt::CopyROP);
//	}

	bitBlt(&imgBuffer,0,0,&imgOffscreen,0,0,imgOffscreen.width(),h,Qt::CopyROP);
	
	*xImgSource=imgBuffer;
}
void GNetIO::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker");
			QString sMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1");

			bool okRet=false;
			okRet=false;
			iMiniText=sMiniText.toInt(&okRet);
			if(okRet==false)iMiniText=1;

			netWorkDevice=xXMLIconConfig->item(0).toElement().attribute("device","");
			if(netWorkDevice=="")
			{
				// we are directly added by another plugin so, I like to disable minitext
				xGetIconName(netWorkDevice);
				iMiniText=0;
				// we need also setup right image:
				//
				//if(netWorkDevice.startsWidth("eth"))IconsPath="kxdocker/plugins/gnetio/eth";
				//if(netWorkDevice.startsWidth("wlan"))IconsPath="kxdocker/plugins/gnetio/wlan";
				//if(netWorkDevice.startsWidth("bnep"))IconsPath="kxdocker/plugins/gnetio/bnep";
				IconsPath=QString("kxdocker/plugins/gnetio/%1").arg(netWorkDevice);
			}
			if(netWorkDevice=="")netWorkDevice="eth0";



			devicesList.clear();
			devicesList.append(netWorkDevice);
			proc.setDevicesNetwork(devicesList);

			QString vvalue=xXMLIconConfig->item(0).toElement().attribute("rate_bytes","1024");
			Scale=vvalue.toInt(&okRet);
			if(okRet==false)
			{
				Scale=1024;
			}
			vvalue=xXMLIconConfig->item(0).toElement().attribute("polling","1000");
			PollingRate=vvalue.toInt(&okRet);
			if(okRet==false)
			{
				PollingRate=1000;
			}

			dotPitch=xXMLIconConfig->item(0).toElement().attribute("dotpitch","0").toInt(&okRet);
			if(okRet==false)dotPitch=0;

			drawDirection=xXMLIconConfig->item(0).toElement().attribute("drawdirection","0").toInt(&okRet);
			if(okRet==false)drawDirection=0;

	}
	imgOriginal=(*xImgSource);
	loadResources(IconsPath);
	lastValue=-1;
}

void GNetIO::loadResources(const QString &newPath)
{
	//**********************************************************
	QString fbackground;
	QString ClockPaths;
	QFile a;


	fbackground="line.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gnetio/";
		ClockPaths=ClockPaths+fbackground;
	}

	imgLine.load(::locate("data",ClockPaths));


	fbackground="background.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gnetio/";
		ClockPaths=ClockPaths+fbackground;
	}

	imgBackground.load(::locate("data",ClockPaths));

	if(imgBackground.width()>1)imgTrans.create(imgBackground.width(),imgBackground.height(),32);
	else {
		imgTrans.create(128,128,32);
	}
	imgTrans.setAlphaBuffer(false);
	imgTrans.fill(0);
	imgTrans.setAlphaBuffer(true);

	if(imgBackground.width()<2)imgBackground=imgTrans.copy();

	imgOffscreen=imgTrans.copy();
	imgOffscreen2=imgTrans.copy();

}
// 0.40
QObject * GNetIO::Respawn(QObject *p)
{
	return (QObject *)new GNetIO(p,name());
}
