//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gpluginsdkcfgwnd.h"

#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>
#include "gpluginsdkcfgwnd.moc"
#include <qcheckbox.h>

gPluginSDKCfgWnd::gPluginSDKCfgWnd(QObject *parent, const char *name)
    :GPluginSDKCfg(0, name)
{
	Plugin=parent;
	connect(this,SIGNAL(xApplyParameter(const QString, const QString)),
		Plugin,SLOT(xSetupParameter(const QString, const QString)));
	connect(pOK,SIGNAL(clicked()),this,SLOT(onOK()));
	connect(pBrowseTheme,SIGNAL(clicked()),this,SLOT(onBrowseThemes()));

}

void gPluginSDKCfgWnd::onOK()
{
	//qWarning("void gPluginSDKCfgWnd::onOK()");

	xApplyParameter("themepath",ThemePath->currentText());
	xApplyParameter("device",Device->currentText());
	/*
	xApplyParameter("showgauge",mGauge->currentText());
	xApplyParameter("icon_mounted",tMounted->currentText());
	xApplyParameter("icon_unmounted",tuMounted->currentText());
	xApplyParameter("mountcmd",MountCmd->currentText());
	xApplyParameter("umountcmd",uMountCmd->currentText());
	*/
	xApplyParameter("ImageFX_GrayScale",GrayScale->currentText());
	QString stringa;
	stringa.setNum(XDegree->value());
	xApplyParameter("ImageFX_X_degree",stringa);
	stringa.setNum(YDegree->value());
	xApplyParameter("ImageFX_Y_degree",stringa);
	stringa.setNum(Intensity->value());
	xApplyParameter("ImageFX_Intensity",stringa);

	/**************************************/
	stringa.setNum(Scale->value());
	xApplyParameter("rate_bytes",stringa);
	stringa.setNum(Polling->value());
	xApplyParameter("polling",stringa);
	xApplyParameter("minitext",QString("%1").arg(MiniText->currentItem()));
	stringa.setNum(dotPitch->value());
	xApplyParameter("dotpitch",stringa);
	if(invert->isChecked())xApplyParameter("drawdirection","1");
	else xApplyParameter("drawdirection","0");

	hide();
	

}

void gPluginSDKCfgWnd::xSetParameter(QString vname,QString vvalue)
{
	bool okRet=false;
	if(vname=="device")
	{
		Device->setCurrentText(vvalue);
	}
	if(vname=="polling")
	{
		Polling->setValue(vvalue.toInt(&okRet));
		if(!okRet)Polling->setValue(1000);
	}
	if(vname=="dotpitch")
	{
		dotPitch->setValue(vvalue.toInt(&okRet));
		if(!okRet)dotPitch->setValue(0);
	}
	if(vname=="drawdirection")
	{
		if(vvalue=="0")invert->setChecked(false);
		else invert->setChecked(true);
	}

	if(vname=="rate_bytes")
	{
		Scale->setValue(vvalue.toInt(&okRet));
		if(!okRet)Scale->setValue(1024);
	}
	if(vname=="themepath")
	{
		ThemePath->setCurrentText(vvalue);
	}
	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		MiniText->setCurrentItem(i);
	}

	/*
	if(vname=="mountcmd")
	{
		MountCmd->setCurrentText(vvalue);
	}
	if(vname=="umountcmd")
	{
		uMountCmd->setCurrentText(vvalue);
	}

	if(vname=="showgauge")
	{
		mGauge->setCurrentText(vvalue);
	}
	if(vname=="icon_mounted")
	{
		tMounted->setCurrentText(vvalue);
	}
	if(vname=="icon_unmounted")
	{
		tuMounted->setCurrentText(vvalue);
	}
	*/
	if(vname=="ImageFX_GrayScale")
	{
		GrayScale->setCurrentText(vvalue);
	}
	if(vname=="ImageFX_X_degree")
	{
		XDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)XDegree->setValue(0);
	}
	if(vname=="ImageFX_Y_degree")
	{
		YDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)YDegree->setValue(0);
	}
	if(vname=="ImageFX_Intensity")
	{
		Intensity->setValue(vvalue.toInt(&okRet));
		if(!okRet)Intensity->setValue(100);
	}
}




/*!
    \fn gPluginSDKCfgWnd::onBrowseThemes()
 */
void gPluginSDKCfgWnd::onBrowseThemes()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	ThemePath->setCurrentText(cfgPath);

}
