/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gmount.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <string.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>

#include <krun.h>


#include "gpluginpainter.h"


#include "gmount.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GAmarok xeplugin_register()");
	return new GMount(parent,"GMount");
}



GMount::GMount(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{

	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.8";
	// Project name
	PluginInformations.append("KXDocker GMount");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20051019");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gmount");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	//int IconSize=128;
	/*
	Painter=new gPluginPainter(0,"free",DRAW_GaugeVert2);
	Painter->setRect(QRect(1,0,gPluginPainter::SizeBig,gPluginPainter::SizeBig));

	ioWriting=new gPluginPainter(0,"wr",DRAW_Pixmap);
	ioWriting->setRect(QRect(0,0,gPluginPainter::SizeBig,gPluginPainter::SizeBig));
	ioReading=new gPluginPainter(0,"rd",DRAW_Pixmap);
	ioReading->setRect(QRect(0,0,gPluginPainter::SizeBig,gPluginPainter::SizeBig));
	ioEither=new gPluginPainter(0,"rw",DRAW_Pixmap);
	ioEither->setRect(QRect(0,0,gPluginPainter::SizeBig,gPluginPainter::SizeBig));
	*/

	themepath="kxdocker/plugins/gmount/";
	iMiniText=1;

	
	KDEWatch=new KDirWatch();
	isMounted=0;
	ShowGauge="yes";

	MountCmd="mount %1";
	uMountCmd="mount %1";
	lastdstatReads=0;
	lastdstatWrites=0;
	dstatReads=0;
	dstatWrites=0;
	//qWarning(QString("[%1] %1").arg((uint)this).arg("GMount::GMount()"));
	pollGauge=new QTimer();
	pollIO=new QTimer();
	connect(pollGauge,SIGNAL(timeout()),this, SLOT(pollingGauge()));
	connect(pollIO,SIGNAL(timeout()),this, SLOT(pollingActivity()));

}

GMount::~GMount()
{

}

void GMount::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;

	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}

	if(vname=="mountcmd")
	{
		MountCmd=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("mountcmd",MountCmd);

	}
	else
	{
		createXMLTree();
	}
	}
	if(vname=="umountcmd")
	{
		uMountCmd=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("umountcmd",uMountCmd);
	}
	else
	{
		createXMLTree();
	}
	}


	if(vname=="icon_unmounted")
	{
		icon_unmounted=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("icon_unmounted",icon_unmounted);
	}
	else
	{
		createXMLTree();
	}
	}
	if(vname=="showgauge")
	{
		ShowGauge=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("showgauge",ShowGauge);

	}
	else
	{
		createXMLTree();
	}
	}
	if(vname=="themepath")
	{
		themepath=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);

	}
	else
	{
		createXMLTree();
	}
	}
	if(vname=="device")
	{
		device=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("device",device);
	}
	else
	{
		createXMLTree();
	}
	}
	if(vname=="icon_mounted")
	{
		icon_mounted=vvalue;
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("icon_mounted",icon_mounted);

	}
	else
	{
		createXMLTree();
	}
	}

	
	// update the resources
	loadResources(themepath);

	

	// 0.4 version with FX image
	gPluginSDK::xSetupParameter(vname,vvalue);

	// restart the polling
	//if(ShowGauge=="yes")QTimer::singleShot(30000, this, SLOT(polling()));
	dirty("");

}

void GMount::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="icon_unmounted")
	{
		vvalue=icon_unmounted;
	}
	if(vname=="device")
	{
		vvalue=device;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	if(vname=="icon_mounted")
	{
		vvalue=icon_mounted;
	}
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	if(vname=="mountcmd")
	{
		vvalue=MountCmd;
	}
	if(vname=="umountcmd")
	{
		vvalue=uMountCmd;
	}
	if(vname=="showgauge")
	{
		vvalue=ShowGauge;
	}

	// 0.4 version with FX image
	gPluginSDK::xGetParameter(vname,vvalue);
}
void GMount::xGetParameterList(QStringList *a)
{
	a->append("device");
	a->append("icon_unmounted");
	a->append("icon_mounted");
	a->append("themepath");
	a->append("showgauge");
	a->append("mountcmd");
	a->append("umountcmd");
	a->append("minitext");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}


void GMount::xPaint(int newValue)
{
	//qWarning(QString("[%1] %1 [%1]").arg((uint)this).arg("void GMount::xPaint(int newValue)").arg(newValue));

	if(isStopped){
		return;
	}
	if(iMiniText>0)ToolTip2="";
	if(isMounted==0)
	{
		Pixmap=iunMounted.copy();

		ToolTip=device+" is not mounted";
		
	}
	else
	{
		Pixmap=iMounted.copy();

		ToolTip=device+QString(" %1%").arg(dfPercent);
	}
	if(isMounted && ShowGauge=="yes" && dfPercent>0 &&dfPercent<=100)
	{
		// find the Percentage
		//
		int coordY=Pixmap.height()-(dfPercent)*Pixmap.height()/(100);
		int coordW=Painter.width();
		int coordH=Painter.height()-coordY;
		int coordX=0;
		bitBlt(&Pixmap,0,0,&PainterOff,0,0,PainterOff.width(),PainterOff.height(),Qt::CopyROP);
		bitBlt(&Pixmap,coordX,coordY,&Painter,0,coordY,coordW,coordH,Qt::CopyROP);
		//Painter->setValue(QString("%1").arg(dfPercent));
		if(iMiniText==1)ToolTip2=QString("%1%").arg(dfPercent);
		//Painter->paint(&Pixmap);
		coordW=Pixmap.width();
		coordH=Pixmap.height();
		//qWarning(QString("%1 %1").arg(coordW).arg(coordH));
		switch(ioActivity)
		{
			case 1:
				//ioReading->paint(&Pixmap);
				bitBlt(&Pixmap,0,0,&ioReading,0,0,coordW,coordH,Qt::CopyROP);
			break;
			case 2:
				//ioWriting->paint(&Pixmap);
				bitBlt(&Pixmap,0,0,&ioWriting,0,0,coordW,coordH,Qt::CopyROP);
			break;
			case 3:
				//ioEither->paint(&Pixmap);
				bitBlt(&Pixmap,0,0,&ioEither,0,0,coordW,coordH,Qt::CopyROP);
			break;
		}
	}
	//qWarning(QString("%1").arg(ioActivity));
	//*xImgSource=Pixmap.convertToImage();
	*xImgSource=Pixmap;
	// update the popup menu
	//managePopUp();

}


void GMount::polling()
{
	//qWarning(QString("[%1] %1").arg((uint)this).arg("void GMount::polling()"));

	if(isStopped){
		qWarning("void GMount::polling() exiting...");
		return;
	}

	dirty("");
	if(ShowGauge=="yes")
	{
		//QTimer::singleShot(30000, this, SLOT(polling()));
		//QTimer::singleShot(500, this, SLOT(polling()));
	}
}


void GMount::xApplyCfg()
{
	//qWarning(QString("[%1] void GMount::xApplyCfg()").arg((uint)this));
	if(xXMLIconConfig->count()>0)
	{
		icon_unmounted=xXMLIconConfig->item(0).toElement().attribute("icon_unmounted","hd_umount");
		icon_mounted=xXMLIconConfig->item(0).toElement().attribute("icon_mounted","hd_mount");
		ShowGauge=xXMLIconConfig->item(0).toElement().attribute("showgauge","yes");
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gmount/");
		MountCmd=xXMLIconConfig->item(0).toElement().attribute("mountcmd","mount %1");
		uMountCmd=xXMLIconConfig->item(0).toElement().attribute("umountcmd","umount %1");

		bool okRet;
			iMiniText=xXMLIconConfig->item(0).toElement().attribute("minitext","1").toInt(&okRet);
			if(okRet==false)
			{
				iMiniText=1;
			}

		device=xXMLIconConfig->item(0).toElement().attribute("device","");
		if(device=="")
		{
			// we are directly added by another plugin so, I like to disable minitext
			xGetIconName(device);
			iMiniText=0;
			// we need also setup right image:
			//DeviceMounted->mountType()
			KMountPoint::List devList=KMountPoint::currentMountPoints(2);
			KMountPoint *DeviceMounted=NULL;
			for (int i=0;i<devList.count();i++)
			{
				DeviceMounted=devList[i];
				if(DeviceMounted==NULL)break;
				if(DeviceMounted->mountPoint()==device)
				{
					icon_unmounted=QString("umount_%1").arg(DeviceMounted->mountType());
					icon_mounted=QString("mount_%1").arg(DeviceMounted->mountType());
					if(DeviceMounted->mountType()=="udf")ShowGauge="no";
					else if(DeviceMounted->mountType()=="iso9660")ShowGauge="no";
					else if(DeviceMounted->mountType()=="isofs")ShowGauge="no";
					else if(DeviceMounted->mountType()=="usbfs")ShowGauge="no";
					break;
				}
			}
		}
		if(device=="")device="/";


	}
	// to enable the first pass
	lastValue=-1;
	// update the resources
	loadResources(themepath);

	//dirty("");
}


void GMount::dirty(const QString &)
{

	if(isStopped){
		qWarning("void GMount::dirty exiting...");
		return;
	}


	KMountPoint::List devList=KMountPoint::currentMountPoints(2);
	KMountPoint *DeviceMounted=NULL;
	int lastMounted=isMounted;
	isMounted=0;
	for (int i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
		if(DeviceMounted->mountPoint()==device)
		{
			isMounted++;
			deviceDev=DeviceMounted->realDeviceName();
			if(deviceDev=="")
			{
				deviceSys="";
			}
			else
			{
				deviceSys=deviceDev.replace("/dev/","");
				deviceSys=deviceSys.replace("/","");
				int conta=deviceSys.length()-1;
				for(;conta>0;conta--)
				{
					if(deviceSys[conta]>9 || deviceSys[conta]<0)break;
				}
				// /sys/block/hda/hda6/stat
				deviceSys=QString("/sys/block/%1/%1/stat").arg(deviceSys.left(conta)).arg(deviceSys);
			}
			break;
		}
	}

	if(lastMounted!=isMounted)Value=-1-isMounted;
	else Value=0;
	//qWarning("void GMount::dirty(const QString &)");
	if(isMounted)
	{
		pollingGauge();
		pollingActivity();
	}
	// update the popup menu
	managePopUp();
	xRefreshIcon(xGIcon);
}


void GMount::xStop()
{

	gPluginSDK::xStop();
	KDEWatch->stopScan();
}


void GMount::xStart()
{
	if(xGIcon && isStopped)
	{
		//qWarning(QString("[%1] %1").arg((uint)this).arg("xStart()"));
	
		KDEWatch->addFile("/etc/mtab");
		connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	
	
		
		KDEWatch->startScan();
	
	
		gPluginSDK::xStart();
	}
	else
	{
		// initialization not ready yet
		// ex: star() only for a non-Icon plugin
	}
}


void GMount::loadResources(const QString newPath)
{
	//**********************************************************
	QString fbackground;
	QString ClockPaths;
	QFile a;



	fbackground=icon_mounted +".png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths=icon_mounted;
		xFindResource("icon",ClockPaths);
		if(ClockPaths=="")ClockPaths=icon_mounted;
	}
	iMounted.load(::locate("data",ClockPaths));
	//qWarning(::locate("data",ClockPaths));
	/*
	iMounted=KDEIconLoader.loadIcon(
				ClockPaths,
				KIcon::NoGroup,
				128
				);
	*/

	fbackground=icon_unmounted +".png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths=icon_unmounted;
		xFindResource("icon",ClockPaths);
		if(ClockPaths=="")ClockPaths=icon_unmounted;
	}

	iunMounted.load(::locate("data",ClockPaths));


	fbackground="fanv.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gmount/";
		ClockPaths=ClockPaths+fbackground;
	}

//	Painter->load(::locate("data",ClockPaths));
	Painter.load(::locate("data",ClockPaths));


	fbackground="fanv_off.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gmount/";
		ClockPaths=ClockPaths+fbackground;
	}

//	Painter->load(::locate("data",ClockPaths));
	PainterOff.load(::locate("data",ClockPaths));



	fbackground="rd.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gmount/";
		ClockPaths=ClockPaths+fbackground;
	}

	ioReading.load(::locate("data",ClockPaths));

	fbackground="wr.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gmount/";
		ClockPaths=ClockPaths+fbackground;
	}

	ioWriting.load(::locate("data",ClockPaths));

	fbackground="rw.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gmount/";
		ClockPaths=ClockPaths+fbackground;
	}

	ioEither.load(::locate("data",ClockPaths));
}


/*!
    \fn GMount::managePopUp(int)
 */
void GMount::managePopUp()
{
	PluginPopupMenu->clear();
	QPixmap menuImg;
	menuImg.convertFromImage(iunMounted);

	PluginPopupMenu->insertTitle(menuImg,device);


	if(isMounted)
	{
		PluginPopupMenu->insertItem(menuImg,QString("Un Mount device"),this,SLOT(umount()));
	}
	else
	{
		menuImg.convertFromImage(iMounted);
		PluginPopupMenu->insertItem(menuImg,QString("Mount device"),this,SLOT(mount()));
	}
}


/*!
    \fn GMount::mount()
 */
void GMount::mount()
{
	KRun::runCommand(MountCmd.arg(device));
}


/*!
    \fn GMount::umount()
 */
void GMount::umount()
{
	KRun::runCommand(uMountCmd.arg(device));
}


/*!
    \fn GMount::pollingActivity()
 */
void GMount::pollingActivity()
{
	//deviceDev;
	pollIO->stop();

	if(isStopped){
		return;
	}
	FILE *fp=NULL;
	fp=fopen(deviceSys,"r");
	dstatReads=0;
	dstatWrites=0;
	ioActivity=0;
	unsigned long dstatBReads=0;
	unsigned long dstatBWrites=0;
	if(fp==NULL)
	{
		lastdstatReads=0;
		lastdstatWrites=0;
		return;
	}
	fscanf(fp,"%d %d %d %d",
				&dstatReads,
				&dstatBReads,
				&dstatWrites,
				&dstatBWrites
			);
	if(dstatReads!=lastdstatReads)
	{
		ioActivity=1;
		lastdstatReads=dstatReads;
	}
	if(dstatWrites!=lastdstatWrites)
	{
		ioActivity=ioActivity|2;
		lastdstatWrites=dstatWrites;
	}
	fclose(fp);
	Value=Value%100+ioActivity*1000;
	pollIO->start(500);
	xRefreshIcon(xGIcon);
}


/*!
    \fn GMount::pollingGauge()
 */
void GMount::pollingGauge()
{
	pollGauge->stop();

	if(isStopped){
		return;
	}		// now fetch the percentage
		FILE *fp;
		//sprintf(cmd,"df -h %s",device);
		QString a=QString("df %1").arg(device);
		fp=popen(a,"r");

		
		
		if(fp)
		{
			memset(buf,0,128);
			fgets(buf, 128, fp);
			fgets(buf, 128, fp);
			sscanf(buf,"%s %ld %ld %ld %s %s",
				dfDevice,
				&dfiSize,
				&dfiUsed,
				&dfiFree,
				dfPercentage,
				dfMountPoint
			);
			/*
			qWarning(buf);
			qWarning(QString("[%1][%1][%1]").arg(dfiSize)
				.arg(dfiSize)
				.arg(dfiUsed)
				.arg(dfiFree)
				);
			*/
		Value=ioActivity*1000;
		if(dfiUsed &&dfiSize){
			dfPercent=int((double(dfiUsed)/double(dfiSize))*100);
			Value=dfPercent+Value;
		}
		pclose(fp);


		xRefreshIcon(xGIcon);
		pollGauge->start(10000);
	}
}
