//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gpluginpainter.h"
#include "gpluginpainter.moc"
#include <qimage.h>
#include <kimageeffect.h>

#include <math.h>
#include <stdlib.h>

int gPluginPainter::SizeBig;



gPluginPainter::gPluginPainter(gPluginPainter *parent, const char *name, int type)
 : QWidget(parent, name)
{
	Type=type;
//	ImageEffect=new KImageEffect();
	SizeBig=128;
}


gPluginPainter::~gPluginPainter()
{
}





/*!
    \fn gPluginPainter::setValue(const QString)
 */
void gPluginPainter::setValue(const QString newValue)
{
	Value=newValue;

}


/*!
    \fn gPluginPainter::setRect(const QRect)
 */
void gPluginPainter::setRect(const QRect newZone)
{
	Zone=newZone;
}


/*!
    \fn gPluginPainter::load(const QString)
 */
void gPluginPainter::load(const QString a)
{
	Pixmap.load(a);
}


/*!
    \fn gPluginPainter::setFX(QImage &, int,int,int,int)
 */
QImage gPluginPainter::setFX(QImage &lavoro, int intensity,int gray,int dx,int dy)
{
	if(dx!=0)lavoro=setFXRotateX(lavoro,dx);
	if(dy!=0)lavoro=setFXRotateY(lavoro,dy);
	if(gray)lavoro=setFXGray(lavoro);
	if(intensity<100)lavoro=setFXIntensity(lavoro,intensity);
	return lavoro;
}


/*!
    \fn gPluginPainter::setFXRotateY(QImage &,int)
 */
QImage gPluginPainter::setFXRotateY(QImage & lavoro,int iFrame)
{

	int height=lavoro.height();
	int wiFrame=(int)(float(iFrame)/(float)90)*lavoro.width();

	lavoro=lavoro.smoothScale(lavoro.width()-abs(wiFrame),height,QImage::ScaleFree);
	QImage TBuffer;
	//double giFrame2=(45/(double)height)*(double)iFrame;
	double giFrame2=iFrame;
	giFrame2=((double)6.28/(double)360)*giFrame2;
	double Prospettiva=sin((double)giFrame2);
	double Prospettiva2;
	if(Prospettiva<0)Prospettiva2=-Prospettiva;
	else Prospettiva2=Prospettiva;

	int aSizeBig=(int)(Prospettiva2*lavoro.height()+lavoro.height());
	//if(aSizeBig>SizeBig*4/3)aSizeBig=SizeBig*4/3;

	TBuffer.create(
			aSizeBig,
			aSizeBig,
			32);
	TBuffer.setAlphaBuffer(false);
	TBuffer.fill(0);
	TBuffer.setAlphaBuffer(true);

	for(int xdisp=0;xdisp<height;xdisp++)
	{
		double giFrame=(180/(double)height)*(double)xdisp;
		giFrame=((double)6.28/(double)360)*giFrame;
		double rdy=(double)Prospettiva*(double)lavoro.height()*cos((double)giFrame);

		bitBlt(&TBuffer,
			(aSizeBig-
			lavoro.width())/2+xdisp
			,
		//(aSizeBig-((Prospettiva2*lavoro.height()+lavoro.height()))/2+
		//(int)(Prospettiva*lavoro.height())
			(int)-rdy
			,
			&lavoro,

			xdisp,
			0,
			1,
			height,
			Qt::CopyROP);
	}

	return TBuffer;
}


/*!
    \fn gPluginPainter::setFXRotateX(QImage &,int)
 */
QImage gPluginPainter::setFXRotateX(QImage & lavoro,int)
{
	return lavoro;

}

#include <qpixmap.h>

/*!
    \fn gPluginPainter::setFXIntensity(QImage &,int)
 */
QImage gPluginPainter::setFXIntensity(QImage &lavoro,int i)
{
	// return KImageEffect::intensity(lavoro,(float)100/(float)i);
	//qWarning(QString("Intesity: %1").arg((float)i/(float)100));
/*
	QImage TBuffer;
	TBuffer.create(
		lavoro.height(),
		lavoro.width(),
			32);
	TBuffer.setAlphaBuffer(false);
	TBuffer.fill(0);
	
	TBuffer.setAlphaBuffer(true);
*/
/*
	QPixmap rosso(lavoro.height(),
		lavoro.width());
	rosso.fill(Qt::red);
	QImage TBuffer=rosso.convertToImage();
*/
	//KImageEffect::blendOnLower(lavoro,TBuffer,KImageEffect::Centered/*NoImage*/,(float)100/(float)i);
	
	//return KImageEffect::blend(QColor(Qt::red),lavoro,(float)100/(float)i);
//	KImageEffect::blend(lavoro,TBuffer,(float)i/(float)100);
//	TBuffer->setMask(lavoro->mask());
	/*
	for(uint x=0;x<width;x++)
	{
		for(uint y=0;y<height;y++)
		{
			//&0xFF000000
			long alfa=[][]>>24;
			alfa=alfa*gi;
			long precedente=[][]&0xFFFFFF;
			alfa=alfa<<24;
			precedente=precedente+alfa;
		}
	}
	*/

	/*
	QRgb *tabella=lavoro.colorTable();
	if(tabella==NULL){
		qWarning("if(tabella==NULL){");
		return lavoro;
	}
*/
/*
	for(uint idx=0;idx<255;idx++)
	{
		unsigned long pidx=idx<<24;
		//long colore=tabella[pidx];
		long colore=lavoro.color(pidx);
		colore=(float)colore*gi;
		qWarning(QString("[%1][%1][%1][%1]").arg(idx).arg(pidx).arg(colore).arg(lavoro.color(pidx)));
		lavoro.setColor(pidx,colore);
	}
	qWarning("return lavoro;");
*/

	//double gi=((float)i/(float)100)/(float)255;
	//double gi=((float)i*(float)255)/(float)100;
	lavoro=lavoro.convertDepth(32);
	lavoro.setAlphaBuffer(true);
	uint width=lavoro.width();
	uint height=lavoro.height();

	for(uint x=0;x<height;x++)
	{
		uint *riga=(uint *)lavoro.scanLine(x);
		for(uint y=0;y<width;y++)
		{
			uint *p =  (uint *)riga+y;
			uint alfa=qAlpha(*p);
			//alfa=(int)((float)alfa*gi);
			alfa=uint((((float)alfa)/(float)100)*(float)i);
//qWarning(QString("[%1][%1][%1][%1]").arg(*p).arg(alfa).arg(x).arg(y));
//qWarning(QString("[%1][%1][%1][%1]").arg(qAlpha(*p)).arg(alfa).arg(x).arg(y));
			*p =qRgba(qRed(*p),qGreen(*p),qBlue(*p),alfa);
			//*p =qRgba(220,100,x,128);
		}
	}
	
	return lavoro;

}


/*!
    \fn gPluginPainter::setFXGray(QImage &)
 */
QImage gPluginPainter::setFXGray(QImage &lavoro)
{
	return KImageEffect::toGray(lavoro,false);
}


/*!
    \fn gPluginPainter::paint(QImage *)
 */
void gPluginPainter::paint(QImage *target)
{
}

/*!
    \fn gPluginPainter::paint(QPixmap *)
 */
void gPluginPainter::paint(QPixmap *target)
{
	int iValue=0;
	bool okRet=false;
	int iTemp=0;
	switch(Type)
	{
		case DRAW_Pixmap:
			bitBlt(target,Zone.left(),Zone.top(),&Pixmap,0);
		break;
		case DRAW_GaugeHoriz:
			iValue=Value.toInt(&okRet);
			bitBlt(target,Zone.left(),Zone.top(),&Pixmap,0,0,int(double(double(Pixmap.width())/double(100))*iValue),Pixmap.height());
		break;
		case DRAW_GaugeVert:
			iValue=Value.toInt(&okRet);
			iTemp=int(double(double(Pixmap.height())/double(100))*double(iValue));
			bitBlt(target,Zone.left(),Zone.top()+100-iTemp,&Pixmap,0,0,Pixmap.width(),iTemp);
		break;
		case DRAW_GaugeVert2:
			iValue=Value.toInt(&okRet);
			iTemp=int(double(double(Pixmap.height())/double(100))*double(iValue));
			bitBlt(target,Zone.left(),Zone.top()+Pixmap.height()-iTemp,&Pixmap,0,Pixmap.height()-iTemp,Pixmap.width(),iTemp);
		break;
		default:
		break;
	};
}
