/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gmount.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <string.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>

#include <krun.h>


#include "gpluginpainter.h"


#include "gmount.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GAmarok xeplugin_register()");
	return new GMount(parent,"GMount");
}



GMount::GMount(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{

	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.4";
	// Project name
	PluginInformations.append("KXDocker GMount");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20050606");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gmount");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	int IconSize=128;

	Painter=new gPluginPainter(0,"free",DRAW_GaugeVert2);
	Painter->setRect(QRect(1,0,IconSize,IconSize));
	themepath="kxdocker/plugins/gmount/";

	
	KDEWatch=new KDirWatch();
	isMounted=0;
	ShowGauge="yes";

	MountCmd="mount %1";
	uMountCmd="mount %1";

	//qWarning(QString("[%1] %1").arg((uint)this).arg("GMount::GMount()"));

}

GMount::~GMount()
{

}

void GMount::xSetupParameter(const QString vname, const QString vvalue)
{

	if(vname=="mountcmd")
	{
		MountCmd=vvalue;
	}
	if(vname=="umountcmd")
	{
		uMountCmd=vvalue;
	}


	if(vname=="icon_unmounted")
	{
		icon_unmounted=vvalue;
	}
	if(vname=="showgauge")
	{
		ShowGauge=vvalue;
	}
	if(vname=="themepath")
	{
		themepath=vvalue;
	}
	if(vname=="device")
	{
		device=vvalue;
	}
	if(vname=="icon_mounted")
	{
		icon_mounted=vvalue;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("device",device);
		xXMLIconConfig->item(0).toElement().setAttribute("icon_unmounted",icon_unmounted);
		xXMLIconConfig->item(0).toElement().setAttribute("icon_mounted",icon_mounted);
		xXMLIconConfig->item(0).toElement().setAttribute("showgauge",ShowGauge);
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
		xXMLIconConfig->item(0).toElement().setAttribute("mountcmd",MountCmd);
		xXMLIconConfig->item(0).toElement().setAttribute("umountcmd",uMountCmd);

	}
	else
	{
		createXMLTree();
	}
	
	// update the resources
	loadResources(themepath);

	

	// 0.4 version with FX image
	gPluginSDK::xSetupParameter(vname,vvalue);

	// restart the polling
	//if(ShowGauge=="yes")QTimer::singleShot(30000, this, SLOT(polling()));
	dirty("");

}

void GMount::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="icon_unmounted")
	{
		vvalue=icon_unmounted;
	}
	if(vname=="device")
	{
		vvalue=device;
	}
	if(vname=="icon_mounted")
	{
		vvalue=icon_mounted;
	}
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	if(vname=="mountcmd")
	{
		vvalue=MountCmd;
	}
	if(vname=="umountcmd")
	{
		vvalue=uMountCmd;
	}
	if(vname=="showgauge")
	{
		vvalue=ShowGauge;
	}

	// 0.4 version with FX image
	gPluginSDK::xGetParameter(vname,vvalue);
}
void GMount::xGetParameterList(QStringList *a)
{
	a->append("device");
	a->append("icon_unmounted");
	a->append("icon_mounted");
	a->append("themepath");
	a->append("showgauge");
	a->append("mountcmd");
	a->append("umountcmd");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}


void GMount::xPaint(int newValue)
{
	//qWarning(QString("[%1] %1 [%1]").arg((uint)this).arg("void GMount::xPaint(int newValue)").arg(newValue));

	if(isStopped){
		return;
	}
	if(isMounted==0)
	{
		Pixmap=iunMounted;

		ToolTip=device+" is not mounted";
		
	}
	else
	{
		Pixmap=iMounted;

		ToolTip=device+QString(" %1%").arg(newValue);
	}

	if(isMounted && ShowGauge=="yes")
	{
		// find the Percentage
		Painter->setValue(QString("%1").arg(newValue));
		Painter->paint(&Pixmap);
	}

	*xImgSource=Pixmap.convertToImage();


	// update the popup menu
	managePopUp();

}


void GMount::polling()
{
	//qWarning(QString("[%1] %1").arg((uint)this).arg("void GMount::polling()"));

	if(isStopped){
		qWarning("void GMount::polling() exiting...");
		return;
	}

	dirty("");
	if(ShowGauge=="yes")QTimer::singleShot(30000, this, SLOT(polling()));
}


void GMount::xApplyCfg()
{
	//qWarning(QString("[%1] void GMount::xApplyCfg()").arg((uint)this));
	if(xXMLIconConfig->count()>0)
	{
		icon_unmounted=xXMLIconConfig->item(0).toElement().attribute("icon_unmounted","hd_umount");
		icon_mounted=xXMLIconConfig->item(0).toElement().attribute("icon_mounted","hd_mount");
		device=xXMLIconConfig->item(0).toElement().attribute("device","/mnt/storage");
		ShowGauge=xXMLIconConfig->item(0).toElement().attribute("showgauge","yes");
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gmount/");
		MountCmd=xXMLIconConfig->item(0).toElement().attribute("mountcmd","mount %1");
		uMountCmd=xXMLIconConfig->item(0).toElement().attribute("umountcmd","umount %1");
		
	}
	// to enable the first pass
	lastValue=-1;
	// update the resources
	loadResources(themepath);

	//dirty("");
}


void GMount::dirty(const QString &)
{

	if(isStopped){
		qWarning("void GMount::dirty exiting...");
		return;
	}


	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	int lastMounted=isMounted;
	isMounted=0;
	for (int i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
		if(DeviceMounted->mountPoint()==device)isMounted++;
	}

	if(lastMounted!=isMounted)Value=-1-isMounted;
	else Value=0;
	//qWarning("void GMount::dirty(const QString &)");
	if(isMounted)
	{
		// now fetch the percentage
		FILE *fp;
		//sprintf(cmd,"df -h %s",device);
		QString a=QString("df %1").arg(device);
		fp=popen(a,"r");

		
		
		if(fp)
		{
			memset(buf,0,128);
			fgets(buf, 128, fp);
			fgets(buf, 128, fp);
			sscanf(buf,"%s %d %d %d %s %s",
				dfDevice,
				&dfiSize,
				&dfiUsed,
				&dfiFree,
				dfPercentage,
				dfMountPoint
			);
			/*
			qWarning(buf);
			qWarning(QString("[%1][%1][%1]").arg(dfiSize)
				.arg(dfiSize)
				.arg(dfiUsed)
				.arg(dfiFree)
				);
			*/
			if(dfiUsed &&dfiSize)Value=int((double(dfiUsed)/double(dfiSize))*100);
			pclose(fp);
		}
		
	}

	xRefreshIcon(xGIcon);
}


void GMount::xStop()
{

	gPluginSDK::xStop();
	KDEWatch->stopScan();
}


void GMount::xStart()
{
	if(xGIcon && isStopped)
	{
		//qWarning(QString("[%1] %1").arg((uint)this).arg("xStart()"));
	
		KDEWatch->addFile("/etc/mtab");
		connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	
	
		
		KDEWatch->startScan();
	
	
		gPluginSDK::xStart();
	}
	else
	{
		// initialization not ready yet
		// ex: star() only for a non-Icon plugin
	}
}


void GMount::loadResources(const QString newPath)
{
	//**********************************************************
	QString fbackground;
	QString ClockPaths;
	QFile a;



	fbackground=icon_mounted +".png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths=icon_mounted;
		xFindResource("icon",ClockPaths);
		if(ClockPaths=="")ClockPaths=icon_mounted;
	}

	iMounted=KDEIconLoader.loadIcon(
				ClockPaths,
				KIcon::NoGroup,
				128
				);


	fbackground=icon_unmounted +".png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths=icon_unmounted;
		xFindResource("icon",ClockPaths);
		if(ClockPaths=="")ClockPaths=icon_unmounted;
	}

	iunMounted=KDEIconLoader.loadIcon(
				ClockPaths,
				KIcon::NoGroup,
				128
				);


	fbackground="fanv.png";
	ClockPaths=newPath;
	ClockPaths=::locate("data",ClockPaths+"/"+fbackground);
	a.setName(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gmount/";
		ClockPaths=ClockPaths+fbackground;
	}

	Painter->load(::locate("data",ClockPaths));



}


/*!
    \fn GMount::managePopUp(int)
 */
void GMount::managePopUp()
{
	PluginPopupMenu->clear();

	PluginPopupMenu->insertTitle(
//KDEIconLoader.loadIcon(lastIcon->Images.imgFileName,KIcon::Small)
			iunMounted,device);


	if(isMounted)
	{
		PluginPopupMenu->insertItem(iunMounted,QString("Un Mount device"),this,SLOT(umount()));
	}
	else
	{
		PluginPopupMenu->insertItem(iunMounted,QString("Mount device"),this,SLOT(mount()));
	}
}


/*!
    \fn GMount::mount()
 */
void GMount::mount()
{
	KRun::runCommand(MountCmd.arg(device));
}


/*!
    \fn GMount::umount()
 */
void GMount::umount()
{
	KRun::runCommand(uMountCmd.arg(device));
}
