//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gpluginsdkcfgwnd.h"

#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>

#include <kicondialog.h>

#include <qcheckbox.h>




#include "gpluginsdkcfgwnd.moc"

gPluginSDKCfgWnd::gPluginSDKCfgWnd(QObject *parent, const char *name)
    :GPluginSDKCfg(0, name)
{
	Plugin=parent;
	connect(this,SIGNAL(xApplyParameter(const QString, const QString)),
		Plugin,SLOT(xSetupParameter(const QString, const QString)));
	connect(pOK,SIGNAL(clicked()),this,SLOT(onOK()));
	connect(add,SIGNAL(clicked()),this,SLOT(onADD()));
	connect(remove,SIGNAL(clicked()),this,SLOT(onREMOVE()));

	//connect(pBrowseTheme,SIGNAL(clicked()),this,SLOT(onBrowseThemes()));

}

void gPluginSDKCfgWnd::onOK()
{
	//qWarning("void gPluginSDKCfgWnd::onOK()");

	/*
	xApplyParameter("themepath",ThemePath->text());
	xApplyParameter("showgauge",mGauge->currentText());
	xApplyParameter("icon_mounted",tMounted->currentText());
	xApplyParameter("icon_unmounted",tuMounted->currentText());
	xApplyParameter("mountcmd",MountCmd->currentText());
	xApplyParameter("umountcmd",uMountCmd->currentText());
	xApplyParameter("device",MountPoint->currentText());
	*/
	xApplyParameter("ImageFX_GrayScale",GrayScale->currentText());
	QString stringa;
	stringa.setNum(XDegree->value());
	xApplyParameter("ImageFX_X_degree",stringa);
	stringa.setNum(YDegree->value());
	xApplyParameter("ImageFX_Y_degree",stringa);
	stringa.setNum(Intensity->value());
	xApplyParameter("ImageFX_Intensity",stringa);

	/**************************************/

	hide();
	//qWarning("void gPluginSDKCfgWnd::onOK()");
//	xApplyParameter("themepath",ThemePath->text());
	xApplyParameter("baseIcon",baseIcon->icon());
	xApplyParameter("incomingIcon",incomingIcon->icon());
	xApplyParameter("warningIcon",warningIcon->icon());

	xApplyParameter("minitext",QString("%1").arg(MiniText->currentItem()));
	if(cartelle->count()>0)
	{
		QString folders=cartelle->text(0);
		for(uint i=1;i<cartelle->count();i++)
		{
			folders=folders+":";
			folders=folders+cartelle->text(i);
		}
		xApplyParameter("folders",folders);
	}
	else xApplyParameter("folders","");
	xApplyParameter("folderName",folderName->text());


	if(bool_overlay_incoming->isChecked())xApplyParameter("overlay_incoming",overlay_incoming->icon());
	else xApplyParameter("overlay_incoming","");
	if(bool_overlay_none->isChecked())xApplyParameter("overlay_none",overlay_none->icon());
	else xApplyParameter("overlay_none","");

	hide();
	


}

void gPluginSDKCfgWnd::xSetParameter(QString vname,QString vvalue)
{
	bool okRet=false;
/*
	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}

*/
	if(vname=="incomingIcon")
	{
		incomingIcon->setIcon(vvalue);
	}
	if(vname=="baseIcon")
	{
		baseIcon->setIcon(vvalue);
	}
	if(vname=="folderName")
	{
		folderName->setText(vvalue);
	}
	if(vname=="warningIcon")
	{
		warningIcon->setIcon(vvalue);
	}
	if(vname=="overlay_incoming")
	{
		if(vvalue!="")
		{
			overlay_incoming->setIcon(vvalue);
			bool_overlay_incoming->setChecked(true);
		}
		else bool_overlay_incoming->setChecked(false);
	}
	if(vname=="overlay_none")
	{
		if(vvalue!="")
		{
			overlay_none->setIcon(vvalue);
			bool_overlay_none->setChecked(true);
		}
		else bool_overlay_none->setChecked(false);
	}
	if(vname=="folders")
	{
		QStringList folders=QStringList::split (":",vvalue,FALSE);;
		cartelle->clear();
		cartelle->insertStringList(folders);
	
	}
	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		MiniText->setCurrentItem(i);
	}

	/*
	if(vname=="device")
	{
		MountPoint->setCurrentText(vvalue);
	}
	if(vname=="mountcmd")
	{
		MountCmd->setCurrentText(vvalue);
	}
	if(vname=="umountcmd")
	{
		uMountCmd->setCurrentText(vvalue);
	}

	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	if(vname=="showgauge")
	{
		mGauge->setCurrentText(vvalue);
	}
	if(vname=="icon_mounted")
	{
		tMounted->setCurrentText(vvalue);
	}
	if(vname=="icon_unmounted")
	{
		tuMounted->setCurrentText(vvalue);
	}
	*/
	if(vname=="ImageFX_GrayScale")
	{
		GrayScale->setCurrentText(vvalue);
	}
	if(vname=="ImageFX_X_degree")
	{
		XDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)XDegree->setValue(0);
	}
	if(vname=="ImageFX_Y_degree")
	{
		YDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)YDegree->setValue(0);
	}
	if(vname=="ImageFX_Intensity")
	{
		Intensity->setValue(vvalue.toInt(&okRet));
		if(!okRet)Intensity->setValue(100);
	}
}




/*!
    \fn gPluginSDKCfgWnd::onBrowseThemes()
 */
void gPluginSDKCfgWnd::onBrowseThemes()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	//ThemePath->setText(cfgPath);

}


/*!
    \fn gPluginSDKCfgWnd::onREMOVE()
 */
void gPluginSDKCfgWnd::onREMOVE()
{
	if(cartelle->selectedItem ())cartelle->removeItem(cartelle->currentItem ());
}


/*!
    \fn gPluginSDKCfgWnd::onADD()
 */
void gPluginSDKCfgWnd::onADD()
{
	if(cartella->text()!="")cartelle->insertItem(cartella->text(),0);

}
