/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wmconfigurationwindow.h"
#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>

#include <kicondialog.h>

#include <qcheckbox.h>


WMConfigurationWindow::WMConfigurationWindow(QObject *parent, const char *name)
 : GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));

}


WMConfigurationWindow::~WMConfigurationWindow()
{
}

void WMConfigurationWindow::pOK_clicked()
{
	/**************************************/

	xApplyParameter("baseIcon",baseIcon->icon());
	xApplyParameter("incomingIcon",incomingIcon->icon());
	xApplyParameter("warningIcon",warningIcon->icon());
	xApplyParameter("minitext",QString("%1").arg(MiniText->currentItem()));
	xApplyParameter("NotebookLEDKind",QString("%1").arg(led->currentItem()));
	if(cartelle->count()>0)
	{
		QString folders=cartelle->text(0);
		for(uint i=1;i<cartelle->count();i++)
		{
			folders=folders+":";
			folders=folders+cartelle->text(i);
		}
		xApplyParameter("folders",folders);
	}
	else xApplyParameter("folders","");
	xApplyParameter("folderName",folderName->text());


	if(bool_overlay_incoming->isChecked())xApplyParameter("overlay_incoming",overlay_incoming->icon());
	else xApplyParameter("overlay_incoming","");
	if(bool_overlay_none->isChecked())xApplyParameter("overlay_none",overlay_none->icon());
	else xApplyParameter("overlay_none","");

	hide();
}


#include "wmconfigurationwindow.moc"


void WMConfigurationWindow::xSetupParameter(QString vname,QString vvalue)
{
	bool okRet=false;
/*
	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}

*/
	if(vname=="incomingIcon")
	{
		incomingIcon->setIcon(vvalue);
	}
	if(vname=="baseIcon")
	{
		baseIcon->setIcon(vvalue);
	}
	if(vname=="folderName")
	{
		folderName->setText(vvalue);
	}
	if(vname=="warningIcon")
	{
		warningIcon->setIcon(vvalue);
	}
	if(vname=="overlay_incoming")
	{
		if(vvalue!="")
		{
			overlay_incoming->setIcon(vvalue);
			bool_overlay_incoming->setChecked(true);
		}
		else bool_overlay_incoming->setChecked(false);
	}
	if(vname=="overlay_none")
	{
		if(vvalue!="")
		{
			overlay_none->setIcon(vvalue);
			bool_overlay_none->setChecked(true);
		}
		else bool_overlay_none->setChecked(false);
	}
	if(vname=="folders")
	{
		QStringList folders=QStringList::split (":",vvalue,FALSE);;
		cartelle->clear();
		cartelle->insertStringList(folders);
	
	}
	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		MiniText->setCurrentItem(i);
	}
	if(vname=="NotebookLEDKind")
	{
		int i=vvalue.toInt(&okRet);
		led->setCurrentItem(i);
	}
}

void WMConfigurationWindow::add_clicked()
{
	if(cartella->text()!="")cartelle->insertItem(cartella->text(),0);
}

void WMConfigurationWindow::remove_clicked()
{
	if(cartelle->selectedItem ())cartelle->removeItem(cartelle->currentItem ());
}


