#ifndef IPCONTRACKER_H
#define IPCONTRACKER_H

#include <qobject.h>

#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
#include "gpluginsdk.h"
#include <qpixmap.h>
#include <kiconloader.h>
class QPixmap;

class IPContracker;

class gPluginPainter;


/**
@author Stefano
*/
class GIPContrack : public gPluginSDK
{
Q_OBJECT
public:
    GIPContrack(QObject *parent = 0, const char *name = 0);

    ~GIPContrack();

protected:
	QString			overlay_outgoing;
	QString			overlay_incoming;
	QImage			overlay_incomingImage;
	QImage			overlay_noneImage;
	QString			incomingIcon;
	QString			warningIcon;
	QPixmap			BasePixmap;
	QPixmap			IncomingPixmap;
	QPixmap			warningPixmap;
	int			seconds;
	QString			IP;
	QStringList		folders;
	int			iMiniText;
	int			Direction;
	int			warningIncoming;
	unsigned long int	longValue;
	unsigned long int	lastlongValue;
	unsigned long int	longValue2;
	unsigned long int	lastlongValue2;
	IPContracker *ipContracker;


public slots:
    void xGetParameterList(QStringList *);
    void xPaint(int nEmails);
    void xApplyCfg();
    void xGetParameter(const QString, QString&);
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void polling();
    void xGetParameterType(const QString &, QString &);

protected:
    void loadImages();
};

#endif
