/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "geyes.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>

#include "gpluginpainter.h"

#include "geyes.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GEyes xeplugin_register()");
	return new GEyes(parent,"GEyes");
}



GEyes::GEyes(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
    themepath="kxdocker/plugins/geyes/";
    
	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.1";
	// Project name
	PluginInformations.append("KXDocker GEyes");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20050817");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#geyes");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#geyes");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	//IconSize=256;

	ToolTip="Eyes";

	Painter=new gPluginPainter(0,"current",DRAW_GaugeVert2);
	Painter->setRect(QRect(1,0,IconSize,IconSize));
}

GEyes::~GEyes()
{

}

void GEyes::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		themepath=vvalue;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
	}
	else
	{
		createXMLTree();
	}

	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(themepath);
}

void GEyes::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void GEyes::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
}


void GEyes::xPaint(int newValue)
{

	lastImage=background;
	int inc=lastImage.width()/2;
	
	int ddx;
	int ddy;
	ddy=(double(dy)/double((QApplication::desktop()->height())))*double(inc)*0.7-double(eye.height())/2;
	//qWarning(QString("[%1][%1] (%1) %1 %1").arg(ddx).arg(ddy).arg(inc).arg(QApplication::desktop()->height()));



	ddx=(double(dx+inc)/double((QApplication::desktop()->width())))*double(inc)*0.7-double(eye.width())/2;


	bitBlt(&lastImage,ddx+inc/2-14,ddy+inc+14,&eye,0,0,eye.width(),eye.height());

	ddx=(double(dx-inc)/double((QApplication::desktop()->width())))*double(inc)*0.7-double(eye.width())/2;

	bitBlt(&lastImage,ddx+inc/2+inc,ddy+inc+14,&eye,0,0,eye.width(),eye.height());

	*xImgSource=lastImage.convertToImage();
}
#include <qcursor.h>

void GEyes::polling()
{
/*
	Value++;
	xRefreshIcon(xGIcon);
	QTimer::singleShot(1000, this, SLOT(polling()));
*/

	if(isStopped){
		qWarning("void GEyes::polling exiting...");
		return;
	}
	QPoint TheMouse=QCursor::pos();

	dx=TheMouse.x()-lastDockerIconX-lastDockerX-lastDockerIconSize/2;
	dy=TheMouse.y()-lastDockerIconY-lastDockerY-lastDockerIconSize/2;
	Value=dx+dy;
	QString a=QString("%1 %1").arg(dx).arg(dy);
	dirty(a);
	//qWarning(a);

	QTimer::singleShot(250, this, SLOT(polling()));
}


void GEyes::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/geyes");
	}
	loadResources(themepath);
	// to enable the first pass
	lastValue=-1;
	//dirty("");
}


void GEyes::dirty(const QString &AlbumImage)
{
	if(isStopped){
		return;
	}

	//ToolTip=AlbumImage;

	xRefreshIcon(xGIcon);
}


void GEyes::xStop()
{
	gPluginSDK::xStop();

}


void GEyes::xStart()
{
	gPluginSDK::xStart();

}


void GEyes::loadResources(const QString newPath)
{
	//**********************************************************
	// path where to find images
	QString ClockPaths=newPath;
	QFile a;

	a.setName(ClockPaths);
	ClockPaths=newPath;
	QString FanV="occhi.png";
	ClockPaths=ClockPaths+"/"+FanV;
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/geyes/";
		ClockPaths=ClockPaths+FanV;
	}
	//Painter->load(::locate("data",ClockPaths));
	background.load(::locate("data",ClockPaths));


	a.setName(ClockPaths);
	ClockPaths=newPath;
	FanV="occhio.png";
	ClockPaths=ClockPaths+"/"+FanV;
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/geyes/";
		ClockPaths=ClockPaths+FanV;
	}

	eye.load(::locate("data",ClockPaths));
}

